/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ijent.community.impl.nio;

import com.intellij.platform.ijent.community.impl.nio.TransitionalIjentWslFileSystemProvider;
import java.io.Closeable;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0002\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0016H\u0016J-\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u000f2\u0016\u0010\u0019\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\u001a\"\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/platform/ijent/community/impl/nio/TransitionalIjentWslFileSystem;", "Ljava/nio/file/FileSystem;", "provider", "Lcom/intellij/platform/ijent/community/impl/nio/TransitionalIjentWslFileSystemProvider;", "localFs", "ijentFs", "<init>", "(Lcom/intellij/platform/ijent/community/impl/nio/TransitionalIjentWslFileSystemProvider;Ljava/nio/file/FileSystem;Ljava/nio/file/FileSystem;)V", "close", "", "Ljava/nio/file/spi/FileSystemProvider;", "isOpen", "", "isReadOnly", "getSeparator", "", "getRootDirectories", "", "Ljava/nio/file/Path;", "getFileStores", "Ljava/nio/file/FileStore;", "supportedFileAttributeViews", "", "getPath", "first", "more", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/nio/file/Path;", "getPathMatcher", "Ljava/nio/file/PathMatcher;", "syntaxAndPattern", "getUserPrincipalLookupService", "Ljava/nio/file/attribute/UserPrincipalLookupService;", "newWatchService", "Ljava/nio/file/WatchService;", "intellij.platform.ijent.community.impl"})
public final class TransitionalIjentWslFileSystem
extends FileSystem {
    @NotNull
    private final TransitionalIjentWslFileSystemProvider provider;
    @NotNull
    private final FileSystem localFs;
    @NotNull
    private final FileSystem ijentFs;

    public TransitionalIjentWslFileSystem(@NotNull TransitionalIjentWslFileSystemProvider provider, @NotNull FileSystem localFs, @NotNull FileSystem ijentFs) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)localFs, (String)"localFs");
        Intrinsics.checkNotNullParameter((Object)ijentFs, (String)"ijentFs");
        this.provider = provider;
        this.localFs = localFs;
        this.ijentFs = ijentFs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Closeable closeable = this.localFs;
        Throwable throwable = null;
        try {
            FileSystem it = (FileSystem)closeable;
            boolean bl = false;
            this.ijentFs.close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public boolean isOpen() {
        if (!(this.localFs.isOpen() == this.ijentFs.isOpen())) {
            throw new IllegalStateException("Check failed.");
        }
        return this.localFs.isOpen();
    }

    @Override
    public boolean isReadOnly() {
        if (!(this.localFs.isReadOnly() == this.ijentFs.isReadOnly())) {
            throw new IllegalStateException("Check failed.");
        }
        return this.localFs.isReadOnly();
    }

    @Override
    @NotNull
    public String getSeparator() {
        String string = this.localFs.getSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSeparator(...)");
        return string;
    }

    @Override
    @NotNull
    public Iterable<Path> getRootDirectories() {
        Iterable<Path> iterable = this.localFs.getRootDirectories();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
        return iterable;
    }

    @Override
    @NotNull
    public Iterable<FileStore> getFileStores() {
        Iterable<FileStore> iterable = this.localFs.getFileStores();
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"getFileStores(...)");
        return iterable;
    }

    @Override
    @NotNull
    public Set<String> supportedFileAttributeViews() {
        Set<String> set = this.localFs.supportedFileAttributeViews();
        Intrinsics.checkNotNullExpressionValue(set, (String)"supportedFileAttributeViews(...)");
        return set;
    }

    @Override
    @NotNull
    public Path getPath(@NotNull String first, String ... more) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)more, (String)"more");
        Path path = this.localFs.getPath(first, Arrays.copyOf(more, more.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        return path;
    }

    @Override
    @NotNull
    public PathMatcher getPathMatcher(@Nullable String syntaxAndPattern) {
        PathMatcher pathMatcher = this.localFs.getPathMatcher(syntaxAndPattern);
        Intrinsics.checkNotNullExpressionValue((Object)pathMatcher, (String)"getPathMatcher(...)");
        return pathMatcher;
    }

    @Override
    @NotNull
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        UserPrincipalLookupService userPrincipalLookupService = this.localFs.getUserPrincipalLookupService();
        Intrinsics.checkNotNullExpressionValue((Object)userPrincipalLookupService, (String)"getUserPrincipalLookupService(...)");
        return userPrincipalLookupService;
    }

    @Override
    @NotNull
    public WatchService newWatchService() {
        WatchService watchService = this.localFs.newWatchService();
        Intrinsics.checkNotNullExpressionValue((Object)watchService, (String)"newWatchService(...)");
        return watchService;
    }
}

