/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.formatting.service.ExternalFormatProcessorAdapter;
import com.intellij.formatting.service.FormattingService;
import com.intellij.formatting.service.FormattingServiceUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.ChangeInfo;
import com.intellij.pom.tree.events.TreeChange;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import com.intellij.pom.tree.events.impl.TreeChangeImpl;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.PsiDocumentManagerEx;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.DisabledIndentRangesProvider;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.codeStyle.IndentHelperImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementVisitor;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.Function;
import com.intellij.util.InjectionUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.TextRangeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class PostprocessReformattingAspectImpl
extends PostprocessReformattingAspect {
    private static final Logger LOG = Logger.getInstance(PostprocessReformattingAspectImpl.class);
    private final Project myProject;
    private final NotNullLazyValue<TreeAspect> myTreeAspect;
    private static final Key<Throwable> REFORMAT_ORIGINATOR = Key.create((String)"REFORMAT_ORIGINATOR");
    private static final Key<Boolean> REPARSE_PENDING = Key.create((String)"REPARSE_PENDING");
    private static final Key<Boolean> FORCE_POSTPROCESS_FORMAT = Key.create((String)"FORCE_POSTPROCESS_FORMAT");
    private final ThreadLocal<Context> myContext;

    public PostprocessReformattingAspectImpl(@NotNull Project project2) {
        if (project2 == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(0);
        }
        this.myContext = ThreadLocal.withInitial(Context::new);
        this.myProject = project2;
        this.myTreeAspect = NotNullLazyValue.createValue(() -> TreeAspect.getInstance((Project)this.myProject));
        ApplicationManager.getApplication().addApplicationListener(new ApplicationListener(){

            public void writeActionStarted(@NotNull Object action2) {
                CommandProcessor processor2;
                if (action2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((processor2 = CommandProcessor.getInstance()) != null && processor2.getCurrentCommandProject() == PostprocessReformattingAspectImpl.this.myProject) {
                    PostprocessReformattingAspectImpl.this.incrementPostponedCounter();
                }
            }

            public void writeActionFinished(@NotNull Object action2) {
                Application app;
                CommandProcessor processor2;
                if (action2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                CommandProcessor commandProcessor = processor2 = (app = ApplicationManager.getApplication()) == null ? null : (CommandProcessor)app.getServiceIfCreated(CommandProcessor.class);
                if (processor2 != null && processor2.getCurrentCommandProject() == PostprocessReformattingAspectImpl.this.myProject) {
                    PostprocessReformattingAspectImpl.this.decrementPostponedCounter();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "action";
                objectArray2[1] = "com/intellij/psi/impl/source/PostprocessReformattingAspectImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "writeActionStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "writeActionFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)project2);
    }

    public void disablePostprocessFormattingInside(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(1);
        }
        this.disablePostprocessFormattingInside((Computable)((NullableComputable)() -> {
            runnable2.run();
            return null;
        }));
    }

    public <T> T disablePostprocessFormattingInside(@NotNull Computable<T> computable) {
        Object object;
        if (computable == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(2);
        }
        try {
            ++this.getContext().myDisabledCounter;
            object = computable.compute();
            --this.getContext().myDisabledCounter;
            LOG.assertTrue(this.getContext().myDisabledCounter > 0 || !this.isDisabled());
        }
        catch (Throwable throwable) {
            --this.getContext().myDisabledCounter;
            LOG.assertTrue(this.getContext().myDisabledCounter > 0 || !this.isDisabled());
            throw throwable;
        }
        return (T)object;
    }

    public void postponeFormattingInside(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(3);
        }
        this.postponeFormattingInside((Computable)((NullableComputable)() -> {
            runnable2.run();
            return null;
        }));
    }

    public <T> T postponeFormattingInside(@NotNull Computable<T> computable) {
        if (computable == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(4);
        }
        try {
            this.incrementPostponedCounter();
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            this.decrementPostponedCounter();
        }
    }

    public void forcePostprocessFormatInside(@NotNull PsiFile psiFile, @NotNull Runnable runnable2) {
        if (psiFile == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(5);
        }
        if (runnable2 == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(6);
        }
        try {
            psiFile.getViewProvider().putUserData(FORCE_POSTPROCESS_FORMAT, (Object)true);
            runnable2.run();
        }
        finally {
            psiFile.getViewProvider().putUserData(FORCE_POSTPROCESS_FORMAT, null);
        }
    }

    public void forcePostprocessFormat(@NotNull PsiFile psiFile, @NotNull Disposable disposable) {
        if (psiFile == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(7);
        }
        if (disposable == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(8);
        }
        psiFile.getViewProvider().putUserData(FORCE_POSTPROCESS_FORMAT, (Object)true);
        Disposer.register((Disposable)disposable, () -> psiFile.getViewProvider().putUserData(FORCE_POSTPROCESS_FORMAT, null));
    }

    private void incrementPostponedCounter() {
        ++this.getContext().myPostponedCounter;
    }

    private void decrementPostponedCounter() {
        Application application = ApplicationManager.getApplication();
        if (--this.getContext().myPostponedCounter == 0) {
            if (application.isWriteAccessAllowed() || !application.isWriteIntentLockAcquired() || this.noWriteIsNecessary()) {
                this.doPostponedFormatting();
            } else {
                application.runWriteAction(this::doPostponedFormatting);
            }
        }
    }

    private boolean noWriteIsNecessary() {
        return ContainerUtil.all((Collection)this.getContext().myUpdatedProviders.keySet(), vp -> !vp.isEventSystemEnabled());
    }

    @NotNull
    private static PsiFile getContainingFile(@NotNull PsiElement psiElement) {
        PsiFile topLevelFile;
        FileViewProvider topLevelViewProvider;
        if (psiElement == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(9);
        }
        if (InjectionUtils.shouldFormatOnlyInjectedCode((FileViewProvider)(topLevelViewProvider = (topLevelFile = InjectedLanguageManager.getInstance((Project)psiElement.getProject()).getTopLevelFile(psiElement)).getViewProvider()))) {
            PsiFile psiFile = psiElement.getContainingFile();
            if (psiFile == null) {
                PostprocessReformattingAspectImpl.$$$reportNull$$$0(10);
            }
            return psiFile;
        }
        PsiFile psiFile = topLevelFile;
        if (psiFile == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(11);
        }
        return psiFile;
    }

    public void update(@NotNull PomModelEvent event) {
        if (event == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(12);
        }
        if (this.isDisabled() || this.getContext().myPostponedCounter == 0) {
            return;
        }
        TreeChangeEvent changeSet = (TreeChangeEvent)event.getChangeSet((PomModelAspect)this.myTreeAspect.getValue());
        if (changeSet == null) {
            return;
        }
        PsiElement psiElement = changeSet.getRootElement().getPsi();
        if (psiElement == null) {
            return;
        }
        PsiFile containingFile = PostprocessReformattingAspectImpl.getContainingFile(psiElement);
        final FileViewProvider viewProvider = containingFile.getViewProvider();
        if (!(viewProvider.isEventSystemEnabled() || IntentionPreviewUtils.isPreviewElement((PsiElement)containingFile) || FORCE_POSTPROCESS_FORMAT.isIn((UserDataHolder)viewProvider))) {
            return;
        }
        this.getContext().myUpdatedProviders.putValue((Object)viewProvider, (Object)((FileElement)containingFile.getNode()));
        for (ASTNode node : changeSet.getChangedElements()) {
            TreeChange treeChange = changeSet.getChangesByElement(node);
            block5: for (ASTNode affectedChild : treeChange.getAffectedChildren()) {
                if (PostprocessReformattingAspectImpl.changeMightBreakPsiTextConsistency(affectedChild)) {
                    containingFile.putUserData(REPARSE_PENDING, (Object)true);
                } else if (PostprocessReformattingAspectImpl.leavesEmptyRangeAtEdge((TreeChangeImpl)treeChange, affectedChild) && PostprocessReformattingAspectImpl.hasRaiseableEdgeChild(node)) {
                    this.getContext().myRaisingCandidates.putValue((Object)viewProvider, (Object)node);
                }
                ChangeInfo childChange = treeChange.getChangeByChild(affectedChild);
                switch (childChange.getChangeType()) {
                    case 0: 
                    case 2: {
                        this.postponeFormatting(viewProvider, affectedChild);
                        continue block5;
                    }
                    case 3: {
                        if (CodeEditUtil.isNodeGenerated((ASTNode)affectedChild)) continue block5;
                        ((TreeElement)affectedChild).acceptTree((TreeElementVisitor)new RecursiveTreeElementWalkingVisitor(){

                            protected void visitNode(TreeElement element) {
                                if (CodeEditUtil.isNodeGenerated((ASTNode)element) && CodeEditUtil.isSuspendedNodesReformattingAllowed()) {
                                    PostprocessReformattingAspectImpl.this.postponeFormatting(viewProvider, (ASTNode)element);
                                    return;
                                }
                                super.visitNode(element);
                            }
                        });
                    }
                }
            }
        }
    }

    private static boolean changeMightBreakPsiTextConsistency(ASTNode child) {
        return TreeUtil.containsOuterLanguageElements((ASTNode)child) || PostprocessReformattingAspectImpl.isRightAfterErrorElement(child);
    }

    private static boolean leavesEmptyRangeAtEdge(TreeChangeImpl treeChange, ASTNode child) {
        ChangeInfoImpl info = treeChange.getChangeByChild(child);
        ASTNode newChild = info.getNewChild();
        return (newChild == null || newChild.getTextLength() == 0) && PostprocessReformattingAspectImpl.wasEdgeChild(treeChange, info.getOldChildNode());
    }

    private static boolean wasEdgeChild(TreeChangeImpl treeChange, ASTNode oldChild) {
        List initial = treeChange.getInitialChildren();
        return !initial.isEmpty() && (oldChild == initial.get(0) || oldChild == initial.get(initial.size() - 1));
    }

    private static boolean isRightAfterErrorElement(ASTNode _node) {
        Function prevNode = node -> {
            ASTNode prev = node.getTreePrev();
            return prev != null ? TreeUtil.getLastChild((ASTNode)prev) : node.getTreeParent();
        };
        return JBIterable.generate((Object)_node, (Function)prevNode).skip(1).takeWhile(e -> e instanceof PsiWhiteSpace || e.getTextLength() == 0).filter(PsiErrorElement.class).isNotEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPostponedFormatting() {
        if (this.isDisabled()) {
            return;
        }
        try {
            FileViewProvider[] viewProviders;
            for (FileViewProvider viewProvider : viewProviders = this.getContext().myUpdatedProviders.keySet().toArray(new FileViewProvider[0])) {
                this.doPostponedFormatting(viewProvider);
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            LOG.assertTrue(this.getContext().myReformatElements.isEmpty(), this.getContext().myReformatElements);
        }
    }

    public void doPostponedFormatting(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(13);
        }
        if (this.isDisabled()) {
            return;
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            try {
                this.disablePostprocessFormattingInside(() -> this.doPostponedFormattingInner(viewProvider));
            }
            finally {
                this.getContext().myUpdatedProviders.remove((Object)viewProvider);
                this.getContext().myRaisingCandidates.remove((Object)viewProvider);
                this.getContext().myReformatElements.remove(viewProvider);
                viewProvider.putUserData(REFORMAT_ORIGINATOR, null);
            }
        });
    }

    public boolean isViewProviderLocked(@NotNull FileViewProvider fileViewProvider) {
        if (fileViewProvider == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(14);
        }
        return this.getContext().myReformatElements.containsKey(fileViewProvider);
    }

    public boolean isDocumentLocked(@NotNull Document document2) {
        VirtualFile file2;
        if (document2 == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(15);
        }
        if ((file2 = FileDocumentManager.getInstance().getFile(document2)) != null && file2.isValid()) {
            for (FileViewProvider provider : this.getContext().myReformatElements.keySet()) {
                if (!file2.equals(provider.getVirtualFile())) continue;
                return true;
            }
        }
        return false;
    }

    public void assertDocumentChangeIsAllowed(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(16);
        }
        if (this.isViewProviderLocked(viewProvider)) {
            Throwable cause = (Throwable)viewProvider.getUserData(REFORMAT_ORIGINATOR);
            @NonNls String message = "Document is locked by write PSI operations. Use PsiDocumentManager.doPostponedOperationsAndUnblockDocument() to commit PSI changes to the document.\nUnprocessed elements: " + this.dumpUnprocessedElements(viewProvider) + (cause == null ? "" : " \nSee cause stacktrace for the reason to lock.");
            throw cause == null ? new RuntimeException(message) : new RuntimeException(message, cause);
        }
    }

    private String dumpUnprocessedElements(@NotNull FileViewProvider provider) {
        if (provider == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(17);
        }
        StringBuilder sb = new StringBuilder();
        int count = 0;
        List<ASTNode> nodes = this.myContext.get().myReformatElements.get(provider);
        for (ASTNode node : nodes) {
            if (count >= 5) {
                sb.append(" and ").append(nodes.size() - count).append(" more.");
                break;
            }
            if (!sb.isEmpty()) {
                sb.append(", ");
            }
            sb.append(node.getElementType()).append(node.getTextRange());
            ++count;
        }
        return sb.toString();
    }

    private void postponeFormatting(@NotNull FileViewProvider viewProvider, @NotNull ASTNode child) {
        List<ASTNode> list2;
        if (viewProvider == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(18);
        }
        if (child == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(19);
        }
        if (!CodeEditUtil.isNodeGenerated((ASTNode)child) && child.getElementType() != TokenType.WHITE_SPACE) {
            int oldIndent = CodeEditUtil.getOldIndentation((ASTNode)child);
            LOG.assertTrue(oldIndent >= 0, (Object)("for not generated items old indentation must be defined: element=" + String.valueOf(child) + ", text=" + child.getText()));
        }
        if ((list2 = this.getContext().myReformatElements.get(viewProvider)) == null) {
            list2 = new ArrayList<ASTNode>();
            this.getContext().myReformatElements.put(viewProvider, list2);
            if (Holder.STORE_REFORMAT_ORIGINATOR_STACKTRACE) {
                viewProvider.putUserData(REFORMAT_ORIGINATOR, (Object)new Throwable());
            }
        }
        list2.add(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPostponedFormattingInner(@NotNull FileViewProvider key) {
        FileManager fileManager;
        FileViewProvider viewProvider;
        if (key == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(20);
        }
        List<ASTNode> astNodes = this.getContext().myReformatElements.remove(key);
        Document document2 = key.getDocument();
        if (document2 == null) {
            return;
        }
        VirtualFile virtualFile2 = key.getVirtualFile();
        if (!virtualFile2.isValid()) {
            return;
        }
        PsiManager manager2 = key.getManager();
        if (manager2 instanceof PsiManagerEx && (viewProvider = (fileManager = ((PsiManagerEx)manager2).getFileManager()).findCachedViewProvider(virtualFile2)) != key) {
            if (viewProvider == null) {
                viewProvider = fileManager.findViewProvider(virtualFile2);
            }
            if (viewProvider != null) {
                key = viewProvider;
                astNodes = this.getContext().myReformatElements.remove(key);
            }
        }
        List<Disposable> toDispose = Collections.emptyList();
        try {
            TreeSet<PostprocessFormattingTask> postProcessTasks = new TreeSet<PostprocessFormattingTask>();
            PostprocessReformattingAspectImpl.handleReformatMarkers(key, postProcessTasks);
            toDispose = new ArrayList<Disposable>(postProcessTasks);
            if (astNodes != null) {
                PostprocessReformattingAspectImpl.createActionsMap(astNodes, key, postProcessTasks);
            }
            while (!postProcessTasks.isEmpty()) {
                List<PostponedAction> normalizedActions = this.normalizeAndReorderPostponedActions(postProcessTasks, document2);
                toDispose.addAll(normalizedActions);
                FileViewProvider viewProvider2 = key;
                if (normalizedActions.isEmpty()) continue;
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager2.getProject());
                for (PostponedAction normalizedAction : normalizedActions) {
                    codeStyleManager.runWithDocCommentFormattingDisabled(viewProvider2.getPsi(viewProvider2.getBaseLanguage()), () -> normalizedAction.execute(viewProvider2));
                }
            }
            this.reparseByTextIfNeeded(key, document2);
        }
        finally {
            for (Disposable disposable : toDispose) {
                disposable.dispose();
            }
        }
    }

    private void reparseByTextIfNeeded(@NotNull FileViewProvider viewProvider, @NotNull Document document2) {
        if (viewProvider == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(21);
        }
        if (document2 == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(22);
        }
        if (PsiDocumentManager.getInstance((Project)this.myProject).isCommitted(document2)) {
            HashSet rootsToReparse = new HashSet();
            for (ASTNode node : this.myContext.get().myRaisingCandidates.get((Object)viewProvider)) {
                if (!PostprocessReformattingAspectImpl.hasRaiseableEdgeChild(node)) continue;
                ContainerUtil.addIfNotNull(rootsToReparse, (Object)SharedImplUtil.getContainingFile((ASTNode)node));
            }
            for (PsiFile file2 : viewProvider.getAllFiles()) {
                if (file2.getUserData(REPARSE_PENDING) == null && !rootsToReparse.contains(file2)) continue;
                ((PsiDocumentManagerEx)PsiDocumentManager.getInstance((Project)this.myProject)).reparseFileFromText((PsiFileImpl)file2);
                file2.putUserData(REPARSE_PENDING, null);
            }
        }
    }

    private static boolean hasRaiseableEdgeChild(ASTNode node) {
        ASTNode last;
        ASTNode first;
        for (first = node.getFirstChildNode(); first != null && first.getTextLength() == 0; first = first.getTreeNext()) {
        }
        for (last = node.getLastChildNode(); last != null && last.getTextLength() == 0; last = last.getTreePrev()) {
        }
        return first == null || last == null || PostprocessReformattingAspectImpl.isRaiseable(first) || PostprocessReformattingAspectImpl.isRaiseable(last);
    }

    private static boolean isRaiseable(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        PsiElement psi = node.getPsi();
        return psi instanceof PsiWhiteSpace || psi instanceof PsiComment;
    }

    @NotNull
    private List<PostponedAction> normalizeAndReorderPostponedActions(@NotNull Set<PostprocessFormattingTask> rangesToProcess, @NotNull Document document2) {
        if (rangesToProcess == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(23);
        }
        if (document2 == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(24);
        }
        ArrayList<PostprocessFormattingTask> freeFormattingActions = new ArrayList<PostprocessFormattingTask>();
        ArrayList<ReindentTask> indentActions = new ArrayList<ReindentTask>();
        PostprocessFormattingTask accumulatedTask = null;
        Iterator<PostprocessFormattingTask> iterator2 = rangesToProcess.iterator();
        while (iterator2.hasNext()) {
            PostprocessFormattingTask currentTask = iterator2.next();
            if (accumulatedTask == null) {
                accumulatedTask = currentTask;
                iterator2.remove();
                continue;
            }
            if (accumulatedTask.getStartOffset() > currentTask.getEndOffset() || accumulatedTask.getStartOffset() == currentTask.getEndOffset() && !PostprocessReformattingAspectImpl.canStickActionsTogether(accumulatedTask, currentTask)) {
                if (accumulatedTask instanceof ReindentTask) {
                    indentActions.add((ReindentTask)accumulatedTask);
                } else {
                    freeFormattingActions.add(accumulatedTask);
                }
                accumulatedTask = currentTask;
                iterator2.remove();
                continue;
            }
            if (accumulatedTask instanceof ReformatTask && currentTask instanceof ReindentTask) {
                if (accumulatedTask.getStartOffset() < currentTask.getStartOffset()) {
                    RangeMarker endOfRange = document2.createRangeMarker(accumulatedTask.getStartOffset(), currentTask.getStartOffset());
                    rangesToProcess.add(new ReformatTask(endOfRange));
                    iterator2 = rangesToProcess.iterator();
                    while (iterator2.next().getRange() != currentTask.getRange()) {
                    }
                }
                RangeMarker rangeToProcess = document2.createRangeMarker(currentTask.getEndOffset(), accumulatedTask.getEndOffset());
                freeFormattingActions.add(new ReformatWithHeadingWhitespaceTask(rangeToProcess));
                accumulatedTask = currentTask;
                iterator2.remove();
                continue;
            }
            if (!(accumulatedTask instanceof ReindentTask)) {
                iterator2.remove();
                boolean withLeadingWhitespace = accumulatedTask instanceof ReformatWithHeadingWhitespaceTask;
                if (accumulatedTask instanceof ReformatTask && currentTask instanceof ReformatWithHeadingWhitespaceTask && accumulatedTask.getStartOffset() == currentTask.getStartOffset()) {
                    withLeadingWhitespace = true;
                } else if (accumulatedTask instanceof ReformatWithHeadingWhitespaceTask && currentTask instanceof ReformatTask && accumulatedTask.getStartOffset() < currentTask.getStartOffset()) {
                    withLeadingWhitespace = false;
                }
                int newStart = Math.min(accumulatedTask.getStartOffset(), currentTask.getStartOffset());
                int newEnd = Math.max(accumulatedTask.getEndOffset(), currentTask.getEndOffset());
                RangeMarker rangeMarker = accumulatedTask.getStartOffset() == newStart && accumulatedTask.getEndOffset() == newEnd ? accumulatedTask.getRange() : (currentTask.getStartOffset() == newStart && currentTask.getEndOffset() == newEnd ? currentTask.getRange() : document2.createRangeMarker(newStart, newEnd));
                accumulatedTask = withLeadingWhitespace ? new ReformatWithHeadingWhitespaceTask(rangeMarker) : new ReformatTask(rangeMarker);
                continue;
            }
            if (!(currentTask instanceof ReindentTask)) continue;
            iterator2.remove();
        }
        if (accumulatedTask != null) {
            if (accumulatedTask instanceof ReindentTask) {
                indentActions.add((ReindentTask)accumulatedTask);
            } else {
                freeFormattingActions.add(accumulatedTask);
            }
        }
        Collections.reverse(freeFormattingActions);
        Collections.reverse(indentActions);
        ArrayList<PostponedAction> result2 = new ArrayList<PostponedAction>();
        if (!freeFormattingActions.isEmpty()) {
            FormatTextRanges ranges = new FormatTextRanges();
            ranges.setExtendToContext(true);
            for (PostprocessFormattingTask action2 : freeFormattingActions) {
                TextRange range = TextRange.create((Segment)action2);
                ranges.add(range, action2 instanceof ReformatWithHeadingWhitespaceTask);
            }
            result2.add(new ReformatRangesAction(ranges));
        }
        if (!indentActions.isEmpty()) {
            ReindentRangesAction reindentRangesAction = new ReindentRangesAction();
            for (ReindentTask action3 : indentActions) {
                reindentRangesAction.add(action3.getRange(), action3.getOldIndent());
            }
            result2.add(reindentRangesAction);
        }
        ArrayList<PostponedAction> arrayList = result2;
        if (arrayList == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    private static boolean canStickActionsTogether(PostprocessFormattingTask currentTask, PostprocessFormattingTask nextTask) {
        if (nextTask instanceof ReformatWithHeadingWhitespaceTask && nextTask.getStartOffset() == nextTask.getEndOffset()) {
            return false;
        }
        if (currentTask instanceof ReformatWithHeadingWhitespaceTask && currentTask.getStartOffset() == currentTask.getEndOffset()) {
            return false;
        }
        return !(currentTask instanceof ReindentTask);
    }

    private static void createActionsMap(@NotNull List<? extends ASTNode> astNodes, @NotNull FileViewProvider provider, final @NotNull Collection<? super PostprocessFormattingTask> rangesToProcess) {
        if (astNodes == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(26);
        }
        if (provider == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(27);
        }
        if (rangesToProcess == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(28);
        }
        final HashSet<? extends ASTNode> nodesToProcess = new HashSet<ASTNode>(astNodes);
        final Document document2 = provider.getDocument();
        if (document2 == null) {
            return;
        }
        for (ASTNode aSTNode : astNodes) {
            nodesToProcess.remove(aSTNode);
            FileElement fileElement = TreeUtil.getFileElement((TreeElement)((TreeElement)aSTNode));
            if (fileElement == null || ((PsiFile)fileElement.getPsi()).getViewProvider() != provider) continue;
            final boolean isGenerated = CodeEditUtil.isNodeGenerated((ASTNode)aSTNode);
            ((TreeElement)aSTNode).acceptTree((TreeElementVisitor)new RecursiveTreeElementVisitor(){
                private boolean inGeneratedContext;
                {
                    this.inGeneratedContext = !isGenerated;
                }

                protected boolean visitNode(TreeElement element) {
                    if (nodesToProcess.contains(element)) {
                        return false;
                    }
                    boolean currentNodeGenerated = CodeEditUtil.isNodeGenerated((ASTNode)element);
                    CodeEditUtil.setNodeGenerated((ASTNode)element, (boolean)false);
                    if (currentNodeGenerated && !this.inGeneratedContext) {
                        rangesToProcess.add(new ReformatTask(document2.createRangeMarker(element.getTextRange())));
                        this.inGeneratedContext = true;
                    }
                    if (!currentNodeGenerated && this.inGeneratedContext) {
                        if (element.getElementType() == TokenType.WHITE_SPACE) {
                            return false;
                        }
                        int oldIndent = CodeEditUtil.getOldIndentation((ASTNode)element);
                        if (oldIndent < 0) {
                            LOG.warn("For not generated items old indentation must be defined: element " + String.valueOf(element));
                            oldIndent = 0;
                        }
                        CodeEditUtil.setOldIndentation((TreeElement)element, (int)-1);
                        for (TextRange indentRange : 3.getEnabledRanges(element.getPsi())) {
                            rangesToProcess.add(new ReindentTask(document2.createRangeMarker(indentRange), oldIndent));
                        }
                        this.inGeneratedContext = false;
                    }
                    return true;
                }

                private static Iterable<TextRange> getEnabledRanges(@NotNull PsiElement element) {
                    if (element == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    ArrayList<TextRange> disabledRanges = new ArrayList<TextRange>();
                    for (DisabledIndentRangesProvider rangesProvider : DisabledIndentRangesProvider.EP_NAME.getExtensionList()) {
                        Collection<TextRange> providedDisabledRanges = rangesProvider.getDisabledIndentRanges(element);
                        if (providedDisabledRanges == null) continue;
                        disabledRanges.addAll(providedDisabledRanges);
                    }
                    return TextRangeUtil.excludeRanges((TextRange)element.getTextRange(), disabledRanges);
                }

                public void visitComposite(CompositeElement composite2) {
                    boolean oldGeneratedContext = this.inGeneratedContext;
                    super.visitComposite(composite2);
                    this.inGeneratedContext = oldGeneratedContext;
                }

                public void visitLeaf(LeafElement leaf) {
                    boolean oldGeneratedContext = this.inGeneratedContext;
                    super.visitLeaf(leaf);
                    this.inGeneratedContext = oldGeneratedContext;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PostprocessReformattingAspectImpl$3", "getEnabledRanges"));
                }
            });
        }
    }

    private static void handleReformatMarkers(@NotNull FileViewProvider key, final @NotNull Set<? super PostprocessFormattingTask> rangesToProcess) {
        Document document2;
        if (key == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(29);
        }
        if (rangesToProcess == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(30);
        }
        if ((document2 = key.getDocument()) == null) {
            return;
        }
        for (FileASTNode fileElement : ((AbstractFileViewProvider)key).getKnownTreeRoots()) {
            ((TreeElement)fileElement).acceptTree((TreeElementVisitor)new RecursiveTreeElementWalkingVisitor(){

                protected void visitNode(TreeElement element) {
                    if (CodeEditUtil.isMarkedToReformatBefore((TreeElement)element)) {
                        CodeEditUtil.markToReformatBefore((ASTNode)element, (boolean)false);
                        rangesToProcess.add(new ReformatWithHeadingWhitespaceTask(document2.createRangeMarker(element.getStartOffset(), element.getStartOffset())));
                    } else if (CodeEditUtil.isMarkedToReformat((ASTNode)element)) {
                        CodeEditUtil.markToReformat((ASTNode)element, (boolean)false);
                        rangesToProcess.add(new ReformatWithHeadingWhitespaceTask(document2.createRangeMarker(element.getStartOffset(), element.getStartOffset() + element.getTextLength())));
                    }
                    super.visitNode(element);
                }
            });
        }
    }

    private static void adjustIndentationInRange(@NotNull PsiFile file2, @NotNull Document document2, TextRange @NotNull [] indents, int indentAdjustment) {
        if (file2 == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(31);
        }
        if (document2 == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(32);
        }
        if (indents == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(33);
        }
        CharSequence charsSequence = document2.getCharsSequence();
        for (TextRange indent : indents) {
            String oldIndentStr = charsSequence.subSequence(indent.getStartOffset() + 1, indent.getEndOffset()).toString();
            int oldIndent = IndentHelperImpl.getIndent(file2, oldIndentStr, true);
            String newIndentStr = IndentHelperImpl.fillIndent(CodeStyle.getIndentOptions((PsiFile)file2), Math.max(oldIndent + indentAdjustment, 0));
            document2.replaceString(indent.getStartOffset() + 1, indent.getEndOffset(), (CharSequence)newIndentStr);
        }
    }

    private static int getNewIndent(@NotNull PsiFile psiFile, int firstWhitespace) {
        int startOffset;
        if (psiFile == null) {
            PostprocessReformattingAspectImpl.$$$reportNull$$$0(34);
        }
        Document document2 = psiFile.getViewProvider().getDocument();
        assert (document2 != null);
        int endOffset = startOffset = document2.getLineStartOffset(document2.getLineNumber(firstWhitespace));
        CharSequence charsSequence = document2.getCharsSequence();
        while (Character.isWhitespace(charsSequence.charAt(endOffset++))) {
        }
        String newIndentStr = charsSequence.subSequence(startOffset, endOffset - 1).toString();
        return IndentHelperImpl.getIndent(psiFile, newIndentStr, true);
    }

    public boolean isDisabled() {
        return this.getContext().myDisabledCounter > 0;
    }

    @TestOnly
    public void clear() {
        this.getContext().myReformatElements.clear();
    }

    private Context getContext() {
        return this.myContext.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 5: 
            case 7: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 10: 
            case 11: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PostprocessReformattingAspectImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 13: 
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileViewProvider";
                break;
            }
            case 15: 
            case 22: 
            case 24: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 17: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 20: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 23: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangesToProcess";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNodes";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PostprocessReformattingAspectImpl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeAndReorderPostponedActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "disablePostprocessFormattingInside";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "postponeFormattingInside";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "forcePostprocessFormatInside";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "forcePostprocessFormat";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
            case 10: 
            case 11: 
            case 25: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doPostponedFormatting";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isViewProviderLocked";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDocumentLocked";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "assertDocumentChangeIsAllowed";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "dumpUnprocessedElements";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "postponeFormatting";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doPostponedFormattingInner";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "reparseByTextIfNeeded";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "normalizeAndReorderPostponedActions";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createActionsMap";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "handleReformatMarkers";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "adjustIndentationInRange";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getNewIndent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 25 -> new IllegalStateException(string);
        };
    }

    private static final class Context {
        private int myPostponedCounter;
        private int myDisabledCounter;
        private final MultiMap<FileViewProvider, FileElement> myUpdatedProviders = MultiMap.create();
        private final MultiMap<FileViewProvider, ASTNode> myRaisingCandidates = MultiMap.create();
        private final Map<FileViewProvider, List<ASTNode>> myReformatElements = new HashMap<FileViewProvider, List<ASTNode>>();

        private Context() {
        }
    }

    private static final class Holder {
        private static final boolean STORE_REFORMAT_ORIGINATOR_STACKTRACE = ApplicationManager.getApplication().isInternal();

        private Holder() {
        }
    }

    private static interface PostponedAction
    extends Disposable {
        public void execute(@NotNull FileViewProvider var1);
    }

    private static abstract class PostprocessFormattingTask
    implements Comparable<PostprocessFormattingTask>,
    Segment,
    Disposable {
        @NotNull
        private final RangeMarker myRange;

        PostprocessFormattingTask(@NotNull RangeMarker rangeMarker) {
            if (rangeMarker == null) {
                PostprocessFormattingTask.$$$reportNull$$$0(0);
            }
            this.myRange = rangeMarker;
        }

        @Override
        public int compareTo(@NotNull PostprocessFormattingTask o) {
            RangeMarker o2;
            RangeMarker o1;
            if (o == null) {
                PostprocessFormattingTask.$$$reportNull$$$0(1);
            }
            if ((o1 = this.myRange).equals((Object)(o2 = o.myRange))) {
                return 0;
            }
            int diff = o2.getEndOffset() - o1.getEndOffset();
            if (diff == 0) {
                if (o1.getStartOffset() == o2.getStartOffset()) {
                    return 0;
                }
                if (o1.getStartOffset() == o1.getEndOffset()) {
                    return -1;
                }
                if (o2.getStartOffset() == o2.getEndOffset()) {
                    return 1;
                }
                return o1.getStartOffset() - o2.getStartOffset();
            }
            return diff;
        }

        @NotNull
        public RangeMarker getRange() {
            RangeMarker rangeMarker = this.myRange;
            if (rangeMarker == null) {
                PostprocessFormattingTask.$$$reportNull$$$0(2);
            }
            return rangeMarker;
        }

        public int getStartOffset() {
            return this.myRange.getStartOffset();
        }

        public int getEndOffset() {
            return this.myRange.getEndOffset();
        }

        public void dispose() {
            if (this.myRange.isValid()) {
                this.myRange.dispose();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeMarker";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/PostprocessReformattingAspectImpl$PostprocessFormattingTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/PostprocessReformattingAspectImpl$PostprocessFormattingTask";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ReindentTask
    extends PostprocessFormattingTask {
        private final int myOldIndent;

        ReindentTask(@NotNull RangeMarker rangeMarker, int oldIndent) {
            if (rangeMarker == null) {
                ReindentTask.$$$reportNull$$$0(0);
            }
            super(rangeMarker);
            this.myOldIndent = oldIndent;
        }

        int getOldIndent() {
            return this.myOldIndent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/psi/impl/source/PostprocessReformattingAspectImpl$ReindentTask", "<init>"));
        }
    }

    private static final class ReformatTask
    extends PostprocessFormattingTask {
        ReformatTask(@NotNull RangeMarker rangeMarker) {
            if (rangeMarker == null) {
                ReformatTask.$$$reportNull$$$0(0);
            }
            super(rangeMarker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/psi/impl/source/PostprocessReformattingAspectImpl$ReformatTask", "<init>"));
        }
    }

    private static final class ReformatWithHeadingWhitespaceTask
    extends PostprocessFormattingTask {
        ReformatWithHeadingWhitespaceTask(@NotNull RangeMarker rangeMarker) {
            if (rangeMarker == null) {
                ReformatWithHeadingWhitespaceTask.$$$reportNull$$$0(0);
            }
            super(rangeMarker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/psi/impl/source/PostprocessReformattingAspectImpl$ReformatWithHeadingWhitespaceTask", "<init>"));
        }
    }

    private final class ReformatRangesAction
    implements PostponedAction {
        private final FormatTextRanges myRanges;

        ReformatRangesAction(FormatTextRanges ranges) {
            if (ranges == null) {
                ReformatRangesAction.$$$reportNull$$$0(0);
            }
            this.myRanges = ranges;
        }

        @Override
        public void execute(@NotNull FileViewProvider viewProvider) {
            if (viewProvider == null) {
                ReformatRangesAction.$$$reportNull$$$0(1);
            }
            PsiFile file2 = viewProvider.getPsi(viewProvider.getBaseLanguage());
            FormattingService formattingService = FormattingServiceUtil.findService(file2, false, false);
            this.commitDocument(viewProvider);
            formattingService.formatRanges(file2, (FormattingRangesInfo)this.getRanges(formattingService), true, true);
        }

        private void commitDocument(@NotNull FileViewProvider viewProvider) {
            if (viewProvider == null) {
                ReformatRangesAction.$$$reportNull$$$0(2);
            }
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)PostprocessReformattingAspectImpl.this.myProject);
            Document document2 = viewProvider.getDocument();
            assert (document2 != null);
            documentManager.commitDocument(document2);
        }

        private FormatTextRanges getRanges(@NotNull FormattingService formattingService) {
            if (formattingService == null) {
                ReformatRangesAction.$$$reportNull$$$0(3);
            }
            if (formattingService instanceof ExternalFormatProcessorAdapter) {
                return this.myRanges;
            }
            FormatTextRanges textRanges = this.myRanges.ensureNonEmpty();
            textRanges.setExtendToContext(true);
            return textRanges;
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ranges";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewProvider";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formattingService";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/source/PostprocessReformattingAspectImpl$ReformatRangesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "commitDocument";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRanges";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ReindentRangesAction
    implements PostponedAction {
        private final List<Pair<Integer, RangeMarker>> myRangesToReindent = new ArrayList<Pair<Integer, RangeMarker>>();

        private ReindentRangesAction() {
        }

        public void add(@NotNull RangeMarker rangeMarker, int oldIndent) {
            if (rangeMarker == null) {
                ReindentRangesAction.$$$reportNull$$$0(0);
            }
            this.myRangesToReindent.add((Pair<Integer, RangeMarker>)new Pair((Object)oldIndent, (Object)rangeMarker));
        }

        @Override
        public void execute(@NotNull FileViewProvider viewProvider) {
            if (viewProvider == null) {
                ReindentRangesAction.$$$reportNull$$$0(1);
            }
            Document document2 = viewProvider.getDocument();
            assert (document2 != null);
            PsiFile psiFile = viewProvider.getPsi(viewProvider.getBaseLanguage());
            for (Pair<Integer, RangeMarker> integerRangeMarkerPair : this.myRangesToReindent) {
                RangeMarker marker = (RangeMarker)integerRangeMarkerPair.second;
                CharSequence charsSequence = document2.getCharsSequence().subSequence(marker.getStartOffset(), marker.getEndOffset());
                int oldIndent = (Integer)integerRangeMarkerPair.first;
                TextRange[] whitespaces = CharArrayUtil.getIndents((CharSequence)charsSequence, (int)marker.getStartOffset());
                int indentAdjustment = PostprocessReformattingAspectImpl.getNewIndent(psiFile, marker.getStartOffset()) - oldIndent;
                if (indentAdjustment == 0) continue;
                PostprocessReformattingAspectImpl.adjustIndentationInRange(psiFile, document2, whitespaces, indentAdjustment);
            }
        }

        public void dispose() {
            for (Pair<Integer, RangeMarker> pair : this.myRangesToReindent) {
                RangeMarker marker = (RangeMarker)pair.second;
                if (!marker.isValid()) continue;
                marker.dispose();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeMarker";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewProvider";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/source/PostprocessReformattingAspectImpl$ReindentRangesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class LangPomModel
    extends PomModelImpl {
        private final PostprocessReformattingAspect myAspect;

        LangPomModel(@NotNull Project project2) {
            if (project2 == null) {
                LangPomModel.$$$reportNull$$$0(0);
            }
            super(project2);
            this.myAspect = new PostprocessReformattingAspectImpl(project2);
        }

        public <T extends PomModelAspect> T getModelAspect(@NotNull Class<T> aClass) {
            if (aClass == null) {
                LangPomModel.$$$reportNull$$$0(1);
            }
            return (T)(this.myAspect.getClass().equals(aClass) || this.myAspect.getClass().getSuperclass().equals(aClass) ? this.myAspect : super.getModelAspect(aClass));
        }

        protected void updateDependentAspects(PomModelEvent event) {
            super.updateDependentAspects(event);
            this.myAspect.update(event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/source/PostprocessReformattingAspectImpl$LangPomModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getModelAspect";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

