/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.CodeStyleBundle;
import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.codeStyle.cache.CodeStyleCachingService;
import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.FormatTextRange;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.service.FormattingServiceUtil;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PlainTextTokenTypes;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.DocCommentSettings;
import com.intellij.psi.codeStyle.FormattingModeAwareIndentAdjuster;
import com.intellij.psi.codeStyle.Indent;
import com.intellij.psi.codeStyle.LanguageCodeStyleProvider;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.ChangedRangesUtil;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.impl.source.codeStyle.CodeFormattingData;
import com.intellij.psi.impl.source.codeStyle.CodeStyleManagerRunnable;
import com.intellij.psi.impl.source.codeStyle.CoreCodeStyleUtil;
import com.intellij.psi.impl.source.codeStyle.FormatterBasedIndentAdjuster;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import com.intellij.psi.impl.source.codeStyle.IndentHelperImpl;
import com.intellij.psi.impl.source.codeStyle.IndentImpl;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CodeStyleManagerImpl
extends CodeStyleManager
implements FormattingModeAwareIndentAdjuster {
    private static final Logger LOG = Logger.getInstance(CodeStyleManagerImpl.class);
    private final ThreadLocal<FormattingMode> myCurrentFormattingMode = ThreadLocal.withInitial(() -> FormattingMode.REFORMAT);
    private final Project myProject;

    public CodeStyleManagerImpl(Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(0);
        }
        return project2;
    }

    @NotNull
    public PsiElement reformat(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = this.reformat(element, false);
        if (psiElement == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement reformat(@NotNull PsiElement element, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        if (element == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(3);
        }
        CheckUtil.checkWritable((PsiElement)element);
        if (!SourceTreeToPsiMap.hasTreeElement((PsiElement)element)) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(4);
            }
            return psiElement;
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 == null) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(5);
            }
            return psiElement;
        }
        PsiElement psiElement = FormattingServiceUtil.formatElement(element, canChangeWhiteSpacesOnly);
        if (psiElement == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    public void reformatText(@NotNull PsiFile file2, @NotNull Collection<? extends TextRange> ranges, boolean processChangedTextOnly) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(7);
        }
        if (ranges == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(8);
        }
        FormatTextRanges formatRanges = new FormatTextRanges();
        ranges.forEach(range -> formatRanges.add((TextRange)range, true));
        this.reformatText(file2, formatRanges, (myRanges, psiFile) -> CodeStyleManagerImpl.isFullRange(myRanges, psiFile) && !processChangedTextOnly);
    }

    public PsiElement reformatRange(@NotNull PsiElement element, int startOffset, int endOffset, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        if (element == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(9);
        }
        return CodeStyleManagerImpl.reformatRangeImpl(element, startOffset, endOffset, canChangeWhiteSpacesOnly);
    }

    public PsiElement reformatRange(@NotNull PsiElement element, int startOffset, int endOffset) throws IncorrectOperationException {
        if (element == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(10);
        }
        return CodeStyleManagerImpl.reformatRangeImpl(element, startOffset, endOffset, false);
    }

    private static void transformAllChildren(ASTNode file2) {
        ((TreeElement)file2).acceptTree((TreeElementVisitor)new RecursiveTreeElementWalkingVisitor(){});
    }

    public void reformatText(@NotNull PsiFile file2, int startOffset, int endOffset) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(11);
        }
        this.reformatText(file2, Collections.singleton(new TextRange(startOffset, endOffset)));
    }

    public void reformatText(@NotNull PsiFile file2, @NotNull Collection<? extends TextRange> ranges) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(12);
        }
        if (ranges == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(13);
        }
        FormatTextRanges formatRanges = new FormatTextRanges();
        ranges.forEach(range -> formatRanges.add((TextRange)range, true));
        this.reformatText(file2, formatRanges, (myRanges, psiFile) -> CodeStyleManagerImpl.isFullRange(myRanges, psiFile));
    }

    public void reformatChanges(@NotNull PsiFile file2, @NotNull ChangedRangesInfo info) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(14);
        }
        if (info == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(15);
        }
        this.ensureDocumentCommitted(file2);
        FormatTextRanges formatRanges = new FormatTextRanges(info, ChangedRangesUtil.processChangedRanges(file2, info));
        this.reformatText(file2, formatRanges, (ranges, psiFile) -> CodeStyleManagerImpl.isFullRange(ranges, psiFile));
    }

    private static boolean isFullRange(FormatTextRanges ranges, PsiFile psiFile) {
        return ranges.getRanges().size() == 1 && ranges.getRanges().get(0).getTextRange().equals((Object)psiFile.getTextRange());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reformatText(@NotNull PsiFile file2, @NotNull FormatTextRanges ranges, BiFunction<FormatTextRanges, PsiFile, Boolean> isFullRange) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(16);
        }
        if (ranges == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(17);
        }
        if (ranges.isEmpty()) {
            return;
        }
        this.ensureDocumentCommitted(file2);
        CheckUtil.checkWritable((PsiElement)file2);
        if (!SourceTreeToPsiMap.hasTreeElement((PsiElement)file2)) {
            return;
        }
        ASTNode treeElement = SourceTreeToPsiMap.psiElementToTree((PsiElement)file2);
        CodeStyleManagerImpl.transformAllChildren(treeElement);
        LOG.assertTrue(file2.isValid(), (Object)("File name: " + file2.getName() + " , class: " + file2.getClass().getSimpleName()));
        ((CodeStyleManager.Listener)this.myProject.getMessageBus().syncPublisher(CodeStyleManager.Listener.TOPIC)).beforeReformatText(file2);
        try {
            if (FormatterUtil.isFormatterCalledExplicitly()) {
                CodeStyleManagerImpl.removeEndingWhiteSpaceFromEachRange(file2, ranges);
            }
            FormattingServiceUtil.formatRanges(file2, ranges, false, isFullRange.apply(ranges, file2));
        }
        finally {
            ((CodeStyleManager.Listener)this.myProject.getMessageBus().syncPublisher(CodeStyleManager.Listener.TOPIC)).afterReformatText(file2);
        }
    }

    private void ensureDocumentCommitted(@NotNull PsiFile file2) {
        PsiDocumentManager documentManager;
        Document document2;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(18);
        }
        if ((document2 = (documentManager = PsiDocumentManager.getInstance((Project)this.myProject)).getDocument(file2)) != null) {
            documentManager.commitDocument(document2);
        }
    }

    private static void removeEndingWhiteSpaceFromEachRange(@NotNull PsiFile file2, @NotNull FormatTextRanges ranges) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(19);
        }
        if (ranges == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(20);
        }
        for (FormatTextRange formatRange : ranges.getRanges()) {
            PsiElement prev;
            TextRange range = formatRange.getTextRange();
            int rangeStart = range.getStartOffset();
            int rangeEnd = range.getEndOffset();
            PsiElement lastElementInRange = CoreCodeStyleUtil.findElementInTreeWithFormatterEnabled(file2, rangeEnd);
            if (!(lastElementInRange instanceof PsiWhiteSpace) || rangeStart >= lastElementInRange.getTextRange().getStartOffset() || (prev = lastElementInRange.getPrevSibling()) == null) continue;
            int newEnd = prev.getTextRange().getEndOffset();
            formatRange.setTextRange(new TextRange(rangeStart, newEnd));
        }
    }

    private static PsiElement reformatRangeImpl(@NotNull PsiElement element, int startOffset, int endOffset, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        if (element == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(21);
        }
        LOG.assertTrue(element.isValid());
        CheckUtil.checkWritable((PsiElement)element);
        if (!SourceTreeToPsiMap.hasTreeElement((PsiElement)element)) {
            return element;
        }
        return FormattingServiceUtil.formatElement(element, TextRange.create((int)startOffset, (int)endOffset), canChangeWhiteSpacesOnly);
    }

    public void reformatNewlyAddedElement(@NotNull ASTNode parent, @NotNull ASTNode addedElement) throws IncorrectOperationException {
        FormattingModelBuilder builder;
        if (parent == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(22);
        }
        if (addedElement == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(23);
        }
        LOG.assertTrue(addedElement.getTreeParent() == parent, (Object)"addedElement must be added to parent");
        PsiElement psiElement = parent.getPsi();
        PsiFile containingFile = psiElement.getContainingFile();
        FileViewProvider fileViewProvider = containingFile.getViewProvider();
        if (fileViewProvider instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
            containingFile = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
        }
        assert (containingFile != null);
        TextRange textRange = addedElement.getTextRange();
        Document document2 = fileViewProvider.getDocument();
        if (document2 instanceof DocumentWindow) {
            DocumentWindow documentWindow = (DocumentWindow)document2;
            if (CodeFormatterFacade.shouldDelegateToTopLevel(containingFile)) {
                containingFile = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getTopLevelFile((PsiElement)containingFile);
                textRange = documentWindow.injectedToHost(textRange);
            }
        }
        if ((builder = LanguageFormatting.INSTANCE.forContext((PsiElement)containingFile)) != null) {
            FormattingModel model2 = CoreFormatterUtil.buildModel(builder, (PsiElement)containingFile, CodeStyleManagerImpl.getSettings(containingFile), FormattingMode.REFORMAT);
            FormatterEx.getInstanceEx().formatAroundRange(model2, CodeStyleManagerImpl.getSettings(containingFile), containingFile, textRange);
        }
        this.adjustLineIndent(containingFile, textRange);
    }

    public int adjustLineIndent(@NotNull PsiFile file2, int offset) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(24);
        }
        return (Integer)PostprocessReformattingAspect.getInstance((Project)file2.getProject()).disablePostprocessFormattingInside(() -> this.doAdjustLineIndentByOffset(file2, offset, FormattingMode.ADJUST_INDENT));
    }

    public int adjustLineIndent(@NotNull Document document2, int offset, FormattingMode mode) {
        if (document2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(25);
        }
        return (Integer)PostprocessReformattingAspect.getInstance((Project)this.getProject()).disablePostprocessFormattingInside(() -> {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            documentManager.commitDocument(document2);
            PsiFile file2 = documentManager.getPsiFile(document2);
            if (file2 == null) {
                return offset;
            }
            return this.doAdjustLineIndentByOffset(file2, offset, mode);
        });
    }

    public int adjustLineIndent(@NotNull Document document2, int offset) {
        if (document2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(26);
        }
        return this.adjustLineIndent(document2, offset, FormattingMode.ADJUST_INDENT);
    }

    private int doAdjustLineIndentByOffset(@NotNull PsiFile file2, int offset, FormattingMode mode) {
        Integer result2;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(27);
        }
        return (result2 = (Integer)new CodeStyleManagerRunnable<Integer>(this, this, mode){

            @Override
            protected Integer doPerform(int offset, TextRange range) {
                return FormatterEx.getInstanceEx().adjustLineIndent(this.myModel, this.mySettings, this.myIndentOptions, offset, this.mySignificantRange);
            }

            @Override
            protected Integer computeValueInsidePlainComment(PsiFile file2, int offset, Integer defaultValue) {
                return CharArrayUtil.shiftForward((CharSequence)file2.getViewProvider().getContents(), (int)offset, (String)" \t");
            }

            @Override
            protected Integer adjustResultForInjected(Integer result2, DocumentWindow documentWindow) {
                return result2 != null ? Integer.valueOf(documentWindow.hostToInjected(result2.intValue())) : null;
            }
        }.perform(file2, offset, null, null)) != null ? result2 : offset;
    }

    public void adjustLineIndent(@NotNull PsiFile file2, TextRange rangeToAdjust) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(28);
        }
        new CodeStyleManagerRunnable<Object>(this, this, FormattingMode.ADJUST_INDENT){

            @Override
            protected Object doPerform(int offset, TextRange range) {
                FormatterEx.getInstanceEx().adjustLineIndentsForRange(this.myModel, this.mySettings, this.myIndentOptions, range);
                return null;
            }
        }.perform(file2, -1, rangeToAdjust, null);
    }

    @Nullable
    public String getLineIndent(@NotNull PsiFile file2, int offset) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(29);
        }
        return this.getLineIndent(file2, offset, FormattingMode.ADJUST_INDENT);
    }

    @Nullable
    public String getLineIndent(@NotNull PsiFile file2, int offset, FormattingMode mode) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(30);
        }
        return new CodeStyleManagerRunnable<String>(this, this, mode){

            @Override
            protected boolean useDocumentBaseFormattingModel() {
                return false;
            }

            @Override
            protected String doPerform(int offset, TextRange range) {
                return FormatterEx.getInstanceEx().getLineIndent(this.myModel, this.mySettings, this.myIndentOptions, offset, this.mySignificantRange);
            }
        }.perform(file2, offset, null, null);
    }

    @Nullable
    public List<String> getLineIndents(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(31);
        }
        return new CodeStyleManagerRunnable<List<String>>(this, this, FormattingMode.ADJUST_INDENT){

            @Override
            protected boolean useDocumentBaseFormattingModel() {
                return false;
            }

            @Override
            protected List<String> doPerform(int offset, TextRange range) {
                return FormatterEx.getInstanceEx().getLineIndents(this.myModel, this.mySettings, this.myIndentOptions);
            }
        }.perform(file2, 0, null, null);
    }

    @Nullable
    public String getLineIndent(@NotNull Document document2, int offset) {
        PsiFile file2;
        if (document2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(32);
        }
        if ((file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document2)) == null) {
            return "";
        }
        return this.getLineIndent(file2, offset);
    }

    @Deprecated
    public boolean isLineToBeIndented(@NotNull PsiFile file2, int offset) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(33);
        }
        if (!SourceTreeToPsiMap.hasTreeElement((PsiElement)file2)) {
            return false;
        }
        CharSequence chars = file2.getViewProvider().getContents();
        int start2 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)" \t");
        if (start2 > 0 && chars.charAt(start2) != '\n' && chars.charAt(start2) != '\r') {
            return false;
        }
        int end = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)" \t");
        if (end >= chars.length()) {
            return false;
        }
        ASTNode element = SourceTreeToPsiMap.psiElementToTree((PsiElement)CoreCodeStyleUtil.findElementInTreeWithFormatterEnabled(file2, end));
        if (element == null) {
            return false;
        }
        if (element.getElementType() == TokenType.WHITE_SPACE) {
            return false;
        }
        if (element.getElementType() == PlainTextTokenTypes.PLAIN_TEXT) {
            return false;
        }
        return !CodeStyleManagerImpl.getSettings((PsiFile)file2).getCommonSettings((Language)file2.getLanguage()).KEEP_FIRST_COLUMN_COMMENT || !CodeStyleManagerImpl.isCommentToken(element) || IndentHelper.getInstance().getIndent(this.myProject, file2.getFileType(), element, true) != 0;
    }

    private static boolean isCommentToken(ASTNode element) {
        Language language = element.getElementType().getLanguage();
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        if (commenter instanceof CodeDocumentationAwareCommenter) {
            CodeDocumentationAwareCommenter documentationAwareCommenter = (CodeDocumentationAwareCommenter)commenter;
            return element.getElementType() == documentationAwareCommenter.getBlockCommentTokenType() || element.getElementType() == documentationAwareCommenter.getLineCommentTokenType();
        }
        return false;
    }

    public Indent getIndent(String text2, FileType fileType2) {
        int indent = IndentHelperImpl.getIndent(CodeStyle.getSettings((Project)this.myProject).getIndentOptions(fileType2), text2, true);
        int indentLevel = indent / 10000;
        int spaceCount = indent - indentLevel * 10000;
        return new IndentImpl(CodeStyle.getSettings((Project)this.myProject), indentLevel, spaceCount, fileType2);
    }

    public String fillIndent(Indent indent, FileType fileType2) {
        IndentImpl indent1 = (IndentImpl)indent;
        int indentLevel = indent1.getIndentLevel();
        int spaceCount = indent1.getSpaceCount();
        CodeStyleSettings settings = CodeStyle.getSettings((Project)this.myProject);
        if (indentLevel < 0) {
            spaceCount += indentLevel * settings.getIndentSize(fileType2);
            indentLevel = 0;
            if (spaceCount < 0) {
                spaceCount = 0;
            }
        } else if (spaceCount < 0) {
            int v = (-spaceCount + settings.getIndentSize(fileType2) - 1) / settings.getIndentSize(fileType2);
            spaceCount += v * settings.getIndentSize(fileType2);
            if ((indentLevel -= v) < 0) {
                indentLevel = 0;
            }
        }
        return IndentHelperImpl.fillIndent(this.myProject, fileType2, indentLevel * 10000 + spaceCount);
    }

    public Indent zeroIndent() {
        return new IndentImpl(CodeStyle.getSettings((Project)this.myProject), 0, 0, null);
    }

    @NotNull
    private static CodeStyleSettings getSettings(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(34);
        }
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((PsiFile)file2);
        if (codeStyleSettings == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(35);
        }
        return codeStyleSettings;
    }

    public boolean isSequentialProcessingAllowed() {
        return CoreCodeStyleUtil.isSequentialProcessingAllowed();
    }

    public void performActionWithFormatterDisabled(Runnable r) {
        this.performActionWithFormatterDisabled(() -> {
            r.run();
            return null;
        });
    }

    public <T extends Throwable> void performActionWithFormatterDisabled(ThrowableRunnable<T> r) throws T {
        Throwable[] throwable = new Throwable[1];
        this.performActionWithFormatterDisabled(() -> {
            try {
                r.run();
            }
            catch (Throwable t) {
                throwable[0] = t;
            }
            return null;
        });
        if (throwable[0] != null) {
            throw throwable[0];
        }
    }

    public <T> T performActionWithFormatterDisabled(Computable<T> r) {
        PostprocessReformattingAspect component2 = PostprocessReformattingAspect.getInstance((Project)this.getProject());
        return (T)component2.disablePostprocessFormattingInside(r);
    }

    public FormattingMode getCurrentFormattingMode() {
        return this.myCurrentFormattingMode.get();
    }

    void setCurrentFormattingMode(@NotNull FormattingMode mode) {
        if (mode == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(36);
        }
        this.myCurrentFormattingMode.set(mode);
    }

    public int getSpacing(@NotNull PsiFile file2, int offset) {
        FormattingModel model2;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(37);
        }
        return (model2 = CodeStyleManagerImpl.createFormattingModel(file2, offset)) == null ? -1 : FormatterEx.getInstance().getSpacingForBlockAtOffset(model2, offset);
    }

    public int getMinLineFeeds(@NotNull PsiFile file2, int offset) {
        FormattingModel model2;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(38);
        }
        return (model2 = CodeStyleManagerImpl.createFormattingModel(file2, offset)) == null ? -1 : FormatterEx.getInstance().getMinLineFeedsBeforeBlockAtOffset(model2, offset);
    }

    @Nullable
    private static FormattingModel createFormattingModel(@NotNull PsiFile file2, int offset) {
        FormattingModelBuilder builder;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(39);
        }
        if ((builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file2)) == null) {
            return null;
        }
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)file2);
        return builder.createModel(FormattingContext.create((PsiElement)file2, (TextRange)TextRange.create((int)offset, (int)offset), (CodeStyleSettings)settings, (FormattingMode)FormattingMode.REFORMAT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithDocCommentFormattingDisabled(@NotNull PsiFile file2, @NotNull Runnable runnable2) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(40);
        }
        if (runnable2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(41);
        }
        DocCommentSettings docSettings = this.getDocCommentSettings(file2);
        boolean currDocFormattingEnabled = docSettings.isDocFormattingEnabled();
        docSettings.setDocFormattingEnabled(false);
        try {
            runnable2.run();
        }
        finally {
            docSettings.setDocFormattingEnabled(currDocFormattingEnabled);
        }
    }

    @NotNull
    public DocCommentSettings getDocCommentSettings(@NotNull PsiFile file2) {
        Language language;
        LanguageCodeStyleProvider settingsProvider;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(42);
        }
        if ((settingsProvider = LanguageCodeStyleProvider.forLanguage((Language)(language = file2.getLanguage()))) != null) {
            DocCommentSettings docCommentSettings = settingsProvider.getDocCommentSettings(CodeStyle.getSettings((PsiFile)file2));
            if (docCommentSettings == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(43);
            }
            return docCommentSettings;
        }
        DocCommentSettings docCommentSettings = DocCommentSettings.DEFAULTS;
        if (docCommentSettings == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(44);
        }
        return docCommentSettings;
    }

    public void scheduleIndentAdjustment(@NotNull Document document2, int offset) {
        if (document2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(45);
        }
        FormatterBasedIndentAdjuster.scheduleIndentAdjustment(this.myProject, document2, offset);
    }

    public void scheduleReformatWhenSettingsComputed(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(46);
        }
        if (LightVirtualFile.shouldSkipEventSystem((VirtualFile)file2.getViewProvider().getVirtualFile())) {
            this.ensureDocumentCommitted(file2);
            this.formatBlockingPostprocess(file2);
            return;
        }
        Runnable commandRunnable = () -> {
            if (file2.isValid()) {
                WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)CodeStyleBundle.message((String)"command.name.reformat", (Object[])new Object[0]), null, () -> this.formatBlockingPostprocess(file2), (PsiFile[])new PsiFile[]{file2});
            }
        };
        CodeStyleCachingService.getInstance((Project)this.myProject).scheduleWhenSettingsComputed(file2, () -> {
            NonBlockingReadAction prepareDataAction = ReadAction.nonBlocking(() -> CodeFormattingData.prepare(file2, Collections.singletonList(file2.getTextRange()))).expireWhen(() -> this.myProject.isDisposed()).withDocumentsCommitted(this.myProject);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.ensureDocumentCommitted(file2);
                commandRunnable.run();
            } else if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
                prepareDataAction.executeSynchronously();
                commandRunnable.run();
            } else {
                prepareDataAction.finishOnUiThread(ModalityState.nonModal(), data2 -> commandRunnable.run()).submit((Executor)AppExecutorUtil.getAppExecutorService());
            }
        });
    }

    private void formatBlockingPostprocess(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(47);
        }
        PostprocessReformattingAspect.getInstance((Project)this.myProject).disablePostprocessFormattingInside(() -> this.reformat((PsiElement)this.ensureValid(file2)));
    }

    @NotNull
    private PsiFile ensureValid(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(48);
        }
        if (!file2.isValid()) {
            PsiFile fileToUse = PsiUtilCore.getPsiFile((Project)this.myProject, (VirtualFile)file2.getViewProvider().getVirtualFile());
            CodeFormattingData.copy(file2, fileToUse);
            PsiFile psiFile = fileToUse;
            if (psiFile == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(49);
            }
            return psiFile;
        }
        PsiFile psiFile = file2;
        if (psiFile == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(50);
        }
        return psiFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 36, 37, 38, 39, 40, 41, 42, 45, 46, 47, 48 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 46: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedElement";
                break;
            }
            case 25: 
            case 26: 
            case 32: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "reformat";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocCommentSettings";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureValid";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reformat";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "reformatText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reformatRange";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "reformatChanges";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "ensureDocumentCommitted";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeEndingWhiteSpaceFromEachRange";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "reformatRangeImpl";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "reformatNewlyAddedElement";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "adjustLineIndent";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doAdjustLineIndentByOffset";
                break;
            }
            case 29: 
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndent";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndents";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isLineToBeIndented";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentFormattingMode";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getMinLineFeeds";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createFormattingModel";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "runWithDocCommentFormattingDisabled";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getDocCommentSettings";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "scheduleIndentAdjustment";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "scheduleReformatWhenSettingsComputed";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "formatBlockingPostprocess";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "ensureValid";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 36, 37, 38, 39, 40, 41, 42, 45, 46, 47, 48 -> new IllegalArgumentException(string);
        };
    }
}

