/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.statistics.impl;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.SettingsSavingComponent;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.statistics.impl.StatisticsManagerImplKt;
import com.intellij.psi.statistics.impl.StatisticsUnit;
import com.intellij.util.ScrambledOutputStream;
import com.intellij.util.io.PathKt;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001b\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\u001f\u001a\u00020\u0018H\u0096@\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u0011H\u0002J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u0011H\u0002J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&H\u0007R(\u0010\u0005\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\b \t*\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/psi/statistics/impl/StatisticsManagerImpl;", "Lcom/intellij/psi/statistics/StatisticsManager;", "Lcom/intellij/configurationStore/SettingsSavingComponent;", "<init>", "()V", "units", "Ljava/util/ArrayList;", "Ljava/lang/ref/SoftReference;", "Lcom/intellij/psi/statistics/impl/StatisticsUnit;", "kotlin.jvm.PlatformType", "modifiedUnits", "Ljava/util/HashSet;", "testingStatistics", "", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getUseCount", "", "info", "Lcom/intellij/psi/statistics/StatisticsInfo;", "doGetUseCount", "getLastUseRecency", "doGetRecency", "incUseCount", "", "doIncUseCount", "getAllValues", "", "context", "", "(Ljava/lang/String;)[Lcom/intellij/psi/statistics/StatisticsInfo;", "save", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getUnit", "unitNumber", "saveUnit", "enableStatistics", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nStatisticsManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticsManagerImpl.kt\ncom/intellij/psi/statistics/impl/StatisticsManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,179:1\n1#2:180\n1586#3:181\n1661#3,3:182\n37#4,2:185\n*S KotlinDebug\n*F\n+ 1 StatisticsManagerImpl.kt\ncom/intellij/psi/statistics/impl/StatisticsManagerImpl\n*L\n100#1:181\n100#1:182,3\n101#1:185,2\n*E\n"})
public final class StatisticsManagerImpl
extends StatisticsManager
implements SettingsSavingComponent {
    @NotNull
    private final ArrayList<SoftReference<StatisticsUnit>> units = new ArrayList(Collections.nCopies(997, null));
    @NotNull
    private final HashSet<StatisticsUnit> modifiedUnits = new HashSet();
    private boolean testingStatistics;
    @NotNull
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public int getUseCount(@NotNull StatisticsInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (info == StatisticsInfo.EMPTY) {
            return 0;
        }
        int useCount = 0;
        for (StatisticsInfo conjunct : info.getConjuncts()) {
            Intrinsics.checkNotNull((Object)conjunct);
            useCount = Math.max(this.doGetUseCount(conjunct), useCount);
        }
        return useCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int doGetUseCount(StatisticsInfo info) {
        int n;
        String string = info.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContext(...)");
        String key = string;
        int unitNumber = StatisticsManagerImplKt.access$getUnitNumber(key);
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            n = this.getUnit(unitNumber).getData(key, info.getValue());
        }
        finally {
            readLock.unlock();
        }
        return n;
    }

    public int getLastUseRecency(@NotNull StatisticsInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (info == StatisticsInfo.EMPTY) {
            return 0;
        }
        int recency = Integer.MAX_VALUE;
        for (StatisticsInfo conjunct : info.getConjuncts()) {
            Intrinsics.checkNotNull((Object)conjunct);
            recency = Math.min(this.doGetRecency(conjunct), recency);
        }
        return recency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int doGetRecency(StatisticsInfo info) {
        int n;
        String string = info.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContext(...)");
        String key1 = string;
        int unitNumber = StatisticsManagerImplKt.access$getUnitNumber(key1);
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            StatisticsUnit unit = this.getUnit(unitNumber);
            n = unit.getRecency(key1, info.getValue());
        }
        finally {
            readLock.unlock();
        }
        return n;
    }

    public void incUseCount(@NotNull StatisticsInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (info == StatisticsInfo.EMPTY) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !this.testingStatistics) {
            return;
        }
        for (StatisticsInfo conjunct : info.getConjuncts()) {
            Intrinsics.checkNotNull((Object)conjunct);
            this.doIncUseCount(conjunct);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doIncUseCount(StatisticsInfo info) {
        String string = info.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContext(...)");
        String key1 = string;
        int unitNumber = StatisticsManagerImplKt.access$getUnitNumber(key1);
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            StatisticsUnit unit = this.getUnit(unitNumber);
            unit.incData(key1, info.getValue());
            boolean bl2 = this.modifiedUnits.add(unit);
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public StatisticsInfo[] getAllValues(@NotNull String context2) {
        void $this$mapTo$iv$iv;
        Collection<String> collection;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object object = this.lock.readLock();
        ((ReentrantReadWriteLock.ReadLock)object).lock();
        try {
            boolean $i$a$-read-StatisticsManagerImpl$getAllValues$22 = false;
            Collection<String> $i$a$-read-StatisticsManagerImpl$getAllValues$22 = this.getUnit(StatisticsManagerImplKt.access$getUnitNumber(context2)).getKeys2(context2);
            collection = $i$a$-read-StatisticsManagerImpl$getAllValues$22;
        }
        finally {
            ((ReentrantReadWriteLock.ReadLock)object).unlock();
        }
        Intrinsics.checkNotNullExpressionValue(collection, (String)"read(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(new StatisticsInfo(context2, (String)it));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new StatisticsInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object save(@NotNull Continuation<? super Unit> $completion) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                Iterator<StatisticsUnit> iterator2 = this.modifiedUnits.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
                Iterator<StatisticsUnit> iterator3 = iterator2;
                while (iterator3.hasNext()) {
                    StatisticsUnit unit;
                    Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
                    this.saveUnit(unit.getNumber());
                }
            }
            this.modifiedUnits.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return Unit.INSTANCE;
    }

    private final StatisticsUnit getUnit(int unitNumber) {
        StatisticsUnit unit;
        SoftReference<StatisticsUnit> softReference = this.units.get(unitNumber);
        StatisticsUnit statisticsUnit = unit = softReference != null ? softReference.get() : null;
        if (unit == null) {
            unit = StatisticsManagerImplKt.access$loadUnit(unitNumber);
            this.units.set(unitNumber, new SoftReference<StatisticsUnit>(unit));
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveUnit(int unitNumber) {
        SoftReference<StatisticsUnit> softReference = this.units.get(unitNumber);
        if (softReference == null || (softReference = softReference.get()) == null) {
            return;
        }
        SoftReference<StatisticsUnit> unit = softReference;
        try {
            Path path = StatisticsManagerImplKt.access$getPathToUnit(unitNumber);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"access$getPathToUnit(...)");
            Closeable closeable = new ScrambledOutputStream(new BufferedOutputStream(PathKt.outputStream((Path)path)));
            Throwable throwable = null;
            try {
                ScrambledOutputStream out2 = (ScrambledOutputStream)closeable;
                boolean bl = false;
                ((StatisticsUnit)((Object)unit)).write(out2);
                Unit unit2 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            Object[] objectArray = new Object[]{e.getLocalizedMessage()};
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.saving.statistics", (Object[])objectArray), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        }
    }

    @TestOnly
    public final void enableStatistics(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.testingStatistics = true;
        Disposer.register((Disposable)parentDisposable, () -> StatisticsManagerImpl.enableStatistics$lambda$0(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void enableStatistics$lambda$0(StatisticsManagerImpl this$0) {
        ReentrantReadWriteLock reentrantReadWriteLock = this$0.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int j = 0; j < n; ++j) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            Collections.fill((List)this$0.units, null);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int j = 0; j < n; ++j) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        this$0.testingStatistics = false;
    }
}

