/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.intellij.serialization.Binding;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.ReadContext;
import com.intellij.serialization.SerializationException;
import com.intellij.serialization.WriteContext;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0010H\u0016J\u001a\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\tH\u0016J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\tH\u0002R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/serialization/PolymorphicBinding;", "Lcom/intellij/serialization/Binding;", "superClass", "Ljava/lang/Class;", "<init>", "(Ljava/lang/Class;)V", "serialize", "", "obj", "", "context", "Lcom/intellij/serialization/WriteContext;", "deserialize", "hostObject", "property", "Lcom/intellij/serialization/MutableAccessor;", "Lcom/intellij/serialization/ReadContext;", "doDeserialize", "intellij.platform.objectSerializer"})
@SourceDebugExtension(value={"SMAP\nPolymorphicBinding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolymorphicBinding.kt\ncom/intellij/serialization/PolymorphicBinding\n+ 2 Binding.kt\ncom/intellij/serialization/BindingKt\n*L\n1#1,55:1\n55#2,7:56\n*S KotlinDebug\n*F\n+ 1 PolymorphicBinding.kt\ncom/intellij/serialization/PolymorphicBinding\n*L\n18#1:56,7\n*E\n"})
public final class PolymorphicBinding
implements Binding {
    @NotNull
    private final Class<?> superClass;

    public PolymorphicBinding(@NotNull Class<?> superClass) {
        Intrinsics.checkNotNullParameter(superClass, (String)"superClass");
        this.superClass = superClass;
    }

    @Override
    public void serialize(@NotNull Object obj2, @NotNull WriteContext context2) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Class<?> valueClass = obj2.getClass();
        IonWriter writer = context2.writer;
        if (!context2.configuration.allowAnySubTypes) {
            throw new SerializationException("Polymorphic type without specified allowed sub types is forbidden");
        }
        writer.addTypeAnnotation(valueClass.getName());
        context2.bindingProducer.getRootBinding(valueClass).serialize(obj2, context2);
    }

    @Override
    public void deserialize(@NotNull Object hostObject, @NotNull MutableAccessor property, @NotNull ReadContext context2) {
        Intrinsics.checkNotNullParameter((Object)hostObject, (String)"hostObject");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object object = hostObject;
        MutableAccessor mutableAccessor = property;
        ReadContext context$iv = context2;
        boolean $i$f$read = false;
        if (context$iv.getReader().getType() == IonType.NULL) {
            property$iv.set((Object)hostObject$iv, null);
        } else {
            IonReader ionReader = context$iv.getReader();
            void var11_9 = hostObject$iv;
            void var10_10 = property$iv;
            boolean bl = false;
            Object object2 = this.doDeserialize(context2, hostObject);
            var10_10.set((Object)var11_9, object2);
        }
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull ReadContext context2, @Nullable Object hostObject) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object object = this.doDeserialize(context2, hostObject);
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    private final Object doDeserialize(ReadContext context2, Object hostObject) {
        if (!context2.getConfiguration().allowAnySubTypes) {
            throw new SerializationException("Polymorphic type without specified allowed sub types is forbidden");
        }
        IonReader reader = context2.getReader();
        Class beanClass = null;
        Iterator typeAnnotationIterator = reader.iterateTypeAnnotations();
        if (typeAnnotationIterator.hasNext()) {
            String className = (String)typeAnnotationIterator.next();
            Function2<String, Object, Class<?>> loadClass = context2.getConfiguration().loadClass;
            if (loadClass == null || hostObject == null) {
                Class clazz = this.getClass().getClassLoader().loadClass(className);
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"loadClass(...)");
                beanClass = clazz;
            } else {
                Intrinsics.checkNotNull((Object)className);
                Class clazz = (Class)loadClass.invoke((Object)className, hostObject);
                if (clazz == null) {
                    return null;
                }
                beanClass = clazz;
            }
            if (!this.superClass.isAssignableFrom(beanClass)) {
                throw new SerializationException("Class \"" + className + "\" must be assignable to \"" + this.superClass.getName() + "\"");
            }
        } else {
            throw new SerializationException("Class name is not specified");
        }
        return context2.getBindingProducer().getRootBinding(beanClass).deserialize(context2, hostObject);
    }
}

