/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.toolWindow;

import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.WindowInfo;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.toolWindow.ImageCache;
import com.intellij.toolWindow.ImageRef;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.toolWindow.ToolWindowPaneKt;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ui.ImageUtil;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dR\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/intellij/toolWindow/FrameLayeredPane;", "Ljavax/swing/JLayeredPane;", "splitter", "Ljavax/swing/JComponent;", "frame", "Ljavax/swing/JFrame;", "<init>", "(Ljavax/swing/JComponent;Ljavax/swing/JFrame;)V", "imageProvider", "Lkotlin/Function1;", "Lcom/intellij/ui/scale/ScaleContext;", "Lcom/intellij/toolWindow/ImageRef;", "bottomImageCache", "Lcom/intellij/toolWindow/ImageCache;", "topImageCache", "bottomImage", "Ljava/awt/Image;", "getBottomImage", "()Ljava/awt/Image;", "topImage", "getTopImage", "doLayout", "", "setBoundsInPaletteLayer", "component", "Ljava/awt/Component;", "anchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "w", "", "intellij.platform.ide.impl"})
public class FrameLayeredPane
extends JLayeredPane {
    @NotNull
    private final Function1<ScaleContext, ImageRef> imageProvider;
    @NotNull
    private final ImageCache bottomImageCache;
    @NotNull
    private final ImageCache topImageCache;

    public FrameLayeredPane(@NotNull JComponent splitter2, @NotNull JFrame frame) {
        Intrinsics.checkNotNullParameter((Object)splitter2, (String)"splitter");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.imageProvider = arg_0 -> FrameLayeredPane.imageProvider$lambda$0(this, frame, arg_0);
        this.bottomImageCache = new ImageCache(this.imageProvider);
        this.topImageCache = new ImageCache(this.imageProvider);
        this.setOpaque(false);
        this.add(splitter2, JLayeredPane.DEFAULT_LAYER, -1);
    }

    @NotNull
    public final Image getBottomImage() {
        return this.bottomImageCache.get(ScaleContext.Companion.create((Component)this));
    }

    @NotNull
    public final Image getTopImage() {
        return this.topImageCache.get(ScaleContext.Companion.create((Component)this));
    }

    @Override
    public void doLayout() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width < 0 || height < 0) {
            return;
        }
        Integer n = JLayeredPane.DEFAULT_LAYER;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"DEFAULT_LAYER");
        Component[] components = this.getComponentsInLayer(((Number)n).intValue());
        ToolWindowPaneKt.access$getLOG$p().assertTrue(components.length <= 1);
        Component[] componentArray = components;
        Intrinsics.checkNotNull((Object)componentArray);
        for (Component component2 : componentArray) {
            component2.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
        Integer n2 = JLayeredPane.PALETTE_LAYER;
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"PALETTE_LAYER");
        Component[] componentArray2 = components = this.getComponentsInLayer(((Number)n2).intValue());
        Intrinsics.checkNotNull((Object)componentArray2);
        for (Component component2 : componentArray2) {
            if (!(component2 instanceof InternalDecoratorImpl)) continue;
            WindowInfo info = ((InternalDecoratorImpl)((Object)component2)).toolWindow.getWindowInfo();
            JRootPane jRootPane = this.getRootPane();
            int rootWidth = jRootPane != null ? jRootPane.getWidth() : 0;
            JRootPane jRootPane2 = this.getRootPane();
            int rootHeight = jRootPane2 != null ? jRootPane2.getHeight() : 0;
            float weight = info.getAnchor().isHorizontal() ? ToolWindowManagerImpl.Companion.getAdjustedRatio(((InternalDecoratorImpl)((Object)component2)).getHeight(), rootHeight, 1) : ToolWindowManagerImpl.Companion.getAdjustedRatio(((InternalDecoratorImpl)((Object)component2)).getWidth(), rootWidth, 1);
            this.setBoundsInPaletteLayer(component2, info.getAnchor(), weight);
        }
    }

    public final void setBoundsInPaletteLayer(@NotNull Component component2, @NotNull ToolWindowAnchor anchor, float w) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        float weight = w;
        if (weight < 0.0f) {
            weight = 0.33f;
        } else if (weight > 1.0f) {
            weight = 1.0f;
        }
        JRootPane jRootPane = this.getRootPane();
        int rootHeight = jRootPane != null ? jRootPane.getHeight() : 0;
        JRootPane jRootPane2 = this.getRootPane();
        int rootWidth = jRootPane2 != null ? jRootPane2.getWidth() : 0;
        ToolWindowAnchor toolWindowAnchor = anchor;
        if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.TOP)) {
            component2.setBounds(0, 0, this.getWidth(), (int)((float)rootHeight * weight));
        } else if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.LEFT)) {
            component2.setBounds(0, 0, (int)((float)rootWidth * weight), this.getHeight());
        } else if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.BOTTOM)) {
            int height = (int)((float)rootHeight * weight);
            component2.setBounds(0, this.getHeight() - height, this.getWidth(), height);
        } else if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.RIGHT)) {
            int width = (int)((float)rootWidth * weight);
            component2.setBounds(this.getWidth() - width, 0, width, this.getHeight());
        } else {
            ToolWindowPaneKt.access$getLOG$p().error("unknown anchor " + anchor);
        }
    }

    private static final ImageRef imageProvider$lambda$0(FrameLayeredPane this$0, JFrame $frame, ScaleContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int width = Math.max(Math.max(1, this$0.getWidth()), $frame.getWidth());
        int height = Math.max(Math.max(1, this$0.getHeight()), $frame.getHeight());
        BufferedImage bufferedImage = ImageUtil.createImage((GraphicsConfiguration)this$0.getGraphicsConfiguration(), (int)width, (int)height, (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
        return new ImageRef(bufferedImage);
    }
}

