/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.toolWindow;

import com.intellij.ide.HelpTooltip;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.WindowInfo;
import com.intellij.openapi.wm.impl.AbstractDroppableStripe;
import com.intellij.openapi.wm.impl.AnchoredButton;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.toolWindow.Stripe;
import com.intellij.toolWindow.StripeButtonKt;
import com.intellij.toolWindow.StripeButtonManager;
import com.intellij.toolWindow.StripeButtonUi;
import com.intellij.toolWindow.ToolWindowDragHelper;
import com.intellij.toolWindow.ToolWindowEventSource;
import com.intellij.toolWindow.ToolWindowPane;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.awt.DevicePoint;
import com.intellij.ui.drag.DragButtonKt;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002:\u0001FB\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\bH\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010)\u001a\u00020\bH\u0016J\b\u0010*\u001a\u00020+H\u0016J\u0010\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\nH\u0002J\u0010\u00101\u001a\u00020\u00192\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020\n2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00105\u001a\u00020\u00192\u0006\u00102\u001a\u000203H\u0014J\"\u00106\u001a\u00020\u00192\b\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020\b2\u0006\u0010:\u001a\u00020\bH\u0002J\b\u0010;\u001a\u00020\u0019H\u0016J\u0006\u0010<\u001a\u00020\u0019J\u0010\u0010=\u001a\u00020\u00192\b\u0010>\u001a\u0004\u0018\u00010?J\u0010\u0010@\u001a\u00020\u00192\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0015\u0010A\u001a\u00020\u00192\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bBJ\b\u0010D\u001a\u00020\u0019H\u0002J\n\u0010E\u001a\u00020\u001fH\u0096\u0080\u0004R\u0010\u0010\u0003\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010,\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010-R\u0014\u0010C\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010-\u00a8\u0006G"}, d2={"Lcom/intellij/toolWindow/StripeButton;", "Lcom/intellij/openapi/wm/impl/AnchoredButton;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "toolWindow", "Lcom/intellij/openapi/wm/impl/ToolWindowImpl;", "<init>", "(Lcom/intellij/openapi/wm/impl/ToolWindowImpl;)V", "mnemonic", "", "pressedWhenSelected", "", "dragPane", "Ljavax/swing/JLayeredPane;", "dragButton", "Lcom/intellij/toolWindow/StripeButtonManager;", "dragButtonImage", "Ljavax/swing/JLabel;", "pressedPoint", "Ljava/awt/Point;", "lastStripe", "Lcom/intellij/openapi/wm/impl/AbstractDroppableStripe;", "dragKeyEventDispatcher", "Ljava/awt/KeyEventDispatcher;", "dragCancelled", "updateHelpTooltip", "", "windowInfo", "Lcom/intellij/openapi/wm/WindowInfo;", "getWindowInfo", "()Lcom/intellij/openapi/wm/WindowInfo;", "id", "", "getId", "()Ljava/lang/String;", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "getMnemonic", "setMnemonic", "", "setMnemonic2", "getMnemonic2", "getAnchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "isFirst", "()Z", "isLast", "is", "first", "processDrag", "e", "Ljava/awt/event/MouseEvent;", "isWithinDeadZone", "processMouseEvent", "showPopup", "component", "Ljava/awt/Component;", "x", "y", "updateUI", "updatePresentation", "updateIcon", "icon", "Ljavax/swing/Icon;", "updateText", "updateState", "updateState$intellij_platform_ide_impl", "isDraggingNow", "finishDragging", "toString", "DragKeyEventDispatcher", "intellij.platform.ide.impl"})
public final class StripeButton
extends AnchoredButton
implements UiDataProvider {
    @JvmField
    @NotNull
    public final ToolWindowImpl toolWindow;
    private int mnemonic;
    private boolean pressedWhenSelected;
    @Nullable
    private JLayeredPane dragPane;
    @Nullable
    private StripeButtonManager dragButton;
    @Nullable
    private JLabel dragButtonImage;
    @Nullable
    private Point pressedPoint;
    @Nullable
    private AbstractDroppableStripe lastStripe;
    @Nullable
    private KeyEventDispatcher dragKeyEventDispatcher;
    private boolean dragCancelled;

    public StripeButton(@NotNull ToolWindowImpl toolWindow2) {
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        this.toolWindow = toolWindow2;
        this.setFocusable(false);
        this.setBorder((Border)JBUI.Borders.empty((int)5, (int)5, (int)0, (int)5));
        this.putClientProperty(MnemonicHelper.DISABLE_MNEMONIC_PROCESSING, true);
        this.addActionListener(arg_0 -> StripeButton._init_$lambda$0(this, arg_0));
        this.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component component2, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                this.showPopup(component2, x, y);
            }
        });
        this.setRolloverEnabled(true);
        this.setOpaque(false);
        this.enableEvents(16L);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!AdvancedSettings.Companion.getBoolean("ide.tool.window.header.dnd")) {
                    this.processDrag(e);
                }
            }
        });
        this.updateHelpTooltip();
    }

    private final void updateHelpTooltip() {
        HelpTooltip.dispose((Component)this);
        HelpTooltip tooltip = new HelpTooltip();
        tooltip.setTitle(this.toolWindow.getStripeTitleProvider());
        String activateActionId = ActivateToolWindowAction.Manager.getActionIdForToolWindow(this.toolWindow.getId());
        tooltip.setShortcut((Shortcut)ActionManager.getInstance().getKeyboardShortcut(activateActionId));
        tooltip.installOn((JComponent)this);
    }

    @NotNull
    public final WindowInfo getWindowInfo() {
        return this.toolWindow.getWindowInfo();
    }

    @NotNull
    public final String getId() {
        return this.toolWindow.getId();
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = PlatformDataKeys.TOOL_WINDOW;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"TOOL_WINDOW");
        sink.set(dataKey, (Object)this.toolWindow);
        DataKey dataKey2 = CommonDataKeys.PROJECT;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"PROJECT");
        sink.set(dataKey2, (Object)this.toolWindow.toolWindowManager.getProject());
    }

    @Override
    public int getMnemonic() {
        return this.mnemonic;
    }

    @NotNull
    public Void setMnemonic(int mnemonic) {
        throw new UnsupportedOperationException("use setMnemonic2(int)");
    }

    private final void setMnemonic2(int mnemonic) {
        this.mnemonic = mnemonic;
        this.updateHelpTooltip();
        this.revalidate();
        this.repaint();
    }

    @Override
    public int getMnemonic2() {
        return this.mnemonic;
    }

    @Override
    @NotNull
    public ToolWindowAnchor getAnchor() {
        return this.toolWindow.getAnchor();
    }

    public final boolean isFirst() {
        return this.is(true);
    }

    public final boolean isLast() {
        return this.is(false);
    }

    private final boolean is(boolean first) {
        Container container = this.getParent();
        if (container == null) {
            return false;
        }
        Container parent = container;
        int max = first ? Integer.MAX_VALUE : 0;
        ToolWindowAnchor anchor = this.getAnchor();
        Component c = null;
        int count = parent.getComponentCount();
        for (int i2 = 0; i2 < count; ++i2) {
            Component component2 = parent.getComponent(i2);
            if (!component2.isVisible()) continue;
            Rectangle r = component2.getBounds();
            if (Intrinsics.areEqual((Object)anchor, (Object)ToolWindowAnchor.LEFT) || Intrinsics.areEqual((Object)anchor, (Object)ToolWindowAnchor.RIGHT)) {
                if ((!first || max <= r.y) && (first || max >= r.y)) continue;
                max = r.y;
                c = component2;
                continue;
            }
            if ((!first || max <= r.x) && (first || max >= r.x)) continue;
            max = r.x;
            c = component2;
        }
        return c == this;
    }

    private final void processDrag(MouseEvent e) {
        if (this.dragCancelled || !MouseDragHelper.checkModifiers((InputEvent)e)) {
            return;
        }
        if (!this.isDraggingNow()) {
            if (this.pressedPoint == null || this.isWithinDeadZone(e)) {
                return;
            }
            JLayeredPane jLayeredPane = StripeButtonKt.access$findLayeredPane(e);
            if (jLayeredPane == null) {
                return;
            }
            this.dragPane = jLayeredPane;
            Container container = this.getParent();
            Intrinsics.checkNotNull((Object)container, (String)"null cannot be cast to non-null type com.intellij.toolWindow.Stripe");
            this.dragButton = ((Stripe)((Object)container)).getButtonFor(this.toolWindow.getId());
            BufferedImage image2 = ToolWindowDragHelper.Companion.createThumbnailDragImage$intellij_platform_ide_impl$default(ToolWindowDragHelper.Companion, this, 0, 2, null);
            Intrinsics.checkNotNull((Object)image2, (String)"null cannot be cast to non-null type java.awt.Image");
            JBImageIcon jBImageIcon = IconUtil.createImageIcon((Image)image2);
            JLabel dragButtonImage2 = new JLabel(this, jBImageIcon){
                final /* synthetic */ StripeButton this$0;
                {
                    this.this$0 = $receiver;
                    super((Icon)$super_call_param$1);
                }

                public String toString() {
                    return "Image for: " + this.this$0;
                }
            };
            this.dragButtonImage = dragButtonImage2;
            dragButtonImage2.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ StripeButton this$0;
                {
                    this.this$0 = $receiver;
                }

                public void mouseReleased(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    StripeButton.access$finishDragging(this.this$0);
                    StripeButton.access$setPressedPoint$p(this.this$0, null);
                    StripeButton.access$setDragButtonImage$p(this.this$0, null);
                    super.mouseReleased(e);
                }
            });
            JLayeredPane jLayeredPane2 = this.dragPane;
            Intrinsics.checkNotNull((Object)jLayeredPane2);
            Component component2 = dragButtonImage2;
            Integer n = JLayeredPane.POPUP_LAYER;
            Intrinsics.checkNotNull((Object)n, (String)"null cannot be cast to non-null type kotlin.Any");
            jLayeredPane2.add(component2, n);
            dragButtonImage2.setSize(dragButtonImage2.getPreferredSize());
            this.setVisible(false);
            this.toolWindow.toolWindowManager.getToolWindowPane((ToolWindow)((ToolWindow)this.toolWindow)).buttonManager.startDrag();
            this.dragKeyEventDispatcher = new DragKeyEventDispatcher();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.dragKeyEventDispatcher);
        }
        if (!this.isDraggingNow()) {
            return;
        }
        Point xy = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.dragPane);
        if (this.pressedPoint != null) {
            int n = xy.x;
            Point point = this.pressedPoint;
            Intrinsics.checkNotNull((Object)point);
            xy.x = n - point.x;
            int n2 = xy.y;
            Point point2 = this.pressedPoint;
            Intrinsics.checkNotNull((Object)point2);
            xy.y = n2 - point2.y;
        }
        JLabel jLabel = this.dragButtonImage;
        Intrinsics.checkNotNull((Object)jLabel);
        jLabel.setLocation(xy);
        SwingUtilities.convertPointToScreen(xy, this.dragPane);
        Intrinsics.checkNotNull((Object)xy);
        JLayeredPane jLayeredPane = this.dragPane;
        Intrinsics.checkNotNull((Object)jLayeredPane);
        DevicePoint devicePoint = new DevicePoint(xy, (Component)jLayeredPane);
        ToolWindowPane toolWindowPane2 = this.toolWindow.toolWindowManager.getToolWindowPane(this.toolWindow);
        Container container = this.getParent();
        Intrinsics.checkNotNull((Object)container, (String)"null cannot be cast to non-null type com.intellij.toolWindow.Stripe");
        AbstractDroppableStripe stripe = toolWindowPane2.getStripeFor$intellij_platform_ide_impl(devicePoint, (Stripe)((Object)container));
        if (stripe == null) {
            if (this.lastStripe != null) {
                AbstractDroppableStripe abstractDroppableStripe = this.lastStripe;
                Intrinsics.checkNotNull((Object)((Object)abstractDroppableStripe));
                abstractDroppableStripe.resetDrop();
            }
        } else {
            if (this.lastStripe != null && this.lastStripe != stripe) {
                AbstractDroppableStripe abstractDroppableStripe = this.lastStripe;
                Intrinsics.checkNotNull((Object)((Object)abstractDroppableStripe));
                abstractDroppableStripe.resetDrop();
            }
            StripeButtonManager stripeButtonManager = this.dragButton;
            Intrinsics.checkNotNull((Object)stripeButtonManager);
            JLabel jLabel2 = this.dragButtonImage;
            Intrinsics.checkNotNull((Object)jLabel2);
            stripe.processDropButton(stripeButtonManager, DragButtonKt.asDragButton(jLabel2), devicePoint);
        }
        this.lastStripe = stripe;
    }

    private final boolean isWithinDeadZone(MouseEvent e) {
        Point point = this.pressedPoint;
        Intrinsics.checkNotNull((Object)point);
        return point.distance(e.getPoint()) < (double)JBUI.scale((int)7);
    }

    @Override
    protected void processMouseEvent(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.isPopupTrigger() && e.getComponent().isShowing()) {
            super.processMouseEvent(e);
            return;
        }
        if (UIUtil.isCloseClick((MouseEvent)e)) {
            this.toolWindow.toolWindowManager.hideToolWindow(this.toolWindow.getId(), true);
            return;
        }
        if (e.getButton() == 1) {
            if (501 == e.getID()) {
                this.pressedPoint = e.getPoint();
                this.pressedWhenSelected = this.isSelected();
                this.dragCancelled = false;
            } else if (502 == e.getID()) {
                this.finishDragging();
                this.pressedPoint = null;
                this.dragButtonImage = null;
            }
        }
        super.processMouseEvent(e);
    }

    private final void showPopup(Component component2, int x, int y) {
        ActionGroup group2 = ToolWindowImpl.createPopupGroup$default(this.toolWindow, false, 1, null);
        ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("ToolwindowPopup", group2);
        Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"createActionPopupMenu(...)");
        ActionPopupMenu popupMenu = actionPopupMenu;
        popupMenu.getComponent().show(component2, x, y);
    }

    @Override
    public void updateUI() {
        this.setUI(new StripeButtonUi());
        Font font = StartupUiUtil.getLabelFont();
        RelativeFont relativeFont = RelativeFont.NORMAL.fromResource("StripeButton.fontSizeOffset", -2, JBUIScale.scale((float)11.0f));
        Intrinsics.checkNotNullExpressionValue((Object)relativeFont, (String)"fromResource(...)");
        RelativeFont relativeFont2 = relativeFont;
        this.setFont(relativeFont2.derive(font));
    }

    public final void updatePresentation() {
        this.updateState$intellij_platform_ide_impl(this.toolWindow);
        this.updateText(this.toolWindow);
        this.updateIcon(this.toolWindow.getIcon());
    }

    public final void updateIcon(@Nullable Icon icon2) {
        this.setIcon(icon2);
        Icon icon3 = icon2;
        this.setDisabledIcon((Icon)(icon3 == null ? null : IconLoader.getDisabledIcon((Icon)icon3)));
    }

    private final void updateText(ToolWindowImpl toolWindow2) {
        Object text2 = toolWindow2.getStripeTitle();
        if (UISettings.Companion.getInstance().getShowToolWindowsNumbers()) {
            int mnemonic = ActivateToolWindowAction.Manager.getMnemonicForToolWindow(toolWindow2.getId());
            if (mnemonic != -1) {
                text2 = (char)mnemonic + ": " + (String)text2;
                this.setMnemonic2(mnemonic);
            } else {
                this.setMnemonic2(0);
            }
        }
        this.setText((String)text2);
        this.updateHelpTooltip();
    }

    public final void updateState$intellij_platform_ide_impl(@NotNull ToolWindowImpl toolWindow2) {
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        boolean toShow = toolWindow2.isAvailable() || toolWindow2.isPlaceholderMode();
        this.setVisible(toShow && (toolWindow2.isShowStripeButton() || this.isSelected()));
        this.setEnabled(toolWindow2.isAvailable());
    }

    private final boolean isDraggingNow() {
        return this.dragButtonImage != null;
    }

    private final void finishDragging() {
        if (!this.isDraggingNow()) {
            return;
        }
        JLayeredPane jLayeredPane = this.dragPane;
        Intrinsics.checkNotNull((Object)jLayeredPane);
        jLayeredPane.remove(this.dragButtonImage);
        this.dragButtonImage = null;
        this.dragButton = null;
        this.toolWindow.toolWindowManager.getToolWindowPane((ToolWindow)((ToolWindow)this.toolWindow)).buttonManager.stopDrag();
        JLayeredPane jLayeredPane2 = this.dragPane;
        Intrinsics.checkNotNull((Object)jLayeredPane2);
        jLayeredPane2.repaint();
        this.setVisible(true);
        if (this.lastStripe != null) {
            AbstractDroppableStripe abstractDroppableStripe = this.lastStripe;
            Intrinsics.checkNotNull((Object)((Object)abstractDroppableStripe));
            abstractDroppableStripe.finishDrop(this.toolWindow.toolWindowManager);
            this.lastStripe = null;
        }
        if (this.dragKeyEventDispatcher != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.dragKeyEventDispatcher);
            this.dragKeyEventDispatcher = null;
        }
    }

    @Override
    @NotNull
    public String toString() {
        return StringUtilRt.getShortName((String)this.getClass().getName()) + " text: " + this.getText();
    }

    private static final void _init_$lambda$0(StripeButton this$0, ActionEvent it) {
        String id2 = this$0.toolWindow.getId();
        ToolWindowManagerImpl manager2 = this$0.toolWindow.toolWindowManager;
        if (this$0.pressedWhenSelected) {
            ToolWindowManagerImpl.hideToolWindow$default(manager2, id2, false, false, false, ToolWindowEventSource.StripeButton, 14, null);
        } else {
            manager2.activated$intellij_platform_ide_impl(this$0.toolWindow, ToolWindowEventSource.StripeButton);
        }
        this$0.pressedWhenSelected = false;
    }

    public static final /* synthetic */ void access$setPressedPoint$p(StripeButton $this, Point point) {
        $this.pressedPoint = point;
    }

    public static final /* synthetic */ void access$setDragButtonImage$p(StripeButton $this, JLabel jLabel) {
        $this.dragButtonImage = jLabel;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/toolWindow/StripeButton$DragKeyEventDispatcher;", "Ljava/awt/KeyEventDispatcher;", "<init>", "(Lcom/intellij/toolWindow/StripeButton;)V", "dispatchKeyEvent", "", "e", "Ljava/awt/event/KeyEvent;", "intellij.platform.ide.impl"})
    private final class DragKeyEventDispatcher
    implements KeyEventDispatcher {
        @Override
        public boolean dispatchKeyEvent(@NotNull KeyEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (StripeButton.this.isDraggingNow() && e.getKeyCode() == 27 && e.getID() == 401) {
                StripeButton.this.dragCancelled = true;
                StripeButton.this.finishDragging();
                return true;
            }
            return false;
        }
    }
}

