/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.toolWindow;

import com.intellij.ide.RemoteDesktopService;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.BorderPainterHolder;
import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.application.impl.islands.IslandsUICustomizationKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Splittable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowInfo;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.impl.AbstractDroppableStripe;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.toolWindow.FrameLayeredPane;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.toolWindow.StripesUxCustomizer;
import com.intellij.toolWindow.Surface;
import com.intellij.toolWindow.ToolWindowButtonManager;
import com.intellij.toolWindow.ToolWindowDragHelper;
import com.intellij.toolWindow.ToolWindowInnerDragHelper;
import com.intellij.toolWindow.ToolWindowPane;
import com.intellij.toolWindow.ToolWindowPaneKt;
import com.intellij.toolWindow.ToolWindowPaneNewButtonManager;
import com.intellij.toolWindow.ToolWindowPaneOldButtonManager;
import com.intellij.toolWindow.ToolWindowPaneState;
import com.intellij.ui.BorderPainter;
import com.intellij.ui.DefaultBorderPainter;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.DevicePoint;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.LayoutFocusTraversalPolicy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00e0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0007\u0018\u0000 v2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002vwB!\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001dH\u0002J\b\u0010(\u001a\u00020&H\u0016J\u0010\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020&H\u0016J\u0010\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020/H\u0016J&\u00100\u001a\u00020&2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u000207J(\u00108\u001a\u00020&2\u0006\u00103\u001a\u0002042\b\u00109\u001a\u0004\u0018\u0001022\u0006\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u000207J\u0006\u0010:\u001a\u000202J\u0006\u0010;\u001a\u00020&J\"\u0010<\u001a\u00020&2\b\u00109\u001a\u0004\u0018\u0001022\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0002J\u001d\u0010E\u001a\u00020&2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0000\u00a2\u0006\u0002\bFJ\u001d\u0010G\u001a\u00020&2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020@H\u0000\u00a2\u0006\u0002\bKJ\u0012\u0010L\u001a\u0004\u0018\u0001022\u0006\u0010=\u001a\u00020>H\u0002J\u0012\u0010M\u001a\u00020&2\b\u00109\u001a\u0004\u0018\u000102H\u0007J\n\u0010N\u001a\u0004\u0018\u000102H\u0007J\u0010\u0010O\u001a\u00020&2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u0010P\u001a\u00020&2\u0006\u0010Q\u001a\u00020RH\u0014J\u001f\u0010Y\u001a\u0004\u0018\u00010Z2\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020ZH\u0000\u00a2\u0006\u0002\b^J\u0016\u0010_\u001a\u00020&2\u0006\u0010H\u001a\u00020`2\u0006\u0010*\u001a\u00020TJ\u0016\u0010a\u001a\u00020&2\u0006\u0010H\u001a\u00020`2\u0006\u0010*\u001a\u00020TJ\u0018\u0010b\u001a\u00020&2\u0006\u0010H\u001a\u00020`2\u0006\u0010*\u001a\u00020TH\u0002J\u0012\u0010c\u001a\u0004\u0018\u00010d2\u0006\u0010H\u001a\u00020`H\u0007J\u001e\u0010e\u001a\u0010\u0012\u0004\u0012\u00020g\u0012\u0004\u0012\u00020h\u0018\u00010f2\u0006\u0010H\u001a\u00020`H\u0002J\u0010\u0010i\u001a\u00020&2\u0006\u0010.\u001a\u00020/H\u0002J\u000e\u0010j\u001a\u00020\u000f2\u0006\u0010H\u001a\u00020`J\u0016\u0010k\u001a\u00020&2\u0006\u0010l\u001a\u00020`2\u0006\u0010m\u001a\u00020\u000fJ\r\u0010n\u001a\u00020&H\u0000\u00a2\u0006\u0002\boJ(\u0010p\u001a\u00020&2\u0006\u0010q\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u000207H\u0002J \u0010r\u001a\u00020&2\u0006\u00109\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000fH\u0002J \u0010s\u001a\u00020&2\u0006\u00109\u001a\u00020h2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000fH\u0002J\u0015\u0010t\u001a\u00020&2\u0006\u0010*\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\buR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\b\u001a\u00020\t8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\"\u001a\u00070#\u00a2\u0006\u0002\b$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010A\u001a&\u0012\u0004\u0012\u00020>\u0012\b\u0012\u0006\u0012\u0002\b\u00030C0Bj\u0012\u0012\u0004\u0012\u00020>\u0012\b\u0012\u0006\u0012\u0002\b\u00030C`DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010S\u001a\u00020T8F\u00a2\u0006\u0006\u001a\u0004\bU\u0010VR\u0011\u0010W\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\bW\u0010X\u00a8\u0006x"}, d2={"Lcom/intellij/toolWindow/ToolWindowPane;", "Ljavax/swing/JLayeredPane;", "Lcom/intellij/ide/ui/UISettingsListener;", "Lcom/intellij/openapi/application/impl/BorderPainterHolder;", "frame", "Ljavax/swing/JFrame;", "paneId", "", "buttonManager", "Lcom/intellij/toolWindow/ToolWindowButtonManager;", "<init>", "(Ljavax/swing/JFrame;Ljava/lang/String;Lcom/intellij/toolWindow/ToolWindowButtonManager;)V", "getPaneId", "()Ljava/lang/String;", "isLookAndFeelUpdated", "", "state", "Lcom/intellij/toolWindow/ToolWindowPaneState;", "getFrame$intellij_platform_ide_impl", "()Ljavax/swing/JFrame;", "borderPainter", "Lcom/intellij/ui/BorderPainter;", "getBorderPainter", "()Lcom/intellij/ui/BorderPainter;", "setBorderPainter", "(Lcom/intellij/ui/BorderPainter;)V", "layeredPane", "Lcom/intellij/toolWindow/FrameLayeredPane;", "verticalSplitter", "Lcom/intellij/openapi/ui/ThreeComponentsSplitter;", "horizontalSplitter", "isWideScreen", "leftHorizontalSplit", "rightHorizontalSplit", "disposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "setUpSplitter", "", "splitter", "removeNotify", "updateInnerMinSize", "value", "Lcom/intellij/openapi/util/registry/RegistryValue;", "doLayout", "uiSettingsChanged", "uiSettings", "Lcom/intellij/ide/ui/UISettings;", "addDecorator", "decorator", "Ljavax/swing/JComponent;", "info", "Lcom/intellij/openapi/wm/WindowInfo;", "dirtyMode", "manager", "Lcom/intellij/openapi/wm/impl/ToolWindowManagerImpl;", "removeDecorator", "component", "getLayeredPane", "validateAndRepaint", "setComponent", "anchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "weight", "", "setAnchorWeightFutures", "Ljava/util/HashMap;", "Ljava/util/concurrent/Future;", "Lkotlin/collections/HashMap;", "setWeight", "setWeight$intellij_platform_ide_impl", "setSideWeight", "window", "Lcom/intellij/openapi/wm/impl/ToolWindowImpl;", "sideWeight", "setSideWeight$intellij_platform_ide_impl", "getComponentAt", "setDocumentComponent", "getDocumentComponent", "updateToolStripesVisibility", "paintChildren", "g", "Ljava/awt/Graphics;", "bottomHeight", "", "getBottomHeight", "()I", "isBottomSideToolWindowsVisible", "()Z", "getStripeFor", "Lcom/intellij/openapi/wm/impl/AbstractDroppableStripe;", "devicePoint", "Lcom/intellij/ui/awt/DevicePoint;", "preferred", "getStripeFor$intellij_platform_ide_impl", "stretchWidth", "Lcom/intellij/openapi/wm/ToolWindow;", "stretchHeight", "stretch", "getComponentSize", "Ljava/awt/Dimension;", "findResizerAndComponent", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/toolWindow/ToolWindowPane$Resizer;", "Ljava/awt/Component;", "updateLayout", "isMaximized", "setMaximized", "toolWindow", "maximized", "reset", "reset$intellij_platform_ide_impl", "addAndSplitDockedComponentCmd", "newComponent", "addSlidingComponent", "removeSlidingComponent", "setStripesOverlaid", "setStripesOverlaid$intellij_platform_ide_impl", "Companion", "Resizer", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nToolWindowPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolWindowPane.kt\ncom/intellij/toolWindow/ToolWindowPane\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1075:1\n1#2:1076\n60#3,5:1077\n60#3,5:1082\n60#3,5:1087\n*S KotlinDebug\n*F\n+ 1 ToolWindowPane.kt\ncom/intellij/toolWindow/ToolWindowPane\n*L\n346#1:1077,5\n704#1:1082,5\n729#1:1087,5\n*E\n"})
public final class ToolWindowPane
extends JLayeredPane
implements UISettingsListener,
BorderPainterHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String paneId;
    @JvmField
    @NotNull
    public final ToolWindowButtonManager buttonManager;
    private boolean isLookAndFeelUpdated;
    @NotNull
    private ToolWindowPaneState state;
    @NotNull
    private final JFrame frame;
    @NotNull
    private BorderPainter borderPainter;
    @NotNull
    private final FrameLayeredPane layeredPane;
    @NotNull
    private final ThreeComponentsSplitter verticalSplitter;
    @NotNull
    private final ThreeComponentsSplitter horizontalSplitter;
    private boolean isWideScreen;
    private boolean leftHorizontalSplit;
    private boolean rightHorizontalSplit;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final HashMap<ToolWindowAnchor, Future<?>> setAnchorWeightFutures;
    @NotNull
    public static final String TEMPORARY_ADDED = "TEMPORARY_ADDED";

    private ToolWindowPane(JFrame frame, String paneId, ToolWindowButtonManager buttonManager) {
        this.paneId = paneId;
        this.buttonManager = buttonManager;
        this.state = new ToolWindowPaneState();
        this.borderPainter = new DefaultBorderPainter();
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        this.setOpaque(false);
        this.frame = frame;
        this.setName(this.paneId);
        this.verticalSplitter = new ThreeComponentsSplitter(true, false, 2, null);
        this.horizontalSplitter = new ThreeComponentsSplitter(false, false, 2, null);
        this.setUpSplitter(this.verticalSplitter);
        this.setUpSplitter(this.horizontalSplitter);
        RegistryValue registryValue = Registry.Companion.get("ide.mainSplitter.min.size");
        registryValue.addListener(new RegistryValueListener(){

            public void afterValueChanged(RegistryValue value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.updateInnerMinSize(value);
            }
        }, this.disposable);
        this.updateInnerMinSize(registryValue);
        UISettings uiSettings = UISettings.Companion.getInstance();
        this.isWideScreen = uiSettings.getWideScreenSupport();
        this.leftHorizontalSplit = uiSettings.getLeftHorizontalSplit();
        this.rightHorizontalSplit = uiSettings.getRightHorizontalSplit();
        if (this.isWideScreen) {
            this.horizontalSplitter.setInnerComponent((JComponent)this.verticalSplitter);
        } else {
            this.verticalSplitter.setInnerComponent((JComponent)this.horizontalSplitter);
        }
        this.updateToolStripesVisibility(uiSettings);
        this.layeredPane = new FrameLayeredPane((JComponent)(this.isWideScreen ? this.horizontalSplitter : this.verticalSplitter), frame);
        this.buttonManager.setupToolWindowPane(this);
        this.add(this.layeredPane, JLayeredPane.DEFAULT_LAYER, -1);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        new ToolWindowDragHelper(this.disposable, this).start();
        new ToolWindowInnerDragHelper(this.disposable, this).start();
        this.setAnchorWeightFutures = new HashMap();
    }

    @NotNull
    public final String getPaneId() {
        return this.paneId;
    }

    @NotNull
    public final JFrame getFrame$intellij_platform_ide_impl() {
        return this.frame;
    }

    @Override
    @NotNull
    public BorderPainter getBorderPainter() {
        return this.borderPainter;
    }

    @Override
    public void setBorderPainter(@NotNull BorderPainter borderPainter) {
        Intrinsics.checkNotNullParameter((Object)borderPainter, (String)"<set-?>");
        this.borderPainter = borderPainter;
    }

    private final void setUpSplitter(ThreeComponentsSplitter splitter2) {
        splitter2.setDividerWidth(0);
        splitter2.setDividerMouseZoneSize(Registry.Companion.intValue("ide.splitter.mouseZone"));
        Object object = InternalUICustomization.Companion.getInstance();
        if (object == null || (object = ((InternalUICustomization)object).getToolWindowsPaneThreeSplitterBackground()) == null) {
            object = (Color)JBColor.GRAY;
        }
        splitter2.setBackground((Color)object);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (ScreenUtil.isStandardAddRemoveNotify((Component)this)) {
            Disposer.dispose((Disposable)this.disposable);
        }
    }

    private final void updateInnerMinSize(RegistryValue value) {
        int minSize = Math.max(0, Math.min(100, value.asInteger()));
        this.verticalSplitter.setMinSize(JBUIScale.scale((int)minSize));
        this.horizontalSplitter.setMinSize(JBUIScale.scale((int)minSize));
    }

    @Override
    public void doLayout() {
        Dimension dimension = this.getSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
        this.buttonManager.layout(dimension, this.layeredPane);
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        Intrinsics.checkNotNullParameter((Object)uiSettings, (String)"uiSettings");
        this.updateToolStripesVisibility(uiSettings);
        this.updateLayout(uiSettings);
    }

    public final void addDecorator(@NotNull JComponent decorator, @NotNull WindowInfo info, boolean dirtyMode, @NotNull ToolWindowManagerImpl manager2) {
        Intrinsics.checkNotNullParameter((Object)decorator, (String)"decorator");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)((Object)manager2), (String)"manager");
        if (info.isDocked()) {
            boolean side = !info.isSplit();
            ToolWindowAnchor anchor = info.getAnchor();
            WindowInfo sideInfo = manager2.getDockedInfoAt$intellij_platform_ide_impl(this.paneId, anchor, side);
            if (sideInfo == null) {
                this.setComponent(decorator, anchor, ToolWindowPane.Companion.normalizeWeight(info.getWeight()));
                if (!dirtyMode) {
                    this.layeredPane.validate();
                    this.layeredPane.repaint();
                }
            } else {
                this.addAndSplitDockedComponentCmd(decorator, info, dirtyMode, manager2);
            }
        } else if (info.getType() == ToolWindowType.SLIDING) {
            this.addSlidingComponent(decorator, info, dirtyMode);
        } else {
            throw new IllegalArgumentException("Unknown window type: " + info.getType());
        }
    }

    public final void removeDecorator(@NotNull WindowInfo info, @Nullable JComponent component2, boolean dirtyMode, @NotNull ToolWindowManagerImpl manager2) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)((Object)manager2), (String)"manager");
        if (info.getType() != ToolWindowType.DOCKED) {
            if (info.getType() == ToolWindowType.SLIDING) {
                JComponent jComponent = component2;
                if (jComponent != null) {
                    JComponent it = jComponent;
                    boolean bl = false;
                    this.removeSlidingComponent(it, info, dirtyMode);
                }
            }
        } else if (component2 != null && component2.isShowing()) {
            ToolWindowAnchor anchor = info.getAnchor();
            WindowInfo sideInfo = manager2.getDockedInfoAt$intellij_platform_ide_impl(this.paneId, anchor, !info.isSplit());
            if (sideInfo == null) {
                this.setComponent(null, anchor, 0.0f);
            } else {
                JComponent c = this.getComponentAt(anchor);
                if (c instanceof Splitter) {
                    JComponent jComponent = info.isSplit() ? ((Splitter)c).getFirstComponent() : ((Splitter)c).getSecondComponent();
                    Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.toolWindow.InternalDecoratorImpl");
                    InternalDecoratorImpl component1 = (InternalDecoratorImpl)((Object)jComponent);
                    this.state.addSplitProportion(info, component1, (Splitter)c);
                    this.setComponent((JComponent)((Object)component1), anchor, ToolWindowManagerImpl.Companion.getRegisteredMutableInfoOrLogError(component1).getWeight());
                    if (info.isSplit()) {
                        ((Splitter)c).setSecondComponent(null);
                    } else {
                        ((Splitter)c).setFirstComponent(null);
                    }
                } else {
                    this.setComponent(null, anchor, 0.0f);
                }
            }
            if (!dirtyMode) {
                this.layeredPane.validate();
                this.layeredPane.repaint();
            }
        }
    }

    @NotNull
    public final JComponent getLayeredPane() {
        return this.layeredPane;
    }

    public final void validateAndRepaint() {
        this.layeredPane.validate();
        this.layeredPane.repaint();
        this.buttonManager.validateAndRepaint();
    }

    private final void setComponent(JComponent component2, ToolWindowAnchor anchor, float weight) {
        ToolWindowAnchor toolWindowAnchor = anchor;
        if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.TOP)) {
            this.verticalSplitter.setFirstComponent(component2);
        } else if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.LEFT)) {
            this.horizontalSplitter.setFirstComponent(component2);
        } else if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.BOTTOM)) {
            this.verticalSplitter.setLastComponent(component2);
        } else if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.RIGHT)) {
            this.horizontalSplitter.setLastComponent(component2);
        } else {
            ToolWindowPaneKt.access$getLOG$p().error("unknown anchor: " + anchor);
        }
        this.setWeight$intellij_platform_ide_impl(anchor, weight);
    }

    public final void setWeight$intellij_platform_ide_impl(@NotNull ToolWindowAnchor anchor, float weight) {
        int n;
        boolean aboutToBeMaximized;
        JRootPane rootPane;
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Future<?> future = this.setAnchorWeightFutures.remove(anchor);
        if (future != null) {
            future.cancel(false);
        }
        if ((serializable = (rootPane = this.getRootPane())) == null || (serializable = ((Component)serializable).getSize()) == null) {
            serializable = new Dimension();
        }
        Serializable size2 = serializable;
        JFrame jFrame = this.frame;
        IdeFrameImpl ideFrameImpl = jFrame instanceof IdeFrameImpl ? (IdeFrameImpl)jFrame : null;
        boolean bl = aboutToBeMaximized = ideFrameImpl != null ? ideFrameImpl.isAboutToBeMaximized : false;
        if (rootPane != null && (aboutToBeMaximized || ((Dimension)size2).height == 0 && ((Dimension)size2).width == 0)) {
            if (ToolWindowPaneKt.access$getLOG$p().isDebugEnabled()) {
                ToolWindowPaneKt.access$getLOG$p().debug("Postponing setting the weight of the anchor " + anchor + " (size=" + (Dimension)size2 + ", aboutToBeMaximized=" + aboutToBeMaximized + ", state=" + this.frame.getExtendedState() + ")");
            }
            ((Map)this.setAnchorWeightFutures).put(anchor, UIUtil.runOnceWhenResized((Component)rootPane, () -> ToolWindowPane.setWeight$lambda$0(anchor, this, weight)));
            return;
        }
        jFrame = anchor;
        if (Intrinsics.areEqual((Object)jFrame, (Object)ToolWindowAnchor.TOP)) {
            n = (int)(((Dimension)size2).getHeight() * (double)weight);
        } else if (Intrinsics.areEqual((Object)jFrame, (Object)ToolWindowAnchor.LEFT)) {
            n = (int)(((Dimension)size2).getWidth() * (double)weight);
        } else if (Intrinsics.areEqual((Object)jFrame, (Object)ToolWindowAnchor.BOTTOM)) {
            n = (int)(((Dimension)size2).getHeight() * (double)weight);
        } else if (Intrinsics.areEqual((Object)jFrame, (Object)ToolWindowAnchor.RIGHT)) {
            n = (int)(((Dimension)size2).getWidth() * (double)weight);
        } else {
            ToolWindowPaneKt.access$getLOG$p().error("unknown anchor: " + anchor);
            return;
        }
        int anchorSize = n;
        jFrame = anchor;
        if (Intrinsics.areEqual((Object)jFrame, (Object)ToolWindowAnchor.TOP)) {
            this.verticalSplitter.setFirstSize(anchorSize);
        } else if (Intrinsics.areEqual((Object)jFrame, (Object)ToolWindowAnchor.LEFT)) {
            this.horizontalSplitter.setFirstSize(anchorSize);
        } else if (Intrinsics.areEqual((Object)jFrame, (Object)ToolWindowAnchor.BOTTOM)) {
            this.verticalSplitter.setLastSize(anchorSize);
        } else if (Intrinsics.areEqual((Object)jFrame, (Object)ToolWindowAnchor.RIGHT)) {
            this.horizontalSplitter.setLastSize(anchorSize);
        } else {
            ToolWindowPaneKt.access$getLOG$p().error("unknown anchor: " + anchor);
            return;
        }
        Logger $this$debug_u24default$iv = ToolWindowPaneKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger2 = $this$debug_u24default$iv;
            boolean bl2 = false;
            logger2.debug("Set the size of the anchor " + anchor + " to " + anchorSize + " based on the root pane size " + (Dimension)size2 + " and weight " + weight, t$iv);
        }
    }

    public final void setSideWeight$intellij_platform_ide_impl(@NotNull ToolWindowImpl window, float sideWeight) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        if (window.getType() != ToolWindowType.DOCKED) {
            return;
        }
        JComponent splitter2 = this.getComponentAt(window.getAnchor());
        if (!(splitter2 instanceof Splitter)) {
            return;
        }
        float proportion = window.getWindowInfo().isSplit() ? ToolWindowPane.Companion.normalizeWeight(1.0f - sideWeight) : ToolWindowPane.Companion.normalizeWeight(sideWeight);
        ((Splitter)splitter2).setProportion(proportion);
        if (ToolWindowPaneKt.access$getLOG$p().isDebugEnabled()) {
            ToolWindowPaneKt.access$getLOG$p().debug("Set the proportion of the size splitter " + window.getAnchor() + " to " + proportion + " because " + window.getId() + " is the " + (window.getWindowInfo().isSplit() ? "last" : "first") + " in the splitter and has side weight of " + sideWeight);
        }
    }

    private final JComponent getComponentAt(ToolWindowAnchor anchor) {
        JComponent jComponent;
        ToolWindowAnchor toolWindowAnchor = anchor;
        if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.TOP)) {
            jComponent = this.verticalSplitter.getFirstComponent();
        } else if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.LEFT)) {
            jComponent = this.horizontalSplitter.getFirstComponent();
        } else if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.BOTTOM)) {
            jComponent = this.verticalSplitter.getLastComponent();
        } else if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.RIGHT)) {
            jComponent = this.horizontalSplitter.getLastComponent();
        } else {
            ToolWindowPaneKt.access$getLOG$p().error("unknown anchor: " + anchor);
            jComponent = null;
        }
        return jComponent;
    }

    @RequiresEdt
    public final void setDocumentComponent(@Nullable JComponent component2) {
        (this.isWideScreen ? this.verticalSplitter : this.horizontalSplitter).setInnerComponent(component2);
    }

    @RequiresEdt
    @Nullable
    public final JComponent getDocumentComponent() {
        return (this.isWideScreen ? this.verticalSplitter : this.horizontalSplitter).getInnerComponent();
    }

    private final void updateToolStripesVisibility(UISettings uiSettings) {
        boolean showButtons;
        boolean bl = showButtons = !uiSettings.getHideToolStripes() && !uiSettings.getPresentationMode();
        if (this.buttonManager.updateToolStripesVisibility(showButtons, this.state)) {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    protected void paintChildren(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintChildren(g);
        if (!IslandsUICustomizationKt.isIjpl217440()) {
            this.getBorderPainter().paintAfterChildren(this, g);
        }
    }

    public final int getBottomHeight() {
        return this.buttonManager.getBottomHeight();
    }

    public final boolean isBottomSideToolWindowsVisible() {
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.BOTTOM;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"BOTTOM");
        return this.getComponentAt(toolWindowAnchor) != null;
    }

    @Nullable
    public final AbstractDroppableStripe getStripeFor$intellij_platform_ide_impl(@NotNull DevicePoint devicePoint, @NotNull AbstractDroppableStripe preferred) {
        Intrinsics.checkNotNullParameter((Object)devicePoint, (String)"devicePoint");
        Intrinsics.checkNotNullParameter((Object)((Object)preferred), (String)"preferred");
        return this.buttonManager.getStripeFor(devicePoint, preferred, this);
    }

    public final void stretchWidth(@NotNull ToolWindow window, int value) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        this.stretch(window, value);
    }

    public final void stretchHeight(@NotNull ToolWindow window, int value) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        this.stretch(window, value);
    }

    private final void stretch(ToolWindow window, int value) {
        Pair<Resizer, Component> pair = this.findResizerAndComponent(window);
        if (pair == null) {
            return;
        }
        Pair<Resizer, Component> pair2 = pair;
        boolean vertical = Intrinsics.areEqual((Object)window.getAnchor(), (Object)ToolWindowAnchor.TOP) || Intrinsics.areEqual((Object)window.getAnchor(), (Object)ToolWindowAnchor.BOTTOM);
        int actualSize = (vertical ? ((Component)pair2.second).getHeight() : ((Component)pair2.second).getWidth()) + value;
        boolean first = Intrinsics.areEqual((Object)window.getAnchor(), (Object)ToolWindowAnchor.LEFT) || Intrinsics.areEqual((Object)window.getAnchor(), (Object)ToolWindowAnchor.TOP);
        int maxValue = vertical ? this.verticalSplitter.getMaxSize(first) : this.horizontalSplitter.getMaxSize(first);
        int minValue = vertical ? this.verticalSplitter.getMinSize(first) : this.horizontalSplitter.getMinSize(first);
        ((Resizer)pair2.first).setSize(Math.max(minValue, Math.min(maxValue, actualSize)));
    }

    @ApiStatus.Internal
    @Nullable
    public final Dimension getComponentSize(@NotNull ToolWindow window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Object object = this.findResizerAndComponent(window);
        return object != null && (object = (Component)((Pair)object).second) != null ? ((Component)object).getSize() : null;
    }

    private final Pair<Resizer, Component> findResizerAndComponent(ToolWindow window) {
        if (!window.isVisible()) {
            return null;
        }
        Resizer resizer = null;
        Component component2 = null;
        if (window.getType() == ToolWindowType.DOCKED) {
            ToolWindowAnchor toolWindowAnchor = window.getAnchor();
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"getAnchor(...)");
            component2 = this.getComponentAt(toolWindowAnchor);
            if (component2 != null) {
                resizer = window.getAnchor().isHorizontal() ? (Resizer)(this.verticalSplitter.getFirstComponent() == component2 ? (Resizer.Splitter)new Resizer.Splitter.FirstComponent(this.verticalSplitter) : (Resizer.Splitter)new Resizer.Splitter.LastComponent(this.verticalSplitter)) : (Resizer)(this.horizontalSplitter.getFirstComponent() == component2 ? (Resizer.Splitter)new Resizer.Splitter.FirstComponent(this.horizontalSplitter) : (Resizer.Splitter)new Resizer.Splitter.LastComponent(this.horizontalSplitter));
            }
        } else if (window.getType() == ToolWindowType.SLIDING) {
            for (component2 = (Component)window.getComponent(); component2 != null && component2.getParent() != this.layeredPane; component2 = (Component)component2.getParent()) {
            }
            if (component2 != null) {
                ToolWindowAnchor toolWindowAnchor = window.getAnchor();
                resizer = Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.TOP) ? (Resizer)new Resizer.LayeredPane.Top(component2) : (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.BOTTOM) ? (Resizer)new Resizer.LayeredPane.Bottom(component2) : (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.LEFT) ? (Resizer)new Resizer.LayeredPane.Left(component2) : (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.RIGHT) ? (Resizer)new Resizer.LayeredPane.Right(component2) : null)));
            }
        }
        return resizer == null ? null : new Pair(resizer, (Object)component2);
    }

    private final void updateLayout(UISettings uiSettings) {
        WindowInfoImpl secondInfo;
        WindowInfoImpl firstInfo;
        JComponent component2;
        if (this.isWideScreen != uiSettings.getWideScreenSupport()) {
            JComponent documentComponent = (this.isWideScreen ? this.verticalSplitter : this.horizontalSplitter).getInnerComponent();
            this.isWideScreen = uiSettings.getWideScreenSupport();
            if (this.isWideScreen) {
                this.verticalSplitter.setInnerComponent(null);
                this.horizontalSplitter.setInnerComponent((JComponent)this.verticalSplitter);
            } else {
                this.horizontalSplitter.setInnerComponent(null);
                this.verticalSplitter.setInnerComponent((JComponent)this.horizontalSplitter);
            }
            this.layeredPane.remove((Component)(this.isWideScreen ? this.verticalSplitter : this.horizontalSplitter));
            this.layeredPane.add((Component)(this.isWideScreen ? this.horizontalSplitter : this.verticalSplitter), JLayeredPane.DEFAULT_LAYER, -1);
            this.setDocumentComponent(documentComponent);
        }
        if (this.leftHorizontalSplit != uiSettings.getLeftHorizontalSplit()) {
            ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.LEFT;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"LEFT");
            component2 = this.getComponentAt(toolWindowAnchor);
            if (component2 instanceof Splitter) {
                JComponent jComponent = ((Splitter)component2).getFirstComponent();
                Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.toolWindow.InternalDecoratorImpl");
                firstInfo = ToolWindowManagerImpl.Companion.getRegisteredMutableInfoOrLogError((InternalDecoratorImpl)((Object)jComponent));
                JComponent jComponent2 = ((Splitter)component2).getSecondComponent();
                Intrinsics.checkNotNull((Object)jComponent2, (String)"null cannot be cast to non-null type com.intellij.toolWindow.InternalDecoratorImpl");
                secondInfo = ToolWindowManagerImpl.Companion.getRegisteredMutableInfoOrLogError((InternalDecoratorImpl)((Object)jComponent2));
                ToolWindowAnchor toolWindowAnchor2 = ToolWindowAnchor.LEFT;
                Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor2, (String)"LEFT");
                this.setComponent(component2, toolWindowAnchor2, ToolWindowAnchor.LEFT.isSplitVertically() ? firstInfo.getWeight() : firstInfo.getWeight() + secondInfo.getWeight());
            }
            this.leftHorizontalSplit = uiSettings.getLeftHorizontalSplit();
        }
        if (this.rightHorizontalSplit != uiSettings.getRightHorizontalSplit()) {
            ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.RIGHT;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"RIGHT");
            component2 = this.getComponentAt(toolWindowAnchor);
            if (component2 instanceof Splitter) {
                JComponent jComponent = ((Splitter)component2).getFirstComponent();
                Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.toolWindow.InternalDecoratorImpl");
                firstInfo = ToolWindowManagerImpl.Companion.getRegisteredMutableInfoOrLogError((InternalDecoratorImpl)((Object)jComponent));
                JComponent jComponent3 = ((Splitter)component2).getSecondComponent();
                Intrinsics.checkNotNull((Object)jComponent3, (String)"null cannot be cast to non-null type com.intellij.toolWindow.InternalDecoratorImpl");
                secondInfo = ToolWindowManagerImpl.Companion.getRegisteredMutableInfoOrLogError((InternalDecoratorImpl)((Object)jComponent3));
                ToolWindowAnchor toolWindowAnchor3 = ToolWindowAnchor.RIGHT;
                Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor3, (String)"RIGHT");
                this.setComponent(component2, toolWindowAnchor3, ToolWindowAnchor.RIGHT.isSplitVertically() ? firstInfo.getWeight() : firstInfo.getWeight() + secondInfo.getWeight());
            }
            this.rightHorizontalSplit = uiSettings.getRightHorizontalSplit();
        }
    }

    public final boolean isMaximized(@NotNull ToolWindow window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        return this.state.isMaximized(window);
    }

    public final void setMaximized(@NotNull ToolWindow toolWindow2, boolean maximized) {
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        Pair<Resizer, Component> pair = this.findResizerAndComponent(toolWindow2);
        if (pair == null) {
            return;
        }
        Pair<Resizer, Component> resizerAndComponent = pair;
        if (maximized) {
            int size2 = toolWindow2.getAnchor().isHorizontal() ? ((Component)resizerAndComponent.second).getHeight() : ((Component)resizerAndComponent.second).getWidth();
            this.stretch(toolWindow2, Short.MAX_VALUE);
            this.state.setMaximizedProportion((Pair<ToolWindow, Integer>)new Pair((Object)toolWindow2, (Object)size2));
        } else {
            boolean bl;
            Pair<ToolWindow, Integer> maximizedProportion = this.state.getMaximizedProportion();
            ToolWindowPaneKt.access$getLOG$p().assertTrue(maximizedProportion != null);
            Pair<ToolWindow, Integer> pair2 = maximizedProportion;
            Intrinsics.checkNotNull(pair2);
            ToolWindow maximizedWindow = (ToolWindow)pair2.first;
            boolean bl2 = bl = maximizedWindow == toolWindow2;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Resizer resizer = (Resizer)resizerAndComponent.first;
            Object object = maximizedProportion.second;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
            resizer.setSize(((Number)object).intValue());
            this.state.setMaximizedProportion(null);
        }
        this.doLayout();
    }

    public final void reset$intellij_platform_ide_impl() {
        this.buttonManager.reset();
        this.state = new ToolWindowPaneState();
        this.revalidate();
    }

    private final void addAndSplitDockedComponentCmd(JComponent newComponent, WindowInfo info, boolean dirtyMode, ToolWindowManagerImpl manager2) {
        JComponent c;
        ToolWindowAnchor anchor = info.getAnchor();
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\r\u001a\u00020\fH\u0016J\n\u0010\u000e\u001a\u00020\u000fH\u0096\u0080\u0004R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"com/intellij/toolWindow/ToolWindowPane$addAndSplitDockedComponentCmd$MySplitter", "Lcom/intellij/ui/OnePixelSplitter;", "Lcom/intellij/ide/ui/UISettingsListener;", "<init>", "(Lcom/intellij/openapi/wm/ToolWindowAnchor;)V", "uiSettingsChanged", "", "uiSettings", "Lcom/intellij/ide/ui/UISettings;", "createDivider", "Lcom/intellij/openapi/ui/Divider;", "myCustomDividerWidth", "", "getDividerWidth", "toString", "", "intellij.platform.ide.impl"})
        @SourceDebugExtension(value={"SMAP\nToolWindowPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolWindowPane.kt\ncom/intellij/toolWindow/ToolWindowPane$addAndSplitDockedComponentCmd$MySplitter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1075:1\n1#2:1076\n*E\n"})
        public final class MySplitter
        extends OnePixelSplitter
        implements UISettingsListener {
            private final int myCustomDividerWidth;
            final /* synthetic */ ToolWindowAnchor $anchor;

            public MySplitter(ToolWindowAnchor $anchor) {
                this.$anchor = $anchor;
                Object dividerWidth = this.getDivider().getClientProperty("DividerWidth");
                this.myCustomDividerWidth = dividerWidth instanceof Integer ? ((Number)dividerWidth).intValue() : -1;
            }

            public void uiSettingsChanged(UISettings uiSettings) {
                Intrinsics.checkNotNullParameter((Object)uiSettings, (String)"uiSettings");
                if (Intrinsics.areEqual((Object)this.$anchor, (Object)ToolWindowAnchor.LEFT)) {
                    this.setOrientation(!uiSettings.getLeftHorizontalSplit());
                } else if (Intrinsics.areEqual((Object)this.$anchor, (Object)ToolWindowAnchor.RIGHT)) {
                    this.setOrientation(!uiSettings.getRightHorizontalSplit());
                }
            }

            protected Divider createDivider() {
                InternalUICustomization internalUICustomization = InternalUICustomization.Companion.getInstance();
                if (internalUICustomization == null || (internalUICustomization = internalUICustomization.createCustomDivider(this.isVertical(), (Splittable)this)) == null) {
                    Divider divider;
                    Divider it = divider = super.createDivider();
                    boolean bl = false;
                    it.setBackground(JBUI.CurrentTheme.ToolWindow.mainBorderColor());
                    Divider divider2 = divider;
                    internalUICustomization = divider2;
                    Intrinsics.checkNotNullExpressionValue((Object)divider2, (String)"also(...)");
                }
                return internalUICustomization;
            }

            public int getDividerWidth() {
                if (this.myCustomDividerWidth != -1) {
                    return this.myCustomDividerWidth;
                }
                return super.getDividerWidth();
            }

            public String toString() {
                return "[" + this.getFirstComponent() + "|" + this.getSecondComponent() + "]";
            }
        }
        MySplitter splitter2 = new MySplitter(anchor);
        splitter2.setOrientation(anchor.isSplitVertically());
        if (!anchor.isHorizontal()) {
            splitter2.setAllowSwitchOrientationByMouseClick(true);
            splitter2.addPropertyChangeListener(arg_0 -> ToolWindowPane.addAndSplitDockedComponentCmd$lambda$0(splitter2, anchor, arg_0));
        }
        if ((c = this.getComponentAt(anchor)) == null) {
            String string = info.getId();
            Intrinsics.checkNotNull((Object)string);
            List<ToolWindowEx> toolWindows = manager2.getToolWindowsOn$intellij_platform_ide_impl(this.paneId, anchor, string);
            toolWindows.removeIf(arg_0 -> ToolWindowPane.addAndSplitDockedComponentCmd$lambda$2(arg_0 -> ToolWindowPane.addAndSplitDockedComponentCmd$lambda$1(info, arg_0), arg_0));
            if (!toolWindows.isEmpty()) {
                ToolWindowEx toolWindowEx = toolWindows.get(0);
                Intrinsics.checkNotNull((Object)toolWindowEx, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.impl.ToolWindowImpl");
                c = ((ToolWindowImpl)toolWindowEx).getDecoratorComponent();
            }
            if (c == null) {
                ToolWindowPaneKt.access$getLOG$p().error("Empty splitter @ " + anchor + " during AddAndSplitDockedComponentCmd for " + info.getId());
            }
        }
        float newWeight = 0.0f;
        if (c instanceof InternalDecoratorImpl) {
            Logger logger2;
            boolean $i$f$debug;
            Throwable t$iv;
            JComponent oldComponent = c;
            WindowInfoImpl oldInfo = ToolWindowManagerImpl.Companion.getRegisteredMutableInfoOrLogError((InternalDecoratorImpl)((Object)oldComponent));
            if (this.isLookAndFeelUpdated) {
                IJSwingUtilities.updateComponentTreeUI(oldComponent);
                IJSwingUtilities.updateComponentTreeUI(newComponent);
                this.isLookAndFeelUpdated = false;
            }
            if (info.isSplit()) {
                splitter2.setFirstComponent(oldComponent);
                splitter2.setSecondComponent(newComponent);
                Logger $this$debug_u24default$iv = ToolWindowPaneKt.access$getLOG$p();
                t$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger2 = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger2.debug("Determining the split proportion for " + oldInfo.getId() + "+" + info.getId() + " using oldInfo.sideWeight=" + oldInfo.getSideWeight(), t$iv);
                }
                String string = oldInfo.getId();
                Intrinsics.checkNotNull((Object)string);
                float proportion = this.state.getPreferredSplitProportion(string, ToolWindowPane.Companion.normalizeWeight(oldInfo.getSideWeight() / (oldInfo.getSideWeight() + info.getSideWeight())));
                splitter2.setProportion(proportion);
                newWeight = !anchor.isHorizontal() && !anchor.isSplitVertically() ? ToolWindowPane.Companion.normalizeWeight(oldInfo.getWeight() + info.getWeight()) : ToolWindowPane.Companion.normalizeWeight(oldInfo.getWeight());
            } else {
                splitter2.setFirstComponent(newComponent);
                splitter2.setSecondComponent(oldComponent);
                splitter2.setProportion(ToolWindowPane.Companion.normalizeWeight(info.getSideWeight()));
                newWeight = !anchor.isHorizontal() && !anchor.isSplitVertically() ? ToolWindowPane.Companion.normalizeWeight(oldInfo.getWeight() + info.getWeight()) : ToolWindowPane.Companion.normalizeWeight(info.getWeight());
            }
            Logger $this$debug_u24default$iv = ToolWindowPaneKt.access$getLOG$p();
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger2 = $this$debug_u24default$iv;
                boolean bl = false;
                logger2.debug("Calculated splitter weight of " + newWeight + " for " + oldInfo.getId() + "+" + info.getId() + " using isSplit=" + info.isSplit() + ", isHorizontal=" + anchor.isHorizontal() + ", isSplitVertically=" + anchor.isSplitVertically() + ", oldInfo.weight=" + oldInfo.getWeight() + ", newInfo.weight=" + info.getWeight(), t$iv);
            }
        } else {
            newWeight = ToolWindowPane.Companion.normalizeWeight(info.getWeight());
        }
        this.setComponent((JComponent)((Object)splitter2), anchor, newWeight);
        if (!dirtyMode) {
            this.layeredPane.validate();
            this.layeredPane.repaint();
        }
    }

    private final void addSlidingComponent(JComponent component2, WindowInfo info, boolean dirtyMode) {
        if (dirtyMode || !UISettings.Companion.getInstance().getAnimateWindows() || RemoteDesktopService.isRemoteSession()) {
            this.layeredPane.add(component2, JLayeredPane.PALETTE_LAYER, -1);
            this.layeredPane.setBoundsInPaletteLayer(component2, info.getAnchor(), info.getWeight());
        } else {
            Image topImage = this.layeredPane.getTopImage();
            Rectangle bounds = component2.getBounds();
            UIUtil.useSafely((Graphics)topImage.getGraphics(), arg_0 -> ToolWindowPane.addSlidingComponent$lambda$1(arg_0 -> ToolWindowPane.addSlidingComponent$lambda$0(component2, this, info, arg_0), arg_0));
            Image bottomImage = this.layeredPane.getBottomImage();
            Point2D point2D = PaintUtil.getFractOffsetInRootPane((JComponent)this.layeredPane);
            Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"getFractOffsetInRootPane(...)");
            Point2D bottomImageOffset = point2D;
            UIUtil.useSafely((Graphics)bottomImage.getGraphics(), arg_0 -> ToolWindowPane.addSlidingComponent$lambda$3(arg_0 -> ToolWindowPane.addSlidingComponent$lambda$2(bounds, bottomImageOffset, this, arg_0), arg_0));
            Point2D point2D2 = PaintUtil.negate((Point2D)bottomImageOffset);
            Intrinsics.checkNotNullExpressionValue((Object)point2D2, (String)"negate(...)");
            Surface surface = new Surface(topImage, bottomImage, point2D2, 1, info.getAnchor(), 300);
            this.layeredPane.add(surface, JLayeredPane.PALETTE_LAYER, -1);
            surface.setBounds(bounds);
            this.layeredPane.validate();
            this.layeredPane.repaint();
            surface.runMovement();
            this.layeredPane.remove(surface);
            this.layeredPane.add(component2, JLayeredPane.PALETTE_LAYER, -1);
        }
        if (!dirtyMode) {
            this.layeredPane.validate();
            this.layeredPane.repaint();
        }
    }

    private final void removeSlidingComponent(Component component2, WindowInfo info, boolean dirtyMode) {
        if (!dirtyMode && UISettings.Companion.getInstance().getAnimateWindows() && !RemoteDesktopService.isRemoteSession()) {
            Rectangle bounds = component2.getBounds();
            Image topImage = this.layeredPane.getTopImage();
            UIUtil.useSafely((Graphics)topImage.getGraphics(), arg_0 -> ToolWindowPane.removeSlidingComponent$lambda$1(arg_0 -> ToolWindowPane.removeSlidingComponent$lambda$0(component2, arg_0), arg_0));
            Image bottomImage = this.layeredPane.getBottomImage();
            Point2D point2D = PaintUtil.getFractOffsetInRootPane((JComponent)this.layeredPane);
            Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"getFractOffsetInRootPane(...)");
            Point2D bottomImageOffset = point2D;
            UIUtil.useSafely((Graphics)bottomImage.getGraphics(), arg_0 -> ToolWindowPane.removeSlidingComponent$lambda$3(arg_0 -> ToolWindowPane.removeSlidingComponent$lambda$2(this, component2, bounds, bottomImageOffset, arg_0), arg_0));
            Point2D point2D2 = PaintUtil.negate((Point2D)bottomImageOffset);
            Intrinsics.checkNotNullExpressionValue((Object)point2D2, (String)"negate(...)");
            Surface surface = new Surface(topImage, bottomImage, point2D2, -1, info.getAnchor(), 300);
            this.layeredPane.add(surface, JLayeredPane.PALETTE_LAYER, -1);
            surface.setBounds(bounds);
            this.layeredPane.validate();
            this.layeredPane.repaint();
            surface.runMovement();
            this.layeredPane.remove(surface);
        } else {
            this.layeredPane.remove(component2);
        }
        if (!dirtyMode) {
            this.layeredPane.validate();
            this.layeredPane.repaint();
        }
    }

    public final void setStripesOverlaid$intellij_platform_ide_impl(boolean value) {
        this.state.setStripesOverlaid(value);
        this.updateToolStripesVisibility(UISettings.Companion.getInstance());
    }

    private static final void setWeight$lambda$0(ToolWindowAnchor $anchor, ToolWindowPane this$0, float $weight) {
        if (ToolWindowPaneKt.access$getLOG$p().isDebugEnabled()) {
            ToolWindowPaneKt.access$getLOG$p().debug("Retrying to set the weight of the anchor " + $anchor + " on pane resize");
        }
        this$0.setWeight$intellij_platform_ide_impl($anchor, $weight);
    }

    private static final void addAndSplitDockedComponentCmd$lambda$0(addAndSplitDockedComponentCmd.MySplitter $splitter, ToolWindowAnchor $anchor, PropertyChangeEvent event) {
        if (!Intrinsics.areEqual((Object)"orientation", (Object)event.getPropertyName())) {
            return;
        }
        boolean isSplitterHorizontalNow = !$splitter.isVertical();
        UISettings settings = UISettings.Companion.getInstance();
        if (Intrinsics.areEqual((Object)$anchor, (Object)ToolWindowAnchor.LEFT) && settings.getLeftHorizontalSplit() != isSplitterHorizontalNow) {
            settings.setLeftHorizontalSplit(isSplitterHorizontalNow);
            settings.fireUISettingsChanged();
        }
        if (Intrinsics.areEqual((Object)$anchor, (Object)ToolWindowAnchor.RIGHT) && settings.getRightHorizontalSplit() != isSplitterHorizontalNow) {
            settings.setRightHorizontalSplit(isSplitterHorizontalNow);
            settings.fireUISettingsChanged();
        }
    }

    private static final boolean addAndSplitDockedComponentCmd$lambda$1(WindowInfo $info, ToolWindowEx window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        return window.isSplitMode() == $info.isSplit() || !window.isVisible();
    }

    private static final boolean addAndSplitDockedComponentCmd$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit addSlidingComponent$lambda$0(JComponent $component, ToolWindowPane this$0, WindowInfo $info, Graphics2D topGraphics) {
        $component.putClientProperty(TEMPORARY_ADDED, true);
        try {
            this$0.layeredPane.add($component, JLayeredPane.PALETTE_LAYER, -1);
            this$0.layeredPane.moveToFront($component);
            this$0.layeredPane.setBoundsInPaletteLayer($component, $info.getAnchor(), $info.getWeight());
            $component.paint(topGraphics);
            this$0.layeredPane.remove($component);
        }
        finally {
            $component.putClientProperty(TEMPORARY_ADDED, null);
        }
        return Unit.INSTANCE;
    }

    private static final void addSlidingComponent$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit addSlidingComponent$lambda$2(Rectangle $bounds, Point2D $bottomImageOffset, ToolWindowPane this$0, Graphics2D bottomGraphics) {
        bottomGraphics.setClip(0, 0, $bounds.width, $bounds.height);
        bottomGraphics.translate($bottomImageOffset.getX() - (double)$bounds.x, $bottomImageOffset.getY() - (double)$bounds.y);
        this$0.layeredPane.paint(bottomGraphics);
        return Unit.INSTANCE;
    }

    private static final void addSlidingComponent$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit removeSlidingComponent$lambda$0(Component $component, Graphics2D g) {
        $component.paint(g);
        return Unit.INSTANCE;
    }

    private static final void removeSlidingComponent$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit removeSlidingComponent$lambda$2(ToolWindowPane this$0, Component $component, Rectangle $bounds, Point2D $bottomImageOffset, Graphics2D bottomGraphics) {
        Intrinsics.checkNotNullParameter((Object)bottomGraphics, (String)"bottomGraphics");
        this$0.layeredPane.remove($component);
        bottomGraphics.clipRect(0, 0, $bounds.width, $bounds.height);
        bottomGraphics.translate($bottomImageOffset.getX() - (double)$bounds.x, $bottomImageOffset.getY() - (double)$bounds.y);
        this$0.layeredPane.paint(bottomGraphics);
        return Unit.INSTANCE;
    }

    private static final void removeSlidingComponent$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public /* synthetic */ ToolWindowPane(JFrame frame, String paneId, ToolWindowButtonManager buttonManager, DefaultConstructorMarker $constructor_marker) {
        this(frame, paneId, buttonManager);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\r\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ-\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J%\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0019J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0005H\u0007J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/intellij/toolWindow/ToolWindowPane$Companion;", "", "<init>", "()V", "TEMPORARY_ADDED", "", "headerResizeArea", "", "getHeaderResizeArea", "()I", "normalizeWeight", "", "weight", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "log$intellij_platform_ide_impl", "create", "Lcom/intellij/toolWindow/ToolWindowPane;", "frame", "Ljavax/swing/JFrame;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "paneId", "buttonManager", "Lcom/intellij/toolWindow/ToolWindowButtonManager;", "create$intellij_platform_ide_impl", "createButtonManager", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmName(name="getHeaderResizeArea")
        public final int getHeaderResizeArea() {
            return JBUI.scale((int)Registry.Companion.intValue("ide.new.tool.window.resize.area.height", 14, 1, 26));
        }

        private final float normalizeWeight(float weight) {
            if (weight <= 0.0f) {
                return 0.33f;
            }
            return weight >= 1.0f ? 0.66999996f : weight;
        }

        @NotNull
        public final Logger log$intellij_platform_ide_impl() {
            return ToolWindowPaneKt.access$getLOG$p();
        }

        @NotNull
        public final ToolWindowPane create$intellij_platform_ide_impl(@NotNull JFrame frame, @NotNull CoroutineScope coroutineScope, @NotNull String paneId, @NotNull ToolWindowButtonManager buttonManager) {
            ToolWindowPane toolWindowPane2;
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Intrinsics.checkNotNullParameter((Object)paneId, (String)"paneId");
            Intrinsics.checkNotNullParameter((Object)buttonManager, (String)"buttonManager");
            ToolWindowPane pane2 = toolWindowPane2 = new ToolWindowPane(frame, paneId, buttonManager, null);
            boolean bl = false;
            Application app = ApplicationManager.getApplication();
            SimpleMessageBusConnection simpleMessageBusConnection = app.getMessageBus().connect(coroutineScope);
            Topic topic = LafManagerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            simpleMessageBusConnection.subscribe(topic, arg_0 -> Companion.create$lambda$0$0(pane2, arg_0));
            return toolWindowPane2;
        }

        @NotNull
        public final ToolWindowPane create$intellij_platform_ide_impl(@NotNull JFrame frame, @NotNull CoroutineScope coroutineScope, @NotNull String paneId) {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Intrinsics.checkNotNullParameter((Object)paneId, (String)"paneId");
            ToolWindowButtonManager buttonManager = this.createButtonManager(paneId);
            return this.create$intellij_platform_ide_impl(frame, coroutineScope, paneId, buttonManager);
        }

        @ApiStatus.Internal
        @VisibleForTesting
        @NotNull
        public final ToolWindowPane create(@NotNull JFrame frame, @NotNull String paneId) {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter((Object)paneId, (String)"paneId");
            ToolWindowButtonManager buttonManager = this.createButtonManager(paneId);
            return new ToolWindowPane(frame, paneId, buttonManager, null);
        }

        private final ToolWindowButtonManager createButtonManager(String paneId) {
            ToolWindowButtonManager toolWindowButtonManager;
            StripesUxCustomizer stripesUxCustomizer;
            InternalUICustomization internalUICustomization = InternalUICustomization.Companion.getInstance();
            if (internalUICustomization != null && (stripesUxCustomizer = internalUICustomization.getInternalCustomizer$intellij_platform_ide_impl()) != null && (toolWindowButtonManager = stripesUxCustomizer.createCustomButtonManager(paneId)) != null) {
                ToolWindowButtonManager it = toolWindowButtonManager;
                boolean bl = false;
                return it;
            }
            ToolWindowButtonManager buttonManager = null;
            buttonManager = ExperimentalUI.Companion.isNewUI() ? (ToolWindowButtonManager)new ToolWindowPaneNewButtonManager(paneId) : (ToolWindowButtonManager)new ToolWindowPaneOldButtonManager(paneId);
            return buttonManager;
        }

        private static final void create$lambda$0$0(ToolWindowPane $pane, LafManager it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $pane.isLookAndFeelUpdated = true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001:\u0002\u0006\u0007J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/toolWindow/ToolWindowPane$Resizer;", "", "setSize", "", "size", "", "Splitter", "LayeredPane", "intellij.platform.ide.impl"})
    public static interface Resizer {
        public void setSize(int var1);

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0004\u000e\u000f\u0010\u0011B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0012"}, d2={"Lcom/intellij/toolWindow/ToolWindowPane$Resizer$LayeredPane;", "Lcom/intellij/toolWindow/ToolWindowPane$Resizer;", "component", "Ljava/awt/Component;", "<init>", "(Ljava/awt/Component;)V", "getComponent", "()Ljava/awt/Component;", "setComponent", "setSize", "", "size", "", "_setSize", "Left", "Right", "Top", "Bottom", "intellij.platform.ide.impl"})
        public static abstract class LayeredPane
        implements Resizer {
            @NotNull
            private Component component;

            public LayeredPane(@NotNull Component component2) {
                Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                this.component = component2;
            }

            @NotNull
            public final Component getComponent() {
                return this.component;
            }

            public final void setComponent(@NotNull Component component2) {
                Intrinsics.checkNotNullParameter((Object)component2, (String)"<set-?>");
                this.component = component2;
            }

            @Override
            public void setSize(int size2) {
                this._setSize(size2);
                if (this.component.getParent() instanceof JComponent) {
                    Component component2 = this.component;
                    Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type javax.swing.JComponent");
                    JComponent parent = (JComponent)component2;
                    parent.revalidate();
                    parent.repaint();
                }
            }

            public abstract void _setSize(int var1);

            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/toolWindow/ToolWindowPane$Resizer$LayeredPane$Bottom;", "Lcom/intellij/toolWindow/ToolWindowPane$Resizer$LayeredPane;", "component", "Ljava/awt/Component;", "<init>", "(Ljava/awt/Component;)V", "_setSize", "", "size", "", "intellij.platform.ide.impl"})
            public static final class Bottom
            extends LayeredPane {
                public Bottom(@NotNull Component component2) {
                    Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                    super(component2);
                }

                @Override
                public void _setSize(int size2) {
                    Rectangle bounds = this.getComponent().getBounds();
                    int delta = size2 - bounds.height;
                    bounds.y -= delta;
                    bounds.height += delta;
                    this.getComponent().setBounds(bounds);
                }
            }

            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/toolWindow/ToolWindowPane$Resizer$LayeredPane$Left;", "Lcom/intellij/toolWindow/ToolWindowPane$Resizer$LayeredPane;", "component", "Ljava/awt/Component;", "<init>", "(Ljava/awt/Component;)V", "_setSize", "", "size", "", "intellij.platform.ide.impl"})
            public static final class Left
            extends LayeredPane {
                public Left(@NotNull Component component2) {
                    Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                    super(component2);
                }

                @Override
                public void _setSize(int size2) {
                    this.getComponent().setSize(size2, this.getComponent().getHeight());
                }
            }

            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/toolWindow/ToolWindowPane$Resizer$LayeredPane$Right;", "Lcom/intellij/toolWindow/ToolWindowPane$Resizer$LayeredPane;", "component", "Ljava/awt/Component;", "<init>", "(Ljava/awt/Component;)V", "_setSize", "", "size", "", "intellij.platform.ide.impl"})
            public static final class Right
            extends LayeredPane {
                public Right(@NotNull Component component2) {
                    Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                    super(component2);
                }

                @Override
                public void _setSize(int size2) {
                    Rectangle bounds = this.getComponent().getBounds();
                    int delta = size2 - bounds.width;
                    bounds.x -= delta;
                    bounds.width += delta;
                    this.getComponent().setBounds(bounds);
                }
            }

            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/toolWindow/ToolWindowPane$Resizer$LayeredPane$Top;", "Lcom/intellij/toolWindow/ToolWindowPane$Resizer$LayeredPane;", "component", "Ljava/awt/Component;", "<init>", "(Ljava/awt/Component;)V", "_setSize", "", "size", "", "intellij.platform.ide.impl"})
            public static final class Top
            extends LayeredPane {
                public Top(@NotNull Component component2) {
                    Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                    super(component2);
                }

                @Override
                public void _setSize(int size2) {
                    this.getComponent().setSize(this.getComponent().getWidth(), size2);
                }
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001:\u0002\t\nB\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u000b"}, d2={"Lcom/intellij/toolWindow/ToolWindowPane$Resizer$Splitter;", "Lcom/intellij/toolWindow/ToolWindowPane$Resizer;", "splitter", "Lcom/intellij/openapi/ui/ThreeComponentsSplitter;", "<init>", "(Lcom/intellij/openapi/ui/ThreeComponentsSplitter;)V", "getSplitter", "()Lcom/intellij/openapi/ui/ThreeComponentsSplitter;", "setSplitter", "FirstComponent", "LastComponent", "intellij.platform.ide.impl"})
        public static abstract class Splitter
        implements Resizer {
            @NotNull
            private ThreeComponentsSplitter splitter;

            public Splitter(@NotNull ThreeComponentsSplitter splitter2) {
                Intrinsics.checkNotNullParameter((Object)splitter2, (String)"splitter");
                this.splitter = splitter2;
            }

            @NotNull
            public final ThreeComponentsSplitter getSplitter() {
                return this.splitter;
            }

            public final void setSplitter(@NotNull ThreeComponentsSplitter threeComponentsSplitter) {
                Intrinsics.checkNotNullParameter((Object)threeComponentsSplitter, (String)"<set-?>");
                this.splitter = threeComponentsSplitter;
            }

            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/toolWindow/ToolWindowPane$Resizer$Splitter$FirstComponent;", "Lcom/intellij/toolWindow/ToolWindowPane$Resizer$Splitter;", "splitter", "Lcom/intellij/openapi/ui/ThreeComponentsSplitter;", "<init>", "(Lcom/intellij/openapi/ui/ThreeComponentsSplitter;)V", "setSize", "", "size", "", "intellij.platform.ide.impl"})
            public static final class FirstComponent
            extends Splitter {
                public FirstComponent(@NotNull ThreeComponentsSplitter splitter2) {
                    Intrinsics.checkNotNullParameter((Object)splitter2, (String)"splitter");
                    super(splitter2);
                }

                @Override
                public void setSize(int size2) {
                    this.getSplitter().setFirstSize(size2);
                }
            }

            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/toolWindow/ToolWindowPane$Resizer$Splitter$LastComponent;", "Lcom/intellij/toolWindow/ToolWindowPane$Resizer$Splitter;", "splitter", "Lcom/intellij/openapi/ui/ThreeComponentsSplitter;", "<init>", "(Lcom/intellij/openapi/ui/ThreeComponentsSplitter;)V", "setSize", "", "size", "", "intellij.platform.ide.impl"})
            public static final class LastComponent
            extends Splitter {
                public LastComponent(@NotNull ThreeComponentsSplitter splitter2) {
                    Intrinsics.checkNotNullParameter((Object)splitter2, (String)"splitter");
                    super(splitter2);
                }

                @Override
                public void setSize(int size2) {
                    this.getSplitter().setLastSize(size2);
                }
            }
        }
    }
}

