/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import javax.swing.UIManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class BalloonLayoutConfiguration {
    public final int iconPanelWidth;
    public final Dimension iconOffset;
    public final int topSpaceHeight;
    public final int titleContentSpaceHeight;
    public final int contentActionsSpaceHeight;
    public final int titleActionsSpaceHeight;
    public final int bottomSpaceHeight;
    public final int actionGap;
    public final Dimension rightActionsOffset;
    public final int closeOffset;
    public final int gearCloseSpace;
    public final int allActionsOffset;
    public final int beforeGearSpace;
    private static final int RawWidth;
    private static final int RawStyleWidth;

    public static int MaxFullContentWidth() {
        return JBUIScale.scale((int)350);
    }

    @NotNull
    public static String MaxFullContentWidthStyle() {
        String string = "width:" + BalloonLayoutConfiguration.MaxFullContentWidth() + "px;";
        if (string == null) {
            BalloonLayoutConfiguration.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static int MinWidth() {
        return JBUIScale.scale((int)100);
    }

    public static int FixedWidth() {
        return JBUIScale.scale((int)RawWidth);
    }

    public static int MaxWidth() {
        return JBUIScale.scale((int)(RawWidth - 60));
    }

    public static String MaxWidthStyle() {
        return "width:" + JBUIScale.scale((int)RawStyleWidth) + "px;";
    }

    @NotNull
    public static BalloonLayoutConfiguration create(@NotNull Notification notification2, @NotNull BalloonLayoutData layoutData, boolean actions) {
        if (notification2 == null) {
            BalloonLayoutConfiguration.$$$reportNull$$$0(1);
        }
        if (layoutData == null) {
            BalloonLayoutConfiguration.$$$reportNull$$$0(2);
        }
        boolean hasTitle = notification2.hasTitle();
        boolean hasContent = notification2.hasContent();
        if (hasTitle && hasContent && actions) {
            return BalloonLayoutConfiguration.treeLines();
        }
        if (hasContent && NotificationsManagerImpl.calculateContentHeight(hasTitle || actions ? 1 : 2) < layoutData.fullHeight) {
            return BalloonLayoutConfiguration.treeLines();
        }
        return BalloonLayoutConfiguration.twoLines();
    }

    @NotNull
    public BalloonLayoutConfiguration replace(int topSpaceHeight, int bottomSpaceHeight) {
        return new BalloonLayoutConfiguration(this.iconPanelWidth, this.iconOffset, topSpaceHeight, this.titleContentSpaceHeight, this.contentActionsSpaceHeight, this.titleActionsSpaceHeight, bottomSpaceHeight, this.actionGap, null, 0, 0, 0);
    }

    @NotNull
    private static BalloonLayoutConfiguration twoLines() {
        return new BalloonLayoutConfiguration((Dimension)new JBDimension(10, 11), JBUIScale.scale((int)11), JBUIScale.scale((int)5), JBUIScale.scale((int)5), JBUIScale.scale((int)5), JBUIScale.scale((int)14));
    }

    @NotNull
    private static BalloonLayoutConfiguration treeLines() {
        return new BalloonLayoutConfiguration((Dimension)new JBDimension(10, 7), JBUIScale.scale((int)7), JBUIScale.scale((int)3), JBUIScale.scale((int)7), 0, JBUIScale.scale((int)8));
    }

    private BalloonLayoutConfiguration(@NotNull Dimension iconOffset, int topSpaceHeight, int titleContentSpaceHeight, int contentActionsSpaceHeight, int titleActionsSpaceHeight, int bottomSpaceHeight) {
        if (iconOffset == null) {
            BalloonLayoutConfiguration.$$$reportNull$$$0(3);
        }
        this(JBUIScale.scale((int)32), iconOffset, topSpaceHeight, titleContentSpaceHeight, contentActionsSpaceHeight, titleActionsSpaceHeight, bottomSpaceHeight, JBUIScale.scale((int)16), (Dimension)(ExperimentalUI.isNewUI() ? new JBDimension(9, 9) : new JBDimension(8, 6)), JBUIScale.scale((int)7), JBUIScale.scale((int)5), JBUIScale.scale((int)15));
    }

    private BalloonLayoutConfiguration(int iconPanelWidth, @NotNull Dimension iconOffset, int topSpaceHeight, int titleContentSpaceHeight, int contentActionsSpaceHeight, int titleActionsSpaceHeight, int bottomSpaceHeight, int actionGap, @Nullable Dimension rightActionsOffset, int afterGearSpace, int beforeCloseSpace, int beforeGearSpace) {
        if (iconOffset == null) {
            BalloonLayoutConfiguration.$$$reportNull$$$0(4);
        }
        Dimension iconOffsets = UIManager.getDimension("Notification.iconOffsetSize");
        this.iconPanelWidth = iconOffsets == null ? iconPanelWidth : iconOffsets.width;
        this.iconOffset = iconOffset;
        if (iconOffsets != null) {
            this.iconOffset.width = iconOffsets.height;
        }
        this.topSpaceHeight = topSpaceHeight;
        this.titleContentSpaceHeight = JBUI.getInt((String)"Notification.titleContentInset", (int)titleContentSpaceHeight);
        this.contentActionsSpaceHeight = JBUI.getInt((String)"Notification.contentActionsInset", (int)contentActionsSpaceHeight);
        this.titleActionsSpaceHeight = JBUI.getInt((String)"Notification.titleActionsInset", (int)titleActionsSpaceHeight);
        this.bottomSpaceHeight = bottomSpaceHeight;
        this.actionGap = actionGap;
        if (rightActionsOffset == null) {
            this.rightActionsOffset = new Dimension();
            this.closeOffset = 0;
            this.gearCloseSpace = 0;
            this.allActionsOffset = 0;
            this.beforeGearSpace = 0;
        } else {
            this.rightActionsOffset = rightActionsOffset;
            this.closeOffset = beforeCloseSpace + AllIcons.Ide.Notification.Close.getIconWidth() + rightActionsOffset.width;
            this.gearCloseSpace = afterGearSpace + beforeCloseSpace;
            this.allActionsOffset = this.closeOffset + afterGearSpace + AllIcons.Ide.Notification.Gear.getIconWidth();
            this.beforeGearSpace = beforeGearSpace;
        }
    }

    static {
        int width = 360;
        width += JBUI.unscale((int)AllIcons.Ide.Shadow.Left.getIconWidth());
        RawWidth = width += JBUI.unscale((int)AllIcons.Ide.Shadow.Right.getIconWidth());
        RawStyleWidth = 240;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/BalloonLayoutConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutData";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconOffset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "MaxFullContentWidthStyle";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/BalloonLayoutConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

