/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.FilteringSpeedSearch;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Function;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilteringTree<T extends DefaultMutableTreeNode, U> {
    public static final SpeedSearchSupply DUMMY_SEARCH = new SpeedSearchSupply(){

        @Nullable
        public Iterable<TextRange> matchingFragments(@NotNull String text2) {
            if (text2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return null;
        }

        public void refreshSelection() {
        }

        public boolean isPopupActive() {
            return false;
        }

        public void addChangeListener(@NotNull PropertyChangeListener listener2) {
            if (listener2 == null) {
                1.$$$reportNull$$$0(1);
            }
        }

        public void removeChangeListener(@NotNull PropertyChangeListener listener2) {
            if (listener2 == null) {
                1.$$$reportNull$$$0(2);
            }
        }

        public void findAndSelectElement(@NotNull String searchQuery) {
            if (searchQuery == null) {
                1.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchQuery";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/FilteringTree$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchingFragments";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChangeListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeChangeListener";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findAndSelectElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final T myRoot;
    private final Tree myTree;

    public FilteringTree(@NotNull Tree tree2, @NotNull T root) {
        if (tree2 == null) {
            FilteringTree.$$$reportNull$$$0(0);
        }
        if (root == null) {
            FilteringTree.$$$reportNull$$$0(1);
        }
        this.myRoot = root;
        this.myTree = tree2;
        this.myTree.setModel(new SearchTreeModel(this.myRoot, DUMMY_SEARCH, o -> this.getText(o), this::createNode, this::getChildren, this.useIdentityHashing()));
    }

    @NotNull
    public SearchTextField installSearchField() {
        SearchTextField field = new SearchTextField(false){

            protected boolean preprocessEventForTextField(KeyEvent e) {
                if (e.getKeyCode() == 40 || e.getKeyCode() == 38) {
                    FilteringTree.this.myTree.dispatchEvent((AWTEvent)e);
                    return true;
                }
                if (e.getKeyCode() == 27 && this.getText().isEmpty()) {
                    UIUtil.requestFocus((JComponent)FilteringTree.this.myTree);
                    return true;
                }
                return false;
            }
        };
        this.getSearchModel().setSpeedSearch(this.createSpeedSearch(field));
        SearchTextField searchTextField = field;
        if (searchTextField == null) {
            FilteringTree.$$$reportNull$$$0(2);
        }
        return searchTextField;
    }

    @NotNull
    protected SpeedSearchSupply createSpeedSearch(@NotNull SearchTextField searchTextField) {
        if (searchTextField == null) {
            FilteringTree.$$$reportNull$$$0(3);
        }
        return new FilteringSpeedSearch(this, searchTextField);
    }

    public void installSimple() {
        TreeSpeedSearch supply = new TreeSpeedSearch((JTree)this.myTree, true, null, p -> StringUtil.notNullize((String)this.getText(p == null ? null : (U)this.getUserObject((TreeNode)p.getLastPathComponent())))){

            @Override
            protected void onSearchFieldUpdated(String pattern) {
                super.onSearchFieldUpdated(pattern);
                if (StringUtil.isNotEmpty((String)pattern) && !this.isPopupActive()) {
                    SwingUtilities.invokeLater(() -> {
                        FilteringTree.this.getSearchModel().refilter();
                        if (StringUtil.isNotEmpty((String)pattern)) {
                            TreeUtil.expandAll((JTree)FilteringTree.this.myTree);
                        }
                    });
                } else {
                    FilteringTree.this.getSearchModel().refilter();
                }
            }
        };
        supply.setupListeners();
        this.getSearchModel().setSpeedSearch(supply);
    }

    protected abstract Class<? extends T> getNodeClass();

    @NotNull
    protected abstract T createNode(@NotNull U var1);

    @NotNull
    protected abstract Iterable<U> getChildren(@NotNull U var1);

    @NotNull
    public Tree getTree() {
        Tree tree2 = this.myTree;
        if (tree2 == null) {
            FilteringTree.$$$reportNull$$$0(4);
        }
        return tree2;
    }

    @NotNull
    public JComponent getComponent() {
        Tree tree2 = this.myTree;
        if (tree2 == null) {
            FilteringTree.$$$reportNull$$$0(5);
        }
        return tree2;
    }

    protected void expandTreeOnSearchUpdateComplete(@Nullable String pattern) {
        if (StringUtil.isNotEmpty((String)pattern)) {
            TreeUtil.expandAll((JTree)this.myTree);
        }
    }

    protected void onSpeedSearchUpdateComplete(@Nullable String pattern) {
    }

    protected boolean useIdentityHashing() {
        return true;
    }

    @Nullable
    protected abstract String getText(@Nullable U var1);

    @NotNull
    public SearchTreeModel<T, U> getSearchModel() {
        SearchTreeModel searchTreeModel = (SearchTreeModel)this.myTree.getModel();
        if (searchTreeModel == null) {
            FilteringTree.$$$reportNull$$$0(6);
        }
        return searchTreeModel;
    }

    @NotNull
    public T getRoot() {
        T t = this.myRoot;
        if (t == null) {
            FilteringTree.$$$reportNull$$$0(7);
        }
        return t;
    }

    @Nullable
    public final U getUserObject(@Nullable TreeNode node) {
        return (U)(node == null || !this.getNodeClass().isAssignableFrom(node.getClass()) ? null : ((DefaultMutableTreeNode)node).getUserObject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/FilteringTree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchTextField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/FilteringTree";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "installSearchField";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSpeedSearch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    public static final class SearchTreeModel<N extends DefaultMutableTreeNode, U>
    extends DefaultTreeModel {
        @NotNull
        private final Function<? super U, String> myNamer;
        @NotNull
        private final Function<? super U, ? extends N> myFactory;
        private final U myRootObject;
        private final Function<? super U, ? extends Iterable<? extends U>> myStructure;
        private final boolean myUseIdentityHashing;
        private SpeedSearchSupply mySpeedSearch;
        private Map<U, N> myNodeCache;

        public SearchTreeModel(@NotNull N root, @NotNull SpeedSearchSupply speedSearch2, @NotNull Function<? super U, String> namer, @NotNull Function<? super U, ? extends N> nodeFactory, @NotNull Function<? super U, ? extends Iterable<? extends U>> structure, boolean useIdentityHashing) {
            if (root == null) {
                SearchTreeModel.$$$reportNull$$$0(0);
            }
            if (speedSearch2 == null) {
                SearchTreeModel.$$$reportNull$$$0(1);
            }
            if (namer == null) {
                SearchTreeModel.$$$reportNull$$$0(2);
            }
            if (nodeFactory == null) {
                SearchTreeModel.$$$reportNull$$$0(3);
            }
            if (structure == null) {
                SearchTreeModel.$$$reportNull$$$0(4);
            }
            super((TreeNode)root);
            this.myRootObject = Objects.requireNonNull(this.getUserObject(root));
            this.mySpeedSearch = speedSearch2;
            this.myNamer = namer;
            this.myFactory = nodeFactory;
            this.myStructure = structure;
            this.myUseIdentityHashing = useIdentityHashing;
            this.myNodeCache = this.createUserObjectMap();
        }

        public void setSpeedSearch(@NotNull SpeedSearchSupply supply) {
            if (supply == null) {
                SearchTreeModel.$$$reportNull$$$0(5);
            }
            this.mySpeedSearch = supply;
            this.updateStructure();
        }

        public SpeedSearchSupply getSpeedSearch() {
            return this.mySpeedSearch;
        }

        @RequiresEdt
        public void updateStructure() {
            ThreadingAssertions.assertEventDispatchThread();
            Map<U, N> newNodes = this.createUserObjectMap();
            Iterator iterator2 = ((JBTreeTraverser)JBTreeTraverser.from(this.myStructure).withRoot(this.getRootObject())).iterator();
            while (iterator2.hasNext()) {
                Object node;
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.myNodeCache.get(node = iterator2.next());
                newNodes.put(node, treeNode == null ? this.createNode(node) : treeNode);
            }
            Set<N> nodesToRemove = this.getNodesToRemove(newNodes);
            this.myNodeCache = newNodes;
            for (DefaultMutableTreeNode node : nodesToRemove) {
                if (node.getParent() == null) continue;
                this.removeNodeFromParent(node);
            }
            this.refilter();
        }

        @NotNull
        private Set<N> getNodesToRemove(Map<U, N> newNodes) {
            ReferenceOpenHashSet nodesToRemove = new ReferenceOpenHashSet();
            for (Map.Entry<U, N> entry : this.myNodeCache.entrySet()) {
                if (newNodes.containsKey(entry.getKey())) continue;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)entry.getValue();
                boolean shouldRemove = true;
                for (TreeNode treeNode : node.getPath()) {
                    if (!nodesToRemove.contains(treeNode)) continue;
                    shouldRemove = false;
                    break;
                }
                if (!shouldRemove) continue;
                nodesToRemove.add(node);
            }
            ReferenceOpenHashSet referenceOpenHashSet = nodesToRemove;
            if (referenceOpenHashSet == null) {
                SearchTreeModel.$$$reportNull$$$0(6);
            }
            return referenceOpenHashSet;
        }

        public N getRoot() {
            return (N)((DefaultMutableTreeNode)this.root);
        }

        @NotNull
        public U getRootObject() {
            U u = this.myRootObject;
            if (u == null) {
                SearchTreeModel.$$$reportNull$$$0(7);
            }
            return u;
        }

        @NotNull
        public N getNode(@NotNull U object) {
            N node;
            if (object == null) {
                SearchTreeModel.$$$reportNull$$$0(8);
            }
            if ((node = this.getCachedNode(object)) == null) {
                node = this.createNode(object);
                this.myNodeCache.put(object, node);
            }
            N n = node;
            if (n == null) {
                SearchTreeModel.$$$reportNull$$$0(9);
            }
            return n;
        }

        @Nullable
        public N getCachedNode(@Nullable U object) {
            if (object == null) {
                return null;
            }
            if (object == this.myRootObject) {
                return (N)this.getRoot();
            }
            return (N)((DefaultMutableTreeNode)this.myNodeCache.get(object));
        }

        @NotNull
        private N createNode(@NotNull U object) {
            if (object == null) {
                SearchTreeModel.$$$reportNull$$$0(10);
            }
            assert (!(object instanceof DefaultMutableTreeNode));
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.myFactory.fun(object);
            if (defaultMutableTreeNode == null) {
                SearchTreeModel.$$$reportNull$$$0(11);
            }
            return (N)defaultMutableTreeNode;
        }

        @RequiresEdt
        public void refilter() {
            ThreadingAssertions.assertEventDispatchThread();
            if (this.mySpeedSearch.isPopupActive()) {
                Set acceptCache = this.createUserObjectSet();
                this.computeAcceptCache(this.myRootObject, acceptCache);
                this.filterChildren(this.myRootObject, x -> acceptCache.contains(x));
            } else {
                this.filterChildren(this.myRootObject, x -> true);
            }
        }

        @NotNull
        private Set<U> createUserObjectSet() {
            return this.myUseIdentityHashing ? new ReferenceOpenHashSet() : new HashSet();
        }

        @NotNull
        private Map<U, N> createUserObjectMap() {
            return this.myUseIdentityHashing ? new Reference2ObjectLinkedOpenHashMap() : new LinkedHashMap();
        }

        private boolean equalUserObjects(@Nullable U u1, @Nullable U u2) {
            return this.myUseIdentityHashing ? u1 == u2 : Objects.equals(u1, u2);
        }

        private boolean computeAcceptCache(@NotNull U object, @NotNull Set<? super U> cache2) {
            if (object == null) {
                SearchTreeModel.$$$reportNull$$$0(12);
            }
            if (cache2 == null) {
                SearchTreeModel.$$$reportNull$$$0(13);
            }
            boolean isAccepted = false;
            Iterable<U> children2 = this.getChildren(object);
            for (U child : children2) {
                isAccepted |= this.computeAcceptCache(child, cache2);
            }
            boolean bl = isAccepted = isAccepted || object == this.myRootObject || this.accept(object);
            if (isAccepted) {
                for (U child : children2) {
                    if (this.myNamer.fun(child) != null) continue;
                    cache2.add(child);
                }
                cache2.add(object);
            }
            return isAccepted;
        }

        private boolean accept(@NotNull U object) {
            String name2;
            if (object == null) {
                SearchTreeModel.$$$reportNull$$$0(14);
            }
            if ((name2 = (String)this.myNamer.fun(object)) == null) {
                return false;
            }
            Iterable matchingFragments = this.mySpeedSearch.matchingFragments(name2);
            SpeedSearchSupply speedSearchSupply = this.mySpeedSearch;
            if (speedSearchSupply instanceof FilteringTreeUserObjectMatcher) {
                FilteringTreeUserObjectMatcher filteringTreeSpeedSearch = (FilteringTreeUserObjectMatcher)speedSearchSupply;
                return filteringTreeSpeedSearch.checkMatching(object, matchingFragments) != Matching.NONE;
            }
            return matchingFragments != null;
        }

        @NotNull
        public Iterable<? extends U> getChildren(@Nullable U object) {
            Object object2 = object == null ? JBIterable.empty() : (Iterable)this.myStructure.fun(object);
            if (object2 == null) {
                SearchTreeModel.$$$reportNull$$$0(15);
            }
            return object2;
        }

        @NotNull
        public Function<? super U, ? extends Iterable<? extends U>> getStructure() {
            Function<? super U, ? extends Iterable<? extends U>> function = this.myStructure;
            if (function == null) {
                SearchTreeModel.$$$reportNull$$$0(16);
            }
            return function;
        }

        @Nullable
        private static <N extends DefaultMutableTreeNode> N getChildSafe(@NotNull N node, int i2) {
            if (node == null) {
                SearchTreeModel.$$$reportNull$$$0(17);
            }
            return node.getChildCount() <= i2 ? null : (N)SearchTreeModel.getChild(node, i2);
        }

        private static <N extends DefaultMutableTreeNode> N getChild(@NotNull N node, int i2) {
            if (node == null) {
                SearchTreeModel.$$$reportNull$$$0(18);
            }
            return (N)((DefaultMutableTreeNode)node.getChildAt(i2));
        }

        private void filterChildren(@Nullable U object, @NotNull Condition<? super U> filter2) {
            if (filter2 == null) {
                SearchTreeModel.$$$reportNull$$$0(19);
            }
            if (object == null) {
                return;
            }
            N node = this.getNode(object);
            this.filterDirectChildren(node, filter2);
            int c = ((DefaultMutableTreeNode)node).getChildCount();
            for (int i2 = 0; i2 < c; ++i2) {
                this.filterChildren(this.getUserObject(SearchTreeModel.getChild(node, i2)), filter2);
            }
        }

        private void filterDirectChildren(@NotNull N node, @NotNull Condition<? super U> filter2) {
            if (node == null) {
                SearchTreeModel.$$$reportNull$$$0(20);
            }
            if (filter2 == null) {
                SearchTreeModel.$$$reportNull$$$0(21);
            }
            Set<U> acceptedSet = this.createUserObjectSet();
            ArrayList<U> acceptedList = new ArrayList<U>();
            for (U child : this.getChildren(this.getUserObject(node))) {
                if (!filter2.value(child)) continue;
                acceptedSet.add(child);
                acceptedList.add(child);
            }
            if (acceptedList.size() != acceptedSet.size()) {
                throw new AssertionError((Object)"Duplicate nodes will cause failure");
            }
            this.removeNotAccepted(node, acceptedSet);
            this.mergeAcceptedNodes(node, acceptedList);
        }

        private void mergeAcceptedNodes(@NotNull N node, List<? extends U> accepted) {
            if (node == null) {
                SearchTreeModel.$$$reportNull$$$0(22);
            }
            int k = 0;
            N cur = SearchTreeModel.getChildSafe(node, 0);
            IntArrayList newIds = new IntArrayList();
            for (U child : accepted) {
                boolean isCur;
                U curUsrObject = this.getUserObject(cur);
                boolean bl = isCur = cur != null && this.equalUserObjects(child, curUsrObject);
                if (isCur) {
                    cur = SearchTreeModel.getChildSafe(node, k + 1);
                } else {
                    newIds.add(k);
                    ((DefaultMutableTreeNode)node).insert((MutableTreeNode)this.getNode(child), k);
                }
                ++k;
            }
            if (!newIds.isEmpty()) {
                this.nodesWereInserted((TreeNode)node, newIds.toIntArray());
            }
            if (((DefaultMutableTreeNode)node).getChildCount() > k) {
                IntArrayList leftIds = new IntArrayList();
                ArrayList<N> leftNodes = new ArrayList<N>();
                for (int i2 = ((DefaultMutableTreeNode)node).getChildCount() - 1; i2 >= k; --i2) {
                    leftNodes.add(SearchTreeModel.getChild(node, i2));
                    ((DefaultMutableTreeNode)node).remove(i2);
                    leftIds.add(i2);
                }
                if (!leftIds.isEmpty()) {
                    int[] ints = leftIds.toIntArray();
                    for (int i3 = 0; i3 < ints.length; ++i3) {
                        int temp = ints[i3];
                        ints[i3] = ints[ints.length - i3 - 1];
                        ints[ints.length - i3 - 1] = temp;
                    }
                    Collections.reverse(leftNodes);
                    this.nodesWereRemoved((TreeNode)node, ints, leftNodes.toArray());
                }
            }
        }

        private void removeNotAccepted(@NotNull N node, Set<U> accepted) {
            if (node == null) {
                SearchTreeModel.$$$reportNull$$$0(23);
            }
            IntArrayList removedIds = new IntArrayList();
            ArrayList<N> removedNodes = new ArrayList<N>();
            for (int i2 = ((DefaultMutableTreeNode)node).getChildCount() - 1; i2 >= 0; --i2) {
                N child = SearchTreeModel.getChild(node, i2);
                if (accepted.contains(this.getUserObject(child))) continue;
                removedIds.add(i2);
                removedNodes.add(child);
                ((DefaultMutableTreeNode)node).remove(i2);
            }
            if (!removedIds.isEmpty()) {
                Collections.reverse(removedNodes);
                int[] ints = removedIds.toIntArray();
                for (int i3 = 0; i3 < ints.length / 2; ++i3) {
                    int temp = ints[i3];
                    ints[i3] = ints[ints.length - i3 - 1];
                    ints[ints.length - i3 - 1] = temp;
                }
                this.nodesWereRemoved((TreeNode)node, ints, removedNodes.toArray());
            }
        }

        @Override
        public boolean isLeaf(Object node) {
            return this.getRoot() != node && super.isLeaf(node);
        }

        @Nullable
        public U getUserObject(@Nullable N node) {
            return (U)(node == null ? null : ((DefaultMutableTreeNode)node).getUserObject());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7, 9, 11, 15, 16 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "speedSearch";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeFactory";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "structure";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "supply";
                    break;
                }
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/FilteringTree$SearchTreeModel";
                    break;
                }
                case 8: 
                case 10: 
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cache";
                    break;
                }
                case 17: 
                case 18: 
                case 20: 
                case 22: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 19: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/FilteringTree$SearchTreeModel";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodesToRemove";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootObject";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNode";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNode";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStructure";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setSpeedSearch";
                    break;
                }
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 15: 
                case 16: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getNode";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "createNode";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "computeAcceptCache";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildSafe";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "getChild";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "filterChildren";
                    break;
                }
                case 20: 
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "filterDirectChildren";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "mergeAcceptedNodes";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "removeNotAccepted";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7, 9, 11, 15, 16 -> new IllegalStateException(string);
            };
        }
    }

    protected static interface FilteringTreeUserObjectMatcher<U> {
        @NotNull
        public Matching checkMatching(@NotNull U var1, @Nullable Iterable<TextRange> var2);
    }

    public static enum Matching {
        NONE,
        PARTIAL,
        FULL;

    }
}

