/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public final class TreeExpandCollapse {
    public static void collapse(JTree tree2) {
        TreePath selectionPath = tree2.getSelectionPath();
        tree2.collapsePath(selectionPath);
    }

    public static void expand(JTree tree2) {
        TreePath selectionPath = tree2.getSelectionPath();
        tree2.expandPath(selectionPath);
    }

    public static void expandAll(JTree tree2) {
        TreePath[] paths = tree2.getSelectionPaths();
        if (paths == null) {
            paths = new TreePath[]{new TreePath(tree2.getModel().getRoot())};
        }
        for (TreePath path : paths) {
            new ExpandContext(300, 10).expand(tree2, path);
        }
    }

    private static final class ExpandContext {
        private final int myLevelsLeft;
        private int myExpansionLimit;

        ExpandContext(int expansionLimit, int levelsLeft) {
            this.myExpansionLimit = expansionLimit;
            this.myLevelsLeft = levelsLeft;
        }

        public int expand(JTree tree2, TreePath path) {
            if (this.myLevelsLeft == 0) {
                return this.myExpansionLimit;
            }
            TreeModel model2 = tree2.getModel();
            Object node = path.getLastPathComponent();
            int levelDecrement = 0;
            if (!tree2.isExpanded(path) && !model2.isLeaf(node)) {
                tree2.expandPath(path);
                levelDecrement = 1;
                --this.myExpansionLimit;
            }
            for (int i2 = 0; i2 < model2.getChildCount(node); ++i2) {
                Object child = model2.getChild(node, i2);
                if (model2.isLeaf(child)) continue;
                ExpandContext childContext = new ExpandContext(this.myExpansionLimit, this.myLevelsLeft - levelDecrement);
                this.myExpansionLimit = childContext.expand(tree2, path.pathByAddingChild(child));
                if (this.myExpansionLimit > 0) continue;
                return 0;
            }
            return this.myExpansionLimit;
        }
    }
}

