/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.ui.WindowResizeListener;
import com.intellij.ui.WindowResizeListenerExKt;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\n\u0010\u000eJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0016\u001a\u00020\u0015H\u0014J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0011J\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ui/WindowResizeListenerEx;", "Lcom/intellij/ui/WindowResizeListener;", "glassPane", "Lcom/intellij/openapi/wm/IdeGlassPane;", "content", "Ljava/awt/Component;", "border", "Ljava/awt/Insets;", "corner", "Ljavax/swing/Icon;", "<init>", "(Lcom/intellij/openapi/wm/IdeGlassPane;Ljava/awt/Component;Ljava/awt/Insets;Ljavax/swing/Icon;)V", "movable", "", "(Lcom/intellij/openapi/wm/IdeGlassPane;Ljava/awt/Component;Z)V", "resizeListeners", "", "Ljava/lang/Runnable;", "cursor", "Ljava/awt/Cursor;", "setCursor", "", "notifyResized", "install", "parent", "Lcom/intellij/openapi/Disposable;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "addResizeListeners", "listener", "removeResizeListeners", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nWindowResizeListenerEx.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowResizeListenerEx.kt\ncom/intellij/ui/WindowResizeListenerEx\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1915#2,2:87\n*S KotlinDebug\n*F\n+ 1 WindowResizeListenerEx.kt\ncom/intellij/ui/WindowResizeListenerEx\n*L\n44#1:87,2\n*E\n"})
public final class WindowResizeListenerEx
extends WindowResizeListener {
    @NotNull
    private final IdeGlassPane glassPane;
    @NotNull
    private final List<Runnable> resizeListeners;
    @Nullable
    private Cursor cursor;

    public WindowResizeListenerEx(@NotNull IdeGlassPane glassPane, @NotNull Component content2, @NotNull Insets border, @Nullable Icon corner) {
        Intrinsics.checkNotNullParameter((Object)glassPane, (String)"glassPane");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)border, (String)"border");
        super(content2, border, corner);
        this.glassPane = glassPane;
        this.resizeListeners = new ArrayList();
    }

    public WindowResizeListenerEx(@NotNull IdeGlassPane glassPane, @NotNull Component content2, boolean movable) {
        Intrinsics.checkNotNullParameter((Object)glassPane, (String)"glassPane");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        this(glassPane, content2, WindowResizeListenerExKt.access$defaultBorder(movable), null);
    }

    @Override
    protected void setCursor(@NotNull Component content2, @NotNull Cursor cursor) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
        if (this.cursor != cursor || this.cursor != Cursor.getDefaultCursor()) {
            this.glassPane.setCursor(cursor, (Object)this);
            this.cursor = cursor;
            if (content2 instanceof JComponent) {
                JComponent jComponent = (JComponent)content2;
                Cursor cursor2 = content2.getCursor();
                Intrinsics.checkNotNullExpressionValue((Object)cursor2, (String)"getCursor(...)");
                IdeGlassPaneImpl.Companion.savePreProcessedCursor(jComponent, cursor2);
            }
        }
        super.setCursor(content2, cursor);
    }

    @Override
    protected void notifyResized() {
        Iterable $this$forEach$iv = this.resizeListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Runnable p0 = (Runnable)element$iv;
            boolean bl = false;
            p0.run();
        }
    }

    @NotNull
    public final WindowResizeListenerEx install(@NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.glassPane.addMousePreprocessor((MouseListener)this, parent);
        this.glassPane.addMouseMotionPreprocessor((MouseMotionListener)this, parent);
        return this;
    }

    @NotNull
    public final WindowResizeListenerEx install(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.glassPane.addMouseListener((MouseListener)this, coroutineScope);
        return this;
    }

    public final void addResizeListeners(@NotNull Runnable listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.resizeListeners.add(listener2);
    }

    public final void removeResizeListeners(@NotNull Runnable listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.resizeListeners.remove(listener2);
    }
}

