/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.drag;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.ui.drag.DragImageView;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010!\u001a\u00020\"*\u00020#H\u0002J\f\u0010$\u001a\u00020\"*\u00020#H\u0002J\b\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020+H\u0016J\b\u0010-\u001a\u00020+H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR(\u0010%\u001a\u0004\u0018\u00010#2\b\u0010\u0010\u001a\u0004\u0018\u00010#@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006/"}, d2={"Lcom/intellij/ui/drag/GlassPaneDragImageView;", "Lcom/intellij/ui/drag/DragImageView;", "glassPane", "Lcom/intellij/openapi/wm/IdeGlassPane;", "<init>", "(Lcom/intellij/openapi/wm/IdeGlassPane;)V", "glassPaneComponent", "Ljava/awt/Component;", "disposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "painter", "Lcom/intellij/ui/drag/GlassPaneDragImageView$DragImagePainter;", "background", "Ljava/awt/Color;", "kotlin.jvm.PlatformType", "value", "Ljava/awt/Point;", "location", "getLocation", "()Ljava/awt/Point;", "setLocation", "(Ljava/awt/Point;)V", "bounds", "Ljava/awt/Rectangle;", "getBounds", "()Ljava/awt/Rectangle;", "size", "Ljava/awt/Dimension;", "getSize", "()Ljava/awt/Dimension;", "preferredSize", "getPreferredSize", "getWidth", "", "Ljava/awt/Image;", "getHeight", "image", "getImage", "()Ljava/awt/Image;", "setImage", "(Ljava/awt/Image;)V", "repaint", "", "show", "hide", "DragImagePainter", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nGlassPaneDragImageView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlassPaneDragImageView.kt\ncom/intellij/ui/drag/GlassPaneDragImageView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
public final class GlassPaneDragImageView
implements DragImageView {
    @NotNull
    private final IdeGlassPane glassPane;
    @Nullable
    private final Component glassPaneComponent;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final DragImagePainter painter;
    private final Color background;
    @NotNull
    private Point location;
    @Nullable
    private Image image;

    public GlassPaneDragImageView(@NotNull IdeGlassPane glassPane) {
        Intrinsics.checkNotNullParameter((Object)glassPane, (String)"glassPane");
        IdeGlassPane ideGlassPane = this.glassPane = glassPane;
        this.glassPaneComponent = ideGlassPane instanceof Component ? (Component)ideGlassPane : null;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        this.painter = new DragImagePainter();
        this.background = new JLabel().getBackground();
        this.location = new Point(0, 0);
    }

    @Override
    @NotNull
    public Point getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(@NotNull Point value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.location = value;
        this.repaint();
    }

    @Override
    @NotNull
    public Rectangle getBounds() {
        return new Rectangle(this.getLocation(), this.getSize());
    }

    @Override
    @NotNull
    public Dimension getSize() {
        return this.getPreferredSize();
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension;
        Image image2 = this.getImage();
        if (image2 != null) {
            Image it = image2;
            boolean bl = false;
            dimension = new Dimension(this.getWidth(it), this.getHeight(it));
        } else {
            dimension = new Dimension(0, 0);
        }
        return dimension;
    }

    private final int getWidth(Image $this$getWidth) {
        return $this$getWidth instanceof JBHiDPIScaledImage ? ((JBHiDPIScaledImage)$this$getWidth).getUserWidth() : $this$getWidth.getWidth(this.glassPaneComponent);
    }

    private final int getHeight(Image $this$getHeight) {
        return $this$getHeight instanceof JBHiDPIScaledImage ? ((JBHiDPIScaledImage)$this$getHeight).getUserHeight() : $this$getHeight.getHeight(this.glassPaneComponent);
    }

    @Override
    @Nullable
    public Image getImage() {
        return this.image;
    }

    @Override
    public void setImage(@Nullable Image value) {
        this.image = value;
        this.repaint();
    }

    private final void repaint() {
        block0: {
            Component component2 = this.glassPaneComponent;
            if (component2 == null) break block0;
            component2.repaint();
        }
    }

    @Override
    public void show() {
        this.glassPane.addPainter(null, (Painter)this.painter, this.disposable);
    }

    @Override
    public void hide() {
        Disposer.dispose((Disposable)this.disposable);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/ui/drag/GlassPaneDragImageView$DragImagePainter;", "Lcom/intellij/openapi/ui/AbstractPainter;", "<init>", "(Lcom/intellij/ui/drag/GlassPaneDragImageView;)V", "needsRepaint", "", "executePaint", "", "component", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics2D;", "intellij.platform.ide.impl"})
    private final class DragImagePainter
    extends AbstractPainter {
        public boolean needsRepaint() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executePaint(@NotNull Component component2, @NotNull Graphics2D g) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Image image2 = GlassPaneDragImageView.this.getImage();
            if (image2 == null) {
                return;
            }
            Image image3 = image2;
            Graphics g2 = g.create();
            try {
                g2.setColor(GlassPaneDragImageView.this.background);
                Dimension size2 = GlassPaneDragImageView.this.getSize();
                Point location = new Point(GlassPaneDragImageView.this.getLocation());
                SwingUtilities.convertPointFromScreen(location, component2);
                g2.fillRect(location.x, location.y, size2.width, size2.height);
                Intrinsics.checkNotNull((Object)g2);
                StartupUiUtil.drawImage((Graphics)g2, (Image)image3, (int)location.x, (int)location.y, (ImageObserver)component2);
            }
            finally {
                g2.dispose();
            }
        }
    }
}

