/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefInputMethodAdapter;
import com.intellij.ui.jcef.JBCefOsrHandler;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scroll.TouchScrollUtil;
import com.intellij.util.Alarm;
import com.jetbrains.cef.JCefAppConfig;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.im.InputMethodRequests;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.cef.browser.CefBrowser;
import org.cef.input.CefTouchEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JBCefOsrComponent
extends JPanel {
    static final int RESIZE_DELAY_MS = Integer.getInteger("ide.browser.jcef.resize_delay_ms", 100);
    @NotNull
    private volatile JBCefOsrHandler myRenderHandler;
    @NotNull
    private volatile CefBrowser myBrowser;
    @NotNull
    private final JBCefInputMethodAdapter myInputMethodAdapter = new JBCefInputMethodAdapter(this);
    private double myScale = 1.0;
    @NotNull
    private final AtomicLong myScheduleResizeMs = new AtomicLong(-1L);
    @Nullable
    private Alarm myResizeAlarm;
    @NotNull
    private final Alarm myGraphicsConfigurationAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    AtomicBoolean myScaleInitialized = new AtomicBoolean(false);
    @NotNull
    private Disposable myDisposable;
    private final int WHEEL_ROTATION_FACTOR = RegistryManager.getInstance().intValue("ide.browser.jcef.osr.wheelRotation.factor");

    JBCefOsrComponent(boolean isMouseWheelEventEnabled) {
        this.setPreferredSize(JBCefBrowser.DEF_PREF_SIZE);
        this.setBackground(JBColor.background());
        this.enableEvents(0x18L | (isMouseWheelEventEnabled ? 131072L : 0L) | 0x20L | 0x800L);
        this.enableInputMethods(true);
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.setFocusTraversalKeysEnabled(false);
        this.addInputMethodListener(this.myInputMethodAdapter);
        this.addPropertyChangeListener("graphicsConfiguration", e -> {
            this.myGraphicsConfigurationAlarm.cancelAllRequests();
            if (this.myScaleInitialized.get()) {
                this.myGraphicsConfigurationAlarm.addRequest(this::onGraphicsConfigurationChanged, 1000);
            } else {
                this.onGraphicsConfigurationChanged();
                this.myScaleInitialized.set(true);
            }
        });
    }

    public void setBrowser(@NotNull CefBrowser browser) {
        if (browser == null) {
            JBCefOsrComponent.$$$reportNull$$$0(0);
        }
        this.myBrowser = browser;
        this.myInputMethodAdapter.setBrowser(browser);
    }

    public void setRenderHandler(@NotNull JBCefOsrHandler renderHandler) {
        if (renderHandler == null) {
            JBCefOsrComponent.$$$reportNull$$$0(1);
        }
        this.myRenderHandler = renderHandler;
        this.myRenderHandler.addCaretListener(this.myInputMethodAdapter);
        this.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                if (JBCefOsrComponent.this.isShowing()) {
                    JBCefOsrComponent.this.myRenderHandler.setLocationOnScreen(JBCefOsrComponent.this.getLocationOnScreen());
                }
            }
        });
        try {
            this.myRenderHandler.setLocationOnScreen(this.getLocationOnScreen());
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JBCefOsrComponent.this.myRenderHandler.setLocationOnScreen(JBCefOsrComponent.this.getLocationOnScreen());
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.myDisposable = Disposer.newDisposable();
        this.myResizeAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.myDisposable);
        ApplicationManager.getApplication().getMessageBus().connect(this.myDisposable).subscribe(UISettingsListener.TOPIC, uiSettings -> this.onGraphicsConfigurationChanged());
        if (!JBCefBrowserBase.isCefBrowserCreationStarted(this.myBrowser)) {
            this.myBrowser.createImmediately();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Disposer.dispose((Disposable)this.myDisposable);
        this.myGraphicsConfigurationAlarm.cancelAllRequests();
        this.myRenderHandler.stopResizePusher();
        this.myScaleInitialized.set(false);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.myRenderHandler.paint((Graphics2D)g);
    }

    @Override
    public void reshape(int x, int y, int w, int h) {
        super.reshape(x, y, w, h);
        long timeMs = System.currentTimeMillis();
        if (this.myResizeAlarm != null) {
            if (this.myResizeAlarm.isEmpty()) {
                this.myScheduleResizeMs.set(timeMs);
            }
            this.myResizeAlarm.cancelAllRequests();
            if (timeMs - this.myScheduleResizeMs.get() >= (long)RESIZE_DELAY_MS) {
                this.myBrowser.wasResized(0, 0);
                this.myRenderHandler.startResizePusher(this.myBrowser, true);
            } else {
                this.myResizeAlarm.addRequest(() -> {
                    this.myBrowser.wasResized(0, 0);
                    this.myRenderHandler.startResizePusher(this.myBrowser, true);
                }, RESIZE_DELAY_MS);
            }
        }
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return this.myInputMethodAdapter;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.isConsumed()) {
            return;
        }
        this.myBrowser.sendMouseEvent(new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), PaintUtil.RoundingMode.ROUND.round((double)e.getX() / this.myScale), PaintUtil.RoundingMode.ROUND.round((double)e.getY() / this.myScale), PaintUtil.RoundingMode.ROUND.round((double)e.getXOnScreen() / this.myScale), PaintUtil.RoundingMode.ROUND.round((double)e.getYOnScreen() / this.myScale), e.getClickCount(), e.isPopupTrigger(), e.getButton()));
        if (e.getID() == 501) {
            this.requestFocusInWindow();
        }
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent e) {
        super.processMouseWheelEvent(e);
        if (e.isConsumed()) {
            return;
        }
        if (TouchScrollUtil.isTouchScroll((MouseWheelEvent)e)) {
            this.myBrowser.sendTouchEvent(new CefTouchEvent(0, (float)e.getX(), (float)e.getY(), 0.0f, 0.0f, 0.0f, 0.0f, JBCefOsrComponent.getTouchEventType(e), e.getModifiersEx(), CefTouchEvent.PointerType.UNKNOWN));
        } else {
            double val = e.getPreciseWheelRotation() * (double)this.WHEEL_ROTATION_FACTOR;
            if (SystemInfoRt.isLinux || SystemInfoRt.isMac) {
                val *= -1.0;
            }
            this.myBrowser.sendMouseWheelEvent(new MouseWheelEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), PaintUtil.RoundingMode.ROUND.round((double)e.getX() / this.myScale), PaintUtil.RoundingMode.ROUND.round((double)e.getY() / this.myScale), PaintUtil.RoundingMode.ROUND.round((double)e.getXOnScreen() / this.myScale), PaintUtil.RoundingMode.ROUND.round((double)e.getYOnScreen() / this.myScale), e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), e.getScrollAmount(), (int)val, val));
        }
    }

    static CefTouchEvent.EventType getTouchEventType(MouseWheelEvent e) {
        if (!TouchScrollUtil.isTouchScroll((MouseWheelEvent)e)) {
            return null;
        }
        if (TouchScrollUtil.isBegin((MouseWheelEvent)e)) {
            return CefTouchEvent.EventType.PRESSED;
        }
        if (TouchScrollUtil.isUpdate((MouseWheelEvent)e)) {
            return CefTouchEvent.EventType.MOVED;
        }
        if (TouchScrollUtil.isEnd((MouseWheelEvent)e)) {
            return CefTouchEvent.EventType.RELEASED;
        }
        return CefTouchEvent.EventType.CANCELLED;
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        this.myBrowser.sendMouseEvent(new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), PaintUtil.RoundingMode.ROUND.round((double)e.getX() / this.myScale), PaintUtil.RoundingMode.ROUND.round((double)e.getY() / this.myScale), PaintUtil.RoundingMode.ROUND.round((double)e.getXOnScreen() / this.myScale), PaintUtil.RoundingMode.ROUND.round((double)e.getYOnScreen() / this.myScale), e.getClickCount(), e.isPopupTrigger(), e.getButton()));
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        this.myBrowser.sendKeyEvent(e);
    }

    private void onGraphicsConfigurationChanged() {
        double oldScale = this.myScale;
        double oldDensity = this.myRenderHandler.getPixelDensity();
        double pixelDensity = JreHiDpiUtil.isJreHiDPIEnabled() ? JCefAppConfig.getDeviceScaleFactor((Component)this) : 1.0;
        this.myScale = (JreHiDpiUtil.isJreHiDPIEnabled() ? 1.0 : JCefAppConfig.getDeviceScaleFactor((Component)this)) * (double)UISettings.getInstance().getCurrentIdeScale();
        this.myRenderHandler.setScreenInfo(pixelDensity, this.myScale);
        if (oldScale != this.myScale || oldDensity != pixelDensity) {
            this.myBrowser.notifyScreenInfoChanged();
        }
    }

    Color getColorAt(int x, int y) {
        return this.myRenderHandler.getColorAt(x, y);
    }

    double getPixelDensity() {
        return this.myRenderHandler.getPixelDensity();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderHandler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/jcef/JBCefOsrComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setBrowser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setRenderHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

