/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeDependentAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.platform.jbr.JdkEx;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.mac.MacWinTabsHandler;
import com.intellij.ui.mac.MacWinTabsHandlerV2;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.foundation.MacUtil;
import java.awt.Component;
import java.awt.Window;
import java.util.Objects;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class MergeAllWindowsAction
extends IdeDependentAction {
    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            MergeAllWindowsAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MergeAllWindowsAction.$$$reportNull$$$0(1);
        }
        Presentation presentation2 = e.getPresentation();
        if (JdkEx.isTabbingModeAvailable()) {
            presentation2.setVisible(true);
            IdeFrame[] frames = WindowManager.getInstance().getAllProjectFrames();
            if (frames.length > 1) {
                ID id2 = MacUtil.getWindowFromJavaWindow((Window)((ProjectFrameHelper)frames[0]).getFrame());
                int tabs = Foundation.invoke((ID)Foundation.invoke((ID)id2, (String)"tabbedWindows", (Object[])new Object[0]), (String)"count", (Object[])new Object[0]).intValue();
                presentation2.setEnabled(frames.length != tabs);
            } else {
                presentation2.setEnabled(false);
            }
        } else {
            presentation2.setEnabledAndVisible(false);
        }
        super.update(e);
    }

    public static boolean isTabbedWindow(@NotNull JFrame frame) {
        if (frame == null) {
            MergeAllWindowsAction.$$$reportNull$$$0(2);
        }
        if (JdkEx.isTabbingModeAvailable() && WindowManager.getInstance().getAllProjectFrames().length > 1) {
            ID id2 = MacUtil.getWindowFromJavaWindow((Window)frame);
            int tabs = Foundation.invoke((ID)Foundation.invoke((ID)id2, (String)"tabbedWindows", (Object[])new Object[0]), (String)"count", (Object[])new Object[0]).intValue();
            return tabs > 1;
        }
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            MergeAllWindowsAction.$$$reportNull$$$0(3);
        }
        @Nullable Component component2 = (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        Window window = Objects.requireNonNull(ComponentUtil.getWindow((Component)component2));
        MergeAllWindowsAction.mergeAllWindows(window, true);
    }

    private static void mergeAllWindows(@NotNull Window window, boolean updateTabBars) {
        if (window == null) {
            MergeAllWindowsAction.$$$reportNull$$$0(4);
        }
        for (IdeFrame helper : WindowManager.getInstance().getAllProjectFrames()) {
            IdeFrameImpl frame = ((ProjectFrameHelper)helper).getFrame();
            if (frame == window || !helper.isInFullScreen()) continue;
            frame.getRootPane().putClientProperty("Idea.Ignore.Exit.FullScreen", true);
        }
        Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> {
            ID id2 = MacUtil.getWindowFromJavaWindow((Window)window);
            Foundation.invoke((ID)id2, (String)"mergeAllWindows:", (Object[])new Object[]{ID.NIL});
            if (MacWinTabsHandler.isVersion2()) {
                ApplicationManager.getApplication().invokeLater(() -> MacWinTabsHandlerV2.updateTabBarsAfterMerge());
            } else if (updateTabBars) {
                ApplicationManager.getApplication().invokeLater(() -> MacWinTabsHandler.updateTabBars(null));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/MergeAllWindowsAction";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/MergeAllWindowsAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isTabbedWindow";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "mergeAllWindows";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    private static final class RecentProjectsFullScreenTabSupport
    implements AppLifecycleListener {
        private RecentProjectsFullScreenTabSupport() {
        }

        public void appStarted() {
            Logger logger2 = Logger.getInstance(MergeAllWindowsAction.class);
            if (JdkEx.isTabbingModeAvailable()) {
                IdeFrame[] frames = WindowManager.getInstance().getAllProjectFrames();
                if (frames.length > 1) {
                    for (IdeFrame frame : frames) {
                        if (frame.isInFullScreen()) continue;
                        IdeFrameImpl ideFrame = ((ProjectFrameHelper)frame).getFrame();
                        logger2.info("=== FullScreenTabSupport: no fullscreen frame: " + String.valueOf(ideFrame) + " ===");
                        JRootPane pane2 = ideFrame.getRootPane();
                        if (pane2 == null) {
                            logger2.info("=== FullScreenTabSupport: no root pane for frame: " + String.valueOf(ideFrame) + " ===");
                            return;
                        }
                        if (pane2.getClientProperty("Idea.Is.In.FullScreen.Mode.Now") == null && pane2.getClientProperty("Idea.Is.In.FullScreen.Mode.Progress") == null) {
                            return;
                        }
                        logger2.info("=== FullScreenTabSupport: fullscreen in progress for frame: " + String.valueOf(ideFrame) + " ===");
                    }
                    int state2 = Foundation.invoke((String)"NSWindow", (String)"userTabbingPreference", (Object[])new Object[0]).intValue();
                    if (state2 == 2) {
                        logger2.info("=== FullScreenTabSupport: run auto mergeAllWindows on start ===");
                        MergeAllWindowsAction.mergeAllWindows(Objects.requireNonNull(((ProjectFrameHelper)frames[0]).getFrame()), false);
                    } else {
                        logger2.info("=== FullScreenTabSupport: settings: " + state2 + " ===");
                    }
                } else {
                    logger2.info("=== FullScreenTabSupport: frames: " + frames.length + " ===");
                }
            } else if (SystemInfoRt.isMac) {
                logger2.info("=== FullScreenTabSupport: off ===");
            }
        }
    }
}

