/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.FileInputHandle;
import com.intellij.util.io.MultiCloseable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/util/io/UnixFifoInputHandle;", "Lcom/intellij/util/io/FileInputHandle;", "path", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "cleanup", "Lcom/intellij/util/io/MultiCloseable;", "inputStream", "Ljava/io/InputStream;", "getInputStream", "()Ljava/io/InputStream;", "close", "", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nInputHandle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InputHandle.kt\ncom/intellij/util/io/UnixFifoInputHandle\n+ 2 closeable.kt\ncom/intellij/util/io/CloseableUtil\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n7#2,2:94\n10#2,4:97\n15#2:102\n1#3:96\n1#3:101\n*S KotlinDebug\n*F\n+ 1 InputHandle.kt\ncom/intellij/util/io/UnixFifoInputHandle\n*L\n48#1:94,2\n48#1:97,4\n48#1:102\n48#1:101\n*E\n"})
public final class UnixFifoInputHandle
extends FileInputHandle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MultiCloseable cleanup;
    @NotNull
    private final InputStream inputStream;
    private static final long MKFIFO_PROCESS_TIMEOUT_MS = 3000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public UnixFifoInputHandle(@NotNull Path path) {
        void $this$cleanup_u24lambda_u240;
        MultiCloseable multiCloseable;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        super(path);
        MultiCloseable multiCloseable2 = multiCloseable = new MultiCloseable();
        UnixFifoInputHandle unixFifoInputHandle = this;
        boolean bl = false;
        $this$cleanup_u24lambda_u240.registerCloseable(() -> UnixFifoInputHandle.cleanup$lambda$0$0(this));
        unixFifoInputHandle.cleanup = multiCloseable;
        AutoCloseable $this$runClosingOnFailure$iv = (AutoCloseable)this.cleanup;
        boolean $i$f$runClosingOnFailure = false;
        try {
            Object object;
            MultiCloseable $this$_init__u24lambda_u240 = (MultiCloseable)$this$runClosingOnFailure$iv;
            boolean bl2 = false;
            UnixFifoInputHandle.Companion.mkfifo(path);
            OpenOption[] it = object = Unit.INSTANCE;
            boolean bl3 = false;
            this.cleanup.registerCloseable(() -> UnixFifoInputHandle.lambda$0$0$0(path));
            object = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
            object = Files.newByteChannel(path, object);
            MultiCloseable multiCloseable3 = this.cleanup;
            AutoCloseable p0 = (AutoCloseable)object;
            boolean bl4 = false;
            multiCloseable3.registerCloseable(p0);
            Object object2 = object;
        }
        catch (Throwable e$iv) {
            if (!($this$runClosingOnFailure$iv instanceof MultiCloseable)) {
                AutoCloseable autoCloseable = $this$runClosingOnFailure$iv;
                Throwable throwable = null;
                try {
                    try {
                        AutoCloseable it$iv = autoCloseable;
                        boolean bl5 = false;
                        throw e$iv;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    throw throwable3;
                }
            }
            ((MultiCloseable)$this$runClosingOnFailure$iv).close(e$iv);
            throw new IllegalStateException("unreachable".toString());
        }
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ};
        InputStream inputStream = Files.newInputStream(path, openOptionArray);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        this.inputStream = inputStream;
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public void close() {
        this.cleanup.close();
    }

    private static final void cleanup$lambda$0$0(UnixFifoInputHandle this$0) {
        super.close();
    }

    private static final void lambda$0$0$0(Path $path) {
        Files.delete($path);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/util/io/UnixFifoInputHandle$Companion;", "", "<init>", "()V", "MKFIFO_PROCESS_TIMEOUT_MS", "", "mkfifo", "", "path", "Ljava/nio/file/Path;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void mkfifo(Path path) {
            String[] stringArray = new String[]{"mkfifo", "-m", "0666", ((Object)path).toString()};
            Process process2 = new ProcessBuilder(stringArray).start();
            try {
                boolean bl;
                try {
                    Thread.interrupted();
                    bl = process2.waitFor(3000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new IOException("mkfifo interrupted", e);
                }
                boolean completed = bl;
                if (!completed) {
                    throw new IOException("mkfifo timed out (3000 ms)");
                }
                if (process2.exitValue() != 0) {
                    byte[] byArray = process2.getErrorStream().readAllBytes();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                    byte[] byArray2 = byArray;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    Charset charset2 = charset;
                    String stderr = new String(byArray2, charset2);
                    throw new IOException("mkfifo failed with exit code " + process2.exitValue() + ": " + stderr);
                }
            }
            catch (Throwable e) {
                process2.destroyForcibly().onExit().whenComplete((arg_0, arg_1) -> Companion.mkfifo$lambda$1((arg_0, arg_1) -> Companion.mkfifo$lambda$0(path, arg_0, arg_1), arg_0, arg_1));
                throw e;
            }
        }

        private static final Unit mkfifo$lambda$0(Path $path, Process process2, Throwable throwable) {
            Files.deleteIfExists($path);
            return Unit.INSTANCE;
        }

        private static final void mkfifo$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            $tmp0.invoke(p0, p1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

