/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.table;

import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ListWithSelection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ComboBoxTableCellEditor
extends DefaultCellEditor {
    public static final ComboBoxTableCellEditor INSTANCE = new ComboBoxTableCellEditor();
    private final JComboBox comboBox = (JComboBox)this.getComponent();

    public ComboBoxTableCellEditor() {
        super(new JComboBox(new CollectionComboBoxModel(new ArrayList())));
        this.comboBox.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ComboBoxTableCellEditor.this.cancelCellEditing();
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                ComboBoxTableCellEditor.this.cancelCellEditing();
            }
        });
        this.comboBox.setRenderer(SimpleListCellRenderer.create((label2, value, index) -> {
            label2.setIcon(value instanceof Iconable ? ((Iconable)value).getIcon(1) : null);
            @NlsSafe String text2 = value == null ? "" : value.toString();
            label2.setText(text2);
        }));
    }

    @Override
    public Component getTableCellEditorComponent(JTable table2, Object value, boolean isSelected, int row2, int column) {
        if (value instanceof ListWithSelection) {
            ListWithSelection options2 = (ListWithSelection)value;
            this.comboBox.setModel(new CollectionComboBoxModel((List)options2));
            if (options2.getSelection() == null) {
                options2.selectFirst();
            }
            this.comboBox.setSelectedItem(options2.getSelection());
        } else {
            Enum enumValue = (Enum)value;
            Class enumClass = enumValue.getDeclaringClass();
            ComboBoxModel model2 = this.comboBox.getModel();
            if (!(model2 instanceof EnumComboBoxModel) || model2.getSize() <= 0 || ((Enum)model2.getElementAt(0)).getDeclaringClass() != enumClass) {
                this.comboBox.setModel(new EnumComboBoxModel(enumClass));
            }
            this.comboBox.setSelectedItem(value);
        }
        return this.comboBox;
    }
}

