/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.jps.serialization;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.workspace.jps.serialization.impl.ErrorReporter;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.ide.impl.jps.serialization.ModuleLoadingErrorDescriptionBridge;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\f\u001a\u00020\r2\u000b\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/workspaceModel/ide/impl/jps/serialization/IdeErrorReporter;", "Lcom/intellij/platform/workspace/jps/serialization/impl/ErrorReporter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "errors", "Ljava/util/ArrayList;", "Lcom/intellij/openapi/module/ConfigurationErrorDescription;", "Lkotlin/collections/ArrayList;", "getErrors", "()Ljava/util/ArrayList;", "reportError", "", "message", "", "Lorg/jetbrains/annotations/Nls;", "file", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nIdeErrorReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeErrorReporter.kt\ncom/intellij/workspaceModel/ide/impl/jps/serialization/IdeErrorReporter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,64:1\n13#2:65\n*S KotlinDebug\n*F\n+ 1 IdeErrorReporter.kt\ncom/intellij/workspaceModel/ide/impl/jps/serialization/IdeErrorReporter\n*L\n32#1:65\n*E\n"})
public final class IdeErrorReporter
implements ErrorReporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ArrayList<ConfigurationErrorDescription> errors;
    @NotNull
    private static final Logger LOG;

    public IdeErrorReporter(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.errors = new ArrayList();
    }

    @NotNull
    public final ArrayList<ConfigurationErrorDescription> getErrors() {
        return this.errors;
    }

    public void reportError(@NotNull String message, @NotNull VirtualFileUrl file2) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (FileUtil.extensionEquals((String)file2.getFileName(), (String)"iml")) {
            this.errors.add(new ModuleLoadingErrorDescriptionBridge(message, file2, this.project));
        } else {
            LOG.error("Failed to load " + file2.getPresentableUrl() + ": " + message);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(IdeErrorReporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/workspaceModel/ide/impl/jps/serialization/IdeErrorReporter$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

