/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.datasource;

import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.datasource.DataSource;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0003H\u0016J \u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\bH\u0016J\u0018\u0010\u0011\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\bH\u0016J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/zip/signer/datasource/ByteBufferDataSource;", "Lorg/jetbrains/zip/signer/datasource/DataSource;", "buffer", "Ljava/nio/ByteBuffer;", "<init>", "(Ljava/nio/ByteBuffer;)V", "size", "", "", "getByteBuffer", "offset", "copyTo", "", "dest", "feed", "writableByteChannel", "Ljava/nio/channels/WritableByteChannel;", "slice", "checkChunkValid", "lib"})
public final class ByteBufferDataSource
implements DataSource {
    @NotNull
    private final ByteBuffer buffer;
    private final int size;

    public ByteBufferDataSource(@NotNull ByteBuffer buffer2) {
        Intrinsics.checkNotNullParameter((Object)buffer2, (String)"buffer");
        this.buffer = buffer2;
        this.size = this.buffer.remaining();
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    @NotNull
    public ByteBuffer getByteBuffer(long offset, int size2) {
        this.checkChunkValid(offset, size2);
        int chunkPosition = (int)offset;
        int chunkLimit = chunkPosition + size2;
        this.buffer.position(0);
        this.buffer.limit(chunkLimit);
        this.buffer.position(chunkPosition);
        ByteBuffer byteBuffer = this.buffer.slice();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"slice(...)");
        return byteBuffer;
    }

    @Override
    public void copyTo(long offset, int size2, @NotNull ByteBuffer dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.put(this.getByteBuffer(offset, size2));
    }

    @Override
    public void feed(@NotNull WritableByteChannel writableByteChannel, long offset, long size2) {
        Intrinsics.checkNotNullParameter((Object)writableByteChannel, (String)"writableByteChannel");
        if (size2 < 0L || size2 > (long)this.size) {
            throw new IndexOutOfBoundsException("size: " + size2 + ", source size: " + size2);
        }
        writableByteChannel.write(this.getByteBuffer(offset, (int)size2));
    }

    @Override
    @NotNull
    public ByteBufferDataSource slice(long offset, long size2) {
        if (offset == 0L && (int)size2 == this.size) {
            return this;
        }
        if (size2 < 0L || size2 > (long)this.size) {
            throw new IndexOutOfBoundsException("size: " + size2 + ", source size: " + size2);
        }
        return new ByteBufferDataSource(this.getByteBuffer(offset, (int)size2));
    }

    private final void checkChunkValid(long offset, long size2) {
        long endOffset = offset + size2;
        if (offset < 0L) {
            throw new IndexOutOfBoundsException("offset: " + offset);
        }
        if (size2 < 0L) {
            throw new IndexOutOfBoundsException("size: " + size2);
        }
        if (offset > (long)this.size) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") > source size (" + size2 + ')');
        }
        if (endOffset < offset) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") + size (" + size2 + ") overflow");
        }
        if (endOffset > (long)this.size) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") + size (" + size2 + ") > source size (" + size2 + ')');
        }
    }
}

