/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.digest;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.metadata.ContentDigestAlgorithm;
import org.jetbrains.zip.signer.utils.ByteArrayExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/zip/signer/digest/ChunkDigester;", "", "digestAlgorithm", "Lorg/jetbrains/zip/signer/metadata/ContentDigestAlgorithm;", "chunkCount", "", "<init>", "(Lorg/jetbrains/zip/signer/metadata/ContentDigestAlgorithm;I)V", "getDigestAlgorithm", "()Lorg/jetbrains/zip/signer/metadata/ContentDigestAlgorithm;", "chunkPrefix", "", "messageDigest", "Ljava/security/MessageDigest;", "kotlin.jvm.PlatformType", "digest", "", "position", "consume", "", "chunk", "Ljava/nio/ByteBuffer;", "getResult", "lib"})
@ExperimentalUnsignedTypes
public final class ChunkDigester {
    @NotNull
    private final ContentDigestAlgorithm digestAlgorithm;
    private final int chunkCount;
    private final byte chunkPrefix;
    private final MessageDigest messageDigest;
    @NotNull
    private final byte[] digest;
    private int position;

    /*
     * WARNING - void declaration
     */
    public ChunkDigester(@NotNull ContentDigestAlgorithm digestAlgorithm, int chunkCount) {
        void $this$digest_u24lambda_u240;
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)((Object)digestAlgorithm), (String)"digestAlgorithm");
        this.digestAlgorithm = digestAlgorithm;
        this.chunkCount = chunkCount;
        this.chunkPrefix = (byte)90;
        this.messageDigest = MessageDigest.getInstance(this.digestAlgorithm.getJcaMessageDigestAlgorithm());
        byte[] byArray2 = byArray = new byte[5 + this.chunkCount * this.digestAlgorithm.getChunkDigestOutputSizeBytes()];
        ChunkDigester chunkDigester = this;
        boolean bl = false;
        $this$digest_u24lambda_u240[0] = this.chunkPrefix;
        ByteArrayExtensionsKt.setUnsignedInt32LittleEndian-OsBMiQA((byte[])$this$digest_u24lambda_u240, UInt.constructor-impl((int)this.chunkCount), 1);
        chunkDigester.digest = byArray;
    }

    @NotNull
    public final ContentDigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public final void consume(@NotNull ByteBuffer chunk) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        if (this.position >= this.chunkCount) {
            throw new IllegalStateException("Too many chunks provided".toString());
        }
        byte[] $this$consume_u24lambda_u241 = byArray = new byte[5];
        boolean bl = false;
        $this$consume_u24lambda_u241[0] = this.chunkPrefix;
        ByteArrayExtensionsKt.setUnsignedInt32LittleEndian-OsBMiQA($this$consume_u24lambda_u241, UInt.constructor-impl((int)chunk.remaining()), 1);
        byte[] chunkPrefix = byArray;
        this.messageDigest.update(chunkPrefix);
        this.messageDigest.update(chunk);
        int bytesWritten2 = this.messageDigest.digest(this.digest, 5 + this.position * this.digestAlgorithm.getChunkDigestOutputSizeBytes(), this.digestAlgorithm.getChunkDigestOutputSizeBytes());
        if (!(bytesWritten2 == this.digestAlgorithm.getChunkDigestOutputSizeBytes())) {
            boolean bl2 = false;
            String string = "Digest algorithm output has an unexpected size";
            throw new IllegalArgumentException(string.toString());
        }
        ++this.position;
    }

    @NotNull
    public final byte[] getResult() {
        if (!(this.position == this.chunkCount)) {
            boolean bl = false;
            String string = "Not all chunks were processed";
            throw new IllegalArgumentException(string.toString());
        }
        return this.digest;
    }
}

