/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.CheckFor;
import com.intellij.openapi.projectRoots.JavaNameKt;
import com.intellij.openapi.projectRoots.JdkCommandLineSetup;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.jar.Attributes;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JdkUtil {
    public static final Key<Map<String, String>> COMMAND_LINE_CONTENT = Key.create((String)"command.line.content");
    public static final Key<String> AGENT_RUNTIME_CLASSPATH = Key.create((String)"command.line.agent.classpath");
    public static final String PROPERTY_DO_NOT_ESCAPE_CLASSPATH_URL = "idea.do.not.escape.classpath.url";

    private JdkUtil() {
    }

    @Deprecated
    @Nullable
    public static String getJdkMainAttribute(@NotNull Sdk jdk, @NotNull Attributes.Name attribute) {
        File signatureJar;
        String homePath;
        if (jdk == null) {
            JdkUtil.$$$reportNull$$$0(0);
        }
        if (attribute == null) {
            JdkUtil.$$$reportNull$$$0(1);
        }
        if ((homePath = jdk.getHomePath()) != null && (signatureJar = FileUtil.findFirstThatExist((String[])new String[]{homePath + "/jre/lib/rt.jar", homePath + "/lib/rt.jar", homePath + "/lib/jrt-fs.jar", homePath + "/jre/lib/vm.jar", homePath + "/../Classes/classes.jar"})) != null) {
            return JarUtil.getJarAttribute((File)signatureJar, (Attributes.Name)attribute);
        }
        return null;
    }

    @Nullable
    public static String suggestJdkName(@Nullable String versionString) {
        JavaVersion version = JavaVersion.tryParse((String)versionString);
        return version == null ? null : JdkUtil.suggestJdkName(version, null);
    }

    @NotNull
    public static String suggestJdkName(@NotNull JavaVersion version, @Nullable String vendorPrefix) {
        if (version == null) {
            JdkUtil.$$$reportNull$$$0(2);
        }
        StringBuilder suggested = new StringBuilder();
        if (vendorPrefix != null) {
            suggested.append(vendorPrefix).append('-');
        }
        if (version.feature < 9) {
            suggested.append("1.");
        }
        suggested.append(version.feature);
        if (version.ea) {
            suggested.append("-ea");
        }
        String string = suggested.toString();
        if (string == null) {
            JdkUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Deprecated
    @RequiresBackgroundThread(generateAssertion=false)
    public static boolean checkForJdk(@NotNull String homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(4);
        }
        try {
            return JdkUtil.checkForJdk(Path.of(homePath, new String[0]));
        }
        catch (InvalidPathException e) {
            return false;
        }
    }

    @RequiresBackgroundThread(generateAssertion=false)
    public static boolean checkForJdk(@NotNull Path homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(5);
        }
        return JdkUtil.checkForJdkOrJre(homePath, CheckFor.JDK) && (JdkUtil.isModularRuntime(homePath) || Files.exists(homePath.resolve("jre/lib/rt.jar"), new LinkOption[0]) || Files.isDirectory(homePath.resolve("classes"), new LinkOption[0]) || Files.exists(homePath.resolve("jre/lib/vm.jar"), new LinkOption[0]) || Files.exists(homePath.resolve("../Classes/classes.jar"), new LinkOption[0]));
    }

    public static boolean isCompatible(@NotNull Sdk sdk, @NotNull Project project) {
        String sdkHome;
        if (sdk == null) {
            JdkUtil.$$$reportNull$$$0(6);
        }
        if (project == null) {
            JdkUtil.$$$reportNull$$$0(7);
        }
        if ((sdkHome = sdk.getHomePath()) == null) {
            return false;
        }
        Path sdkHomePath = Path.of(sdkHome, new String[0]);
        return JdkUtil.isCompatible(sdkHomePath, project);
    }

    public static boolean isCompatible(@NotNull Path jdkHomePath, @NotNull Project project) {
        if (jdkHomePath == null) {
            JdkUtil.$$$reportNull$$$0(8);
        }
        if (project == null) {
            JdkUtil.$$$reportNull$$$0(9);
        }
        return EelProviderUtil.getEelMachine((Project)project).ownsPath(jdkHomePath);
    }

    @Deprecated
    @RequiresBackgroundThread(generateAssertion=false)
    public static boolean checkForJre(@NotNull String homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(10);
        }
        return JdkUtil.checkForJre(Path.of(homePath, new String[0]));
    }

    @RequiresBackgroundThread(generateAssertion=false)
    public static boolean checkForJre(@NotNull Path homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(11);
        }
        return JdkUtil.checkForJdkOrJre(homePath, CheckFor.JRE);
    }

    public static boolean isModularRuntime(@NotNull String homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(12);
        }
        return JdkUtil.isModularRuntime(Path.of(homePath, new String[0]));
    }

    public static boolean isModularRuntime(@NotNull Path homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(13);
        }
        return Files.isRegularFile(homePath.resolve("lib/jrt-fs.jar"), new LinkOption[0]) || JdkUtil.isExplodedModularRuntime(homePath);
    }

    public static boolean isExplodedModularRuntime(@NotNull Path homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(14);
        }
        return Files.isDirectory(homePath.resolve("modules/java.base"), new LinkOption[0]);
    }

    @ApiStatus.Internal
    @NotNull
    public static TargetedCommandLineBuilder setupJVMCommandLine(@NotNull SimpleJavaParameters javaParameters, @NotNull TargetEnvironmentRequest request) throws CantRunException {
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(15);
        }
        if (request == null) {
            JdkUtil.$$$reportNull$$$0(16);
        }
        JdkCommandLineSetup setup = new JdkCommandLineSetup(request);
        setup.setupJavaExePath(javaParameters);
        setup.setupCommandLine(javaParameters);
        TargetedCommandLineBuilder targetedCommandLineBuilder = setup.getCommandLine();
        if (targetedCommandLineBuilder == null) {
            JdkUtil.$$$reportNull$$$0(17);
        }
        return targetedCommandLineBuilder;
    }

    @NotNull
    public static GeneralCommandLine setupJVMCommandLine(@NotNull SimpleJavaParameters javaParameters) throws CantRunException {
        LocalTargetEnvironment environment;
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(18);
        }
        LocalTargetEnvironmentRequest request = new LocalTargetEnvironmentRequest();
        TargetedCommandLineBuilder builder = JdkUtil.setupJVMCommandLine(javaParameters, (TargetEnvironmentRequest)request);
        try {
            environment = request.prepareEnvironment(TargetProgressIndicator.EMPTY);
        }
        catch (ExecutionException e) {
            throw new CantRunException(e.getMessage(), (Throwable)e);
        }
        GeneralCommandLine generalCommandLine = environment.createGeneralCommandLine(builder.build());
        if (generalCommandLine == null) {
            JdkUtil.$$$reportNull$$$0(19);
        }
        return generalCommandLine;
    }

    public static boolean useDynamicClasspath(@Nullable Project project) {
        boolean hasDynamicProperty = Boolean.parseBoolean(System.getProperty("idea.dynamic.classpath", "false"));
        return project != null ? PropertiesComponent.getInstance((Project)project).getBoolean("dynamic.classpath", hasDynamicProperty) : hasDynamicProperty;
    }

    public static boolean useDynamicVMOptions() {
        return PropertiesComponent.getInstance().getBoolean("idea.dynamic.vmoptions", true);
    }

    public static boolean useDynamicParameters() {
        return PropertiesComponent.getInstance().getBoolean("idea.dynamic.parameters", true);
    }

    public static boolean useClasspathJar() {
        return PropertiesComponent.getInstance().getBoolean("idea.dynamic.classpath.jar", true);
    }

    @RequiresBackgroundThread(generateAssertion=false)
    private static boolean checkForJdkOrJre(@NotNull Path homePath, @NotNull CheckFor checkFor) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(20);
        }
        if (checkFor == null) {
            JdkUtil.$$$reportNull$$$0(21);
        }
        return Files.exists(homePath.resolve("bin").resolve(JavaNameKt.getJavaFileName(homePath, checkFor)), new LinkOption[0]);
    }

    private static void setupCommandLine(GeneralCommandLine commandLine, SimpleJavaParameters javaParameters) throws CantRunException {
        LocalTargetEnvironment environment;
        LocalTargetEnvironmentRequest request = new LocalTargetEnvironmentRequest();
        JdkCommandLineSetup setup = new JdkCommandLineSetup((TargetEnvironmentRequest)request);
        setup.setupCommandLine(javaParameters);
        try {
            environment = request.prepareEnvironment(TargetProgressIndicator.EMPTY);
        }
        catch (ExecutionException e) {
            throw new CantRunException(e.getMessage(), (Throwable)e);
        }
        GeneralCommandLine generalCommandLine = environment.createGeneralCommandLine(setup.getCommandLine().build());
        commandLine.withParentEnvironmentType(javaParameters.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        commandLine.getParametersList().addAll(generalCommandLine.getParametersList().getList());
        commandLine.getEnvironment().putAll(generalCommandLine.getEnvironment());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 3: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/JdkUtil";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkHomePath";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParameters";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/JdkUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestJdkName";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "setupJVMCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getJdkMainAttribute";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "suggestJdkName";
                break;
            }
            case 3: 
            case 17: 
            case 19: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkForJdk";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkForJre";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isModularRuntime";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isExplodedModularRuntime";
                break;
            }
            case 15: 
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setupJVMCommandLine";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkForJdkOrJre";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 17, 19 -> new IllegalStateException(string);
        };
    }
}

