/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class SdkType
implements SdkTypeId {
    public static final ExtensionPointName<SdkType> EP_NAME = new ExtensionPointName("com.intellij.sdkType");
    private static final Logger LOG = Logger.getInstance(SdkType.class);
    private static final Comparator<Sdk> ALPHABETICAL_COMPARATOR = (sdk1, sdk2) -> StringUtil.compare((String)sdk1.getName(), (String)sdk2.getName(), (boolean)true);
    private final String myName;

    public SdkType(@NotNull String name) {
        if (name == null) {
            SdkType.$$$reportNull$$$0(0);
        }
        this.myName = name;
    }

    @Deprecated
    @Nullable
    public abstract String suggestHomePath();

    @Nullable
    public String suggestHomePath(@NotNull Path path) {
        if (path == null) {
            SdkType.$$$reportNull$$$0(1);
        }
        return this.suggestHomePath();
    }

    @Deprecated
    public @Unmodifiable @NotNull Collection<String> suggestHomePaths() {
        String home = this.suggestHomePath();
        List list = ContainerUtil.createMaybeSingletonList((Object)home);
        if (list == null) {
            SdkType.$$$reportNull$$$0(2);
        }
        return list;
    }

    public @Unmodifiable @NotNull Collection<String> suggestHomePaths(@Nullable Project project) {
        Collection<String> collection = this.suggestHomePaths();
        if (collection == null) {
            SdkType.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public @Unmodifiable @NotNull Collection<SdkEntry> collectSdkEntries(@Nullable Project project) {
        List list = ContainerUtil.mapNotNull(this.suggestHomePaths(project), homePath -> {
            String versionString;
            try {
                versionString = this.getVersionString((String)homePath);
            }
            catch (Exception e) {
                LOG.warn("Failed to get the detected SDK version for " + String.valueOf(this) + " at " + homePath + ". " + e.getMessage(), (Throwable)e);
                return null;
            }
            if (versionString == null) {
                LOG.warn("No version is returned for detected SDK " + String.valueOf(this) + " at " + homePath);
                return null;
            }
            return new SdkEntry((String)homePath, versionString);
        });
        if (list == null) {
            SdkType.$$$reportNull$$$0(4);
        }
        return list;
    }

    public boolean isRelevantForFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            SdkType.$$$reportNull$$$0(5);
        }
        if (file == null) {
            SdkType.$$$reportNull$$$0(6);
        }
        return true;
    }

    @NotNull
    public String adjustSelectedSdkHome(@NotNull String homePath) {
        if (homePath == null) {
            SdkType.$$$reportNull$$$0(7);
        }
        String string = homePath;
        if (string == null) {
            SdkType.$$$reportNull$$$0(8);
        }
        return string;
    }

    public abstract boolean isValidSdkHome(@NotNull String var1);

    public String getInvalidHomeMessage(@NotNull String path) {
        if (path == null) {
            SdkType.$$$reportNull$$$0(9);
        }
        return new File(path).isDirectory() ? ProjectBundle.message((String)"sdk.configure.home.invalid.error", (Object[])new Object[]{this.getPresentableName()}) : ProjectBundle.message((String)"sdk.configure.home.file.invalid.error", (Object[])new Object[]{this.getPresentableName()});
    }

    @Nullable
    public String getVersionString(@NotNull Sdk sdk) {
        String homePath;
        if (sdk == null) {
            SdkType.$$$reportNull$$$0(10);
        }
        return (homePath = sdk.getHomePath()) == null ? null : this.getVersionString(homePath);
    }

    @Nullable
    public String getVersionString(@NotNull String sdkHome) {
        if (sdkHome == null) {
            SdkType.$$$reportNull$$$0(11);
        }
        return null;
    }

    @NotNull
    public abstract String suggestSdkName(@Nullable String var1, @NotNull String var2);

    @NotNull
    public Comparator<Sdk> getComparator() {
        Comparator<Sdk> comparator = ALPHABETICAL_COMPARATOR;
        if (comparator == null) {
            SdkType.$$$reportNull$$$0(12);
        }
        return comparator;
    }

    public boolean setupSdkPaths(@NotNull Sdk sdk, @NotNull SdkModel sdkModel) {
        if (sdk == null) {
            SdkType.$$$reportNull$$$0(13);
        }
        if (sdkModel == null) {
            SdkType.$$$reportNull$$$0(14);
        }
        this.setupSdkPaths(sdk);
        return true;
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
        if (sdk == null) {
            SdkType.$$$reportNull$$$0(15);
        }
    }

    @Nullable
    public abstract AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel var1, @NotNull SdkModificator var2);

    @Nullable
    public SdkAdditionalData loadAdditionalData(@NotNull Element additional) {
        if (additional == null) {
            SdkType.$$$reportNull$$$0(16);
        }
        return null;
    }

    @Nullable
    public SdkAdditionalData loadAdditionalData(@NotNull Sdk currentSdk, @NotNull Element additional) {
        if (currentSdk == null) {
            SdkType.$$$reportNull$$$0(17);
        }
        if (additional == null) {
            SdkType.$$$reportNull$$$0(18);
        }
        return this.loadAdditionalData(additional);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            SdkType.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public abstract String getPresentableName();

    public Icon getIcon() {
        return null;
    }

    @NotNull
    public String getHelpTopic() {
        return "preferences.jdks";
    }

    @Deprecated
    public Icon getIconForAddAction() {
        return this.getIcon();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SdkType)) {
            return false;
        }
        SdkType sdkType = (SdkType)o;
        return this.myName.equals(sdkType.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    @NotNull
    public FileChooserDescriptor getHomeChooserDescriptor() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){

            public void validateSelectedFiles(VirtualFile @NotNull [] files) throws Exception {
                String selectedPath;
                boolean valid;
                if (files == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (files.length != 0 && !(valid = SdkType.this.isValidSdkHome(selectedPath = files[0].getPath())) && !(valid = SdkType.this.isValidSdkHome(SdkType.this.adjustSelectedSdkHome(selectedPath)))) {
                    String message = SdkType.this.getInvalidHomeMessage(selectedPath);
                    throw new Exception(message);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/projectRoots/SdkType$1", "validateSelectedFiles"));
            }
        };
        descriptor.setTitle(ProjectBundle.message((String)"sdk.configure.home.title", (Object[])new Object[]{this.getPresentableName()}));
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        if (fileChooserDescriptor == null) {
            SdkType.$$$reportNull$$$0(20);
        }
        return fileChooserDescriptor;
    }

    @NlsContexts.Label
    @NotNull
    public String getHomeFieldLabel() {
        String string = ProjectBundle.message((String)"sdk.configure.type.home.path", (Object[])new Object[]{this.getPresentableName()});
        if (string == null) {
            SdkType.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Nullable
    public String getDefaultDocumentationUrl(@NotNull Sdk sdk) {
        if (sdk == null) {
            SdkType.$$$reportNull$$$0(22);
        }
        return null;
    }

    @Nullable
    public String getDownloadSdkUrl() {
        return null;
    }

    @Deprecated
    public static SdkType @NotNull [] getAllTypes() {
        SdkType[] sdkTypeArray = (SdkType[])EP_NAME.getExtensions();
        if (sdkTypeArray == null) {
            SdkType.$$$reportNull$$$0(23);
        }
        return sdkTypeArray;
    }

    @NotNull
    public static @Unmodifiable List<SdkType> getAllTypeList() {
        List list = EP_NAME.getExtensionList();
        if (list == null) {
            SdkType.$$$reportNull$$$0(24);
        }
        return list;
    }

    @Nullable
    public static SdkType findByName(@Nullable String sdkName) {
        if (sdkName == null) {
            return null;
        }
        for (SdkType sdkType : EP_NAME.getExtensionList()) {
            if (!Comparing.strEqual((String)sdkType.getName(), (String)sdkName)) continue;
            return sdkType;
        }
        return null;
    }

    @NotNull
    public static <T extends SdkType> T findInstance(@NotNull Class<T> sdkTypeClass) {
        if (sdkTypeClass == null) {
            SdkType.$$$reportNull$$$0(25);
        }
        for (SdkType sdkType : EP_NAME.getExtensionList()) {
            if (!sdkTypeClass.equals(sdkType.getClass())) continue;
            SdkType sdkType2 = (SdkType)sdkTypeClass.cast(sdkType);
            if (sdkType2 == null) {
                SdkType.$$$reportNull$$$0(26);
            }
            return (T)sdkType2;
        }
        throw new IllegalArgumentException("Unknown SDk type: " + String.valueOf(sdkTypeClass));
    }

    public SdkType getDependencyType() {
        return null;
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type) {
        if (type == null) {
            SdkType.$$$reportNull$$$0(27);
        }
        return true;
    }

    public boolean supportsCustomCreateUI() {
        return false;
    }

    @ApiStatus.OverrideOnly
    public void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @Nullable Sdk selectedSdk, @NotNull java.util.function.Consumer<? super Sdk> sdkCreatedCallback) {
        if (sdkModel == null) {
            SdkType.$$$reportNull$$$0(28);
        }
        if (parentComponent == null) {
            SdkType.$$$reportNull$$$0(29);
        }
        if (sdkCreatedCallback == null) {
            SdkType.$$$reportNull$$$0(30);
        }
        this.showCustomCreateUI(sdkModel, parentComponent, selectedSdk, (Consumer<? super Sdk>)((Consumer)sdk -> sdkCreatedCallback.accept((Sdk)sdk)));
    }

    @Deprecated
    public void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @Nullable Sdk selectedSdk, @NotNull Consumer<? super Sdk> sdkCreatedCallback) {
        if (sdkModel == null) {
            SdkType.$$$reportNull$$$0(31);
        }
        if (parentComponent == null) {
            SdkType.$$$reportNull$$$0(32);
        }
        if (sdkCreatedCallback == null) {
            SdkType.$$$reportNull$$$0(33);
        }
    }

    public boolean sdkHasValidPath(@NotNull Sdk sdk) {
        VirtualFile homeDir;
        if (sdk == null) {
            SdkType.$$$reportNull$$$0(34);
        }
        return (homeDir = sdk.getHomeDirectory()) != null && homeDir.isValid();
    }

    @NotNull
    public String sdkPath(@NotNull VirtualFile homePath) {
        if (homePath == null) {
            SdkType.$$$reportNull$$$0(35);
        }
        String string = homePath.getPath();
        if (string == null) {
            SdkType.$$$reportNull$$$0(36);
        }
        return string;
    }

    public boolean allowCreationByUser() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 8, 12, 19, 20, 21, 23, 24, 26, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/SdkType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 22: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 14: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSdk";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkTypeClass";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkCreatedCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/SdkType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestHomePaths";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSdkEntries";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustSelectedSdkHome";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparator";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeChooserDescriptor";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeFieldLabel";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTypes";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTypeList";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findInstance";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "sdkPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "suggestHomePath";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 36: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isRelevantForFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "adjustSelectedSdkHome";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidHomeMessage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getVersionString";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setupSdkPaths";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalData";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultDocumentationUrl";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findInstance";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isRootTypeApplicable";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "showCustomCreateUI";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "sdkHasValidPath";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "sdkPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 8, 12, 19, 20, 21, 23, 24, 26, 36 -> new IllegalStateException(string);
        };
    }

    public static final class SdkEntry
    extends Record {
        @NotNull
        private final String homePath;
        @NotNull
        private final String versionString;
        private final boolean isSymlink;

        public SdkEntry(@NotNull String homePath, @NotNull String versionString) {
            if (homePath == null) {
                SdkEntry.$$$reportNull$$$0(0);
            }
            if (versionString == null) {
                SdkEntry.$$$reportNull$$$0(1);
            }
            this(homePath, versionString, SdkEntry.isSymlink(homePath));
        }

        public SdkEntry(@NotNull String homePath, @NotNull String versionString, boolean isSymlink) {
            if (homePath == null) {
                SdkEntry.$$$reportNull$$$0(2);
            }
            if (versionString == null) {
                SdkEntry.$$$reportNull$$$0(3);
            }
            this.homePath = homePath;
            this.versionString = versionString;
            this.isSymlink = isSymlink;
        }

        private static boolean isSymlink(@NotNull String path) {
            if (path == null) {
                SdkEntry.$$$reportNull$$$0(4);
            }
            try {
                Path p = Paths.get(path, new String[0]);
                return !p.toRealPath(new LinkOption[0]).equals(p);
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{SdkEntry.class, "homePath;versionString;isSymlink", "homePath", "versionString", "isSymlink"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SdkEntry.class, "homePath;versionString;isSymlink", "homePath", "versionString", "isSymlink"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SdkEntry.class, "homePath;versionString;isSymlink", "homePath", "versionString", "isSymlink"}, this, o);
        }

        @NotNull
        public String homePath() {
            String string = this.homePath;
            if (string == null) {
                SdkEntry.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public String versionString() {
            String string = this.versionString;
            if (string == null) {
                SdkEntry.$$$reportNull$$$0(6);
            }
            return string;
        }

        public boolean isSymlink() {
            return this.isSymlink;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "homePath";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "versionString";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/projectRoots/SdkType$SdkEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/projectRoots/SdkType$SdkEntry";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "homePath";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "versionString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isSymlink";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

