/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.references;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiClassPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.patterns.uast.UCallExpressionPattern;
import com.intellij.patterns.uast.UElementPattern;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import com.intellij.spring.constants.SpringReferencePatternConditions;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.references.SpringBeanNamesReferenceProvider;
import com.intellij.spring.references.SpringBeanReference;
import com.intellij.spring.references.SpringBeanResourceReference;
import com.intellij.spring.references.SpringBeanScopeReference;
import com.intellij.spring.references.SpringPlaceholderReferencesPlacesKt;
import com.intellij.spring.references.SpringUastQualifierNameReferenceProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/spring/references/SpringUastReferenceContributor;", "Lcom/intellij/psi/PsiReferenceContributor;", "<init>", "()V", "registerReferenceProviders", "", "registrar", "Lcom/intellij/psi/PsiReferenceRegistrar;", "registerPropertyReferences", "registerQualifierNameReferenceProviders", "qualifierAnnotation", "Lcom/intellij/patterns/uast/UElementPattern$Capture;", "Lorg/jetbrains/uast/UAnnotation;", "intellij.spring.core"})
@SourceDebugExtension(value={"SMAP\nSpringUastReferenceContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringUastReferenceContributor.kt\ncom/intellij/spring/references/SpringUastReferenceContributor\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,113:1\n129#2:114\n158#2,3:115\n37#3,2:118\n1#4:120\n18#5:121\n*S KotlinDebug\n*F\n+ 1 SpringUastReferenceContributor.kt\ncom/intellij/spring/references/SpringUastReferenceContributor\n*L\n82#1:114\n82#1:115,3\n84#1:118,2\n68#1:121\n*E\n"})
public final class SpringUastReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        this.registerPropertyReferences(registrar);
        this.registerQualifierNameReferenceProviders(registrar);
    }

    /*
     * WARNING - void declaration
     */
    private final void registerPropertyReferences(PsiReferenceRegistrar registrar) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        UExpressionPattern uExpressionPattern = UastPatterns.injectionHostUExpression$default((boolean)false, (int)1, null);
        PatternCondition patternCondition = SpringReferencePatternConditions.PROJECT_HAS_SPRING_FACETS_CONDITION;
        Intrinsics.checkNotNullExpressionValue((Object)patternCondition, (String)"PROJECT_HAS_SPRING_FACETS_CONDITION");
        UExpressionPattern injectionHostWithCondition = (UExpressionPattern)uExpressionPattern.withSourcePsiCondition(patternCondition);
        PsiClassPattern propertyResolver = PsiJavaPatterns.psiClass().inheritorOf(false, "org.springframework.core.env.PropertyResolver");
        Object[] objectArray = new String[]{"getProperty", "containsProperty", "getRequiredProperty"};
        UCallExpressionPattern uCallExpressionPattern = UastPatterns.callExpression().withMethodNames((Collection)CollectionsKt.listOf((Object[])objectArray));
        Intrinsics.checkNotNull((Object)propertyResolver);
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)((ElementPattern)injectionHostWithCondition.callParameter(0, (ElementPattern)uCallExpressionPattern.withReceiver((ElementPattern)propertyResolver))), (UastReferenceProvider)((UastReferenceProvider)UastReferenceRegistrar.uastInjectionHostReferenceProvider(SpringUastReferenceContributor::registerPropertyReferences$lambda$0)), (double)100.0);
        UCallExpressionPattern uCallExpressionPattern2 = UastPatterns.callExpression();
        Intrinsics.checkNotNullExpressionValue((Object)SpringBeanNamesReferenceProvider.METHODS, (String)"METHODS");
        UCallExpressionPattern uCallExpressionPattern3 = uCallExpressionPattern2.withMethodNames((Collection)ArraysKt.toList((Object[])SpringBeanNamesReferenceProvider.METHODS));
        PsiClassPattern psiClassPattern = PsiJavaPatterns.psiClass().inheritorOf(false, "org.springframework.beans.factory.BeanFactory");
        Intrinsics.checkNotNullExpressionValue((Object)psiClassPattern, (String)"inheritorOf(...)");
        UastReferenceRegistrar.registerUastReferenceProvider$default((PsiReferenceRegistrar)registrar, (ElementPattern)((ElementPattern)injectionHostWithCondition.inCall((ElementPattern)uCallExpressionPattern3.withReceiver((ElementPattern)psiClassPattern))), (UastReferenceProvider)((UastReferenceProvider)UastReferenceRegistrar.uastInjectionHostReferenceProvider(SpringUastReferenceContributor::registerPropertyReferences$lambda$1)), (double)0.0, (int)4, null);
        String[] stringArray = new String[]{"javax.annotation.Resource", "jakarta.annotation.Resource"};
        StringPattern stringPattern = StandardPatterns.string().oneOf(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern, (String)"oneOf(...)");
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)((ElementPattern)injectionHostWithCondition.annotationParam((ElementPattern)stringPattern, "name")), (UastReferenceProvider)((UastReferenceProvider)UastReferenceRegistrar.uastInjectionHostReferenceProvider(SpringUastReferenceContributor::registerPropertyReferences$lambda$2)), (double)100.0);
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)((ElementPattern)injectionHostWithCondition.annotationParam("org.springframework.context.annotation.Scope", "value")), (UastReferenceProvider)((UastReferenceProvider)UastReferenceRegistrar.uastInjectionHostReferenceProvider(SpringUastReferenceContributor::registerPropertyReferences$lambda$4)), (double)100.0);
        Map<String, List<String>> map = SpringPlaceholderReferencesPlacesKt.getSPRING_PLACEHOLDER_ANNOTATIONS();
        PsiReferenceRegistrar psiReferenceRegistrar = registrar;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = (String)it.getKey();
            StringPattern stringPattern2 = StandardPatterns.string().oneOf((Collection)it.getValue());
            Intrinsics.checkNotNullExpressionValue((Object)stringPattern2, (String)"oneOf(...)");
            collection.add(injectionHostWithCondition.annotationParams(string, (ElementPattern)stringPattern2));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        stringArray = thisCollection$iv.toArray(new UExpressionPattern[0]);
        ElementPattern elementPattern = PsiJavaPatterns.or((ElementPattern[])((ElementPattern[])Arrays.copyOf(stringArray, stringArray.length)));
        Intrinsics.checkNotNullExpressionValue((Object)elementPattern, (String)"or(...)");
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)psiReferenceRegistrar, (ElementPattern)elementPattern, (UastReferenceProvider)((UastReferenceProvider)UastReferenceRegistrar.uastInjectionHostReferenceProvider(SpringUastReferenceContributor::registerPropertyReferences$lambda$6)), (double)100.0);
    }

    private final void registerQualifierNameReferenceProviders(PsiReferenceRegistrar registrar) {
        UExpressionPattern uExpressionPattern = UastPatterns.injectionHostUExpression$default((boolean)false, (int)1, null);
        PatternCondition patternCondition = SpringReferencePatternConditions.PROJECT_HAS_SPRING_FACETS_CONDITION;
        Intrinsics.checkNotNullExpressionValue((Object)patternCondition, (String)"PROJECT_HAS_SPRING_FACETS_CONDITION");
        UastReferenceRegistrar.registerUastReferenceProvider$default((PsiReferenceRegistrar)registrar, (ElementPattern)((ElementPattern)((UExpressionPattern)uExpressionPattern.withSourcePsiCondition(patternCondition)).annotationParam("value", (ElementPattern)this.qualifierAnnotation())), (UastReferenceProvider)((UastReferenceProvider)new SpringUastQualifierNameReferenceProvider()), (double)0.0, (int)4, null);
    }

    private final UElementPattern.Capture<UAnnotation> qualifierAnnotation() {
        return (UElementPattern.Capture)UastPatterns.capture(UAnnotation.class).filter(SpringUastReferenceContributor::qualifierAnnotation$lambda$0);
    }

    private static final PsiReference[] registerPropertyReferences$lambda$0(UExpression uExpression, PsiLanguageInjectionHost host) {
        Intrinsics.checkNotNullParameter((Object)uExpression, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        PsiReference[] psiReferenceArray = new PsiReference[1];
        Intrinsics.checkNotNullExpressionValue((Object)PlaceholderUtils.getInstance().createInPlaceholderPropertiesReferences((PsiElement)host, false), (String)"createInPlaceholderPropertiesReferences(...)");
        return psiReferenceArray;
    }

    private static final PsiReference[] registerPropertyReferences$lambda$1(UExpression uExpression, PsiLanguageInjectionHost host) {
        Intrinsics.checkNotNullParameter((Object)uExpression, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        PsiReference[] psiReferenceArray = new PsiReference[]{new SpringBeanReference((PsiElement)host, ElementManipulators.getValueTextRange((PsiElement)((PsiElement)host)), SpringBeanNamesReferenceProvider.determineRequiredClass((PsiElement)((PsiElement)host)), false)};
        return psiReferenceArray;
    }

    private static final PsiReference[] registerPropertyReferences$lambda$2(UExpression uLiteral, PsiLanguageInjectionHost psi) {
        String string;
        String it = string = UastUtils.evaluateString((UExpression)uLiteral);
        boolean bl = false;
        String string2 = !StringUtil.isEmptyOrSpaces((String)it) ? string : null;
        if (string2 == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        String beanName = string2;
        boolean isFactoryBeanRef = StringsKt.startsWith$default((String)beanName, (String)"&", (boolean)false, (int)2, null);
        if (isFactoryBeanRef) {
            String string3 = beanName.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            beanName = string3;
        }
        String string4 = psi.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        TextRange textRange = TextRange.from((int)StringsKt.indexOf$default((CharSequence)string4, (String)beanName, (int)0, (boolean)false, (int)6, null), (int)beanName.length());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
        TextRange range = textRange;
        UElement $this$getParentOfType_u24default$iv = (UElement)uLiteral;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        UVariable uVariable = (UVariable)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UVariable.class, (boolean)strict$iv);
        PsiReference[] psiReferenceArray = uVariable != null ? uVariable.getType() : null;
        PsiClassType requiredClassType = psiReferenceArray instanceof PsiClassType ? (PsiClassType)psiReferenceArray : null;
        psiReferenceArray = new PsiReference[1];
        PsiClassType psiClassType = requiredClassType;
        PsiClass psiClass = psiClassType != null ? psiClassType.resolve() : null;
        psiReferenceArray[0] = new SpringBeanResourceReference(psi, range, isFactoryBeanRef, psiClass){};
        return psiReferenceArray;
    }

    private static final PsiReference[] registerPropertyReferences$lambda$4(UExpression uLiteral, PsiLanguageInjectionHost host) {
        Intrinsics.checkNotNullParameter((Object)uLiteral, (String)"uLiteral");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        PsiReference[] psiReferenceArray = new PsiReference[]{new SpringBeanScopeReference(uLiteral, host)};
        return psiReferenceArray;
    }

    private static final PsiReference[] registerPropertyReferences$lambda$6(UExpression uExpression, PsiLanguageInjectionHost host) {
        Intrinsics.checkNotNullParameter((Object)uExpression, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        PsiReference[] psiReferenceArray = PlaceholderUtils.getInstance().createPlaceholderPropertiesReferences((PsiElement)host);
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"createPlaceholderPropertiesReferences(...)");
        return psiReferenceArray;
    }

    private static final boolean qualifierAnnotation$lambda$0(UAnnotation annotation) {
        Object[] objectArray;
        PsiClass psiClass = annotation.resolve();
        if (psiClass == null) {
            return false;
        }
        PsiClass annotationClass = psiClass;
        String string = annotationClass.getQualifiedName();
        if (string == null) {
            return false;
        }
        String qualifiedName = string;
        return Intrinsics.areEqual((Object)qualifiedName, (Object)"org.springframework.beans.factory.annotation.Qualifier") || Intrinsics.areEqual((Object)qualifiedName, (Object)"javax.inject.Qualifier") || MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)annotationClass), (Collection)CollectionsKt.listOf((Object[])(objectArray = new String[]{"javax.inject.Qualifier", "org.springframework.beans.factory.annotation.Qualifier"})));
    }
}

