/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.zmq.protocol;

import java.io.Closeable;
import java.nio.channels.SelectableChannel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.protocol.exceptions.UtilKt;
import org.jetbrains.kotlinx.jupyter.zmq.protocol.PipeSignaller;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015J\b\u0010\u0016\u001a\u00020\u0011H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/BlockingSignallingQueue;", "T", "", "Ljava/io/Closeable;", "capacity", "", "<init>", "(I)V", "queue", "Ljava/util/concurrent/BlockingQueue;", "pipeSignaller", "Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/PipeSignaller;", "signaller", "Ljava/nio/channels/SelectableChannel;", "getSignaller", "()Ljava/nio/channels/SelectableChannel;", "put", "", "item", "(Ljava/lang/Object;)V", "drainAll", "Lkotlin/sequences/Sequence;", "close", "zmq-protocol"})
public final class BlockingSignallingQueue<T>
implements Closeable {
    @NotNull
    private final BlockingQueue<T> queue;
    @NotNull
    private final PipeSignaller pipeSignaller;

    public BlockingSignallingQueue(int capacity) {
        this.queue = new ArrayBlockingQueue(capacity);
        this.pipeSignaller = new PipeSignaller();
    }

    @NotNull
    public final SelectableChannel getSignaller() {
        return this.pipeSignaller.getSignaller();
    }

    public final void put(@NotNull T item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        this.queue.put(item);
        this.pipeSignaller.signal();
    }

    @NotNull
    public final Sequence<T> drainAll() {
        this.pipeSignaller.drain();
        return SequencesKt.generateSequence((Function0)new Function0<T>(this.queue){

            public final T invoke() {
                return (T)((BlockingQueue)this.receiver).poll();
            }
        });
    }

    @Override
    public void close() {
        Function0[] function0Array = new Function0[]{new Function0<Unit>((Object)this.pipeSignaller){

            public final void invoke() {
                ((PipeSignaller)this.receiver).close();
            }
        }, new Function0<Unit>(this.queue){

            public final void invoke() {
                ((BlockingQueue)this.receiver).clear();
            }
        }};
        UtilKt.catchAllIndependentlyAndMerge(function0Array);
    }
}

