/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.visitors;

import com.intellij.diagnostic.hprof.parser.ConstantPoolEntry;
import com.intellij.diagnostic.hprof.parser.HProfVisitor;
import com.intellij.diagnostic.hprof.parser.InstanceFieldEntry;
import com.intellij.diagnostic.hprof.parser.StaticFieldEntry;
import com.intellij.diagnostic.hprof.parser.Type;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.hprof.impl.HprofArray;
import com.intellij.profiler.ultimate.hprof.impl.HprofClass;
import com.intellij.profiler.ultimate.hprof.impl.HprofDump;
import com.intellij.profiler.ultimate.hprof.impl.HprofObject;
import com.intellij.profiler.ultimate.hprof.impl.HprofRecord;
import com.intellij.profiler.ultimate.hprof.utils.BBUtils;
import com.intellij.profiler.ultimate.hprof.utils.IntList;
import com.intellij.profiler.ultimate.hprof.utils.LongBufferUtils;
import com.intellij.profiler.ultimate.hprof.utils.LongList;
import com.intellij.profiler.ultimate.hprof.utils.WriteOnceFile;
import com.intellij.profiler.ultimate.hprof.visitors.IndexFileVisitor;
import com.intellij.profiler.ultimate.hprof.visitors.ObjectConsumer;
import com.intellij.profiler.ultimate.hprof.visitors.ObjectVisitor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.PathKt;
import it.unimi.dsi.fastutil.longs.Long2IntFunction;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.LongIterator;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u000e\b\u0000\u0018\u0000 n2\u00020\u00012\u00060\u0002j\u0002`\u0003:\u0005jklmnB!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u0004\u0018\u00010#2\u0006\u0010'\u001a\u00020\u001aJ\u000e\u0010(\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%J\u000e\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020\u001aJ\u000e\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020\u001aJ\u000e\u0010-\u001a\u00020%2\u0006\u0010,\u001a\u00020\u001aJ\u0006\u0010.\u001a\u00020\u0018J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0018J\u000e\u00102\u001a\u00020%2\u0006\u0010,\u001a\u00020\u001aJ\u0016\u00103\u001a\u0002002\u0006\u0010,\u001a\u00020\u001a2\u0006\u00101\u001a\u00020%J\u0094\u0001\u00104\u001a\u0002002\u008b\u0001\u00105\u001a\u0086\u0001\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b7\u0012\b\b8\u0012\u0004\b\b(9\u0012\u0013\u0012\u00110%\u00a2\u0006\f\b7\u0012\b\b8\u0012\u0004\b\b(:\u0012\u0013\u0012\u00110%\u00a2\u0006\f\b7\u0012\b\b8\u0012\u0004\b\b(;\u0012\u0013\u0012\u00110%\u00a2\u0006\f\b7\u0012\b\b8\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b7\u0012\b\b8\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110%\u00a2\u0006\f\b7\u0012\b\b8\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u001806J\u001a\u0010<\u001a\u0002002\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00180=J\"\u0010<\u001a\u0002002\u0006\u0010>\u001a\u00020%2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00180=J.\u0010?\u001a\b\u0012\u0004\u0012\u0002HA0@\"\u0004\b\u0000\u0010A2\u0006\u0010>\u001a\u00020%2\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u0002HA0=J$\u0010<\u001a\u0002002\u0006\u0010C\u001a\u00020D2\u0014\u00105\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010#\u0012\u0004\u0012\u00020\u00180=J\u0012\u0010E\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0002J\u0012\u0010E\u001a\u0004\u0018\u00010#2\u0006\u0010'\u001a\u00020\u001aH\u0002JA\u0010E\u001a\u00020#2\u0006\u0010:\u001a\u00020%2\u0006\u0010;\u001a\u00020%2\u0006\u0010\u000f\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020%2\n\b\u0002\u0010F\u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0002\u0010GJ\b\u0010J\u001a\u000200H\u0016J0\u0010K\u001a\u0002002\u0006\u0010L\u001a\u00020%2\u0006\u0010M\u001a\u00020%2\u0006\u0010N\u001a\u00020%2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020RH\u0016J_\u0010S\u001a\u0002002\u0006\u0010>\u001a\u00020%2\u0006\u0010M\u001a\u00020%2\u0006\u0010T\u001a\u00020%2\u0006\u0010U\u001a\u00020%2\u0006\u0010V\u001a\u00020%2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020Y0X2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020[0X2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020]0XH\u0016\u00a2\u0006\u0002\u0010^J(\u0010_\u001a\u0002002\u0006\u0010L\u001a\u00020%2\u0006\u0010M\u001a\u00020%2\u0006\u0010`\u001a\u00020%2\u0006\u0010C\u001a\u00020aH\u0016J(\u0010b\u001a\u0002002\u0006\u0010$\u001a\u00020%2\u0006\u0010M\u001a\u00020%2\u0006\u0010c\u001a\u00020%2\u0006\u0010d\u001a\u00020RH\u0016J\b\u0010e\u001a\u000200H\u0016J\b\u0010f\u001a\u000200H\u0016J\b\u0010g\u001a\u00020\u0014H\u0002J\u0006\u0010h\u001a\u000200J\b\u0010i\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001fR\u0010\u0010H\u001a\u0004\u0018\u00010IX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006o"}, d2={"Lcom/intellij/profiler/ultimate/hprof/visitors/IndexFileVisitor;", "Lcom/intellij/diagnostic/hprof/parser/HProfVisitor;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "folder", "Ljava/nio/file/Path;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "dump", "Lcom/intellij/profiler/ultimate/hprof/impl/HprofDump;", "<init>", "(Ljava/nio/file/Path;Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/intellij/profiler/ultimate/hprof/impl/HprofDump;)V", "remap", "Lcom/intellij/profiler/ultimate/hprof/utils/LongList;", "offsets", "classes", "count", "Lcom/intellij/profiler/ultimate/hprof/utils/IntList;", "retained", "remapIDs", "Lit/unimi/dsi/fastutil/longs/Long2IntFunction;", "wereThereFiles", "", "Lcom/intellij/profiler/ultimate/hprof/visitors/IndexFileVisitor$Files;", "", "objectProcessorThreadsNum", "", "objectProcessor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "getObjectProcessor", "()Ljava/util/concurrent/ExecutorService;", "objectProcessor$delegate", "Lkotlin/Lazy;", "getObjectById", "Lcom/intellij/profiler/ultimate/hprof/impl/HprofObject;", "objectId", "", "getObjectByIndex", "objectIndex", "getRemapId", "getObjectId", "remapId", "getClassId", "position", "getShallowSize", "isRetainedSizeCalculated", "setRetainedSizeCalculated", "", "value", "getRetainedSize", "setRetainedSize", "forEachRecordIndexed", "consumer", "Lkotlin/Function6;", "Lkotlin/ParameterName;", "name", "index", "id", "offset", "forEachObject", "Lkotlin/Function1;", "classId", "mapObjectsOfClass", "", "T", "transform", "objects", "Lkotlin/collections/LongIterator;", "newObject", "isArray", "(JJJIJLjava/lang/Boolean;)Lcom/intellij/profiler/ultimate/hprof/impl/HprofObject;", "visitor", "Lcom/intellij/profiler/ultimate/hprof/visitors/ObjectVisitor;", "preVisit", "visitPrimitiveArrayDump", "arrayObjectId", "stackTraceSerialNumber", "numberOfElements", "elementType", "Lcom/intellij/diagnostic/hprof/parser/Type;", "primitiveArrayData", "Ljava/nio/ByteBuffer;", "visitClassDump", "superClassId", "classloaderClassId", "instanceSize", "constants", "", "Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;", "instanceFields", "Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;", "(JJJJJ[Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;[Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;[Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;)V", "visitObjectArrayDump", "arrayClassObjectId", "", "visitInstanceDump", "classObjectId", "bytes", "postVisit", "close", "createRemapIDsFunction", "deleteFiles", "isAllFilesExists", "Files", "TrivialRemapIDs", "SortedRemapIDs", "RunRemapIDs", "Companion", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nIndexFileVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexFileVisitor.kt\ncom/intellij/profiler/ultimate/hprof/visitors/IndexFileVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,418:1\n1#2:419\n1391#3:420\n1480#3,5:421\n2045#3,14:428\n1786#3,3:444\n14060#4,2:426\n14060#4,2:442\n*S KotlinDebug\n*F\n+ 1 IndexFileVisitor.kt\ncom/intellij/profiler/ultimate/hprof/visitors/IndexFileVisitor\n*L\n158#1:420\n158#1:421,5\n340#1:428,14\n412#1:444,3\n225#1:426,2\n370#1:442,2\n*E\n"})
public final class IndexFileVisitor
extends HProfVisitor
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path folder;
    @Nullable
    private final ProgressIndicator indicator;
    @NotNull
    private final HprofDump dump;
    private LongList remap;
    private LongList offsets;
    private LongList classes;
    private IntList count;
    @Nullable
    private LongList retained;
    private Long2IntFunction remapIDs;
    @NotNull
    private final Map<Files, Boolean> wereThereFiles;
    private final int objectProcessorThreadsNum;
    @NotNull
    private final Lazy objectProcessor$delegate;
    @Nullable
    private ObjectVisitor visitor;
    public static final int IN_MEMORY_MAP_SIZE = 1000000;
    @NotNull
    private static final Logger LOG;

    public IndexFileVisitor(@NotNull Path folder, @Nullable ProgressIndicator indicator, @NotNull HprofDump dump) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        this.folder = folder;
        this.indicator = indicator;
        this.dump = dump;
        this.wereThereFiles = new LinkedHashMap();
        this.objectProcessorThreadsNum = Math.min(Runtime.getRuntime().availableProcessors(), 8);
        this.objectProcessor$delegate = LazyKt.lazy(() -> IndexFileVisitor.objectProcessor_delegate$lambda$0(this));
    }

    private final ExecutorService getObjectProcessor() {
        Lazy lazy = this.objectProcessor$delegate;
        return (ExecutorService)lazy.getValue();
    }

    @Nullable
    public final HprofObject getObjectById(long objectId) {
        return this.newObject(objectId);
    }

    @Nullable
    public final HprofObject getObjectByIndex(int objectIndex) {
        return this.newObject(objectIndex);
    }

    public final int getRemapId(long objectId) {
        Long2IntFunction long2IntFunction = this.remapIDs;
        if (long2IntFunction == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remapIDs");
            long2IntFunction = null;
        }
        return long2IntFunction.applyAsInt(objectId);
    }

    public final long getObjectId(int remapId) {
        LongList longList = this.remap;
        if (longList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
            longList = null;
        }
        return longList.get(remapId);
    }

    public final long getClassId(int position) {
        LongList longList = this.classes;
        if (longList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
            longList = null;
        }
        return longList.get(position);
    }

    public final long getShallowSize(int position) {
        long l = this.getClassId(position);
        IntList intList = this.count;
        if (intList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"count");
            intList = null;
        }
        return this.dump.getShallowSize(l, intList.get(position));
    }

    public final boolean isRetainedSizeCalculated() {
        return this.retained != null;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRetainedSizeCalculated(boolean value) {
        if (value && this.retained == null) {
            void $this$setRetainedSizeCalculated_u24lambda_u240;
            Path path;
            Path path2 = path = Files.RETAINED.resolve(this.folder);
            IndexFileVisitor indexFileVisitor = this;
            boolean bl = false;
            LongList longList = this.remap;
            if (longList == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
                longList = null;
            }
            StandardOpenOption[] standardOpenOptionArray = BBUtils.READ_WRITE;
            indexFileVisitor.retained = new LongList.FileBuffer(longList.limit(), (Path)$this$setRetainedSizeCalculated_u24lambda_u240, Arrays.copyOf(standardOpenOptionArray, standardOpenOptionArray.length));
        }
        if (!value && this.retained != null) {
            try {
                PathKt.delete$default((Path)Files.RETAINED.resolve(this.folder), (boolean)false, (int)1, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.retained = null;
        }
    }

    public final long getRetainedSize(int position) {
        LongList longList = this.retained;
        return longList != null ? longList.get(position) : 0L;
    }

    public final void setRetainedSize(int position, long value) {
        block0: {
            this.setRetainedSizeCalculated(true);
            LongList longList = this.retained;
            if (longList == null) break block0;
            longList.put(position, value);
        }
    }

    public final void forEachRecordIndexed(@NotNull Function6<? super Integer, ? super Long, ? super Long, ? super Long, ? super Integer, ? super Long, Boolean> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        int i = 0;
        LongList longList = this.remap;
        if (longList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
            longList = null;
        }
        int n = longList.limit();
        while (i < n) {
            Integer n2 = i;
            LongList longList2 = this.remap;
            if (longList2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
                longList2 = null;
            }
            Long l = longList2.get(i);
            LongList longList3 = this.offsets;
            if (longList3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
                longList3 = null;
            }
            Long l2 = longList3.get(i);
            LongList longList4 = this.classes;
            if (longList4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
                longList4 = null;
            }
            Long l3 = longList4.get(i);
            IntList intList = this.count;
            if (intList == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"count");
                intList = null;
            }
            LongList longList5 = this.retained;
            consumer.invoke((Object)n2, (Object)l, (Object)l2, (Object)l3, (Object)intList.get(i), (Object)(longList5 != null ? longList5.get(i) : 0L));
            ++i;
        }
    }

    public final void forEachObject(@NotNull Function1<? super HprofObject, Boolean> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        int i = 0;
        LongList longList = this.remap;
        if (longList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
            longList = null;
        }
        int n = longList.limit();
        while (i < n) {
            LongList longList2 = this.remap;
            if (longList2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
                longList2 = null;
            }
            long l = longList2.get(i);
            LongList longList3 = this.offsets;
            if (longList3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
                longList3 = null;
            }
            long l2 = longList3.get(i);
            LongList longList4 = this.classes;
            if (longList4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
                longList4 = null;
            }
            long l3 = longList4.get(i);
            IntList intList = this.count;
            if (intList == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"count");
                intList = null;
            }
            LongList longList5 = this.retained;
            if (!((Boolean)consumer.invoke((Object)IndexFileVisitor.newObject$default(this, l, l2, l3, intList.get(i), longList5 != null ? longList5.get(i) : 0L, null, 32, null))).booleanValue()) break;
            ++i;
        }
    }

    public final void forEachObject(long classId, @NotNull Function1<? super HprofObject, Boolean> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        HprofClass hprofClass = this.dump.getClasses().get(classId);
        boolean isArray = hprofClass != null ? hprofClass.isArray() : false;
        int i = 0;
        LongList longList = this.classes;
        if (longList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
            longList = null;
        }
        int n = longList.limit();
        while (i < n) {
            long clazz;
            LongList longList2 = this.classes;
            if (longList2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
                longList2 = null;
            }
            if (classId == (clazz = longList2.get(i))) {
                LongList longList3 = this.remap;
                if (longList3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
                    longList3 = null;
                }
                long l = longList3.get(i);
                LongList longList4 = this.offsets;
                if (longList4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
                    longList4 = null;
                }
                long l2 = longList4.get(i);
                IntList intList = this.count;
                if (intList == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"count");
                    intList = null;
                }
                LongList longList5 = this.retained;
                if (!((Boolean)consumer.invoke((Object)this.newObject(l, l2, classId, intList.get(i), longList5 != null ? longList5.get(i) : 0L, isArray))).booleanValue()) break;
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> List<T> mapObjectsOfClass(long classId, @NotNull Function1<? super HprofObject, ? extends T> transform) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        HprofClass hprofClass = this.dump.getClasses().get(classId);
        boolean isArray = hprofClass != null ? hprofClass.isArray() : false;
        List result = new ArrayList();
        int tasksPerThread = 1;
        int allChunks = this.objectProcessorThreadsNum * tasksPerThread;
        LongList longList = this.classes;
        if (longList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
            longList = null;
        }
        int chunkSize = longList.limit() / allChunks;
        int n = allChunks - 1;
        for (int chunkIdx = 0; chunkIdx < n; ++chunkIdx) {
            ((Collection)result).add(IndexFileVisitor.mapObjectsOfClass$doTask(this, classId, transform, isArray, chunkIdx * chunkSize, (chunkIdx + 1) * chunkSize));
        }
        Collection chunkIdx = result;
        LongList longList2 = this.classes;
        if (longList2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
            longList2 = null;
        }
        chunkIdx.add(IndexFileVisitor.mapObjectsOfClass$doTask(this, classId, transform, isArray, (allChunks - 1) * chunkSize, longList2.limit()));
        this.getObjectProcessor().shutdown();
        try {
            this.getObjectProcessor().awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            LOG.error("Computation took more than 1 hour");
        }
        Iterable $this$flatMap$iv = result;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Future it = (Future)element$iv$iv;
            boolean bl = false;
            Object v = it.get();
            Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
            Iterable list$iv$iv = (Iterable)v;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void forEachObject(@NotNull LongIterator objects, @NotNull Function1<? super HprofObject, Boolean> consumer) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        while (objects.hasNext()) {
            boolean res;
            boolean bl;
            long objectId = objects.nextLong();
            int id = this.getRemapId(objectId);
            if (id >= 0) {
                LongList longList = this.remap;
                if (longList == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
                    longList = null;
                }
                long l = longList.get(id);
                LongList longList2 = this.offsets;
                if (longList2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
                    longList2 = null;
                }
                long l2 = longList2.get(id);
                LongList longList3 = this.classes;
                if (longList3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
                    longList3 = null;
                }
                long l3 = longList3.get(id);
                IntList intList = this.count;
                if (intList == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"count");
                    intList = null;
                }
                LongList longList4 = this.retained;
                bl = (Boolean)consumer.invoke((Object)IndexFileVisitor.newObject$default(this, l, l2, l3, intList.get(id), longList4 != null ? longList4.get(id) : 0L, null, 32, null));
            } else {
                bl = (Boolean)consumer.invoke(null);
            }
            if (res = bl) continue;
            break;
        }
    }

    private final HprofObject newObject(long objectId) {
        int id = this.getRemapId(objectId);
        if (id < 0) {
            return null;
        }
        LongList longList = this.offsets;
        if (longList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
            longList = null;
        }
        long l = longList.get(id);
        LongList longList2 = this.classes;
        if (longList2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
            longList2 = null;
        }
        long l2 = longList2.get(id);
        IntList intList = this.count;
        if (intList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"count");
            intList = null;
        }
        LongList longList3 = this.retained;
        return IndexFileVisitor.newObject$default(this, objectId, l, l2, intList.get(id), longList3 != null ? longList3.get(id) : 0L, null, 32, null);
    }

    private final HprofObject newObject(int objectIndex) {
        if (objectIndex < 0) {
            return null;
        }
        LongList longList = this.remap;
        if (longList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
            longList = null;
        }
        long l = longList.get(objectIndex);
        LongList longList2 = this.offsets;
        if (longList2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
            longList2 = null;
        }
        long l2 = longList2.get(objectIndex);
        LongList longList3 = this.classes;
        if (longList3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
            longList3 = null;
        }
        long l3 = longList3.get(objectIndex);
        IntList intList = this.count;
        if (intList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"count");
            intList = null;
        }
        LongList longList4 = this.retained;
        return IndexFileVisitor.newObject$default(this, l, l2, l3, intList.get(objectIndex), longList4 != null ? longList4.get(objectIndex) : 0L, null, 32, null);
    }

    private final HprofObject newObject(long id, long offset, long classes, int count, long retained, Boolean isArray) {
        long shallow = this.dump.getShallowSize(classes, count);
        boolean isRetainedSizeCalculated = this.dump.isRetainedSizeCalculated();
        Boolean bl = isArray;
        if (bl == null) {
            HprofClass hprofClass = this.dump.getClasses().get(classes);
            bl = hprofClass != null ? Boolean.valueOf(hprofClass.isArray()) : null;
        }
        return Intrinsics.areEqual((Object)bl, (Object)true) ? (HprofObject)new HprofArray(id, classes, count, shallow, isRetainedSizeCalculated ? Long.valueOf(retained) : null, null, offset, this.dump) : (HprofObject)new HprofRecord(id, classes, count, shallow, isRetainedSizeCalculated ? Long.valueOf(retained) : null, null, offset, this.dump);
    }

    static /* synthetic */ HprofObject newObject$default(IndexFileVisitor indexFileVisitor, long l, long l2, long l3, int n, long l4, Boolean bl, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            bl = null;
        }
        return indexFileVisitor.newObject(l, l2, l3, n, l4, bl);
    }

    public void preVisit() {
        this.disableAll();
        this.wereThereFiles.clear();
        Files[] $this$forEach$iv = Files.values();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Files element$iv;
            Files it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            this.wereThereFiles.put(it, java.nio.file.Files.exists(it.resolve(this.folder), Arrays.copyOf(linkOptionArray, linkOptionArray.length)));
        }
        if (!this.isAllFilesExists()) {
            WriteOnceFile remap = new WriteOnceFile(Files.REMAP.resolve(this.folder));
            WriteOnceFile classes = new WriteOnceFile(Files.CLASSES.resolve(this.folder));
            WriteOnceFile offsets = new WriteOnceFile(Files.OFFSETS.resolve(this.folder));
            WriteOnceFile count = new WriteOnceFile(Files.COUNT.resolve(this.folder));
            HprofDump hprofDump = this.dump;
            ObjectConsumer objectConsumer = (arg_0, arg_1, arg_2, arg_3, arg_4) -> IndexFileVisitor.preVisit$lambda$1(remap, classes, offsets, count, arg_0, arg_1, arg_2, arg_3, arg_4);
            Function1 function1 = arg_0 -> IndexFileVisitor.preVisit$lambda$2(this, arg_0);
            this.visitor = new ObjectVisitor(remap, offsets, classes, count, hprofDump, objectConsumer, (Function1<? super ObjectVisitor, Long>)function1){
                final /* synthetic */ WriteOnceFile $remap;
                final /* synthetic */ WriteOnceFile $offsets;
                final /* synthetic */ WriteOnceFile $classes;
                final /* synthetic */ WriteOnceFile $count;
                {
                    this.$remap = $remap;
                    this.$offsets = $offsets;
                    this.$classes = $classes;
                    this.$count = $count;
                    super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                }

                public void postVisit() {
                    super.postVisit();
                    this.$remap.close();
                    this.$offsets.close();
                    this.$classes.close();
                    this.$count.close();
                }
            };
        }
    }

    public void visitPrimitiveArrayDump(long arrayObjectId, long stackTraceSerialNumber, long numberOfElements, @NotNull Type elementType, @NotNull ByteBuffer primitiveArrayData) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
            Intrinsics.checkNotNullParameter((Object)primitiveArrayData, (String)"primitiveArrayData");
            ObjectVisitor objectVisitor = this.visitor;
            if (objectVisitor == null) break block0;
            objectVisitor.visitPrimitiveArrayDump(arrayObjectId, stackTraceSerialNumber, numberOfElements, elementType, primitiveArrayData);
        }
    }

    public void visitClassDump(long classId, long stackTraceSerialNumber, long superClassId, long classloaderClassId, long instanceSize, @NotNull ConstantPoolEntry[] constants, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)constants, (String)"constants");
            Intrinsics.checkNotNullParameter((Object)staticFields, (String)"staticFields");
            Intrinsics.checkNotNullParameter((Object)instanceFields, (String)"instanceFields");
            ObjectVisitor objectVisitor = this.visitor;
            if (objectVisitor == null) break block0;
            objectVisitor.visitClassDump(classId, stackTraceSerialNumber, superClassId, classloaderClassId, instanceSize, constants, staticFields, instanceFields);
        }
    }

    public void visitObjectArrayDump(long arrayObjectId, long stackTraceSerialNumber, long arrayClassObjectId, @NotNull long[] objects) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
            ObjectVisitor objectVisitor = this.visitor;
            if (objectVisitor == null) break block0;
            objectVisitor.visitObjectArrayDump(arrayObjectId, stackTraceSerialNumber, arrayClassObjectId, objects);
        }
    }

    public void visitInstanceDump(long objectId, long stackTraceSerialNumber, long classObjectId, @NotNull ByteBuffer bytes) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            ObjectVisitor objectVisitor = this.visitor;
            if (objectVisitor == null) break block0;
            objectVisitor.visitInstanceDump(objectId, stackTraceSerialNumber, classObjectId, bytes);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void postVisit() {
        Path retainedFile;
        Path $this$postVisit_u24lambda_u243;
        Path $this$postVisit_u24lambda_u242;
        Path $this$postVisit_u24lambda_u241;
        Path $this$postVisit_u24lambda_u240;
        boolean isReadOnly = this.visitor == null;
        StandardOpenOption[] options = isReadOnly ? BBUtils.READ_ONLY : BBUtils.READ_WRITE;
        ObjectVisitor objectVisitor = this.visitor;
        if (objectVisitor != null) {
            objectVisitor.postVisit();
        }
        this.visitor = null;
        Path path = Files.REMAP.resolve(this.folder);
        IndexFileVisitor indexFileVisitor = this;
        boolean bl = false;
        indexFileVisitor.remap = new LongList.FileBuffer((int)(java.nio.file.Files.size($this$postVisit_u24lambda_u240) / (long)8), $this$postVisit_u24lambda_u240, Arrays.copyOf(options, options.length));
        $this$postVisit_u24lambda_u240 = Files.OFFSETS.resolve(this.folder);
        indexFileVisitor = this;
        boolean bl2 = false;
        indexFileVisitor.offsets = new LongList.FileBuffer((int)(java.nio.file.Files.size($this$postVisit_u24lambda_u241) / (long)8), $this$postVisit_u24lambda_u241, Arrays.copyOf(options, options.length));
        $this$postVisit_u24lambda_u241 = Files.CLASSES.resolve(this.folder);
        indexFileVisitor = this;
        boolean bl3 = false;
        indexFileVisitor.classes = new LongList.FileBuffer((int)(java.nio.file.Files.size($this$postVisit_u24lambda_u242) / (long)8), $this$postVisit_u24lambda_u242, Arrays.copyOf(options, options.length));
        $this$postVisit_u24lambda_u242 = Files.COUNT.resolve(this.folder);
        indexFileVisitor = this;
        boolean $i$a$-with-IndexFileVisitor$postVisit$62 = false;
        indexFileVisitor.count = new IntList.FileBuffer((int)(java.nio.file.Files.size($this$postVisit_u24lambda_u243) / (long)4), $this$postVisit_u24lambda_u243, Arrays.copyOf(options, options.length));
        $this$postVisit_u24lambda_u243 = retainedFile = Files.RETAINED.resolve(this.folder);
        LinkOption[] $i$a$-with-IndexFileVisitor$postVisit$62 = new LinkOption[]{};
        if (java.nio.file.Files.exists($this$postVisit_u24lambda_u243, Arrays.copyOf($i$a$-with-IndexFileVisitor$postVisit$62, $i$a$-with-IndexFileVisitor$postVisit$62.length))) {
            void $this$postVisit_u24lambda_u244;
            $this$postVisit_u24lambda_u243 = retainedFile;
            indexFileVisitor = this;
            boolean bl4 = false;
            indexFileVisitor.retained = new LongList.FileBuffer((int)(java.nio.file.Files.size((Path)$this$postVisit_u24lambda_u244) / (long)8), (Path)$this$postVisit_u24lambda_u244, Arrays.copyOf(options, options.length));
        }
        if (!isReadOnly) {
            ProgressIndicator progressIndicator = this.indicator;
            if (progressIndicator != null) {
                progressIndicator.setText(UltimateProfilerBundleKt.profilerMessage("hprof.status.save", new Object[0]));
            }
            HprofClass hprofClass = this.dump.getClasses().get(this.dump.getClasses().getIdOfClassClass());
            Intrinsics.checkNotNull((Object)hprofClass);
            HprofClass clazz = hprofClass;
            int n = this.dump.getClasses().getClasses().size();
            for (int i = 0; i < n; ++i) {
                LongList longList = this.classes;
                if (longList == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
                    longList = null;
                }
                longList.put(i, clazz.getId());
            }
        }
        this.remapIDs = this.createRemapIDsFunction();
    }

    @Override
    public void close() {
        block8: {
            if (this.remap != null) {
                LongList longList = this.remap;
                if (longList == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
                    longList = null;
                }
                longList.close();
            }
            if (this.offsets != null) {
                LongList longList = this.offsets;
                if (longList == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
                    longList = null;
                }
                longList.close();
            }
            if (this.classes != null) {
                LongList longList = this.classes;
                if (longList == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
                    longList = null;
                }
                longList.close();
            }
            if (this.count != null) {
                IntList intList = this.count;
                if (intList == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"count");
                    intList = null;
                }
                intList.close();
            }
            LongList longList = this.retained;
            if (longList == null) break block8;
            longList.close();
        }
    }

    private final Long2IntFunction createRemapIDsFunction() {
        double part;
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u0005\u00a8\u0006\u000b"}, d2={"com/intellij/profiler/ultimate/hprof/visitors/IndexFileVisitor$createRemapIDsFunction$SeqRun", "", "start", "", "<init>", "(I)V", "getStart", "()I", "count", "getCount", "setCount", "intellij.profiler.ultimate"})
        public final class SeqRun {
            private final int start;
            private int count;

            public SeqRun(int start2) {
                this.start = start2;
                this.count = 1;
            }

            public final int getStart() {
                return this.start;
            }

            public final int getCount() {
                return this.count;
            }

            public final void setCount(int n) {
                this.count = n;
            }
        }
        SeqRun maxRun;
        List runs;
        long start2;
        block25: {
            LongList longList;
            block24: {
                Object v4;
                LongList longList2 = this.remap;
                if (longList2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
                    longList2 = null;
                }
                if (longList2.limit() == 0) {
                    return new TrivialRemapIDs();
                }
                start2 = System.currentTimeMillis();
                runs = new ArrayList();
                LongList longList3 = this.remap;
                if (longList3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
                    longList3 = null;
                }
                long current = longList3.get(0);
                ((Collection)runs).add(new SeqRun(0));
                int i = 1;
                LongList longList4 = this.remap;
                if (longList4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
                    longList4 = null;
                }
                int n = longList4.limit();
                while (i < n) {
                    LongList longList5 = this.remap;
                    if (longList5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
                        longList5 = null;
                    }
                    long ith = longList5.get(i);
                    SeqRun lastRun = (SeqRun)CollectionsKt.last((List)runs);
                    if (ith < current) {
                        ((Collection)runs).add(new SeqRun(i));
                    } else {
                        int n2 = lastRun.getCount();
                        lastRun.setCount(n2 + 1);
                    }
                    current = ith;
                    ++i;
                }
                Iterable $this$maxByOrNull$iv = runs;
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v4 = null;
                } else {
                    Object maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v4 = maxElem$iv;
                    } else {
                        SeqRun it = (SeqRun)maxElem$iv;
                        boolean bl = false;
                        int maxValue$iv = it.getCount();
                        do {
                            Object e$iv = iterator$iv.next();
                            SeqRun it2 = (SeqRun)e$iv;
                            $i$a$-maxByOrNull-IndexFileVisitor$createRemapIDsFunction$maxRun$1 = false;
                            int v$iv = it2.getCount();
                            if (maxValue$iv >= v$iv) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v4 = maxElem$iv;
                    }
                }
                SeqRun seqRun = maxRun = (SeqRun)v4;
                double d = seqRun != null ? seqRun.getCount() : 0;
                LongList longList6 = this.remap;
                if (longList6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
                    longList6 = null;
                }
                part = (double)MathKt.roundToInt((double)(d / (double)longList6.limit() * (double)1000)) / 10.0;
                if (maxRun == null) break block24;
                LongList longList7 = this.remap;
                if (longList7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
                    longList7 = null;
                }
                if (longList7.limit() - maxRun.getCount() <= 1000000) break block25;
            }
            if ((longList = this.remap) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
                longList = null;
            }
            LongBufferUtils.sort(longList, this.indicator, (arg_0, arg_1) -> IndexFileVisitor.createRemapIDsFunction$lambda$1(this, arg_0, arg_1));
            LOG.info("Too many in-memory object (" + part + " %), fallback with sort is used in " + (System.currentTimeMillis() - start2) + " ms");
            LongList longList8 = this.remap;
            if (longList8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
                longList8 = null;
            }
            return new SortedRemapIDs(longList8);
        }
        runs.remove(maxRun);
        Long2IntOpenHashMap others = new Long2IntOpenHashMap();
        others.defaultReturnValue(-1);
        for (SeqRun run2 : runs) {
            int n = run2.getStart() + run2.getCount();
            for (int i = run2.getStart(); i < n; ++i) {
                Map map2 = (Map)others;
                LongList longList = this.remap;
                if (longList == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
                    longList = null;
                }
                Long l = longList.get(i);
                Integer n3 = i;
                map2.put(l, n3);
            }
        }
        LOG.info("Found run with " + maxRun.getCount() + " objects (" + part + " %) " + (System.currentTimeMillis() - start2) + " ms");
        LongList longList = this.remap;
        if (longList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
            longList = null;
        }
        return new RunRemapIDs(longList, maxRun.getStart(), maxRun.getStart() + maxRun.getCount() - 1, arg_0 -> ((Long2IntOpenHashMap)others).get(arg_0));
    }

    public final void deleteFiles() throws IOException {
        Files[] $this$forEach$iv = Files.values();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Files element$iv;
            Files it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (Intrinsics.areEqual((Object)this.wereThereFiles.get((Object)it), (Object)true)) continue;
            PathKt.delete$default((Path)it.resolve(this.folder), (boolean)false, (int)1, null);
        }
    }

    private final boolean isAllFilesExists() {
        boolean bl;
        block3: {
            Files[] filesArray = new Files[]{Files.REMAP, Files.CLASSES, Files.OFFSETS, Files.COUNT};
            Iterable $this$all$iv = CollectionsKt.listOf((Object[])filesArray);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Files it = (Files)((Object)element$iv);
                    boolean bl2 = false;
                    Boolean bl3 = this.wereThereFiles.get((Object)it);
                    if (bl3 != null ? bl3 : false) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final ExecutorService objectProcessor_delegate$lambda$0(IndexFileVisitor this$0) {
        return AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"HProf Object Processor", (int)this$0.objectProcessorThreadsNum);
    }

    private static final List mapObjectsOfClass$doTask$lambda$0(int $from, int $to, IndexFileVisitor this$0, long $classId, Function1 $transform, boolean $isArray) {
        List localResult = new ArrayList();
        for (int i = $from; i < $to; ++i) {
            long clazz;
            LongList longList = this$0.classes;
            if (longList == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
                longList = null;
            }
            if ($classId != (clazz = longList.get(i))) continue;
            Collection collection = localResult;
            LongList longList2 = this$0.remap;
            if (longList2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"remap");
                longList2 = null;
            }
            long l = longList2.get(i);
            LongList longList3 = this$0.offsets;
            if (longList3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
                longList3 = null;
            }
            long l2 = longList3.get(i);
            IntList intList = this$0.count;
            if (intList == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"count");
                intList = null;
            }
            LongList longList4 = this$0.retained;
            collection.add($transform.invoke((Object)this$0.newObject(l, l2, $classId, intList.get(i), longList4 != null ? longList4.get(i) : 0L, $isArray)));
        }
        return localResult;
    }

    private static final <T> Future<List<T>> mapObjectsOfClass$doTask(IndexFileVisitor this$0, long $classId, Function1<? super HprofObject, ? extends T> $transform, boolean isArray, int from, int to) {
        Future<List<T>> future = this$0.getObjectProcessor().submit(() -> IndexFileVisitor.mapObjectsOfClass$doTask$lambda$0(from, to, this$0, $classId, $transform, isArray));
        Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
        return future;
    }

    private static final void preVisit$lambda$1(WriteOnceFile $remap, WriteOnceFile $classes, WriteOnceFile $offsets, WriteOnceFile $count, long objectId, long classId, int elementCount, long shallowSize, long offset) {
        $remap.putLong(objectId);
        $classes.putLong(classId);
        $offsets.putLong(offset);
        $count.putInt(elementCount);
    }

    private static final long preVisit$lambda$2(IndexFileVisitor this$0, ObjectVisitor objectVisitor) {
        Intrinsics.checkNotNullParameter((Object)((Object)objectVisitor), (String)"<this>");
        return this$0.getVisitorContext().getCurrentHeapRecordOffset();
    }

    private static final void createRemapIDsFunction$lambda$1(IndexFileVisitor this$0, int left, int right) {
        block3: {
            LongList longList = this$0.classes;
            if (longList == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
                longList = null;
            }
            longList.swap(left, right);
            LongList longList2 = this$0.offsets;
            if (longList2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
                longList2 = null;
            }
            longList2.swap(left, right);
            IntList intList = this$0.count;
            if (intList == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"count");
                intList = null;
            }
            intList.swap(left, right);
            LongList longList3 = this$0.retained;
            if (longList3 == null) break block3;
            longList3.swap(left, right);
        }
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.profiler.ultimate.hprof.impl.HprofDump");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/ultimate/hprof/visitors/IndexFileVisitor$Companion;", "", "<init>", "()V", "IN_MEMORY_MAP_SIZE", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/ultimate/hprof/visitors/IndexFileVisitor$Files;", "", "fileName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "REMAP", "CLASSES", "OFFSETS", "COUNT", "RETAINED", "resolve", "Ljava/nio/file/Path;", "folder", "exists", "", "size", "", "intellij.profiler.ultimate"})
    public static final class Files
    extends Enum<Files> {
        @NotNull
        private final String fileName;
        public static final /* enum */ Files REMAP = new Files("remap.index");
        public static final /* enum */ Files CLASSES = new Files("classes.index");
        public static final /* enum */ Files OFFSETS = new Files("offsets.index");
        public static final /* enum */ Files COUNT = new Files("count.index");
        public static final /* enum */ Files RETAINED = new Files("retained.index");
        private static final /* synthetic */ Files[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Files(String fileName2) {
            this.fileName = fileName2;
        }

        @NotNull
        public final Path resolve(@NotNull Path folder) {
            Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
            Path path = folder.resolve(this.fileName);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        public final boolean exists(@NotNull Path folder) {
            Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            return java.nio.file.Files.exists(this.resolve(folder), Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        }

        public final long size(@NotNull Path folder) {
            Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
            return java.nio.file.Files.size(this.resolve(folder));
        }

        public static Files[] values() {
            return (Files[])$VALUES.clone();
        }

        public static Files valueOf(String value) {
            return Enum.valueOf(Files.class, value);
        }

        @NotNull
        public static EnumEntries<Files> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = filesArray = new Files[]{Files.REMAP, Files.CLASSES, Files.OFFSETS, Files.COUNT, Files.RETAINED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/ultimate/hprof/visitors/IndexFileVisitor$RunRemapIDs;", "Lit/unimi/dsi/fastutil/longs/Long2IntFunction;", "data", "Lcom/intellij/profiler/ultimate/hprof/utils/LongList;", "start", "", "end", "tryFirst", "<init>", "(Lcom/intellij/profiler/ultimate/hprof/utils/LongList;IILit/unimi/dsi/fastutil/longs/Long2IntFunction;)V", "getData", "()Lcom/intellij/profiler/ultimate/hprof/utils/LongList;", "getStart", "()I", "getEnd", "getTryFirst", "()Lit/unimi/dsi/fastutil/longs/Long2IntFunction;", "get", "key", "", "intellij.profiler.ultimate"})
    private static final class RunRemapIDs
    implements Long2IntFunction {
        @NotNull
        private final LongList data;
        private final int start;
        private final int end;
        @NotNull
        private final Long2IntFunction tryFirst;

        public RunRemapIDs(@NotNull LongList data2, int start2, int end, @NotNull Long2IntFunction tryFirst) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Intrinsics.checkNotNullParameter((Object)tryFirst, (String)"tryFirst");
            this.data = data2;
            this.start = start2;
            this.end = end;
            this.tryFirst = tryFirst;
        }

        @NotNull
        public final LongList getData() {
            return this.data;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        @NotNull
        public final Long2IntFunction getTryFirst() {
            return this.tryFirst;
        }

        public int get(long key) {
            int index = this.tryFirst.get(key);
            if (index < 0) {
                index = Math.max(-1, LongBufferUtils.binarySearch(this.data, key, this.start, this.end));
            }
            return index;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/profiler/ultimate/hprof/visitors/IndexFileVisitor$SortedRemapIDs;", "Lit/unimi/dsi/fastutil/longs/Long2IntFunction;", "data", "Lcom/intellij/profiler/ultimate/hprof/utils/LongList;", "<init>", "(Lcom/intellij/profiler/ultimate/hprof/utils/LongList;)V", "getData", "()Lcom/intellij/profiler/ultimate/hprof/utils/LongList;", "get", "", "key", "", "intellij.profiler.ultimate"})
    private static final class SortedRemapIDs
    implements Long2IntFunction {
        @NotNull
        private final LongList data;

        public SortedRemapIDs(@NotNull LongList data2) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            this.data = data2;
        }

        @NotNull
        public final LongList getData() {
            return this.data;
        }

        public int get(long key) {
            return Math.max(-1, LongBufferUtils.binarySearch(this.data, key));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ultimate/hprof/visitors/IndexFileVisitor$TrivialRemapIDs;", "Lit/unimi/dsi/fastutil/longs/Long2IntFunction;", "<init>", "()V", "get", "", "ignored", "", "intellij.profiler.ultimate"})
    private static final class TrivialRemapIDs
    implements Long2IntFunction {
        public int get(long ignored) {
            return -1;
        }
    }
}

