/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.MisConfiguredException;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.api.AttachFailedException;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.api.ProfilerError;
import com.intellij.profiler.api.ProfilerState;
import com.intellij.profiler.api.ProfilerTargetProcess;
import com.intellij.profiler.api.ReadingData;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.ultimate.AttachedToAlreadyRunningProcessCommunicator;
import com.intellij.profiler.ultimate.JavaProfilerProcess;
import com.intellij.profiler.ultimate.ProfilerProcessCommunicator;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.VMAgentAttachKt;
import com.intellij.profiler.ultimate.async.StartedFromExternalSystemProcess;
import com.intellij.profiler.ultimate.jfr.JFRProfilerProcess;
import com.intellij.profiler.ultimate.jfr.RecordingConfiguration;
import com.intellij.profiler.ultimate.jfr.configuration.JFRConfigurationState;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import sun.tools.attach.HotSpotVirtualMachine;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 &*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001&B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J$\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aH\u0014J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001bH\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\"\u001a\u00020#X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006'"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerProcess;", "TargetProcess", "Lcom/intellij/profiler/api/ProfilerTargetProcess;", "Lcom/intellij/profiler/ultimate/JavaProfilerProcess;", "project", "Lcom/intellij/openapi/project/Project;", "communicator", "Lcom/intellij/profiler/ultimate/ProfilerProcessCommunicator;", "profilerConfiguration", "Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "recordingConfiguration", "Lcom/intellij/profiler/ultimate/jfr/RecordingConfiguration;", "attachedTimestamp", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/ultimate/ProfilerProcessCommunicator;Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;Lcom/intellij/profiler/ultimate/jfr/RecordingConfiguration;J)V", "getProfilerConfiguration", "()Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "getAttachedTimestamp", "()J", "doStop", "", "targetProcessId", "", "doSuspend", "onSuspend", "Lkotlin/Function1;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "", "readPreparedDump", "Lcom/intellij/profiler/api/ProfilerState;", "dump", "Ljava/io/File;", "indicator", "helpId", "", "getHelpId", "()Ljava/lang/String;", "Companion", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nJFRProfilerProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JFRProfilerProcess.kt\ncom/intellij/profiler/ultimate/jfr/JFRProfilerProcess\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,210:1\n23#2:211\n23#2:212\n23#2:213\n13#2:214\n*S KotlinDebug\n*F\n+ 1 JFRProfilerProcess.kt\ncom/intellij/profiler/ultimate/jfr/JFRProfilerProcess\n*L\n71#1:211\n75#1:212\n84#1:213\n119#1:214\n*E\n"})
public final class JFRProfilerProcess<TargetProcess extends ProfilerTargetProcess>
extends JavaProfilerProcess<TargetProcess> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProfilerConfigurationState profilerConfiguration;
    @NotNull
    private final RecordingConfiguration recordingConfiguration;
    private final long attachedTimestamp;
    @NotNull
    private final String helpId;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String CMD_HELP = "help";
    @NotNull
    private static final String CMD_START = "JFR.start";
    @NotNull
    private static final String CMD_STOP = "JFR.stop";
    @NotNull
    private static final String CMD_CHECK = "JFR.check";
    @NotNull
    private static final String CMD_CONFIGURE = "JFR.configure";
    @NotNull
    private static final String UNLOCK_COMMERCIAL_MESSAGE = "Use VM.unlock_commercial_features to enable.";
    @NotNull
    private static final String STARTED_MESSAGE = "Started recording";
    @NotNull
    private static final String STOPPED_MESSAGE = "Stopped recording";
    @NotNull
    private static final String JFR_LICENSE_URL = "http://www.oracle.com/technetwork/java/javase/terms/products/index.html";

    public JFRProfilerProcess(@NotNull Project project, @NotNull ProfilerProcessCommunicator<TargetProcess> communicator, @NotNull ProfilerConfigurationState profilerConfiguration, @NotNull RecordingConfiguration recordingConfiguration, long attachedTimestamp) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(communicator, (String)"communicator");
        Intrinsics.checkNotNullParameter((Object)profilerConfiguration, (String)"profilerConfiguration");
        Intrinsics.checkNotNullParameter((Object)recordingConfiguration, (String)"recordingConfiguration");
        super(project, communicator, recordingConfiguration);
        this.profilerConfiguration = profilerConfiguration;
        this.recordingConfiguration = recordingConfiguration;
        this.attachedTimestamp = attachedTimestamp;
        this.helpId = "procedures.profiler";
    }

    @NotNull
    public ProfilerConfigurationState getProfilerConfiguration() {
        return this.profilerConfiguration;
    }

    public long getAttachedTimestamp() {
        return this.attachedTimestamp;
    }

    @Override
    protected boolean doStop(int targetProcessId) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> JFRProfilerProcess.doStop$lambda$0(this, targetProcessId));
        return true;
    }

    @Override
    protected boolean doSuspend(int targetProcessId, @NotNull Function1<? super ProgressIndicator, Unit> onSuspend) {
        Intrinsics.checkNotNullParameter(onSuspend, (String)"onSuspend");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected ProfilerState readPreparedDump(@NotNull File dump, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (this.getTargetProcess() instanceof StartedFromExternalSystemProcess) {
            String string = this.getDumpFileWhenTargetProcessFinished().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            File errorMessageFile = new File(Companion.errorMessageFileFromDumpFile(string));
            if (errorMessageFile.exists() && errorMessageFile.length() > 0L) {
                try {
                    String message = FilesKt.readText$default((File)errorMessageFile, null, (int)1, null);
                    if (((CharSequence)message).length() > 0) {
                        ProfilerState profilerState = (ProfilerState)new ProfilerError(message);
                        return profilerState;
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    errorMessageFile.delete();
                }
            }
        }
        return super.readPreparedDump(dump, indicator);
    }

    @NotNull
    public String getHelpId() {
        return this.helpId;
    }

    private static final Unit doStop$lambda$0$0$0(ProgressIndicator $indicator, JFRProfilerProcess this$0, int $targetProcessId, HotSpotVirtualMachine vm) {
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        $indicator.checkCanceled();
        Disposer.dispose((Disposable)this$0.getCommunicator());
        this$0.changeStateAndNotifyAsync((ProfilerState)ReadingData.INSTANCE);
        File dumpFile = this$0.recordingConfiguration.getResultSnapshot().getDumpFile();
        Object[] objectArray = new String[]{CMD_STOP, "name=\"" + this$0.recordingConfiguration.getName() + "\""};
        List command = CollectionsKt.listOf((Object[])objectArray);
        JFRProfilerProcess $this$thisLogger$iv = this$0;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JFRProfilerProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("stop profiler command: " + command);
        String stop = VMAgentAttachKt.execJCmd(vm, command);
        $indicator.checkCanceled();
        if (!StringsKt.contains$default((CharSequence)stop, (CharSequence)STOPPED_MESSAGE, (boolean)false, (int)2, null)) {
            Object[] objectArray2 = new Object[]{CMD_STOP, stop};
            throw new IllegalStateException(UltimateProfilerBundleKt.profilerMessage("jfr.unexpected.response", objectArray2));
        }
        JFRProfilerProcess $this$thisLogger$iv2 = this$0;
        boolean $i$f$thisLogger2 = false;
        Logger logger2 = Logger.getInstance(JFRProfilerProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger2.info("doStop, targetPid: " + $targetProcessId + ", dumpFile: " + dumpFile.getAbsolutePath());
        ProfilerState readResult = this$0.readPreparedDumpAndReportStatistics(dumpFile, $indicator);
        this$0.changeStateAndNotifyAsync(readResult);
        return Unit.INSTANCE;
    }

    private static final Unit doStop$lambda$0$0(int $targetProcessId, JFRProfilerProcess this$0, ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Throwable error2 = VMAgentAttachKt.safeVMAttach($targetProcessId, (Function1<? super HotSpotVirtualMachine, Unit>)((Function1)arg_0 -> JFRProfilerProcess.doStop$lambda$0$0$0(indicator, this$0, $targetProcessId, arg_0)));
        if (error2 != null) {
            JFRProfilerProcess $this$thisLogger$iv = this$0;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JFRProfilerProcess.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(error2);
            this$0.changeStateAndNotifyAsync((ProfilerState)new ProfilerError(UltimateProfilerBundleKt.profilerMessage("jfr.cant.stop.profiler", new Object[0])));
        }
        return Unit.INSTANCE;
    }

    private static final void doStop$lambda$0(JFRProfilerProcess this$0, int $targetProcessId) {
        this$0.runUnderDumpReadIndicator(arg_0 -> JFRProfilerProcess.doStop$lambda$0$0($targetProcessId, this$0, arg_0));
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JFRProfilerProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        JFRProfilerProcess.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0003R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/profiler/ultimate/jfr/JFRProfilerProcess$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "CMD_HELP", "", "CMD_START", "CMD_STOP", "CMD_CHECK", "CMD_CONFIGURE", "getCMD_CONFIGURE$annotations", "UNLOCK_COMMERCIAL_MESSAGE", "STARTED_MESSAGE", "STOPPED_MESSAGE", "JFR_LICENSE_URL", "attach", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/profiler/ultimate/jfr/JFRProfilerProcess;", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "targetProcess", "recordingConfiguration", "Lcom/intellij/profiler/ultimate/jfr/RecordingConfiguration;", "settings", "Lcom/intellij/profiler/ultimate/jfr/configuration/JFRConfigurationState;", "project", "Lcom/intellij/openapi/project/Project;", "errorMessageFileFromDumpFile", "dumpFile", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getCMD_CONFIGURE$annotations() {
        }

        @NotNull
        public final Promise<JFRProfilerProcess<AttachableTargetProcess>> attach(@NotNull AttachableTargetProcess targetProcess, @NotNull RecordingConfiguration recordingConfiguration, @NotNull JFRConfigurationState settings, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
            Intrinsics.checkNotNullParameter((Object)recordingConfiguration, (String)"recordingConfiguration");
            Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            AsyncPromise result = new AsyncPromise();
            String string = CommonProfilerBundleKt.commonProfilerMessage((String)"attach.task.title", (Object[])new Object[0]);
            PerformInBackgroundOption performInBackgroundOption = PerformInBackgroundOption.DEAF;
            new Task.Backgroundable(project, targetProcess, (AsyncPromise<JFRProfilerProcess<AttachableTargetProcess>>)result, settings, recordingConfiguration, string, performInBackgroundOption){
                final /* synthetic */ Project $project;
                final /* synthetic */ AttachableTargetProcess $targetProcess;
                final /* synthetic */ AsyncPromise<JFRProfilerProcess<AttachableTargetProcess>> $result;
                final /* synthetic */ JFRConfigurationState $settings;
                final /* synthetic */ RecordingConfiguration $recordingConfiguration;
                {
                    this.$project = $project;
                    this.$targetProcess = $targetProcess;
                    this.$result = $result;
                    this.$settings = $settings;
                    this.$recordingConfiguration = $recordingConfiguration;
                    super($project, $super_call_param$1, true, $super_call_param$2);
                }

                public void run(ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    Object[] objectArray = new Object[]{this.$targetProcess.getFullName()};
                    indicator.setText(CommonProfilerBundleKt.commonProfilerMessage((String)"attach.task.text", (Object[])objectArray));
                    Throwable error2 = VMAgentAttachKt.safeVMAttach(this.$targetProcess.getPid(), (Function1<? super HotSpotVirtualMachine, Unit>)((Function1)arg_0 -> attach.1.run$lambda$0(this.$result, this.$targetProcess, this.$settings, this.$recordingConfiguration, this.$project, arg_0)));
                    if (error2 != null) {
                        JFRProfilerProcess.access$getLogger$cp().error(error2);
                        this.$result.setError((Throwable)new AttachFailedException(UtilsKt.explain((Throwable)error2, (String)UltimateProfilerBundleKt.profilerMessage("jfr.profile.cant.attach", new Object[0]))));
                    }
                }

                @NlsSafe
                private static final String run$lambda$0$buildWarningMessage() {
                    StringBuilder stringBuilder;
                    StringBuilder $this$run_u24lambda_u240_u24buildWarningMessage_u240 = stringBuilder = new StringBuilder();
                    boolean bl = false;
                    $this$run_u24lambda_u240_u24buildWarningMessage_u240.append(UltimateProfilerBundleKt.profilerMessage("jfr.cant.configure.options", new Object[0]));
                    $this$run_u24lambda_u240_u24buildWarningMessage_u240.append("<br>");
                    $this$run_u24lambda_u240_u24buildWarningMessage_u240.append(UltimateProfilerBundleKt.profilerMessage("jfr.stacks.can.be.truncated", new Object[0]));
                    return stringBuilder.toString();
                }

                private static final Unit run$lambda$0(AsyncPromise $result, AttachableTargetProcess $targetProcess, JFRConfigurationState $settings, RecordingConfiguration $recordingConfiguration, Project $project, HotSpotVirtualMachine vm) {
                    Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
                    String[] stringArray = new String[]{"help"};
                    String[] stringArray2 = StringUtil.splitByLines((String)VMAgentAttachKt.execJCmd(vm, stringArray));
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"splitByLines(...)");
                    List supportedCommands = ArraysKt.toList((Object[])stringArray2);
                    Object[] objectArray = new String[]{"JFR.check", "JFR.start", "JFR.stop"};
                    if (!supportedCommands.containsAll(CollectionsKt.listOf((Object[])objectArray))) {
                        $result.setError((Throwable)new AttachFailedException(UltimateProfilerBundleKt.profilerMessage("jfr.cant.attach.unsupported", new Object[0])));
                        return Unit.INSTANCE;
                    }
                    stringArray = new String[]{"JFR.check"};
                    String check2 = VMAgentAttachKt.execJCmd(vm, stringArray);
                    if (StringsKt.contains$default((CharSequence)check2, (CharSequence)"Use VM.unlock_commercial_features to enable.", (boolean)false, (int)2, null)) {
                        Object object = new Object[]{String.valueOf($targetProcess.getPid())};
                        String string = UltimateProfilerBundleKt.profilerMessage("jfr.commercial.message", object);
                        object = UltimateProfilerBundleKt.profilerMessage("jfr.commercial.url.text", new Object[0]);
                        MisConfiguredException commercialFeaturesMessage2 = new MisConfiguredException($project, string, (String)object){

                            public void fixAction(Project project) {
                                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                                BrowserUtil.browse((String)"http://www.oracle.com/technetwork/java/javase/terms/products/index.html");
                            }
                        };
                        $result.setError((Throwable)commercialFeaturesMessage2);
                        return Unit.INSTANCE;
                    }
                    String warningMessage = null;
                    CharSequence charSequence = $settings.getFlightRecorderOptions();
                    if (!(charSequence == null || charSequence.length() == 0)) {
                        warningMessage = attach.1.run$lambda$0$buildWarningMessage();
                    }
                    List command = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"JFR.start"), (Iterable)$recordingConfiguration.startCommand($settings.getStartSetting()));
                    JFRProfilerProcess.access$getLogger$cp().info("attach profiler  command: " + command);
                    Object[] objectArray2 = new String[]{CollectionsKt.joinToString$default((Iterable)command, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)};
                    String start2 = VMAgentAttachKt.execJCmd(vm, (String[])objectArray2);
                    if (StringsKt.contains$default((CharSequence)start2, (CharSequence)"Started recording", (boolean)false, (int)2, null)) {
                        AttachedToAlreadyRunningProcessCommunicator communicator = new AttachedToAlreadyRunningProcessCommunicator($targetProcess);
                        $result.setResult(new JFRProfilerProcess<TargetProcess>($project, communicator, (ProfilerConfigurationState)$settings, $recordingConfiguration, System.currentTimeMillis()));
                        CharSequence charSequence2 = warningMessage;
                        if (!(charSequence2 == null || charSequence2.length() == 0)) {
                            ProfilerToolWindowManager.Companion.getInstance($project).showWarningBalloon(warningMessage);
                        }
                    } else {
                        objectArray2 = new Object[]{"JFR.start", start2};
                        throw new IllegalStateException(UltimateProfilerBundleKt.profilerMessage("jfr.unexpected.response", objectArray2));
                    }
                    return Unit.INSTANCE;
                }
            }.queue();
            return (Promise)result;
        }

        @NotNull
        public final String errorMessageFileFromDumpFile(@NotNull String dumpFile) {
            Intrinsics.checkNotNullParameter((Object)dumpFile, (String)"dumpFile");
            return dumpFile + ".gradle_error";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

