/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profiler.ultimate.model.BaseJavaMethodCall;
import com.intellij.profiler.ultimate.ui.JavaProjectCodeDetector;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/ultimate/jfr/ui/ProjectCodeDetectorByFile;", "Lcom/intellij/profiler/ultimate/ui/JavaProjectCodeDetector;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "getFileIndex", "()Lcom/intellij/openapi/roots/ProjectFileIndex;", "fileIndex$delegate", "Lkotlin/Lazy;", "cache", "", "Lcom/intellij/profiler/ultimate/model/BaseJavaMethodCall;", "", "isInProject", "node", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nJFRDumpView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JFRDumpView.kt\ncom/intellij/profiler/ultimate/jfr/ui/ProjectCodeDetectorByFile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,757:1\n1807#2,3:758\n*S KotlinDebug\n*F\n+ 1 JFRDumpView.kt\ncom/intellij/profiler/ultimate/jfr/ui/ProjectCodeDetectorByFile\n*L\n315#1:758,3\n*E\n"})
final class ProjectCodeDetectorByFile
implements JavaProjectCodeDetector {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy fileIndex$delegate;
    @NotNull
    private final Map<BaseJavaMethodCall, Boolean> cache;

    public ProjectCodeDetectorByFile(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.fileIndex$delegate = LazyKt.lazy(() -> ProjectCodeDetectorByFile.fileIndex_delegate$lambda$0(this));
        this.cache = new LinkedHashMap();
    }

    private final ProjectFileIndex getFileIndex() {
        Lazy lazy = this.fileIndex$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (ProjectFileIndex)object;
    }

    @Override
    public boolean isInProject(@NotNull BaseJavaMethodCall node) {
        Intrinsics.checkNotNullParameter((Object)((Object)node), (String)"node");
        Boolean bl = this.cache.computeIfAbsent(node, arg_0 -> ProjectCodeDetectorByFile.isInProject$lambda$1(arg_0 -> ProjectCodeDetectorByFile.isInProject$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"computeIfAbsent(...)");
        return bl;
    }

    private static final ProjectFileIndex fileIndex_delegate$lambda$0(ProjectCodeDetectorByFile this$0) {
        return ProjectRootManager.getInstance((Project)this$0.project).getFileIndex();
    }

    private static final Boolean isInProject$lambda$0(ProjectCodeDetectorByFile this$0, BaseJavaMethodCall it) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            Iterable $this$any$iv = it.findVirtualFiles(this$0.project);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile file = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!this$0.getFileIndex().isInContent(file)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final Boolean isInProject$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

