/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.ClientData;
import org.jetbrains.idea.perforce.application.ConnectionInfo;
import org.jetbrains.idea.perforce.application.P4RootsInformation;
import org.jetbrains.idea.perforce.perforce.PerforceAuthenticationException;
import org.jetbrains.idea.perforce.perforce.PerforceServerUnavailable;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class PerforceClientRootsChecker
implements P4RootsInformation {
    private static final Logger LOG = Logger.getInstance(PerforceClientRootsChecker.class);
    private final Map<P4Connection, WrongRoots> myMap;
    private final MultiMap<P4Connection, VcsException> myErrors;
    private final Map<P4Connection, PerforceAuthenticationException> myNotAuthorized;
    private boolean myHasNoConnections;

    public PerforceClientRootsChecker() {
        this.myMap = new HashMap<P4Connection, WrongRoots>();
        this.myErrors = new MultiMap();
        this.myNotAuthorized = new HashMap<P4Connection, PerforceAuthenticationException>();
        this.myHasNoConnections = false;
    }

    public PerforceClientRootsChecker(@NotNull Map<P4Connection, ConnectionInfo> infoAndClient, @NotNull Map<VirtualFile, P4Connection> map) {
        if (infoAndClient == null) {
            PerforceClientRootsChecker.$$$reportNull$$$0(0);
        }
        if (map == null) {
            PerforceClientRootsChecker.$$$reportNull$$$0(1);
        }
        this(infoAndClient, map, null);
    }

    public PerforceClientRootsChecker(@NotNull Map<P4Connection, ConnectionInfo> infoAndClient, @NotNull Map<VirtualFile, P4Connection> map, @Nullable VirtualFile clientRoot) {
        if (infoAndClient == null) {
            PerforceClientRootsChecker.$$$reportNull$$$0(2);
        }
        if (map == null) {
            PerforceClientRootsChecker.$$$reportNull$$$0(3);
        }
        this.myMap = new HashMap<P4Connection, WrongRoots>();
        this.myErrors = new MultiMap();
        this.myNotAuthorized = new HashMap<P4Connection, PerforceAuthenticationException>();
        this.myHasNoConnections = false;
        if (map.containsKey(null)) {
            LOG.info("Null root: " + String.valueOf(new LinkedHashMap<VirtualFile, P4Connection>(map)));
        }
        this.myHasNoConnections = map.isEmpty();
        MultiMap<P4Connection, VirtualFile> inverse = PerforceClientRootsChecker.invertConnectionMap(map);
        LinkedHashSet connectionsToCheck = new LinkedHashSet(inverse.keySet());
        for (P4Connection connection : connectionsToCheck) {
            List<String> clientRoots;
            try {
                clientRoots = PerforceClientRootsChecker.getClientRoots(connection, infoAndClient);
            }
            catch (PerforceAuthenticationException e) {
                this.myNotAuthorized.put(connection, e);
                continue;
            }
            catch (VcsException e) {
                this.myErrors.putValue((Object)connection, (Object)e);
                continue;
            }
            ArrayList<VirtualFile> rootsToCheck = new ArrayList<VirtualFile>(inverse.get((Object)connection));
            if (clientRoot != null && !rootsToCheck.contains(clientRoot)) {
                rootsToCheck.add(clientRoot);
            }
            ContainerUtil.putIfNotNull((Object)connection, (Object)PerforceClientRootsChecker.checkRoots(rootsToCheck, clientRoots), this.myMap);
        }
    }

    @Nullable
    private static WrongRoots checkRoots(Collection<VirtualFile> roots, List<String> clientRoots) {
        WrongRoots wrongRoots = null;
        for (VirtualFile root : roots) {
            if (root == null) continue;
            boolean checkedOk = false;
            File ioFile = new File(root.getPath());
            File canonicalIoFile = null;
            try {
                canonicalIoFile = ioFile.getCanonicalFile();
            }
            catch (IOException e) {
                LOG.debug("Cannot resolve canonical path for " + root.getPath(), (Throwable)e);
            }
            for (String clientRoot : clientRoots) {
                if ("null".equals(clientRoot)) {
                    checkedOk = true;
                    break;
                }
                File ioRoot = new File(clientRoot);
                if (!PerforceClientRootsChecker.isDirectory(ioRoot) || !FileUtil.isAncestor((File)ioRoot, (File)ioFile, (boolean)false) && (canonicalIoFile == null || !FileUtil.isAncestor((File)ioRoot, (File)canonicalIoFile, (boolean)false))) continue;
                checkedOk = true;
                break;
            }
            if (checkedOk) continue;
            if (wrongRoots == null) {
                wrongRoots = new WrongRoots(clientRoots);
            }
            wrongRoots.addWrong(root);
        }
        return wrongRoots;
    }

    private static MultiMap<P4Connection, VirtualFile> invertConnectionMap(Map<VirtualFile, P4Connection> map) {
        MultiMap inverse = new MultiMap();
        for (Map.Entry<VirtualFile, P4Connection> entry : map.entrySet()) {
            inverse.putValue((Object)entry.getValue(), (Object)entry.getKey());
        }
        return inverse;
    }

    public boolean isServerUnavailable() {
        return ContainerUtil.findInstance(new ArrayList(this.myErrors.values()), PerforceServerUnavailable.class) != null;
    }

    public static boolean isDirectory(File file) {
        String path;
        if (file.isDirectory()) {
            return true;
        }
        return SystemInfo.isWindows && (path = file.getPath()).length() == 2 && OSAgnosticPathUtil.startsWithWindowsDrive((String)path);
    }

    private static List<String> getClientRoots(P4Connection connection, Map<P4Connection, ConnectionInfo> infoMap) throws VcsException {
        ClientData clientSpec;
        ConnectionInfo info = infoMap.get(connection);
        ClientData clientData = clientSpec = info == null ? null : info.getClient();
        if (clientSpec == null) {
            throw new VcsException(PerforceBundle.message("error.no.client.specifications.loaded", new Object[0]));
        }
        return clientSpec.getAllRoots();
    }

    @Override
    public MultiMap<P4Connection, VcsException> getErrors() {
        return this.myErrors;
    }

    @Override
    public boolean hasAnyErrors() {
        return !this.myMap.isEmpty() || !this.myErrors.isEmpty();
    }

    @Override
    public boolean hasNotAuthorized() {
        return !this.myNotAuthorized.isEmpty();
    }

    @Override
    public Map<P4Connection, PerforceAuthenticationException> getNotAuthorized() {
        return this.myNotAuthorized;
    }

    @Override
    public Map<P4Connection, WrongRoots> getMap() {
        return this.myMap;
    }

    @Override
    public boolean hasNoConnections() {
        return this.myHasNoConnections;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "infoAndClient";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "map";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/perforce/application/PerforceClientRootsChecker";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class WrongRoots {
        private final List<String> myActualInClientSpec;
        private final List<VirtualFile> myWrong;

        public WrongRoots(List<String> actualInClientSpec) {
            this.myActualInClientSpec = actualInClientSpec;
            this.myWrong = new ArrayList<VirtualFile>();
        }

        public void addWrong(VirtualFile file) {
            this.myWrong.add(file);
        }

        public List<String> getActualInClientSpec() {
            return this.myActualInClientSpec;
        }

        public List<VirtualFile> getWrong() {
            return this.myWrong;
        }
    }
}

