/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsConnectionProblem;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.Convertor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceRunnerI;

public class PerforceRunnerProxy {
    private static final Logger LOG = Logger.getInstance(PerforceRunnerProxy.class);
    private final Map<String, Convertor<Object[], String>> myMethodName;
    private final PerforceRunnerI myProxy;
    private final Project myProject;

    public PerforceRunnerProxy(Project project, PerforceRunner runner) {
        this.myProject = project;
        this.myProxy = (PerforceRunnerI)ReflectionUtil.proxy(PerforceRunnerI.class, (InvocationHandler)new MyPooledThreadProxy(runner));
        this.myMethodName = new HashMap<String, Convertor<Object[], String>>();
        this.fillNames();
    }

    private static String assumeFirstParamP4File(Object[] o) {
        if (o.length > 0 && o[0] instanceof P4File) {
            return ((P4File)o[0]).getLocalPath();
        }
        return "";
    }

    private void fillNames() {
        this.myMethodName.put("fstat", (Convertor<Object[], String>)((Convertor)o -> PerforceBundle.message("activity.retrieving.file.info", PerforceRunnerProxy.assumeFirstParamP4File(o))));
        this.myMethodName.put("edit", (Convertor<Object[], String>)((Convertor)o -> PerforceBundle.message("activity.opening.file", PerforceRunnerProxy.assumeFirstParamP4File(o))));
        this.myMethodName.put("revert", (Convertor<Object[], String>)((Convertor)o -> PerforceBundle.message("activity.reverting.file", PerforceRunnerProxy.assumeFirstParamP4File(o))));
        this.myMethodName.put("sync", (Convertor<Object[], String>)((Convertor)o -> PerforceBundle.message("activity.sync.view", new Object[0])));
    }

    public PerforceRunnerI getProxy() {
        return this.myProxy;
    }

    private class MyPooledThreadProxy
    implements InvocationHandler {
        private final PerforceRunnerI myDelegate;
        private final ProgressManager myProgressManager;
        private final Application myApplication;

        MyPooledThreadProxy(PerforceRunnerI delegate) {
            this.myDelegate = delegate;
            this.myProgressManager = ProgressManager.getInstance();
            this.myApplication = ApplicationManager.getApplication();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!PerforceRunnerI.class.isAssignableFrom(method.getDeclaringClass())) {
                LOG.info("Proxy used for wrong class's method invocation: " + method.getDeclaringClass().getCanonicalName());
                return null;
            }
            Convertor<Object[], String> getter = PerforceRunnerProxy.this.myMethodName.get(method.getName());
            String title = getter != null ? (String)getter.convert((Object)args) : PerforceBundle.message("activity.performing", new Object[0]);
            MyActuallyInvoked invoked = new MyActuallyInvoked(this.myDelegate, method, args);
            boolean bg = this.myApplication.isDispatchThread();
            if (bg) {
                this.myProgressManager.runProcessWithProgressSynchronously((Runnable)invoked, title, false, PerforceRunnerProxy.this.myProject);
            } else {
                invoked.run();
            }
            VcsException vcsException = invoked.getVcsException();
            if (vcsException != null) {
                throw vcsException instanceof VcsConnectionProblem || !bg ? vcsException : new VcsException((Throwable)vcsException);
            }
            RuntimeException runtimeException = invoked.getRuntimeException();
            if (runtimeException != null) {
                throw runtimeException;
            }
            return invoked.getResult();
        }
    }

    private static final class MyActuallyInvoked
    implements Runnable {
        private final Method myMethod;
        private final Object myProxy;
        private final Object[] myArgs;
        private VcsException myVcsException;
        private RuntimeException myRuntimeException;
        private Object myResult;

        private MyActuallyInvoked(Object proxy, Method method, Object[] args) {
            this.myMethod = method;
            this.myProxy = proxy;
            this.myArgs = args;
        }

        @Override
        public void run() {
            block5: {
                try {
                    this.myResult = this.myMethod.invoke(this.myProxy, this.myArgs);
                }
                catch (IllegalAccessException e) {
                    this.myRuntimeException = new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof VcsException) {
                        this.myVcsException = (VcsException)cause;
                    }
                    if (cause instanceof RuntimeException) {
                        this.myRuntimeException = (RuntimeException)cause;
                    }
                    if (cause == null) break block5;
                    this.myRuntimeException = new RuntimeException(cause);
                }
            }
        }

        public VcsException getVcsException() {
            return this.myVcsException;
        }

        public RuntimeException getRuntimeException() {
            return this.myRuntimeException;
        }

        public Object getResult() {
            return this.myResult;
        }
    }
}

