/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.accessibility;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.swing.text.JTextComponent;

public final class TextFieldWithListAccessibleContext
extends JTextComponent.AccessibleJTextComponent {
    private final AccessibleContext myListContext;
    private PropertyChangeSupport accessibleChangeSupport = null;

    public TextFieldWithListAccessibleContext(JTextComponent textComponent, AccessibleContext listContext) {
        super(textComponent);
        this.myListContext = listContext;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener2) {
        if (this.accessibleChangeSupport == null) {
            this.accessibleChangeSupport = new PropertyChangeSupport(this);
            super.addPropertyChangeListener(evt -> this.redirectEvent(evt));
            this.myListContext.addPropertyChangeListener(evt -> this.redirectEvent(evt));
        }
        this.accessibleChangeSupport.addPropertyChangeListener(listener2);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener2) {
        if (this.accessibleChangeSupport != null) {
            this.accessibleChangeSupport.removePropertyChangeListener(listener2);
        }
    }

    private void redirectEvent(PropertyChangeEvent evt) {
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.accessibleChangeSupport != null) {
            if (newValue instanceof PropertyChangeEvent) {
                PropertyChangeEvent pce = (PropertyChangeEvent)newValue;
                this.accessibleChangeSupport.firePropertyChange(pce);
            } else {
                this.accessibleChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
            }
        }
    }

    @Override
    public AccessibleStateSet getAccessibleStateSet() {
        AccessibleStateSet set = super.getAccessibleStateSet();
        set.addAll(this.myListContext.getAccessibleStateSet().toArray());
        return set;
    }

    @Override
    public int getAccessibleChildrenCount() {
        return this.myListContext.getAccessibleChildrenCount();
    }

    @Override
    public Accessible getAccessibleChild(int i2) {
        return this.myListContext.getAccessibleChild(i2);
    }

    @Override
    public AccessibleSelection getAccessibleSelection() {
        return this.myListContext.getAccessibleSelection();
    }

    @Override
    public AccessibleTable getAccessibleTable() {
        return this.myListContext.getAccessibleTable();
    }
}

