/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipLinkHandlerEP;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.TooltipEvent;
import com.intellij.internal.statistic.service.fus.collectors.TooltipActionsLogger;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.WidthBasedLayout;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineTooltipRenderer
extends ComparableObject.Impl
implements TooltipRenderer {
    public static final int CONTENT_PADDING = 20;
    protected @NlsContexts.Tooltip @Nullable String myText;
    protected final int myCurrentWidth;

    public LineTooltipRenderer(@NlsContexts.Tooltip @Nullable String text2, Object @NotNull [] comparable) {
        if (comparable == null) {
            LineTooltipRenderer.$$$reportNull$$$0(0);
        }
        this(text2, 0, comparable);
    }

    public LineTooltipRenderer(@NlsContexts.Tooltip @Nullable String text2, int width, Object @NotNull [] comparable) {
        if (comparable == null) {
            LineTooltipRenderer.$$$reportNull$$$0(1);
        }
        super(comparable);
        this.myCurrentWidth = width;
        this.myText = text2;
    }

    @NotNull
    private static JPanel createMainPanel(@NotNull HintHint hintHint, final @NotNull JScrollPane pane2, final @NotNull JEditorPane editorPane2, boolean highlightActions, boolean hasSeparators) {
        if (hintHint == null) {
            LineTooltipRenderer.$$$reportNull$$$0(2);
        }
        if (pane2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(3);
        }
        if (editorPane2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(4);
        }
        final int leftBorder = 20;
        final int rightBorder = 12;
        final class MyPanel
        extends JPanel
        implements WidthBasedLayout {
            private MyPanel() {
                super(new GridBagLayout());
            }

            public int getPreferredWidth() {
                return this.getPreferredSize().width;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int getPreferredHeight(int width) {
                int height;
                Dimension size2 = editorPane2.getSize();
                int editorPaneInsets = leftBorder + rightBorder + this.getSideComponentWidth();
                editorPane2.setSize(width - editorPaneInsets, Math.max(1, size2.height));
                try {
                    JScrollBar scrollBar;
                    height = this.getPreferredSize().height;
                    if (width - editorPaneInsets < editorPane2.getMinimumSize().width && (scrollBar = pane2.getHorizontalScrollBar()) != null) {
                        height += scrollBar.getPreferredSize().height;
                    }
                }
                finally {
                    editorPane2.setSize(size2);
                }
                return height;
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                return new AccessibleContextDelegate(editorPane2.getAccessibleContext()){

                    protected Container getDelegateParent() {
                        return this.getParent();
                    }
                };
            }

            private int getSideComponentWidth() {
                GridBagLayout layout2 = (GridBagLayout)this.getLayout();
                Component sideComponent = null;
                GridBagConstraints sideComponentConstraints = null;
                boolean unsupportedLayout = false;
                for (Component component2 : this.getComponents()) {
                    GridBagConstraints c = layout2.getConstraints(component2);
                    if (c.gridx <= 0) continue;
                    if (sideComponent == null && c.gridy == 0) {
                        sideComponent = component2;
                        sideComponentConstraints = c;
                        continue;
                    }
                    unsupportedLayout = true;
                }
                if (unsupportedLayout) {
                    Logger.getInstance(LineTooltipRenderer.class).error("Unsupported tooltip layout");
                }
                if (sideComponent == null) {
                    return 0;
                }
                Insets insets = sideComponentConstraints.insets;
                return sideComponent.getPreferredSize().width + (insets == null ? 0 : insets.left + insets.right);
            }
        }
        MyPanel grid = new MyPanel();
        GridBag bag = new GridBag().anchor(10).weightx(1.0).weighty(1.0).fillCell();
        pane2.setBorder((Border)JBUI.Borders.empty((int)10, (int)leftBorder, (int)(highlightActions ? 10 : (hasSeparators ? 8 : 3)), (int)rightBorder));
        grid.add((Component)pane2, bag);
        grid.setBackground(hintHint.getTextBackground());
        grid.setBorder((Border)JBUI.Borders.empty());
        grid.setOpaque(hintHint.isOpaqueAllowed());
        MyPanel myPanel = grid;
        if (myPanel == null) {
            LineTooltipRenderer.$$$reportNull$$$0(5);
        }
        return myPanel;
    }

    @Override
    public LightweightHint show(@NotNull Editor editor2, @NotNull Point p, boolean alignToRight, @NotNull TooltipGroup group2, @NotNull HintHint hintHint) {
        LightweightHint hint;
        if (editor2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(6);
        }
        if (p == null) {
            LineTooltipRenderer.$$$reportNull$$$0(7);
        }
        if (group2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(8);
        }
        if (hintHint == null) {
            LineTooltipRenderer.$$$reportNull$$$0(9);
        }
        if ((hint = this.createHint(editor2, p, alignToRight, group2, hintHint, true, true, null)) != null) {
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor2, p, 58, 0, false, hintHint);
        }
        return hint;
    }

    public LightweightHint createHint(final @NotNull Editor editor2, @NotNull Point p, boolean alignToRight, @NotNull TooltipGroup group2, @NotNull HintHint hintHint, boolean highlightActions, boolean limitWidthToScreen, @Nullable TooltipReloader tooltipReloader) {
        if (editor2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(10);
        }
        if (p == null) {
            LineTooltipRenderer.$$$reportNull$$$0(11);
        }
        if (group2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(12);
        }
        if (hintHint == null) {
            LineTooltipRenderer.$$$reportNull$$$0(13);
        }
        if (this.myText == null) {
            return null;
        }
        String tooltipPreText = this.myText.replaceAll(String.valueOf('\u001b'), "");
        String dressedText = this.dressDescription(editor2, tooltipPreText, this.myCurrentWidth > 0);
        final boolean expanded = this.myCurrentWidth > 0 && !dressedText.equals(tooltipPreText);
        final JComponent contentComponent = editor2.getContentComponent();
        JComponent editorComponent = editor2.getComponent();
        if (!editorComponent.isShowing()) {
            return null;
        }
        JLayeredPane layeredPane2 = editorComponent.getRootPane().getLayeredPane();
        String textToDisplay = LineTooltipRenderer.colorizeSeparators(dressedText);
        final JEditorPane editorPane2 = IdeTooltipManager.initPane(new Html(textToDisplay).setKeepFont(true), hintHint, layeredPane2, limitWidthToScreen);
        UIUtil.enableEagerSoftWrapping((JTextComponent)editorPane2);
        editorPane2.putClientProperty(UIUtil.TEXT_COPY_ROOT, Boolean.TRUE);
        hintHint.setContentActive(this.isContentAction(dressedText));
        if (!hintHint.isAwtTooltip()) {
            LineTooltipRenderer.correctLocation(editor2, editorPane2, p, alignToRight, expanded, this.myCurrentWidth);
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)editorPane2, (boolean)true);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setOpaque(hintHint.isOpaqueAllowed());
        scrollPane.getViewport().setOpaque(hintHint.isOpaqueAllowed());
        scrollPane.setBackground(hintHint.getTextBackground());
        scrollPane.getViewport().setBackground(hintHint.getTextBackground());
        scrollPane.setViewportBorder(null);
        if (hintHint.isRequestFocus()) {
            editorPane2.setFocusable(true);
        }
        final ArrayList<ReloadHintAction> actions = new ArrayList<ReloadHintAction>();
        JPanel grid = LineTooltipRenderer.createMainPanel(hintHint, scrollPane, editorPane2, highlightActions, !textToDisplay.equals(dressedText));
        if (ScreenReader.isActive()) {
            grid.setFocusTraversalPolicyProvider(true);
            grid.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

                @Override
                public Component getDefaultComponent(Container aContainer) {
                    return editorPane2;
                }

                @Override
                public boolean getImplicitDownCycleTraversal() {
                    return true;
                }
            });
        }
        final LightweightHint hint = new LightweightHint(grid){

            @Override
            public void hide() {
                super.hide();
                for (AnAction action2 : actions) {
                    action2.unregisterCustomShortcutSet(contentComponent);
                }
            }

            @Override
            protected boolean canAutoHideOn(TooltipEvent event) {
                if (!LineTooltipRenderer.this.canAutoHideOn(event)) {
                    return false;
                }
                return super.canAutoHideOn(event);
            }
        };
        final TooltipReloader reloader = tooltipReloader == null ? toExpand -> this.reloadFor(hint, editor2, p, editorPane2, alignToRight, group2, hintHint, toExpand) : tooltipReloader;
        ReloadHintAction reloadAction = new ReloadHintAction(hintHint, reloader, expanded);
        reloadAction.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"ShowErrorDescription"), contentComponent);
        actions.add(reloadAction);
        editorPane2.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    return;
                }
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL url = e.getURL();
                    if (url != null) {
                        BrowserUtil.browse((URL)url);
                        hint.hide();
                        return;
                    }
                    String description = e.getDescription();
                    if (description != null && ((Boolean)WriteIntentReadAction.compute(() -> LineTooltipRenderer.handle(description, editor2))).booleanValue()) {
                        hint.hide();
                        return;
                    }
                    TooltipActionsLogger.logShowDescription((Project)editor2.getProject(), (TooltipActionsLogger.Source)TooltipActionsLogger.Source.MoreLink, (InputEvent)e.getInputEvent(), null);
                    reloader.reload(!expanded);
                }
            }
        });
        this.fillPanel(editor2, grid, hint, hintHint, actions, reloader, highlightActions);
        return hint;
    }

    @Contract(pure=true)
    @NotNull
    private static String colorizeSeparators(@NotNull String html) {
        String body;
        List parts;
        if (html == null) {
            LineTooltipRenderer.$$$reportNull$$$0(14);
        }
        if ((parts = StringUtil.split((String)(body = UIUtil.getHtmlBody((String)html)), (String)"<hr size=1 noshade>", (boolean)true, (boolean)false)).size() <= 1) {
            String string = html;
            if (string == null) {
                LineTooltipRenderer.$$$reportNull$$$0(15);
            }
            return string;
        }
        StringBuilder b = new StringBuilder();
        for (String part : parts) {
            boolean addBorder = !b.isEmpty();
            b.append("<div");
            if (addBorder) {
                b.append(" style='margin-top:6; padding-top:6; border-top: thin solid #");
                b.append(ColorUtil.toHex((Color)UIUtil.getTooltipSeparatorColor()));
                b.append("'");
            }
            b.append("'>").append(part).append("</div>");
        }
        String string = XmlStringUtil.wrapInHtml((CharSequence)b.toString());
        if (string == null) {
            LineTooltipRenderer.$$$reportNull$$$0(16);
        }
        return string;
    }

    protected boolean isContentAction(@NotNull String dressedText) {
        if (dressedText == null) {
            LineTooltipRenderer.$$$reportNull$$$0(17);
        }
        return LineTooltipRenderer.isActiveHtml(dressedText);
    }

    protected boolean canAutoHideOn(@NotNull TooltipEvent event) {
        if (event == null) {
            LineTooltipRenderer.$$$reportNull$$$0(18);
        }
        return true;
    }

    private void reloadFor(@NotNull LightweightHint hint, @NotNull Editor editor2, @NotNull Point p, @NotNull JComponent pane2, boolean alignToRight, @NotNull TooltipGroup group2, @NotNull HintHint hintHint, boolean expand) {
        if (hint == null) {
            LineTooltipRenderer.$$$reportNull$$$0(19);
        }
        if (editor2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(20);
        }
        if (p == null) {
            LineTooltipRenderer.$$$reportNull$$$0(21);
        }
        if (pane2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(22);
        }
        if (group2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(23);
        }
        if (hintHint == null) {
            LineTooltipRenderer.$$$reportNull$$$0(24);
        }
        hint.hide();
        hintHint.setShowImmediately(true);
        Point point = new Point(p);
        TooltipController.getInstance().showTooltip(editor2, point, this.createRenderer(this.myText, expand ? pane2.getWidth() : 0), alignToRight, group2, hintHint);
    }

    protected void fillPanel(@NotNull Editor editor2, @NotNull JPanel component2, @NotNull LightweightHint hint, @NotNull HintHint hintHint, @NotNull List<? super AnAction> actions, @NotNull TooltipReloader expandCallback, boolean highlightActions) {
        if (editor2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(25);
        }
        if (component2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(26);
        }
        if (hint == null) {
            LineTooltipRenderer.$$$reportNull$$$0(27);
        }
        if (hintHint == null) {
            LineTooltipRenderer.$$$reportNull$$$0(28);
        }
        if (actions == null) {
            LineTooltipRenderer.$$$reportNull$$$0(29);
        }
        if (expandCallback == null) {
            LineTooltipRenderer.$$$reportNull$$$0(30);
        }
        if (!ExperimentalUI.isNewUI()) {
            hintHint.setComponentBorder((Border)JBUI.Borders.empty());
            hintHint.setBorderInsets((Insets)JBUI.emptyInsets());
        }
    }

    private static boolean handle(@NotNull String ref2, @NotNull Editor editor2) {
        if (ref2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(31);
        }
        if (editor2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(32);
        }
        return TooltipLinkHandlerEP.handleLink(ref2, editor2);
    }

    private static void correctLocation(@NotNull Editor editor2, @NotNull JComponent tooltipComponent, @NotNull Point p, boolean alignToRight, boolean expanded, int currentWidth) {
        if (editor2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(33);
        }
        if (tooltipComponent == null) {
            LineTooltipRenderer.$$$reportNull$$$0(34);
        }
        if (p == null) {
            LineTooltipRenderer.$$$reportNull$$$0(35);
        }
        JComponent editorComponent = editor2.getComponent();
        JLayeredPane layeredPane2 = editorComponent.getRootPane().getLayeredPane();
        int widthLimit = layeredPane2.getWidth() - 10;
        int heightLimit = layeredPane2.getHeight() - 5;
        Dimension dimension = LineTooltipRenderer.correctLocation(editor2, p, alignToRight, expanded, tooltipComponent, layeredPane2, widthLimit, heightLimit, currentWidth);
        tooltipComponent.setSize(dimension);
        tooltipComponent.setMaximumSize(dimension);
        tooltipComponent.setMinimumSize(dimension);
        tooltipComponent.setPreferredSize(dimension);
    }

    @NotNull
    private static Dimension correctLocation(@NotNull Editor editor2, @NotNull Point p, boolean alignToRight, boolean expanded, @NotNull JComponent tooltipComponent, @NotNull JLayeredPane layeredPane2, int widthLimit, int heightLimit, int currentWidth) {
        if (editor2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(36);
        }
        if (p == null) {
            LineTooltipRenderer.$$$reportNull$$$0(37);
        }
        if (tooltipComponent == null) {
            LineTooltipRenderer.$$$reportNull$$$0(38);
        }
        if (layeredPane2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(39);
        }
        Dimension preferredSize = tooltipComponent.getPreferredSize();
        int width = expanded ? 3 * currentWidth / 2 : preferredSize.width;
        int height = expanded ? Math.max(preferredSize.height, 150) : preferredSize.height;
        Dimension dimension = new Dimension(width, height);
        if (alignToRight) {
            p.x = Math.max(0, p.x - width);
        }
        p.x += 3;
        p.y += 3;
        if (p.x >= widthLimit - width) {
            p.x = widthLimit - width;
            width = Math.min(width, widthLimit);
            dimension = new Dimension(width, height += 20);
        }
        if (p.x < 3) {
            p.x = 3;
        }
        if (p.y > heightLimit - height) {
            p.y = heightLimit - height;
            height = Math.min(heightLimit, height);
            dimension = new Dimension(width, height);
        }
        if (p.y < 3) {
            p.y = 3;
        }
        LineTooltipRenderer.locateOutsideMouseCursor(editor2, layeredPane2, p, width, height, heightLimit);
        Dimension dimension2 = dimension;
        if (dimension2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(40);
        }
        return dimension2;
    }

    private static void locateOutsideMouseCursor(@NotNull Editor editor2, @NotNull JComponent editorComponent, @NotNull Point p, int width, int height, int heightLimit) {
        PointerInfo pointerInfo;
        if (editor2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(41);
        }
        if (editorComponent == null) {
            LineTooltipRenderer.$$$reportNull$$$0(42);
        }
        if (p == null) {
            LineTooltipRenderer.$$$reportNull$$$0(43);
        }
        if ((pointerInfo = MouseInfo.getPointerInfo()) == null) {
            return;
        }
        Point mouse = pointerInfo.getLocation();
        SwingUtilities.convertPointFromScreen(mouse, editorComponent);
        Rectangle tooltipRect = new Rectangle(p, new Dimension(width, height));
        tooltipRect.setBounds(tooltipRect.x, tooltipRect.y - editor2.getLineHeight(), width, height + 2 * editor2.getLineHeight());
        if (tooltipRect.contains(mouse)) {
            p.y = mouse.y + height + editor2.getLineHeight() > heightLimit && mouse.y - height - editor2.getLineHeight() > 0 ? mouse.y - height - editor2.getLineHeight() : mouse.y + editor2.getLineHeight();
        }
    }

    @NotNull
    public LineTooltipRenderer createRenderer(@NlsContexts.Tooltip @Nullable String text2, int width) {
        return new LineTooltipRenderer(text2, width, this.getEqualityObjects());
    }

    @NlsContexts.Tooltip
    @NotNull
    protected String dressDescription(@NotNull Editor editor2, @NlsContexts.Tooltip @NotNull String tooltipText, boolean expanded) {
        if (editor2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(44);
        }
        if (tooltipText == null) {
            LineTooltipRenderer.$$$reportNull$$$0(45);
        }
        String string = tooltipText;
        if (string == null) {
            LineTooltipRenderer.$$$reportNull$$$0(46);
        }
        return string;
    }

    protected static boolean isActiveHtml(@NotNull String html) {
        if (html == null) {
            LineTooltipRenderer.$$$reportNull$$$0(47);
        }
        return html.contains("</a>");
    }

    public void addBelow(@NotNull String text2) {
        Object newBody;
        if (text2 == null) {
            LineTooltipRenderer.$$$reportNull$$$0(48);
        }
        if (this.myText == null) {
            newBody = UIUtil.getHtmlBody((String)text2);
        } else {
            String html1 = UIUtil.getHtmlBody((String)this.myText);
            String html2 = UIUtil.getHtmlBody((String)text2);
            newBody = html1 + "<hr size=1 noshade>" + html2;
        }
        this.myText = XmlStringUtil.wrapInHtml((CharSequence)newBody);
    }

    @NlsContexts.Tooltip
    @Nullable
    public String getText() {
        return this.myText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 15, 16, 40, 46 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparable";
                break;
            }
            case 2: 
            case 9: 
            case 13: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintHint";
                break;
            }
            case 3: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorPane";
                break;
            }
            case 5: 
            case 15: 
            case 16: 
            case 40: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hint/LineTooltipRenderer";
                break;
            }
            case 6: 
            case 10: 
            case 20: 
            case 25: 
            case 32: 
            case 33: 
            case 36: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: 
            case 11: 
            case 21: 
            case 35: 
            case 37: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 8: 
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 14: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dressedText";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 19: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expandCallback";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipComponent";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layeredPane";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorComponent";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipText";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hint/LineTooltipRenderer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainPanel";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "colorizeSeparators";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "correctLocation";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "dressDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createMainPanel";
                break;
            }
            case 5: 
            case 15: 
            case 16: 
            case 40: 
            case 46: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createHint";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "colorizeSeparators";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isContentAction";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "canAutoHideOn";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "reloadFor";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "fillPanel";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "handle";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "correctLocation";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "locateOutsideMouseCursor";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "dressDescription";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isActiveHtml";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "addBelow";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 15, 16, 40, 46 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    public static interface TooltipReloader {
        public void reload(boolean var1);
    }

    private static final class ReloadHintAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        @NotNull
        private final HintHint myHintHint;
        @NotNull
        private final TooltipReloader myReloader;
        private final boolean myExpanded;

        private ReloadHintAction(@NotNull HintHint hintHint, @NotNull TooltipReloader reloader, boolean expanded) {
            if (hintHint == null) {
                ReloadHintAction.$$$reportNull$$$0(0);
            }
            if (reloader == null) {
                ReloadHintAction.$$$reportNull$$$0(1);
            }
            this.myHintHint = hintHint;
            this.myReloader = reloader;
            this.myExpanded = expanded;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ReloadHintAction.$$$reportNull$$$0(2);
            }
            this.myHintHint.setRequestFocus(ScreenReader.isActive() && e.getInputEvent() instanceof KeyEvent);
            TooltipActionsLogger.logShowDescription((Project)e.getProject(), (TooltipActionsLogger.Source)TooltipActionsLogger.Source.Shortcut, (InputEvent)e.getInputEvent(), (String)e.getPlace());
            this.myReloader.reload(!this.myExpanded);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hintHint";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reloader";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/hint/LineTooltipRenderer$ReloadHintAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

