/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.IdeaLogRecordFormatter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class LogMessage
extends AbstractMessage {
    private final Throwable myThrowable;
    private final String myMessage;
    private final List<Attachment> myAttachments;

    public LogMessage(@NotNull Throwable throwable, @Nullable String message, @NotNull List<Attachment> attachments) {
        if (throwable == null) {
            LogMessage.$$$reportNull$$$0(0);
        }
        if (attachments == null) {
            LogMessage.$$$reportNull$$$0(1);
        }
        this.myThrowable = ThrowableInterner.intern((Throwable)throwable);
        String str = message;
        if (str != null && throwable.getMessage() != null && !Strings.areSameInstance((String)(str = Strings.trimStart((String)str, (String)throwable.getMessage())), (String)message)) {
            str = Strings.trimStart((String)str, (String)": ");
        }
        if ("null".equals(str)) {
            str = null;
        }
        this.myMessage = Strings.nullize((String)str, (boolean)true);
        this.myAttachments = new ArrayList<Attachment>(ContainerUtil.filter(attachments, attachment -> attachment != null));
    }

    @Override
    @NotNull
    public Throwable getThrowable() {
        Throwable throwable = this.myThrowable;
        if (throwable == null) {
            LogMessage.$$$reportNull$$$0(2);
        }
        return throwable;
    }

    @Override
    @NotNull
    public String getThrowableText() {
        String string = IdeaLogRecordFormatter.formatThrowable((Throwable)this.myThrowable);
        if (string == null) {
            LogMessage.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getMessage() {
        return this.myMessage != null ? this.myMessage : "";
    }

    @Override
    @NotNull
    public List<Attachment> getAllAttachments() {
        List<Attachment> list2 = Collections.unmodifiableList(this.myAttachments);
        if (list2 == null) {
            LogMessage.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Deprecated(forRemoval=true)
    public static IdeaLoggingEvent eventOf(@NotNull Throwable throwable, @Nullable String userMessage, @NotNull @NotNull List<@NotNull Attachment> attachments) {
        if (throwable == null) {
            LogMessage.$$$reportNull$$$0(5);
        }
        if (attachments == null) {
            LogMessage.$$$reportNull$$$0(6);
        }
        return new IdeaLoggingEvent(userMessage, throwable, (Object)new LogMessage(throwable, userMessage, attachments));
    }

    @Deprecated(forRemoval=true)
    public static IdeaLoggingEvent createEvent(@NotNull Throwable throwable, @Nullable String userMessage, Attachment ... attachments) {
        if (throwable == null) {
            LogMessage.$$$reportNull$$$0(7);
        }
        if (attachments == null) {
            LogMessage.$$$reportNull$$$0(8);
        }
        return new IdeaLoggingEvent(userMessage, throwable, (Object)new LogMessage(throwable, userMessage, List.of(attachments)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachments";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/LogMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/LogMessage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAttachments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "eventOf";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createEvent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

