/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ijent.nio;

import com.intellij.openapi.util.io.CaseSensitivityAttribute;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.platform.eel.EelUserPosixInfo;
import com.intellij.platform.ijent.community.impl.nio.EelPosixGroupPrincipal;
import com.intellij.platform.ijent.community.impl.nio.EelPosixUserPrincipal;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\t\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0011\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012H\u0096\u0001J\u0011\u0010\u0014\u001a\n \u0013*\u0004\u0018\u00010\u00150\u0015H\u0096\u0001J\u0011\u0010\u0016\u001a\n \u0013*\u0004\u0018\u00010\u00170\u0017H\u0096\u0001J\t\u0010\u0018\u001a\u00020\bH\u0096\u0001J\t\u0010\u0019\u001a\u00020\bH\u0096\u0001J\t\u0010\u001a\u001a\u00020\bH\u0096\u0001J\t\u0010\u001b\u001a\u00020\bH\u0096\u0001J\u0011\u0010\u001c\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012H\u0096\u0001J\u0011\u0010\u001d\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012H\u0096\u0001J\u0011\u0010\u001e\u001a\n \u0013*\u0004\u0018\u00010\u001f0\u001fH\u0096\u0001J-\u0010 \u001a&\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\"0\" \u0013*\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\"0\"\u0018\u00010#0!H\u0096\u0001J\t\u0010$\u001a\u00020%H\u0096\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/execution/ijent/nio/IjentNioPosixFileAttributesWithDosAdapter;", "Lcom/intellij/openapi/util/io/CaseSensitivityAttribute;", "Ljava/nio/file/attribute/PosixFileAttributes;", "Ljava/nio/file/attribute/DosFileAttributes;", "userInfo", "Lcom/intellij/platform/eel/EelUserPosixInfo;", "fileInfo", "nameStartsWithDot", "", "<init>", "(Lcom/intellij/platform/eel/EelUserPosixInfo;Ljava/nio/file/attribute/PosixFileAttributes;Z)V", "isReadOnly", "isHidden", "isArchive", "isSystem", "getCaseSensitivity", "Lcom/intellij/openapi/util/io/FileAttributes$CaseSensitivity;", "creationTime", "Ljava/nio/file/attribute/FileTime;", "kotlin.jvm.PlatformType", "fileKey", "", "group", "Ljava/nio/file/attribute/GroupPrincipal;", "isDirectory", "isOther", "isRegularFile", "isSymbolicLink", "lastAccessTime", "lastModifiedTime", "owner", "Ljava/nio/file/attribute/UserPrincipal;", "permissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "", "size", "", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class IjentNioPosixFileAttributesWithDosAdapter
implements CaseSensitivityAttribute,
PosixFileAttributes,
DosFileAttributes {
    @NotNull
    private final EelUserPosixInfo userInfo;
    @NotNull
    private final PosixFileAttributes fileInfo;
    private final boolean nameStartsWithDot;

    public IjentNioPosixFileAttributesWithDosAdapter(@NotNull EelUserPosixInfo userInfo, @NotNull PosixFileAttributes fileInfo, boolean nameStartsWithDot) {
        Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        this.userInfo = userInfo;
        this.fileInfo = fileInfo;
        this.nameStartsWithDot = nameStartsWithDot;
    }

    @Override
    public boolean isReadOnly() {
        PosixFileAttributes $this$isReadOnly_u24lambda_u240 = this.fileInfo;
        boolean bl = false;
        UserPrincipal owner = $this$isReadOnly_u24lambda_u240.owner();
        GroupPrincipal group2 = $this$isReadOnly_u24lambda_u240.group();
        return this.userInfo.getUid() == 0 && owner instanceof EelPosixUserPrincipal && ((EelPosixUserPrincipal)owner).getUid() != 0 ? $this$isReadOnly_u24lambda_u240.isDirectory() : (owner instanceof EelPosixUserPrincipal && ((EelPosixUserPrincipal)owner).getUid() == this.userInfo.getUid() ? !$this$isReadOnly_u24lambda_u240.permissions().contains((Object)PosixFilePermission.OWNER_WRITE) || $this$isReadOnly_u24lambda_u240.isDirectory() && !$this$isReadOnly_u24lambda_u240.permissions().contains((Object)PosixFilePermission.OWNER_EXECUTE) : (group2 instanceof EelPosixGroupPrincipal && ((EelPosixGroupPrincipal)group2).getGid() == this.userInfo.getGid() ? !$this$isReadOnly_u24lambda_u240.permissions().contains((Object)PosixFilePermission.GROUP_WRITE) || $this$isReadOnly_u24lambda_u240.isDirectory() && !$this$isReadOnly_u24lambda_u240.permissions().contains((Object)PosixFilePermission.GROUP_EXECUTE) : !$this$isReadOnly_u24lambda_u240.permissions().contains((Object)PosixFilePermission.OTHERS_WRITE) || $this$isReadOnly_u24lambda_u240.isDirectory() && !$this$isReadOnly_u24lambda_u240.permissions().contains((Object)PosixFilePermission.OTHERS_EXECUTE)));
    }

    @Override
    public boolean isHidden() {
        return this.nameStartsWithDot;
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    public boolean isSystem() {
        return false;
    }

    @NotNull
    public FileAttributes.CaseSensitivity getCaseSensitivity() {
        if (this.fileInfo instanceof CaseSensitivityAttribute) {
            FileAttributes.CaseSensitivity caseSensitivity = ((CaseSensitivityAttribute)this.fileInfo).getCaseSensitivity();
            Intrinsics.checkNotNullExpressionValue((Object)caseSensitivity, (String)"getCaseSensitivity(...)");
            return caseSensitivity;
        }
        return FileAttributes.CaseSensitivity.UNKNOWN;
    }

    @Override
    public FileTime lastModifiedTime() {
        return this.fileInfo.lastModifiedTime();
    }

    @Override
    public FileTime lastAccessTime() {
        return this.fileInfo.lastAccessTime();
    }

    @Override
    public FileTime creationTime() {
        return this.fileInfo.creationTime();
    }

    @Override
    public boolean isRegularFile() {
        return this.fileInfo.isRegularFile();
    }

    @Override
    public boolean isDirectory() {
        return this.fileInfo.isDirectory();
    }

    @Override
    public boolean isSymbolicLink() {
        return this.fileInfo.isSymbolicLink();
    }

    @Override
    public boolean isOther() {
        return this.fileInfo.isOther();
    }

    @Override
    public long size() {
        return this.fileInfo.size();
    }

    @Override
    public Object fileKey() {
        return this.fileInfo.fileKey();
    }

    @Override
    public UserPrincipal owner() {
        return this.fileInfo.owner();
    }

    @Override
    public GroupPrincipal group() {
        return this.fileInfo.group();
    }

    @Override
    public Set<PosixFilePermission> permissions() {
        return this.fileInfo.permissions();
    }
}

