/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.CliResult;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.LightEditorListener;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.messages.MessageBusConnection;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
public final class CommandLineWaitingManager {
    private static final Logger LOG = Logger.getInstance(CommandLineWaitingManager.class);
    private static final String DO_NOT_SHOW_KEY = "command.line.waiting.do.not.show";
    private final Map<Object, CompletableFuture<CliResult>> myFileOrProjectToCallback = Collections.synchronizedMap(new HashMap());
    private final Set<Object> myDismissedObjects = Collections.synchronizedSet(new HashSet());

    private CommandLineWaitingManager() {
        MessageBusConnection busConnection = ApplicationManager.getApplication().getMessageBus().connect();
        busConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                CommandLineWaitingManager.this.freeObject(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/CommandLineWaitingManager$1";
                objectArray[2] = "fileClosed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        LightEditService.getInstance().getEditorManager().addListener(new LightEditorListener(){

            public void afterClose(@NotNull LightEditorInfo editorInfo) {
                if (editorInfo == null) {
                    2.$$$reportNull$$$0(0);
                }
                CommandLineWaitingManager.this.freeObject(editorInfo.getFile());
                Path path = editorInfo.getPreferredSavePath();
                if (path != null) {
                    CommandLineWaitingManager.this.freeObject(path);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorInfo", "com/intellij/ide/CommandLineWaitingManager$2", "afterClose"));
            }
        });
        busConnection.subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(){

            public void projectClosed(@NotNull Project project2) {
                if (project2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                CommandLineWaitingManager.this.freeObject(project2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/CommandLineWaitingManager$3", "projectClosed"));
            }
        });
    }

    @NotNull
    public CompletableFuture<CliResult> addHookForPath(@NotNull Path path) {
        if (path == null) {
            CommandLineWaitingManager.$$$reportNull$$$0(0);
        }
        return this.addHookAndNotify(path, IdeBundle.message((String)"activation.file.is.waiting.notification", (Object[])new Object[]{path.toString()}));
    }

    @NotNull
    public static CommandLineWaitingManager getInstance() {
        CommandLineWaitingManager commandLineWaitingManager = (CommandLineWaitingManager)ApplicationManager.getApplication().getService(CommandLineWaitingManager.class);
        if (commandLineWaitingManager == null) {
            CommandLineWaitingManager.$$$reportNull$$$0(1);
        }
        return commandLineWaitingManager;
    }

    @NotNull
    public CompletableFuture<CliResult> addHookForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            CommandLineWaitingManager.$$$reportNull$$$0(2);
        }
        return this.addHookAndNotify(file2, IdeBundle.message((String)"activation.file.is.waiting.notification", (Object[])new Object[]{file2.getPath()}));
    }

    @NotNull
    public CompletableFuture<CliResult> addHookForProject(@NotNull Project project2) {
        if (project2 == null) {
            CommandLineWaitingManager.$$$reportNull$$$0(3);
        }
        return this.addHookAndNotify(project2, IdeBundle.message((String)"activation.project.is.waiting.notification", (Object[])new Object[]{project2.getName()}));
    }

    @NotNull
    private CompletableFuture<CliResult> addHookAndNotify(@NotNull Object fileOrProject, @NlsContexts.NotificationContent @NotNull String notificationText) {
        if (fileOrProject == null) {
            CommandLineWaitingManager.$$$reportNull$$$0(4);
        }
        if (notificationText == null) {
            CommandLineWaitingManager.$$$reportNull$$$0(5);
        }
        LOG.info(notificationText);
        CompletableFuture<CliResult> result2 = new CompletableFuture<CliResult>();
        this.myFileOrProjectToCallback.put(fileOrProject, result2);
        Notifications.Bus.notify((Notification)new Notification("System Messages", IdeBundle.message((String)"notification.title.activated.from.command.line", (Object[])new Object[0]), notificationText, NotificationType.WARNING).setImportant(true));
        EditorNotifications.updateAll();
        CompletableFuture<CliResult> completableFuture = result2;
        if (completableFuture == null) {
            CommandLineWaitingManager.$$$reportNull$$$0(6);
        }
        return completableFuture;
    }

    public boolean hasHookFor(@NotNull VirtualFile file2) {
        Path path;
        if (file2 == null) {
            CommandLineWaitingManager.$$$reportNull$$$0(7);
        }
        if ((path = LightEditUtil.getPreferredSavePathForNonExistentFile(file2)) != null && this.myFileOrProjectToCallback.containsKey(path)) {
            return true;
        }
        return this.myFileOrProjectToCallback.containsKey(file2);
    }

    private void freeObject(@NotNull Object fileOrProject) {
        if (fileOrProject == null) {
            CommandLineWaitingManager.$$$reportNull$$$0(8);
        }
        this.myDismissedObjects.remove(fileOrProject);
        CompletableFuture<CliResult> future = this.myFileOrProjectToCallback.remove(fileOrProject);
        if (future == null) {
            return;
        }
        LOG.debug("Finished waiting for the " + String.valueOf(fileOrProject));
        future.complete(CliResult.OK);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/CommandLineWaitingManager";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrProject";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/CommandLineWaitingManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addHookAndNotify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addHookForPath";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addHookForFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addHookForProject";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addHookAndNotify";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasHookFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "freeObject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6 -> new IllegalStateException(string);
        };
    }

    private static final class MyNotificationPanel
    extends EditorNotificationPanel {
        private MyNotificationPanel(@NotNull VirtualFile virtualFile2) {
            if (virtualFile2 == null) {
                MyNotificationPanel.$$$reportNull$$$0(0);
            }
            super(EditorColors.GUTTER_BACKGROUND, EditorNotificationPanel.Status.Info);
            this.setText(IdeBundle.message((String)"activation.file.is.waiting.title", (Object[])new Object[0]));
            this.createActionLabel(IdeBundle.message((String)"activation.file.is.waiting.release", (Object[])new Object[0]), () -> {
                Document document2 = FileDocumentManager.getInstance().getDocument(virtualFile2);
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (document2 != null) {
                        FileDocumentManager.getInstance().saveDocument(document2);
                    } else {
                        FileDocumentManager.getInstance().saveAllDocuments();
                    }
                });
                CommandLineWaitingManager.getInstance().freeObject(virtualFile2);
                EditorNotifications.updateAll();
            });
            this.createActionLabel(IdeBundle.message((String)"activation.file.is.waiting.do.not.show", (Object[])new Object[0]), () -> {
                PropertiesComponent.getInstance().setValue(CommandLineWaitingManager.DO_NOT_SHOW_KEY, true);
                EditorNotifications.updateAll();
            });
            this.createActionLabel(IdeBundle.message((String)"activation.file.is.waiting.dismiss", (Object[])new Object[0]), () -> {
                CommandLineWaitingManager.getInstance().myDismissedObjects.add(virtualFile2);
                EditorNotifications.updateAll();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/ide/CommandLineWaitingManager$MyNotificationPanel", "<init>"));
        }
    }

    static final class MyNotification
    implements EditorNotificationProvider,
    DumbAware {
        MyNotification() {
        }

        @Nullable
        public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project2, @NotNull VirtualFile file2) {
            if (project2 == null) {
                MyNotification.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                MyNotification.$$$reportNull$$$0(1);
            }
            if (PropertiesComponent.getInstance().getBoolean(CommandLineWaitingManager.DO_NOT_SHOW_KEY, false)) {
                return null;
            }
            CommandLineWaitingManager manager2 = (CommandLineWaitingManager)ApplicationManager.getApplication().getServiceIfCreated(CommandLineWaitingManager.class);
            if (manager2 == null || !manager2.hasHookFor(file2) || manager2.myDismissedObjects.contains(file2)) {
                return null;
            }
            return fileEditor -> new MyNotificationPanel(file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/CommandLineWaitingManager$MyNotification";
            objectArray[2] = "collectNotificationData";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

