/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.ide.ui.UISettingsUtilsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.impl.zoomIndicator.ZoomIndicatorManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.layout.ValidationInfoBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0001\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\r\u0010\u000e\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u000fJ\b\u0010\u0010\u001a\u00020\fH\u0002J\b\u0010\u0011\u001a\u00020\fH\u0002J\b\u0010\u0012\u001a\u00020\fH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/actions/IdeScaleTransformer;", "", "<init>", "()V", "settingsUtils", "Lcom/intellij/ide/ui/UISettingsUtils;", "getSettingsUtils", "()Lcom/intellij/ide/ui/UISettingsUtils;", "lastSetScale", "", "Ljava/lang/Float;", "uiSettingsChanged", "", "uiSettingsChanged$intellij_platform_ide_impl", "setupLastSetScale", "setupLastSetScale$intellij_platform_ide_impl", "scale", "tweakEditorFont", "notifyAllAndUpdateUI", "Settings", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nIdeScaleTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeScaleTransformer.kt\ncom/intellij/ide/actions/IdeScaleTransformer\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,192:1\n55#2:193\n*S KotlinDebug\n*F\n+ 1 IdeScaleTransformer.kt\ncom/intellij/ide/actions/IdeScaleTransformer\n*L\n63#1:193\n*E\n"})
public final class IdeScaleTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Float lastSetScale;

    private final UISettingsUtils getSettingsUtils() {
        return UISettingsUtils.Companion.getInstance();
    }

    public final void uiSettingsChanged$intellij_platform_ide_impl() {
        Float f = this.lastSetScale;
        if (!(f != null ? UISettingsUtilsKt.getPercentValue((float)f.floatValue()) == UISettingsUtilsKt.getPercentValue((float)this.getSettingsUtils().getCurrentIdeScale()) : false)) {
            this.scale();
        }
    }

    public final void setupLastSetScale$intellij_platform_ide_impl() {
        if (this.lastSetScale == null) {
            this.lastSetScale = Float.valueOf(this.getSettingsUtils().getCurrentIdeScale());
        }
    }

    private final void scale() {
        this.lastSetScale = Float.valueOf(this.getSettingsUtils().getCurrentIdeScale());
        this.tweakEditorFont();
        this.notifyAllAndUpdateUI();
    }

    private final void tweakEditorFont() {
        Editor[] editorArray = EditorFactory.getInstance().getAllEditors();
        Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getAllEditors(...)");
        for (Editor editor2 : editorArray) {
            if (!(editor2 instanceof EditorEx) || ((EditorEx)editor2).isDisposed()) continue;
            ((EditorEx)editor2).putUserData(ZoomIndicatorManager.SUPPRESS_ZOOM_INDICATOR_ONCE, true);
            ((EditorEx)editor2).setFontSize(((EditorEx)editor2).getEditorKind() == EditorKind.CONSOLE ? this.getSettingsUtils().getScaledConsoleFontSize() : this.getSettingsUtils().getScaledEditorFontSize());
        }
    }

    private final void notifyAllAndUpdateUI() {
        boolean $i$f$serviceIfCreated = false;
        Application application = ApplicationManager.getApplication();
        LafManager lafManager = (LafManager)(application != null ? application.getServiceIfCreated(LafManager.class) : null);
        if (lafManager != null) {
            lafManager.updateUI();
        }
        EditorUtil.reinitSettings();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ide/actions/IdeScaleTransformer$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ide/actions/IdeScaleTransformer;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nIdeScaleTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeScaleTransformer.kt\ncom/intellij/ide/actions/IdeScaleTransformer$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,192:1\n42#2,3:193\n*S KotlinDebug\n*F\n+ 1 IdeScaleTransformer.kt\ncom/intellij/ide/actions/IdeScaleTransformer$Companion\n*L\n176#1:193,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IdeScaleTransformer getInstance() {
            boolean $i$f$service = false;
            Class<IdeScaleTransformer> serviceClass$iv = IdeScaleTransformer.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (IdeScaleTransformer)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ide/actions/IdeScaleTransformer$Settings;", "", "<init>", "()V", "Companion", "intellij.platform.ide.impl"})
    public static final class Settings {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private static final float SCALING_STEP = 0.1f;
        private static final float PRESENTATION_MODE_MIN_SCALE = 0.5f;
        private static final float PRESENTATION_MODE_MAX_SCALE = 4.0f;
        @NotNull
        private static final List<Float> ideScaleOptions;
        @NotNull
        private static final List<Float> presentationModeScaleOptions;

        static {
            Object[] objectArray = new Float[]{Float.valueOf(0.7f), Float.valueOf(0.8f), Float.valueOf(0.9f), Float.valueOf(1.0f), Float.valueOf(1.1f), Float.valueOf(1.25f), Float.valueOf(1.5f), Float.valueOf(1.75f), Float.valueOf(2.0f)};
            ideScaleOptions = CollectionsKt.listOf((Object[])objectArray);
            objectArray = new Float[]{Float.valueOf(1.0f), Float.valueOf(1.1f), Float.valueOf(1.25f), Float.valueOf(1.5f), Float.valueOf(1.75f), Float.valueOf(2.0f), Float.valueOf(2.25f), Float.valueOf(2.5f), Float.valueOf(2.75f), Float.valueOf(3.0f)};
            presentationModeScaleOptions = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J&\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u001a2\u0006\u0010\u000f\u001a\u00020\u0010J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001d\u001a\u00020\u0005H\u0003J!\u0010\u001e\u001a\u0004\u0018\u00010\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010\u00132\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010 J\r\u0010!\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\"J\r\u0010#\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\"J'\u0010$\u001a\u0004\u0018\u00010\u00052\u0006\u0010%\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010&J\u001e\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006)"}, d2={"Lcom/intellij/ide/actions/IdeScaleTransformer$Settings$Companion;", "", "<init>", "()V", "SCALING_STEP", "", "PRESENTATION_MODE_MIN_SCALE", "PRESENTATION_MODE_MAX_SCALE", "ideScaleOptions", "", "presentationModeScaleOptions", "currentScaleOptions", "getCurrentScaleOptions", "()Ljava/util/List;", "scaleOptions", "isPresentation", "", "createIdeScaleComboboxModel", "Lcom/intellij/ui/CollectionComboBoxModel;", "", "createPresentationModeScaleComboboxModel", "validatePercentScaleInput", "Lcom/intellij/openapi/ui/ValidationInfo;", "builder", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "comboBox", "Lcom/intellij/openapi/ui/ComboBox;", "string", "validatePresentationModePercentScale", "scale", "scaleFromPercentStringValue", "stringValue", "(Ljava/lang/String;Ljava/lang/Boolean;)Ljava/lang/Float;", "increasedScale", "()Ljava/lang/Float;", "decreasedScale", "scaleWithIndexShift", "isNext", "(ZFZ)Ljava/lang/Float;", "getNearestLessOrEqualOptionIndex", "", "intellij.platform.ide.impl"})
        @SourceDebugExtension(value={"SMAP\nIdeScaleTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeScaleTransformer.kt\ncom/intellij/ide/actions/IdeScaleTransformer$Settings$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n1586#2:193\n1661#2,3:194\n1586#2:197\n1661#2,3:198\n296#2,2:202\n1924#2,3:204\n1#3:201\n*S KotlinDebug\n*F\n+ 1 IdeScaleTransformer.kt\ncom/intellij/ide/actions/IdeScaleTransformer$Settings$Companion\n*L\n80#1:193\n80#1:194,3\n85#1:197\n85#1:198,3\n117#1:202,2\n165#1:204,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<Float> getCurrentScaleOptions() {
                return this.scaleOptions(UISettings.Companion.getInstance().getPresentationMode());
            }

            private final List<Float> scaleOptions(boolean isPresentation) {
                return isPresentation ? presentationModeScaleOptions : ideScaleOptions;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CollectionComboBoxModel<String> createIdeScaleComboboxModel() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.scaleOptions(false);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    float f = ((Number)item$iv$iv).floatValue();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(UISettingsUtilsKt.getPercentStringValue((float)it));
                }
                String string = UISettingsUtilsKt.getPercentStringValue((float)UISettings.Companion.getInstance().getIdeScale());
                List list2 = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                return new CollectionComboBoxModel(list2, (Object)string);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CollectionComboBoxModel<String> createPresentationModeScaleComboboxModel() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.scaleOptions(true);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    float f = ((Number)item$iv$iv).floatValue();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(UISettingsUtilsKt.getPercentStringValue((float)it));
                }
                String string = UISettingsUtilsKt.getPercentStringValue((float)UISettings.Companion.getInstance().getPresentationModeIdeScale());
                List list2 = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                return new CollectionComboBoxModel(list2, (Object)string);
            }

            @Nullable
            public final ValidationInfo validatePercentScaleInput(@NotNull ValidationInfoBuilder builder, @NotNull ComboBox<String> comboBox, boolean isPresentation) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                Intrinsics.checkNotNullParameter(comboBox, (String)"comboBox");
                Object object = comboBox.getItem();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
                String string = this.validatePercentScaleInput((String)object, isPresentation);
                if (string == null) {
                    return null;
                }
                String message = string;
                return builder.error(message);
            }

            @Nls
            @Nullable
            public final String validatePercentScaleInput(@NotNull String string, boolean isPresentation) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"string");
                Float f = this.scaleFromPercentStringValue(string, isPresentation);
                if (f == null) {
                    return IdeBundle.message((String)"presentation.mode.ide.scale.wrong.number.message", (Object[])new Object[0]);
                }
                float scale = f.floatValue();
                return isPresentation ? this.validatePresentationModePercentScale(scale) : null;
            }

            @Nls
            private final String validatePresentationModePercentScale(float scale) {
                if (UISettingsUtilsKt.getPercentValue((float)scale) < UISettingsUtilsKt.getPercentValue((float)0.5f) || UISettingsUtilsKt.getPercentValue((float)scale) > UISettingsUtilsKt.getPercentValue((float)4.0f)) {
                    Object[] objectArray = new Object[]{UISettingsUtilsKt.getPercentValue((float)0.5f), UISettingsUtilsKt.getPercentValue((float)4.0f)};
                    return IdeBundle.message((String)"presentation.mode.ide.scale.out.of.range.number.message.format", (Object[])objectArray);
                }
                return null;
            }

            @Nullable
            public final Float scaleFromPercentStringValue(@Nullable String stringValue, @Nullable Boolean isPresentation) {
                Object v3;
                String string;
                block8: {
                    Object object;
                    block10: {
                        block9: {
                            string = null;
                            String string2 = stringValue;
                            if (string2 == null) {
                                return null;
                            }
                            string = string2;
                            object = isPresentation;
                            if (object == null) break block9;
                            boolean it = (Boolean)object;
                            boolean bl = false;
                            List<Float> list2 = Companion.scaleOptions(it);
                            object = list2;
                            if (list2 != null) break block10;
                        }
                        object = this.getCurrentScaleOptions();
                    }
                    List<Float> scaleOption = object;
                    Iterable $this$firstOrNull$iv = scaleOption;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        float it = ((Number)element$iv).floatValue();
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)string, (Object)UISettingsUtilsKt.getPercentStringValue((float)it))) continue;
                        v3 = element$iv;
                        break block8;
                    }
                    v3 = null;
                }
                Float f = v3;
                if (f != null) {
                    float it = ((Number)f).floatValue();
                    boolean bl = false;
                    return Float.valueOf(it);
                }
                if (StringsKt.last((CharSequence)string) == '%') {
                    string = StringsKt.dropLast((String)string, (int)1);
                }
                Float f2 = StringsKt.toFloatOrNull((String)string);
                if (f2 == null) {
                    return null;
                }
                float value = f2.floatValue();
                return !((float)((int)value) == value) || value <= 0.0f ? null : Float.valueOf(value / (float)100);
            }

            @Nullable
            public final Float increasedScale() {
                return this.scaleWithIndexShift(true, UISettingsUtils.Companion.getInstance().getCurrentIdeScale(), UISettings.Companion.getInstance().getPresentationMode());
            }

            @Nullable
            public final Float decreasedScale() {
                return this.scaleWithIndexShift(false, UISettingsUtils.Companion.getInstance().getCurrentIdeScale(), UISettings.Companion.getInstance().getPresentationMode());
            }

            private final Float scaleWithIndexShift(boolean isNext, float scale, boolean isPresentation) {
                Float f;
                Float result2;
                Float f2;
                List<Float> scaleOptions = this.scaleOptions(isPresentation);
                int lessOrEqualScaleIndex = this.getNearestLessOrEqualOptionIndex(scale, scaleOptions);
                int shift = isNext ? 1 : -1;
                Float lessOrEqualScale = (Float)CollectionsKt.getOrNull(scaleOptions, (int)lessOrEqualScaleIndex);
                if (isPresentation && (scale <= ((Number)CollectionsKt.first(scaleOptions)).floatValue() - 0.1f || scale >= ((Number)CollectionsKt.last(scaleOptions)).floatValue() + 0.1f)) {
                    f2 = Float.valueOf(scale + 0.1f * (float)shift);
                } else if (lessOrEqualScale != null) {
                    if (UISettingsUtilsKt.getPercentValue((float)lessOrEqualScale.floatValue()) == UISettingsUtilsKt.getPercentValue((float)scale) || shift > 0) {
                        Float nextScale = (Float)CollectionsKt.getOrNull(scaleOptions, (int)(lessOrEqualScaleIndex + shift));
                        f2 = isPresentation && nextScale == null ? Float.valueOf(scale + 0.1f * (float)shift) : nextScale;
                    } else {
                        f2 = lessOrEqualScale;
                    }
                } else {
                    f2 = lessOrEqualScaleIndex < 0 && shift > 0 ? (Float)CollectionsKt.first(scaleOptions) : (lessOrEqualScaleIndex >= scaleOptions.size() && shift < 0 ? (Float)CollectionsKt.last(scaleOptions) : null);
                }
                Float f3 = result2 = f2;
                if (f3 != null) {
                    Float f4 = f3;
                    float it = ((Number)f4).floatValue();
                    boolean bl = false;
                    f = !isPresentation || Companion.validatePresentationModePercentScale(it) == null ? f4 : null;
                } else {
                    f = null;
                }
                return f;
            }

            /*
             * WARNING - void declaration
             */
            private final int getNearestLessOrEqualOptionIndex(float scale, List<Float> scaleOptions) {
                Iterable $this$forEachIndexed$iv = scaleOptions;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void v;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    float f = ((Number)item$iv).floatValue();
                    int index = n;
                    boolean bl = false;
                    if (UISettingsUtilsKt.getPercentValue((float)scale) == UISettingsUtilsKt.getPercentValue((float)v)) {
                        return index;
                    }
                    if (UISettingsUtilsKt.getPercentValue((float)scale) >= UISettingsUtilsKt.getPercentValue((float)v)) continue;
                    return index - 1;
                }
                return scaleOptions.size();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

