/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.Strings;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class AbstractPermuteLinesHandler
extends EditorWriteActionHandler {
    protected boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
        if (editor2 == null) {
            AbstractPermuteLinesHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            AbstractPermuteLinesHandler.$$$reportNull$$$0(1);
        }
        return AbstractPermuteLinesHandler.getTargetLineRange(caret) != null;
    }

    /*
     * WARNING - void declaration
     */
    public void executeWriteAction(@NotNull Editor editor2, @Nullable Caret caret, DataContext dataContext2) {
        String newContent;
        int caretLine;
        if (editor2 == null) {
            AbstractPermuteLinesHandler.$$$reportNull$$$0(2);
        }
        if (caret == null) {
            caret = editor2.getCaretModel().getPrimaryCaret();
        }
        Document document2 = editor2.getDocument();
        Couple<Integer> lineRange = AbstractPermuteLinesHandler.getTargetLineRange(caret);
        if (lineRange == null) {
            return;
        }
        int startLine = (Integer)lineRange.first;
        int endLine = (Integer)lineRange.second;
        int lineCount = endLine - startLine + 1;
        CharSequence[] lines = new String[lineCount];
        for (int i2 = 0; i2 < lineCount; ++i2) {
            int line = i2 + startLine;
            lines[i2] = document2.getText(new TextRange(document2.getLineStartOffset(line), document2.getLineEndOffset(line)));
        }
        boolean hasSelection = caret.hasSelection();
        String caretLineContent = null;
        int caretOffsetInLine = 0;
        if (!hasSelection && (caretLine = caret.getLogicalPosition().line) <= endLine) {
            caretLineContent = lines[caretLine - startLine];
            caretOffsetInLine = caret.getOffset() - document2.getLineStartOffset(caretLine);
        }
        this.permute((String[])lines);
        int nulls = 0;
        for (String string : lines) {
            if (string != null) continue;
            ++nulls;
        }
        if (nulls != 0) {
            void var17_22;
            CharSequence[] newLines = new String[lines.length - nulls];
            int index = 0;
            boolean bl = false;
            while (var17_22 < lines.length) {
                if (lines[var17_22] != null) {
                    newLines[index++] = lines[var17_22];
                }
                ++var17_22;
            }
            newContent = String.join((CharSequence)"\n", newLines);
        } else {
            newContent = String.join((CharSequence)"\n", lines);
        }
        int toReplaceStart = document2.getLineStartOffset(startLine);
        int toReplaceEnd = document2.getLineEndOffset(endLine);
        document2.replaceString(toReplaceStart, toReplaceEnd, (CharSequence)newContent);
        if (hasSelection) {
            int n = endLine < document2.getLineCount() - 1 ? document2.getLineStartOffset(endLine + 1) : document2.getTextLength();
            caret.moveToOffset(n);
            caret.setSelection(toReplaceStart, n);
        } else if (caretLineContent != null) {
            void var17_25;
            boolean bl = false;
            while (var17_25 < lineCount) {
                if (Strings.areSameInstance((String)lines[var17_25], (String)caretLineContent)) {
                    caret.moveToOffset(document2.getLineStartOffset(startLine + var17_25) + caretOffsetInLine);
                    break;
                }
                ++var17_25;
            }
        }
        editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    @Nullable
    private static Couple<Integer> getTargetLineRange(@NotNull Caret caret) {
        if (caret == null) {
            AbstractPermuteLinesHandler.$$$reportNull$$$0(3);
        }
        Document document2 = caret.getEditor().getDocument();
        int startOffset = caret.hasSelection() ? caret.getSelectionStart() : 0;
        int endOffset = caret.hasSelection() ? caret.getSelectionEnd() : document2.getTextLength();
        int startLine = document2.getLineNumber(startOffset);
        int endLine = document2.getLineNumber(endOffset);
        if (endOffset == document2.getLineStartOffset(endLine)) {
            --endLine;
        }
        return startLine < endLine ? Couple.of((Object)startLine, (Object)endLine) : null;
    }

    public abstract void permute(String @NotNull [] var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/actions/AbstractPermuteLinesHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "executeWriteAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getTargetLineRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

