/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileChooser.impl.FileChooserDialogHelper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.UIBundle;
import com.intellij.util.ui.OwnerOptional;
import com.jetbrains.JBRFileDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NativeFileSaverDialogImpl
implements FileSaverDialog {
    private final FileSaverDescriptor myDescriptor;
    private final FileChooserDialogHelper myHelper;
    private final FileDialog myFileDialog;

    NativeFileSaverDialogImpl(@NotNull FileSaverDescriptor descriptor2, Project project2) {
        if (descriptor2 == null) {
            NativeFileSaverDialogImpl.$$$reportNull$$$0(0);
        }
        this(descriptor2, IdeFocusManager.getInstance((Project)project2).getFocusOwner());
    }

    NativeFileSaverDialogImpl(@NotNull FileSaverDescriptor descriptor2, Component parent) {
        if (descriptor2 == null) {
            NativeFileSaverDialogImpl.$$$reportNull$$$0(1);
        }
        this.myDescriptor = descriptor2;
        this.myHelper = new FileChooserDialogHelper((FileChooserDescriptor)descriptor2);
        this.myHelper.setNativeDialogProperties();
        String title2 = Objects.requireNonNullElseGet(descriptor2.getTitle(), () -> UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]));
        this.myFileDialog = OwnerOptional.create(parent, dialog2 -> new FileDialog((Dialog)dialog2, title2, 1), frame -> new FileDialog((Frame)frame, title2, 1));
        JBRFileDialog jbrDialog = JBRFileDialog.get((FileDialog)this.myFileDialog);
        if (jbrDialog != null) {
            jbrDialog.setLocalizationString("jbrFileDialogAllFiles", IdeBundle.message((String)"windows.native.common.dialog.all", (Object[])new Object[0]));
            this.myHelper.setFileFilter(jbrDialog, (FileChooserDescriptor)descriptor2);
        }
    }

    @Nullable
    public VirtualFileWrapper save(@Nullable VirtualFile baseDir, @Nullable String filename) {
        return this.doSave(baseDir == null ? null : baseDir.getCanonicalPath(), filename);
    }

    @Nullable
    public VirtualFileWrapper save(@Nullable Path baseDir, @Nullable String filename) {
        return this.doSave(baseDir == null ? null : baseDir.toAbsolutePath().normalize().toString(), filename);
    }

    @Nullable
    private VirtualFileWrapper doSave(@Nullable String baseDir, @Nullable String filename) {
        Pair extensionFilter;
        this.myFileDialog.setDirectory(baseDir);
        if (filename != null && ((String)filename).indexOf(46) < 0 && (extensionFilter = this.myDescriptor.getExtensionFilter()) != null) {
            filename = (String)filename + "." + (String)((List)extensionFilter.second).get(0);
        }
        this.myFileDialog.setFile((String)filename);
        this.myHelper.showNativeDialog(this.myFileDialog);
        File[] files2 = this.myFileDialog.getFiles();
        return files2.length != 0 ? new VirtualFileWrapper(files2[0]) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileChooser/impl/NativeFileSaverDialogImpl", "<init>"));
    }
}

