/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.ClientEditorManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.AsyncFileEditorProvider;
import com.intellij.openapi.fileEditor.ClientFileEditorManager;
import com.intellij.openapi.fileEditor.DocumentsEditor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.StructureViewFileEditorProvider;
import com.intellij.openapi.fileEditor.impl.DefaultPlatformFileEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.QuickDefinitionProvider;
import com.intellij.openapi.fileEditor.impl.text.TextBasedFileEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorCaretState;
import com.intellij.openapi.fileEditor.impl.text.TextEditorComponent;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImplKt;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProviderKt;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 62\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u000267B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u000e\u001a\u00020\tJ0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001b\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+H\u0016J\u0014\u0010,\u001a\u00060-R\u00020\u00002\u0006\u0010*\u001a\u00020+H\u0014J\"\u0010.\u001a\u00020/2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010*\u001a\u00020+2\u0006\u00100\u001a\u000201H\u0017J*\u00102\u001a\u00020#2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010*\u001a\u00020+2\u0006\u0010$\u001a\u00020/2\u0006\u00103\u001a\u00020\tH\u0017J\u001a\u00104\u001a\u0004\u0018\u0001052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u00068"}, d2={"Lcom/intellij/openapi/fileEditor/impl/text/TextEditorProvider;", "Lcom/intellij/openapi/fileEditor/impl/DefaultPlatformFileEditorProvider;", "Lcom/intellij/openapi/fileEditor/impl/text/TextBasedFileEditorProvider;", "Lcom/intellij/openapi/fileEditor/ex/StructureViewFileEditorProvider;", "Lcom/intellij/openapi/fileEditor/impl/text/QuickDefinitionProvider;", "Lcom/intellij/openapi/fileEditor/AsyncFileEditorProvider;", "<init>", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "acceptRequiresReadAction", "createFileEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "document", "Lcom/intellij/openapi/editor/Document;", "editorCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/Document;Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "readState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "element", "Lorg/jdom/Element;", "readCarets", "", "Lcom/intellij/openapi/fileEditor/impl/text/TextEditorCaretState;", "(Lorg/jdom/Element;)[Lcom/intellij/openapi/fileEditor/impl/text/TextEditorCaretState;", "readRelativeCaretPosition", "", "writeState", "", "state", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "getTextEditor", "editor", "Lcom/intellij/openapi/editor/Editor;", "createWrapperForEditor", "Lcom/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper;", "getStateImpl", "Lcom/intellij/openapi/fileEditor/impl/text/TextEditorState;", "level", "Lcom/intellij/openapi/fileEditor/FileEditorStateLevel;", "setStateImpl", "exactState", "getStructureViewBuilder", "Lcom/intellij/ide/structureView/StructureViewBuilder;", "Companion", "EditorWrapper", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nTextEditorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextEditorProvider.kt\ncom/intellij/openapi/fileEditor/impl/text/TextEditorProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,337:1\n1586#2:338\n1661#2,3:339\n37#3,2:342\n11705#4:344\n12052#4,3:345\n*S KotlinDebug\n*F\n+ 1 TextEditorProvider.kt\ncom/intellij/openapi/fileEditor/impl/text/TextEditorProvider\n*L\n187#1:338\n187#1:339,3\n201#1:342,2\n213#1:344\n213#1:345,3\n*E\n"})
public class TextEditorProvider
implements DefaultPlatformFileEditorProvider,
TextBasedFileEditorProvider,
StructureViewFileEditorProvider,
QuickDefinitionProvider,
AsyncFileEditorProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean accept(@NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return Companion.isTextFile(file2) && !SingleRootFileViewProvider.isTooLargeForContentLoading((VirtualFile)file2);
    }

    public final boolean acceptRequiresReadAction() {
        return false;
    }

    @Nullable
    public Object createFileEditor(@NotNull Project project2, @NotNull VirtualFile file2, @Nullable Document document2, @NotNull CoroutineScope editorCoroutineScope, @NotNull Continuation<? super TextEditor> $completion) {
        return TextEditorProvider.createFileEditor$suspendImpl(this, project2, file2, document2, editorCoroutineScope, $completion);
    }

    static /* synthetic */ Object createFileEditor$suspendImpl(TextEditorProvider $this, Project project2, VirtualFile file2, Document document2, CoroutineScope editorCoroutineScope, Continuation<? super TextEditor> $completion) {
        AsyncEditorLoader asyncLoader = TextEditorImplKt.createAsyncEditorLoader($this, project2, file2, editorCoroutineScope);
        return BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TextEditorImpl>, Object>(project2, file2, asyncLoader, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ AsyncEditorLoader $asyncLoader;
            {
                this.$project = $project;
                this.$file = $file;
                this.$asyncLoader = $asyncLoader;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        EditorImpl editor2 = (EditorImpl)TextEditorImplKt.createEditorImpl(this.$project, this.$file, this.$asyncLoader).getFirst();
                        return new TextEditorImpl(this.$project, this.$file, (Pair<? extends TextEditorComponent, AsyncEditorLoader>)TuplesKt.to((Object)new TextEditorComponent(this.$file, editor2), (Object)this.$asyncLoader));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super TextEditorImpl> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        AsyncEditorLoader asyncLoader = TextEditorImplKt.createAsyncEditorLoader(this, project2, file2, null);
        EditorImpl editor2 = (EditorImpl)TextEditorImplKt.createEditorImpl(project2, file2, asyncLoader).getFirst();
        return (FileEditor)new TextEditorImpl(project2, file2, (Pair<? extends TextEditorComponent, AsyncEditorLoader>)TuplesKt.to((Object)new TextEditorComponent(file2, editor2), (Object)asyncLoader));
    }

    @NotNull
    public FileEditorState readState(@NotNull Element element, @NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (element.isEmpty()) {
            return new TextEditorState();
        }
        return new TextEditorState(this.readCarets(element), this.readRelativeCaretPosition(element));
    }

    private final TextEditorCaretState[] readCarets(Element element) {
        List caretElements = element.getChildren("caret");
        if (caretElements.isEmpty()) {
            TextEditorCaretState[] textEditorCaretStateArray = new TextEditorCaretState[]{TextEditorProviderKt.access$readCaretInfo(element)};
            return textEditorCaretStateArray;
        }
        int n = 0;
        int n2 = caretElements.size();
        TextEditorCaretState[] textEditorCaretStateArray = new TextEditorCaretState[n2];
        while (n < n2) {
            int n3 = n++;
            Object e = caretElements.get(n3);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            textEditorCaretStateArray[n3] = TextEditorProviderKt.access$readCaretInfo((Element)e);
        }
        return textEditorCaretStateArray;
    }

    private final int readRelativeCaretPosition(Element element) {
        return StringUtilRt.parseInt((String)element.getAttributeValue("relative-caret-position"), (int)0);
    }

    public void writeState(@NotNull FileEditorState state2, @NotNull Project project2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TextEditorState cfr_ignored_0 = (TextEditorState)state2;
        if (((TextEditorState)state2).getRelativeCaretPosition() != 0) {
            element.setAttribute("relative-caret-position", String.valueOf(((TextEditorState)state2).getRelativeCaretPosition()));
        }
        TextEditorCaretState[] textEditorCaretStateArray = ((TextEditorState)state2).getCarets();
        Intrinsics.checkNotNullExpressionValue((Object)textEditorCaretStateArray, (String)"getCarets(...)");
        for (TextEditorCaretState caretState : textEditorCaretStateArray) {
            Element e = new Element("caret");
            TextEditorProviderKt.access$writeIfNot0(e, "line", caretState.line());
            TextEditorProviderKt.access$writeIfNot0(e, "column", caretState.column());
            if (caretState.leanForward()) {
                e.setAttribute("lean-forward", "true");
            }
            TextEditorProviderKt.access$writeIfNot0(e, "selection-start-line", caretState.selectionStartLine());
            TextEditorProviderKt.access$writeIfNot0(e, "selection-start-column", caretState.selectionStartColumn());
            TextEditorProviderKt.access$writeIfNot0(e, "selection-end-line", caretState.selectionEndLine());
            TextEditorProviderKt.access$writeIfNot0(e, "selection-end-line", caretState.selectionEndLine());
            TextEditorProviderKt.access$writeIfNot0(e, "selection-end-column", caretState.selectionEndColumn());
            if (e.isEmpty()) continue;
            element.addContent(e);
        }
    }

    @NotNull
    public String getEditorTypeId() {
        return "text-editor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.NONE;
    }

    @NotNull
    public TextEditor getTextEditor(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        TextEditor textEditor = (TextEditor)editor2.getUserData(TextEditorProviderKt.access$getTEXT_EDITOR_KEY$p());
        if (textEditor == null) {
            textEditor = this.createWrapperForEditor(editor2);
            Companion.putTextEditor(editor2, textEditor);
        }
        return textEditor;
    }

    @NotNull
    protected EditorWrapper createWrapperForEditor(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return new EditorWrapper(editor2);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @NotNull
    public TextEditorState getStateImpl(@Nullable Project project2, @NotNull Editor editor2, @NotNull FileEditorStateLevel level) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        List list2 = editor2.getCaretModel().getCaretsAndSelections();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getCaretsAndSelections(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void caretState;
            CaretState caretState2 = (CaretState)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            LogicalPosition caretPosition = caretState.getCaretPosition();
            LogicalPosition selectionStartPosition = caretState.getSelectionStart();
            LogicalPosition selectionEndPosition = caretState.getSelectionEnd();
            collection.add(new TextEditorCaretState(TextEditorProviderKt.access$getLine(caretPosition), TextEditorProviderKt.access$getColumn(caretPosition), caretPosition != null && caretPosition.leansForward, caretState.getVisualColumnAdjustment(), TextEditorProviderKt.access$getLine(selectionStartPosition), TextEditorProviderKt.access$getColumn(selectionStartPosition), TextEditorProviderKt.access$getLine(selectionEndPosition), TextEditorProviderKt.access$getColumn(selectionEndPosition)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        TextEditorCaretState[] carets = thisCollection$iv.toArray(new TextEditorCaretState[0]);
        int relativeCaretPosition = level == FileEditorStateLevel.UNDO ? Integer.MAX_VALUE : EditorUtil.calcRelativeCaretPosition(editor2);
        return new TextEditorState(carets, relativeCaretPosition);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void setStateImpl(@Nullable Project project2, @NotNull Editor editor2, @NotNull TextEditorState state2, boolean exactState) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        TextEditorCaretState[] textEditorCaretStateArray = state2.getCarets();
        Intrinsics.checkNotNullExpressionValue((Object)textEditorCaretStateArray, (String)"getCarets(...)");
        TextEditorCaretState[] carets = textEditorCaretStateArray;
        if (!(carets.length == 0)) {
            void $this$mapTo$iv$iv;
            TextEditorCaretState[] $this$map$iv = carets;
            boolean $i$f$map = false;
            TextEditorCaretState[] textEditorCaretStateArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void caretState;
                void item$iv$iv;
                void var15_14 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new CaretState(new LogicalPosition(caretState.line(), caretState.column(), caretState.leanForward()), caretState.visualColumnAdjustment(), new LogicalPosition(caretState.selectionStartLine(), caretState.selectionStartColumn()), new LogicalPosition(caretState.selectionEndLine(), caretState.selectionEndColumn())));
            }
            List states = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            editor2.getCaretModel().setCaretsAndSelections(states, false);
        }
        int relativeCaretPosition = state2.getRelativeCaretPosition();
        if (AsyncEditorLoader.Companion.isEditorLoaded(editor2) || ApplicationManager.getApplication().isUnitTestMode()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                TextEditorProviderKt.scrollToCaret(editor2, exactState, relativeCaretPosition);
            } else {
                JComponent jComponent = editor2.getContentComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
                UiNotifyConnector.Companion.doWhenFirstShown$default((UiNotifyConnector.Companion)UiNotifyConnector.Companion, (Component)jComponent, (boolean)false, () -> TextEditorProvider.setStateImpl$lambda$1(editor2, exactState, relativeCaretPosition), (int)2, null);
            }
        }
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder(@NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return StructureViewBuilder.Companion.getProvider().getStructureViewBuilder(file2.getFileType(), file2, project2);
    }

    private static final Unit setStateImpl$lambda$1(Editor $editor, boolean $exactState, int $relativeCaretPosition) {
        if (!$editor.isDisposed()) {
            TextEditorProviderKt.scrollToCaret($editor, $exactState, $relativeCaretPosition);
        }
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final TextEditorProvider getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @NotNull
    public static final Document[] getDocuments(@NotNull FileEditor editor2) {
        return Companion.getDocuments(editor2);
    }

    @JvmStatic
    public static final boolean isTextFile(@NotNull VirtualFile file2) {
        return Companion.isTextFile(file2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u001b\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/fileEditor/impl/text/TextEditorProvider$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/openapi/fileEditor/impl/text/TextEditorProvider;", "getDocuments", "", "Lcom/intellij/openapi/editor/Document;", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "(Lcom/intellij/openapi/fileEditor/FileEditor;)[Lcom/intellij/openapi/editor/Document;", "putTextEditor", "", "Lcom/intellij/openapi/editor/Editor;", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "isTextFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nTextEditorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextEditorProvider.kt\ncom/intellij/openapi/fileEditor/impl/text/TextEditorProvider$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,337:1\n1#2:338\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TextEditorProvider getInstance() {
            Object object = FileEditorProvider.EP_FILE_EDITOR_PROVIDER.findFirstAssignableExtension(TextEditorProvider.class);
            Intrinsics.checkNotNull((Object)object);
            return (TextEditorProvider)object;
        }

        @JvmStatic
        @NotNull
        public final Document[] getDocuments(@NotNull FileEditor editor2) {
            Document[] documentArray;
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            FileEditor fileEditor = editor2;
            if (fileEditor instanceof DocumentsEditor) {
                Document[] documentArray2 = ((DocumentsEditor)editor2).getDocuments();
                documentArray = documentArray2;
                Intrinsics.checkNotNullExpressionValue((Object)documentArray2, (String)"getDocuments(...)");
            } else if (fileEditor instanceof TextEditor) {
                Document[] documentArray3 = new Document[1];
                Intrinsics.checkNotNullExpressionValue((Object)((TextEditor)editor2).getEditor().getDocument(), (String)"getDocument(...)");
                documentArray = documentArray3;
            } else {
                Document document2;
                Document[] result2 = Document.EMPTY_ARRAY;
                VirtualFile virtualFile2 = editor2.getFile();
                if (virtualFile2 != null) {
                    VirtualFile it = virtualFile2;
                    boolean bl = false;
                    v3 = FileDocumentManager.getInstance().getDocument(it);
                } else {
                    v3 = document2 = null;
                }
                if (document2 != null) {
                    Document[] documentArray4 = new Document[]{document2};
                    result2 = documentArray4;
                }
                Document[] documentArray5 = result2;
                Intrinsics.checkNotNull((Object)documentArray5);
                documentArray = documentArray5;
            }
            return documentArray;
        }

        @ApiStatus.Internal
        public final void putTextEditor(@NotNull Editor editor2, @NotNull TextEditor textEditor) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)textEditor, (String)"textEditor");
            editor2.putUserData(TextEditorProviderKt.access$getTEXT_EDITOR_KEY$p(), (Object)textEditor);
        }

        @JvmStatic
        public final boolean isTextFile(@NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            if (file2.isDirectory() || !file2.isValid()) {
                return false;
            }
            FileType fileType2 = file2.getFileType();
            Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileType(...)");
            FileType fileType3 = fileType2;
            return !fileType3.isBinary() || BinaryFileTypeDecompilers.getInstance().forFileType(fileType3) != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0094\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\u0006\u0010\u0019\u001a\u00020\u0017J\b\u0010\u001a\u001a\u00020\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0016J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\n\u0010%\u001a\u00020\fH\u0096\u0080\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/openapi/fileEditor/impl/text/TextEditorProvider$EditorWrapper;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/openapi/fileEditor/TextEditor;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/fileEditor/impl/text/TextEditorProvider;Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "getName", "", "getStructureViewBuilder", "Lcom/intellij/ide/structureView/StructureViewBuilder;", "getState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "level", "Lcom/intellij/openapi/fileEditor/FileEditorStateLevel;", "setState", "", "state", "exactState", "", "isModified", "isValid", "dispose", "addPropertyChangeListener", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "canNavigateTo", "navigatable", "Lcom/intellij/pom/Navigatable;", "navigateTo", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "toString", "intellij.platform.ide.impl"})
    protected class EditorWrapper
    extends UserDataHolderBase
    implements TextEditor {
        @NotNull
        private final Editor editor;

        public EditorWrapper(Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            this.editor = editor2;
            ClientFileEditorManager.Companion.assignClientId((FileEditor)this, ClientEditorManager.Companion.getClientId(this.editor));
        }

        @NotNull
        public Editor getEditor() {
            return this.editor;
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.editor.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            return jComponent;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.editor.getContentComponent();
        }

        @NotNull
        public String getName() {
            String string = IdeBundle.message((String)"tab.title.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Nullable
        public StructureViewBuilder getStructureViewBuilder() {
            VirtualFile virtualFile2 = this.getFile();
            if (virtualFile2 == null) {
                return null;
            }
            VirtualFile file2 = virtualFile2;
            Project project2 = this.editor.getProject();
            if (project2 == null) {
                return null;
            }
            Project project3 = project2;
            return TextEditorProvider.this.getStructureViewBuilder(project3, file2);
        }

        @NotNull
        public FileEditorState getState(@NotNull FileEditorStateLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            return TextEditorProvider.this.getStateImpl(null, this.editor, level);
        }

        public void setState(@NotNull FileEditorState state2) {
            Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
            this.setState(state2, false);
        }

        public void setState(@NotNull FileEditorState state2, boolean exactState) {
            Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
            TextEditorProvider.this.setStateImpl(null, this.editor, (TextEditorState)state2, exactState);
        }

        public boolean isModified() {
            return false;
        }

        public final boolean isValid() {
            return !this.editor.isDisposed();
        }

        public void dispose() {
        }

        public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        }

        public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        }

        public boolean canNavigateTo(@NotNull Navigatable navigatable) {
            Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
            return false;
        }

        public void navigateTo(@NotNull Navigatable navigatable) {
            Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
        }

        @Nullable
        public VirtualFile getFile() {
            return FileDocumentManager.getInstance().getFile(this.editor.getDocument());
        }

        @NotNull
        public String toString() {
            return "EditorWrapper for " + this.editor.getDocument();
        }
    }
}

