/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class RemovedMappingTracker {
    private static final Logger LOG = Logger.getInstance(RemovedMappingTracker.class);
    private final MultiMap<FileNameMatcher, RemovedMapping> myRemovedMappings = new MultiMap();
    @NonNls
    private static final String ELEMENT_REMOVED_MAPPING = "removed_mapping";
    @NonNls
    private static final String ATTRIBUTE_APPROVED = "approved";
    @NonNls
    private static final String ATTRIBUTE_TYPE = "type";

    @VisibleForTesting
    public void clear() {
        this.myRemovedMappings.clear();
    }

    @VisibleForTesting
    @NotNull
    public RemovedMapping add(@NotNull FileNameMatcher matcher, @NotNull String fileTypeName, boolean approved) {
        if (matcher == null) {
            RemovedMappingTracker.$$$reportNull$$$0(0);
        }
        if (fileTypeName == null) {
            RemovedMappingTracker.$$$reportNull$$$0(1);
        }
        RemovedMapping mapping = new RemovedMapping(matcher, fileTypeName, approved);
        List mappings = (List)this.myRemovedMappings.getModifiable((Object)matcher);
        boolean found = false;
        for (int i2 = 0; i2 < mappings.size(); ++i2) {
            RemovedMapping removedMapping = (RemovedMapping)mappings.get(i2);
            if (!removedMapping.getFileTypeName().equals(fileTypeName)) continue;
            mappings.set(i2, mapping);
            found = true;
            break;
        }
        if (!found) {
            mappings.add(mapping);
        }
        RemovedMapping removedMapping = mapping;
        if (removedMapping == null) {
            RemovedMappingTracker.$$$reportNull$$$0(2);
        }
        return removedMapping;
    }

    void load(@NotNull Element e) {
        if (e == null) {
            RemovedMappingTracker.$$$reportNull$$$0(3);
        }
        List<RemovedMapping> removedMappings = RemovedMappingTracker.readRemovedMappings(e);
        LinkedHashSet<RemovedMapping> uniques = new LinkedHashSet<RemovedMapping>(removedMappings.size());
        for (RemovedMapping mapping : removedMappings) {
            if (uniques.add(mapping)) continue;
            LOG.warn((Throwable)new InvalidDataException("Duplicate <removed_mapping> tag for " + String.valueOf(mapping)));
        }
        for (RemovedMapping mapping : uniques) {
            this.myRemovedMappings.putValue((Object)mapping.myFileNameMatcher, (Object)mapping);
        }
    }

    @NotNull
    static List<RemovedMapping> readRemovedMappings(@NotNull Element e) {
        List children2;
        if (e == null) {
            RemovedMappingTracker.$$$reportNull$$$0(4);
        }
        if ((children2 = e.getChildren(ELEMENT_REMOVED_MAPPING)).isEmpty()) {
            List<RemovedMapping> list2 = Collections.emptyList();
            if (list2 == null) {
                RemovedMappingTracker.$$$reportNull$$$0(5);
            }
            return list2;
        }
        ArrayList<RemovedMapping> result2 = new ArrayList<RemovedMapping>();
        for (Element mapping : children2) {
            String ext = mapping.getAttributeValue("ext");
            ExtensionFileNameMatcher matcher = ext == null ? FileTypeManager.parseFromString((String)mapping.getAttributeValue("pattern")) : new ExtensionFileNameMatcher(ext);
            boolean approved = Boolean.parseBoolean(mapping.getAttributeValue(ATTRIBUTE_APPROVED));
            String fileTypeName = mapping.getAttributeValue(ATTRIBUTE_TYPE);
            if (fileTypeName == null) continue;
            RemovedMapping removedMapping = new RemovedMapping((FileNameMatcher)matcher, fileTypeName, approved);
            result2.add(removedMapping);
        }
        ArrayList<RemovedMapping> arrayList = result2;
        if (arrayList == null) {
            RemovedMappingTracker.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    void save(@NotNull Element element) {
        if (element == null) {
            RemovedMappingTracker.$$$reportNull$$$0(7);
        }
        ArrayList<RemovedMapping> removedMappings = new ArrayList<RemovedMapping>(this.myRemovedMappings.values());
        removedMappings.sort(Comparator.comparing(mapping -> mapping.getFileNameMatcher().getPresentableString()).thenComparing(RemovedMapping::getFileTypeName));
        for (RemovedMapping mapping2 : removedMappings) {
            Element content2 = RemovedMappingTracker.writeRemovedMapping(mapping2.myFileTypeName, mapping2.myFileNameMatcher, true, mapping2.myApproved);
            if (content2 == null) continue;
            element.addContent(content2);
        }
    }

    void saveRemovedMappingsForFileType(@NotNull Element map2, @NotNull String fileTypeName, @NotNull Collection<? extends FileNameMatcher> associations, boolean specifyTypeName) {
        if (map2 == null) {
            RemovedMappingTracker.$$$reportNull$$$0(8);
        }
        if (fileTypeName == null) {
            RemovedMappingTracker.$$$reportNull$$$0(9);
        }
        if (associations == null) {
            RemovedMappingTracker.$$$reportNull$$$0(10);
        }
        for (FileNameMatcher fileNameMatcher : associations) {
            Element content2 = RemovedMappingTracker.writeRemovedMapping(fileTypeName, fileNameMatcher, specifyTypeName, this.isApproved(fileNameMatcher, fileTypeName));
            if (content2 == null) continue;
            map2.addContent(content2);
        }
    }

    boolean hasRemovedMapping(@NotNull FileNameMatcher matcher) {
        if (matcher == null) {
            RemovedMappingTracker.$$$reportNull$$$0(11);
        }
        return this.myRemovedMappings.containsKey((Object)matcher);
    }

    private boolean isApproved(@NotNull FileNameMatcher matcher, @NotNull String fileTypeName) {
        RemovedMapping mapping;
        if (matcher == null) {
            RemovedMappingTracker.$$$reportNull$$$0(12);
        }
        if (fileTypeName == null) {
            RemovedMappingTracker.$$$reportNull$$$0(13);
        }
        return (mapping = (RemovedMapping)ContainerUtil.find((Iterable)this.myRemovedMappings.get((Object)matcher), m -> m.getFileTypeName().equals(fileTypeName))) != null && mapping.isApproved();
    }

    @VisibleForTesting
    @NotNull
    public List<RemovedMapping> getRemovedMappings() {
        return new ArrayList<RemovedMapping>(this.myRemovedMappings.values());
    }

    @VisibleForTesting
    @NotNull
    public List<FileNameMatcher> getMappingsForFileType(@NotNull String fileTypeName) {
        if (fileTypeName == null) {
            RemovedMappingTracker.$$$reportNull$$$0(14);
        }
        List<FileNameMatcher> list2 = this.myRemovedMappings.values().stream().filter(mapping -> mapping.myFileTypeName.equals(fileTypeName)).map(mapping -> mapping.myFileNameMatcher).collect(Collectors.toList());
        if (list2 == null) {
            RemovedMappingTracker.$$$reportNull$$$0(15);
        }
        return list2;
    }

    @VisibleForTesting
    @NotNull
    public List<RemovedMapping> removeIf(@NotNull Predicate<? super RemovedMapping> predicate) {
        if (predicate == null) {
            RemovedMappingTracker.$$$reportNull$$$0(16);
        }
        ArrayList<RemovedMapping> result2 = new ArrayList<RemovedMapping>();
        Iterator iterator2 = this.myRemovedMappings.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator2.next();
            Collection mappings = (Collection)entry.getValue();
            mappings.removeIf((? super E mapping) -> {
                boolean toRemove = predicate.test((RemovedMapping)mapping);
                if (toRemove) {
                    result2.add((RemovedMapping)mapping);
                }
                return toRemove;
            });
            if (!mappings.isEmpty()) continue;
            iterator2.remove();
        }
        ArrayList<RemovedMapping> arrayList = result2;
        if (arrayList == null) {
            RemovedMappingTracker.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    void approveUnapprovedMappings() {
        for (RemovedMapping mapping : new ArrayList(this.myRemovedMappings.values())) {
            if (mapping.isApproved()) continue;
            this.myRemovedMappings.remove((Object)mapping.getFileNameMatcher(), (Object)mapping);
            this.myRemovedMappings.putValue((Object)mapping.getFileNameMatcher(), (Object)new RemovedMapping(mapping.getFileNameMatcher(), mapping.getFileTypeName(), true));
        }
    }

    private static Element writeRemovedMapping(@NotNull String fileTypeName, @NotNull FileNameMatcher matcher, boolean specifyTypeName, boolean approved) {
        Element mapping;
        if (fileTypeName == null) {
            RemovedMappingTracker.$$$reportNull$$$0(18);
        }
        if (matcher == null) {
            RemovedMappingTracker.$$$reportNull$$$0(19);
        }
        if (!AbstractFileType.writePattern(matcher, mapping = new Element(ELEMENT_REMOVED_MAPPING))) {
            return null;
        }
        if (approved) {
            mapping.setAttribute(ATTRIBUTE_APPROVED, "true");
        }
        if (specifyTypeName) {
            mapping.setAttribute(ATTRIBUTE_TYPE, fileTypeName);
        }
        return mapping;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 15, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 1: 
            case 9: 
            case 13: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeName";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/RemovedMappingTracker";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "associations";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/RemovedMappingTracker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "add";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readRemovedMappings";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingsForFileType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "removeIf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 15: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readRemovedMappings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "saveRemovedMappingsForFileType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasRemovedMapping";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isApproved";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMappingsForFileType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeIf";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "writeRemovedMapping";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 15, 17 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static final class RemovedMapping {
        private final FileNameMatcher myFileNameMatcher;
        private final String myFileTypeName;
        private final boolean myApproved;

        private RemovedMapping(@NotNull FileNameMatcher matcher, @NotNull String fileTypeName, boolean approved) {
            if (matcher == null) {
                RemovedMapping.$$$reportNull$$$0(0);
            }
            if (fileTypeName == null) {
                RemovedMapping.$$$reportNull$$$0(1);
            }
            this.myFileNameMatcher = matcher;
            this.myFileTypeName = fileTypeName;
            this.myApproved = approved;
        }

        @VisibleForTesting
        @NotNull
        public FileNameMatcher getFileNameMatcher() {
            FileNameMatcher fileNameMatcher = this.myFileNameMatcher;
            if (fileNameMatcher == null) {
                RemovedMapping.$$$reportNull$$$0(2);
            }
            return fileNameMatcher;
        }

        @VisibleForTesting
        @NotNull
        public String getFileTypeName() {
            String string = this.myFileTypeName;
            if (string == null) {
                RemovedMapping.$$$reportNull$$$0(3);
            }
            return string;
        }

        @VisibleForTesting
        public boolean isApproved() {
            return this.myApproved;
        }

        public String toString() {
            return "Removed mapping '" + String.valueOf(this.myFileNameMatcher) + "' -> " + this.myFileTypeName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemovedMapping mapping = (RemovedMapping)o;
            if (!this.myFileNameMatcher.equals((Object)mapping.myFileNameMatcher)) {
                return false;
            }
            return this.myFileTypeName.equals(mapping.myFileTypeName);
        }

        public int hashCode() {
            int result2 = this.myFileNameMatcher.hashCode();
            result2 = 31 * result2 + this.myFileTypeName.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileTypeName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileTypes/impl/RemovedMappingTracker$RemovedMapping";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileTypes/impl/RemovedMappingTracker$RemovedMapping";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileNameMatcher";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileTypeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

