/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.keyGestures;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionEventVisitor;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardGestureAction;
import com.intellij.openapi.actionSystem.KeyboardModifierGestureShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.impl.ActionProcessor;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.keymap.impl.KeyState;
import com.intellij.openapi.keymap.impl.keyGestures.KeyGestureState;
import com.intellij.openapi.keymap.impl.keyGestures.StateContext;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.TimerUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

public final class KeyboardGestureProcessor {
    final IdeKeyEventDispatcher myDispatcher;
    final StateContext myContext = new StateContext();
    final KeyGestureState myWaitForStart = new KeyGestureState.WaitForStart(this);
    final KeyGestureState myModifierPressed = new KeyGestureState.ModifierPressed(this);
    final KeyGestureState myWaitForDblClick = new KeyGestureState.WaitForDblClick(this);
    final KeyGestureState myWaitForAction = new KeyGestureState.WaitForAction(this);
    final KeyGestureState myWaitForActionEnd = new KeyGestureState.WaitForActionEnd(this);
    final KeyGestureState myFinish = new KeyGestureState.ProcessFinish(this);
    KeyGestureState myState = this.myWaitForStart;
    final Timer myHoldTimer = TimerUtil.createNamedTimer((String)"Keyboard hold", (int)1200, e -> {});
    final Timer myDblClickTimer = TimerUtil.createNamedTimer((String)"Double click", (int)SystemProperties.getIntProperty((String)"actionSystem.keyGestureDblClickTime", (int)650), (ActionListener)new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            KeyboardGestureProcessor.this.myState.processDblClickTimer();
        }
    });
    private final ActionProcessor myActionProcessor = new MyActionProcessor();

    public KeyboardGestureProcessor(IdeKeyEventDispatcher dispatcher) {
        this.myDispatcher = dispatcher;
    }

    public boolean process() {
        boolean wasNotInWaitState;
        boolean bl = wasNotInWaitState = this.myState != this.myWaitForStart;
        if (Boolean.getBoolean("ide.debugMode") && wasNotInWaitState) {
            System.out.println("-- key gesture context: before process, state=" + String.valueOf(this.myState));
            System.out.println(this.myContext);
        }
        this.myContext.keyToProcess = this.myDispatcher.getContext().getInputEvent();
        this.myContext.isModal = this.myDispatcher.getContext().isModalContext();
        this.myContext.dataContext = this.myDispatcher.getContext().getDataContext();
        boolean result2 = this.myState.process();
        if (Boolean.getBoolean("ide.debugMode") && (wasNotInWaitState || this.myState != this.myWaitForStart)) {
            System.out.println("-- key gesture context: after process, state=" + String.valueOf(this.myState));
            System.out.println(this.myContext);
        }
        return result2;
    }

    public boolean processInitState() {
        if (!Boolean.getBoolean("actionSystem.keyGestures.enabled")) {
            return false;
        }
        this.myContext.focusOwner = this.myDispatcher.getContext().getFocusOwner();
        return this.process();
    }

    void executeAction() {
        this.myDispatcher.updateCurrentContext(this.myContext.focusOwner, this.getCurrentShortcut());
        this.myDispatcher.processAction(this.myContext.keyToProcess, this.myActionProcessor);
    }

    @NotNull
    private Shortcut getCurrentShortcut() {
        Shortcut shortcut = KeyboardModifierGestureShortcut.newInstance((KeyboardGestureAction.ModifierType)this.myContext.modifierType, (KeyStroke)this.myContext.actionShortcut);
        if (shortcut == null) {
            KeyboardGestureProcessor.$$$reportNull$$$0(0);
        }
        return shortcut;
    }

    void setState(KeyGestureState state2) {
        boolean isGestureProcessingState;
        boolean bl = isGestureProcessingState = this.myDispatcher.getState() == KeyState.STATE_KEY_GESTURE_PROCESSOR;
        if (state2 == this.myWaitForStart) {
            this.myContext.actionKey = null;
            if (isGestureProcessingState) {
                this.myDispatcher.setState(KeyState.STATE_INIT);
            }
        } else if (state2 == this.myWaitForAction) {
            this.myDispatcher.setState(KeyState.STATE_KEY_GESTURE_PROCESSOR);
        }
        this.myState = state2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/keyGestures/KeyboardGestureProcessor", "getCurrentShortcut"));
    }

    private final class MyActionProcessor
    extends ActionProcessor {
        private MyActionProcessor() {
        }

        @Override
        @NotNull
        public AnActionEvent createEvent(@NotNull InputEvent inputEvent, @NotNull DataContext context2, @NotNull String place, @NotNull Presentation presentation2, @NotNull ActionManager manager2) {
            if (inputEvent == null) {
                MyActionProcessor.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                MyActionProcessor.$$$reportNull$$$0(1);
            }
            if (place == null) {
                MyActionProcessor.$$$reportNull$$$0(2);
            }
            if (presentation2 == null) {
                MyActionProcessor.$$$reportNull$$$0(3);
            }
            if (manager2 == null) {
                MyActionProcessor.$$$reportNull$$$0(4);
            }
            KeyboardGestureProcessor.this.myContext.actionPresentation = presentation2;
            KeyboardGestureProcessor.this.myContext.actionPlace = place;
            AnActionEvent anActionEvent = KeyboardGestureProcessor.this.myState.createActionEvent();
            if (anActionEvent == null) {
                MyActionProcessor.$$$reportNull$$$0(5);
            }
            return anActionEvent;
        }

        @Override
        public void performAction(@NotNull InputEvent inputEvent, final @NotNull AnAction action2, @NotNull AnActionEvent event) {
            if (inputEvent == null) {
                MyActionProcessor.$$$reportNull$$$0(6);
            }
            if (action2 == null) {
                MyActionProcessor.$$$reportNull$$$0(7);
            }
            if (event == null) {
                MyActionProcessor.$$$reportNull$$$0(8);
            }
            final Runnable runnable2 = () -> super.performAction(inputEvent, action2, event);
            event.accept(new AnActionEventVisitor(this){

                public void visitGestureInitEvent(@NotNull AnActionEvent anActionEvent) {
                    if (anActionEvent == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (action2 instanceof KeyboardGestureAction) {
                        runnable2.run();
                    }
                }

                public void visitGesturePerformedEvent(@NotNull AnActionEvent anActionEvent) {
                    if (anActionEvent == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    runnable2.run();
                }

                public void visitGestureFinishEvent(@NotNull AnActionEvent anActionEvent) {
                    if (anActionEvent == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (action2 instanceof KeyboardGestureAction) {
                        runnable2.run();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "anActionEvent";
                    objectArray2[1] = "com/intellij/openapi/keymap/impl/keyGestures/KeyboardGestureProcessor$MyActionProcessor$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitGestureInitEvent";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitGesturePerformedEvent";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitGestureFinishEvent";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputEvent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/keymap/impl/keyGestures/KeyboardGestureProcessor$MyActionProcessor";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/keymap/impl/keyGestures/KeyboardGestureProcessor$MyActionProcessor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEvent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createEvent";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "performAction";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

