/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.linux;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.actions.CreateDesktopEntryAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.SuggestedIde;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.DownloadResult;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.InstallationResult;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.UltimateInstallationInfo;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.UltimateInstallationServiceKt;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.UltimateInstaller;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.UltimateInstallerKt;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.linux.LinuxInstallationInfo;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.Decompressor;
import com.intellij.util.io.PathKt;
import com.intellij.util.system.CpuArch;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0019H\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0019H\u0002R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/linux/LinuxInstaller;", "Lcom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/install/UltimateInstaller;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/openapi/project/Project;)V", "postfix", "", "getPostfix", "()Ljava/lang/String;", "installUltimate", "Lcom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/install/InstallationResult;", "downloadResult", "Lcom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/install/DownloadResult;", "startUltimate", "", "installationResult", "createDesktopEntry", "", "installationInfo", "Lcom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/linux/LinuxInstallationInfo;", "getInstallationInfo", "installPath", "Ljava/nio/file/Path;", "suggestedIde", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/SuggestedIde;", "getUltimateInstallationDirectory", "getLocalShareDir", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nLinuxInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinuxInstaller.kt\ncom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/linux/LinuxInstaller\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n18#2:104\n1#3:105\n*S KotlinDebug\n*F\n+ 1 LinuxInstaller.kt\ncom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/linux/LinuxInstaller\n*L\n49#1:104\n*E\n"})
public final class LinuxInstaller
extends UltimateInstaller {
    @NotNull
    private final String postfix;

    public LinuxInstaller(@NotNull CoroutineScope scope, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(scope, project2);
        this.postfix = CpuArch.isArm64() ? "-aarch64.tar.gz" : ".tar.gz";
    }

    @Override
    @NotNull
    public String getPostfix() {
        return this.postfix;
    }

    @Override
    @Nullable
    public InstallationResult installUltimate(@NotNull DownloadResult downloadResult2) {
        Intrinsics.checkNotNullParameter((Object)downloadResult2, (String)"downloadResult");
        Path path = this.getUltimateInstallationDirectory();
        if (path == null) {
            return null;
        }
        Path installPath = path;
        List entries2 = new ArrayList();
        try {
            Decompressor.Tar decompressor = new Decompressor.Tar(downloadResult2.getDownloadPath());
            decompressor.postProcessor(arg_0 -> LinuxInstaller.installUltimate$lambda$0((Function1)new Function1<Path, Unit>((Object)entries2){

                public final void invoke(Path p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((List)this.receiver).add(p0);
                }
            }, arg_0)).extract(installPath);
        }
        catch (Exception e) {
            this.deleteInBackground(installPath);
            throw e;
        }
        SuggestedIde suggestedIde = downloadResult2.getSuggestedIde();
        Path installFolder = installPath.resolve(((Path)CollectionsKt.first((List)entries2)).getFileName());
        Intrinsics.checkNotNull((Object)installFolder);
        LinuxInstallationInfo linuxInstallationInfo = this.getInstallationInfo(installFolder, suggestedIde);
        if (linuxInstallationInfo == null) {
            return null;
        }
        LinuxInstallationInfo installationInfo = linuxInstallationInfo;
        this.createDesktopEntry(installationInfo);
        return new InstallationResult(installFolder, installationInfo);
    }

    @Override
    public boolean startUltimate(@NotNull InstallationResult installationResult2) {
        Intrinsics.checkNotNullParameter((Object)installationResult2, (String)"installationResult");
        UltimateInstallationInfo $this$asSafely$iv = installationResult2.getInstallationInfo();
        boolean $i$f$asSafely = false;
        UltimateInstallationInfo ultimateInstallationInfo = $this$asSafely$iv;
        if (!(ultimateInstallationInfo instanceof LinuxInstallationInfo)) {
            ultimateInstallationInfo = null;
        }
        LinuxInstallationInfo linuxInstallationInfo = (LinuxInstallationInfo)ultimateInstallationInfo;
        if (linuxInstallationInfo == null) {
            return false;
        }
        LinuxInstallationInfo installationInfo = linuxInstallationInfo;
        String[] stringArray = new String[]{"sh", "-c", ((Object)installationInfo.getScriptPath()).toString() + " " + this.getProject().getBasePath() + " " + this.getTrialParameter() + " &"};
        GeneralCommandLine command = new GeneralCommandLine(stringArray);
        return UltimateInstallerKt.runCommand(command);
    }

    private final void createDesktopEntry(LinuxInstallationInfo installationInfo) {
        SuggestedIde suggestedIde = installationInfo.getSuggestedIde();
        String ideName = suggestedIde.getName();
        Path path = this.getLocalShareDir();
        if (path == null || (path = path.resolve("applications")) == null || (path = path.resolve(ideName + ".desktop")) == null) {
            return;
        }
        Path desktopFile = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(desktopFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(desktopFile, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"$NAME$", (Object)ideName), TuplesKt.to((Object)"$SCRIPT$", (Object)((Object)installationInfo.getScriptPath()).toString()), TuplesKt.to((Object)"$WM_CLASS$", (Object)installationInfo.getWmClass()), TuplesKt.to((Object)"$COMMENT$", (Object)suggestedIde.getProductCode())};
        Map entries2 = MapsKt.mutableMapOf((Pair[])pairArray);
        Path path2 = installationInfo.getIconPath();
        if (path2 != null) {
            Path it = path2;
            boolean bl = false;
            entries2.put("$ICON$", ((Object)it).toString());
        }
        ClassLoader classLoader = CreateDesktopEntryAction.class.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        String content2 = ExecUtil.loadTemplate((ClassLoader)classLoader, (String)"entry.desktop", (Map)entries2);
        PathKt.write$default((Path)desktopFile, (CharSequence)content2, null, (boolean)false, (int)6, null);
    }

    private final LinuxInstallationInfo getInstallationInfo(Path installPath, SuggestedIde suggestedIde) {
        Path path;
        String ide = UltimateInstallationServiceKt.isPycharmProfessional(suggestedIde) ? "pycharm" : "idea";
        Path bin = installPath.resolve("bin");
        Path script = bin.resolve(ide + ".sh");
        Intrinsics.checkNotNull((Object)script);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(script, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        Path it = path = bin.resolve(ide + ".svg");
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        Path icon2 = Files.exists(it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) ? path : null;
        return new LinuxInstallationInfo(suggestedIde, script, icon2, "jetbrains-" + ide);
    }

    @Override
    @Nullable
    public Path getUltimateInstallationDirectory() {
        Object localAppPath;
        Object object = System.getenv("XDG_DATA_HOME");
        if (object == null || (object = NioPathUtil.toNioPathOrNull((String)object)) == null) {
            object = this.getLocalShareDir();
        }
        Object object2 = localAppPath = object;
        return object2 != null ? object2.resolve("JetBrains") : null;
    }

    private final Path getLocalShareDir() {
        String string = SystemProperties.getUserHome();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
        Path path = NioPathUtil.toNioPathOrNull((String)string);
        return path != null ? path.resolve(".local/share") : null;
    }

    private static final void installUltimate$lambda$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

