/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecordsImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnection;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordAccessor;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsStorage;
import com.intellij.openapi.vfs.newvfs.persistent.VFSAttributesStorage;
import com.intellij.openapi.vfs.newvfs.persistent.VFSHealthChecker;
import com.intellij.openapi.vfs.newvfs.persistent.VFSHealthCheckerConstants;
import com.intellij.openapi.vfs.newvfs.persistent.VFSHealthCheckerKt;
import com.intellij.util.BitUtil;
import com.intellij.util.io.ScannableDataEnumeratorEx;
import com.intellij.util.io.storage.RecordIdIterator;
import com.intellij.util.io.storage.VFSContentStorage;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001%B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0082@\u00a2\u0006\u0002\u0010\rJ6\u0010\u0010\u001a\u00020\u0011*\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u001bH\u0082@\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\u0014\u0010!\u001a\u00020\u0011*\u00020\u00152\u0006\u0010\"\u001a\u00020\u0019H\u0002J\u001c\u0010!\u001a\u00020\u0011*\u00020\u00152\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker;", "", "impl", "Lcom/intellij/openapi/vfs/newvfs/persistent/FSRecordsImpl;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "<init>", "(Lcom/intellij/openapi/vfs/newvfs/persistent/FSRecordsImpl;Lcom/intellij/openapi/diagnostic/Logger;)V", "()V", "checkHealth", "Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport;", "checkForOrphanRecords", "", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "verifyFileRecords", "Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$FileRecordsReport;", "checkRecordIsOrphan", "", "fileRecords", "Lcom/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordsStorage;", "fileId", "", "parentId", "parentFlags", "fileName", "", "verifyRoots", "Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$RootsReport;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "verifyNamesEnumerator", "Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$NamesEnumeratorReport;", "verifyContentEnumerator", "Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$ContentEnumeratorReport;", "alsoLogThrottled", "message", "error", "", "VFSHealthCheckReport", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVFSHealthChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VFSHealthChecker.kt\ncom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,688:1\n1586#2:689\n1661#2,3:690\n1807#2,3:693\n1586#2:696\n1661#2,3:697\n*S KotlinDebug\n*F\n+ 1 VFSHealthChecker.kt\ncom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker\n*L\n379#1:689\n379#1:690,3\n384#1:693,3\n325#1:696\n325#1:697,3\n*E\n"})
public final class VFSHealthChecker {
    @NotNull
    private final FSRecordsImpl impl;
    @NotNull
    private final Logger log;

    public VFSHealthChecker(@NotNull FSRecordsImpl impl, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)impl, (String)"impl");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.impl = impl;
        this.log = log;
    }

    public /* synthetic */ VFSHealthChecker(FSRecordsImpl fSRecordsImpl, Logger logger2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Logger logger3 = VFSHealthCheckerKt.access$getLOG$p();
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"access$getLOG$p(...)");
            logger2 = logger3;
        }
        this(fSRecordsImpl, logger2);
    }

    public VFSHealthChecker() {
        FSRecordsImpl fSRecordsImpl = FSRecords.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fSRecordsImpl, (String)"getInstance(...)");
        Logger logger2 = FSRecords.LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"LOG");
        this(fSRecordsImpl, logger2);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object checkHealth(boolean checkForOrphanRecords, @NotNull Continuation<? super VFSHealthCheckReport> $completion) {
        if (!($completion instanceof checkHealth.1)) ** GOTO lbl-1000
        var15_3 = $completion;
        if ((var15_3.label & -2147483648) != 0) {
            var15_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                boolean Z$0;
                long J$0;
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ VFSHealthChecker this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.checkHealth(false, (Continuation<? super VFSHealthCheckReport>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.log.info("Checking VFS started");
                startedAtNs = System.nanoTime();
                $continuation.Z$0 = checkForOrphanRecords;
                $continuation.J$0 = startedAtNs;
                $continuation.label = 1;
                v0 = this.verifyFileRecords(checkForOrphanRecords != false, (Continuation<? super VFSHealthCheckReport.FileRecordsReport>)$continuation);
                if (v0 == var16_5) {
                    return var16_5;
                }
                ** GOTO lbl26
            }
            case 1: {
                startedAtNs = $continuation.J$0;
                checkForOrphanRecords = $continuation.Z$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                fileRecordsReport = (VFSHealthCheckReport.FileRecordsReport)v0;
                $continuation.L$0 = fileRecordsReport;
                $continuation.Z$0 = checkForOrphanRecords;
                $continuation.J$0 = startedAtNs;
                $continuation.label = 2;
                v1 = this.verifyRoots((Continuation<? super VFSHealthCheckReport.RootsReport>)$continuation);
                if (v1 == var16_5) {
                    return var16_5;
                }
                ** GOTO lbl41
            }
            case 2: {
                startedAtNs = $continuation.J$0;
                checkForOrphanRecords = $continuation.Z$0;
                fileRecordsReport = (VFSHealthCheckReport.FileRecordsReport)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl41:
                // 2 sources

                rootsReport = (VFSHealthCheckReport.RootsReport)v1;
                namesEnumeratorReport = this.verifyNamesEnumerator();
                contentEnumeratorReport = this.verifyContentEnumerator();
                finishedAtNs = System.nanoTime();
                var12_12 = DurationKt.toDuration((long)(finishedAtNs - startedAtNs), (DurationUnit)DurationUnit.NANOSECONDS);
                vfsHealthCheckReport = new VFSHealthCheckReport(fileRecordsReport, rootsReport, namesEnumeratorReport, contentEnumeratorReport, var12_12, null);
                if (vfsHealthCheckReport.getHealthy()) {
                    this.log.info("Checking VFS finished (healthy): " + vfsHealthCheckReport);
                } else {
                    this.log.warn("Checking VFS finished (non-healthy): " + vfsHealthCheckReport);
                }
                return vfsHealthCheckReport;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object checkHealth$default(VFSHealthChecker vFSHealthChecker, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            bl = VFSHealthCheckerConstants.INSTANCE.getCHECK_ORPHAN_RECORDS();
        }
        return vFSHealthChecker.checkHealth(bl, (Continuation<? super VFSHealthCheckReport>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private final Object verifyFileRecords(boolean checkForOrphanRecords, Continuation<? super VFSHealthCheckReport.FileRecordsReport> $completion) {
        block7: {
            if (!($completion instanceof verifyFileRecords.1)) ** GOTO lbl-1000
            var20_3 = $completion;
            if ((var20_3.label & -2147483648) != 0) {
                var20_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    boolean Z$0;
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;
                    Object L$8;
                    Object L$9;
                    Object L$10;
                    Object L$11;
                    Object L$12;
                    int I$0;
                    int I$1;
                    int I$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ VFSHealthChecker this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return VFSHealthChecker.access$verifyFileRecords(this.this$0, false, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var21_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            block0 : switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    connection = this.impl.connection();
                    v0 = connection.records();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"records(...)");
                    fileRecords = v0;
                    v1 = connection.names();
                    Intrinsics.checkNotNullExpressionValue(v1, (String)"names(...)");
                    namesEnumerator = v1;
                    v2 = connection.contents();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"contents(...)");
                    contentsStorage = v2;
                    v3 = connection.attributes();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"attributes(...)");
                    attributes = v3;
                    maxAllocatedID = fileRecords.maxAllocatedID();
                    allRoots = new IntOpenHashSet(this.impl.listRoots());
                    invalidFlagsMask = ~PersistentFS.Flags.getAllValidFlags();
                    fileIdsChunks = CollectionsKt.chunked((Iterable)((Iterable)new IntRange(2, maxAllocatedID)), (int)32);
                    $this$verifyFileRecords_u24lambda_u240 = var13_16 = (report = new VFSHealthCheckReport.FileRecordsReport(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2047, null));
                    $i$a$-apply-VFSHealthChecker$verifyFileRecords$2 = 0;
                    var16_19 = fileIdsChunks.iterator();
lbl32:
                    // 4 sources

                    while (var16_19.hasNext()) {
                        fileIdsChunk = (List)var16_19.next();
                        checkChunkFilesTask = (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, verifyFileRecords$lambda$0$0(java.util.List com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsStorage com.intellij.openapi.vfs.newvfs.persistent.VFSHealthChecker$VFSHealthCheckReport$FileRecordsReport int com.intellij.openapi.vfs.newvfs.persistent.VFSHealthChecker com.intellij.util.io.ScannableDataEnumeratorEx com.intellij.openapi.vfs.newvfs.persistent.VFSAttributesStorage com.intellij.util.io.storage.VFSContentStorage it.unimi.dsi.fastutil.ints.IntOpenHashSet boolean ), ()Lkotlin/Unit;)((List)fileIdsChunk, (PersistentFSRecordsStorage)fileRecords, (VFSHealthCheckReport.FileRecordsReport)$this$verifyFileRecords_u24lambda_u240, (int)invalidFlagsMask, (VFSHealthChecker)this, (ScannableDataEnumeratorEx)namesEnumerator, (VFSAttributesStorage)attributes, (VFSContentStorage)contentsStorage, (IntOpenHashSet)allRoots, (boolean)(checkForOrphanRecords != false));
                        if (!VFSHealthCheckerConstants.INSTANCE.getWRAP_HEALTH_CHECK_IN_READ_ACTION()) break block0;
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)connection);
                        $continuation.L$1 = fileRecords;
                        $continuation.L$2 = namesEnumerator;
                        $continuation.L$3 = contentsStorage;
                        $continuation.L$4 = attributes;
                        $continuation.L$5 = allRoots;
                        $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)fileIdsChunks);
                        $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)report);
                        $continuation.L$8 = var13_16;
                        $continuation.L$9 = $this$verifyFileRecords_u24lambda_u240;
                        $continuation.L$10 = var16_19;
                        $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)fileIdsChunk);
                        $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)checkChunkFilesTask);
                        $continuation.Z$0 = checkForOrphanRecords;
                        $continuation.I$0 = maxAllocatedID;
                        $continuation.I$1 = invalidFlagsMask;
                        $continuation.I$2 = $i$a$-apply-VFSHealthChecker$verifyFileRecords$2;
                        $continuation.label = 1;
                        v4 = CoroutinesKt.readAction((Function0)checkChunkFilesTask, (Continuation)$continuation);
                        if (v4 != var21_5) continue;
                        return var21_5;
                    }
                    break block7;
                }
                case 1: {
                    $i$a$-apply-VFSHealthChecker$verifyFileRecords$2 = $continuation.I$2;
                    invalidFlagsMask = $continuation.I$1;
                    maxAllocatedID = $continuation.I$0;
                    checkForOrphanRecords = $continuation.Z$0;
                    checkChunkFilesTask = (Function0)$continuation.L$12;
                    fileIdsChunk = (List)$continuation.L$11;
                    var16_19 = (Iterator<E>)$continuation.L$10;
                    $this$verifyFileRecords_u24lambda_u240 = (VFSHealthCheckReport.FileRecordsReport)$continuation.L$9;
                    var13_16 = (VFSHealthCheckReport.FileRecordsReport)$continuation.L$8;
                    report = (VFSHealthCheckReport.FileRecordsReport)$continuation.L$7;
                    fileIdsChunks = (List)$continuation.L$6;
                    allRoots = (IntOpenHashSet)$continuation.L$5;
                    attributes = (VFSAttributesStorage)$continuation.L$4;
                    contentsStorage = (VFSContentStorage)$continuation.L$3;
                    namesEnumerator = (ScannableDataEnumeratorEx)$continuation.L$2;
                    fileRecords = (PersistentFSRecordsStorage)$continuation.L$1;
                    connection = (PersistentFSConnection)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
                    ** GOTO lbl32
                }
            }
            checkChunkFilesTask.invoke();
            ** GOTO lbl32
        }
        return var13_16;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final void checkRecordIsOrphan(VFSHealthCheckReport.FileRecordsReport $this$checkRecordIsOrphan, PersistentFSRecordsStorage fileRecords, int fileId, int parentId, int parentFlags, String fileName) {
        block7: {
            if (BitUtil.isSet((int)parentFlags, (int)1)) {
                try {
                    boolean bl;
                    List childrenOfParent;
                    block8: {
                        void $this$any$iv;
                        Iterable $this$mapTo$iv$iv;
                        List<? extends ChildInfo> list2 = this.impl.list((int)parentId).children;
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"children");
                        Iterable $this$map$iv = list2;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            ChildInfo childInfo = (ChildInfo)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add(it.getId());
                        }
                        childrenOfParent = (List)destination$iv$iv;
                        if (childrenOfParent.indexOf(fileId) >= 0) break block7;
                        int fileNameId = fileRecords.getNameId(fileId);
                        $this$mapTo$iv$iv = childrenOfParent;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                int childId = ((Number)element$iv).intValue();
                                boolean bl3 = false;
                                if (!(fileRecords.getNameId(childId) == fileNameId)) continue;
                                bl = true;
                                break block8;
                            }
                            bl = false;
                        }
                    }
                    boolean hasChildWithSameName = bl;
                    String childrenPrefix = childrenOfParent.size() > VFSHealthCheckerConstants.INSTANCE.getMAX_CHILDREN_TO_LOG() ? "first " + VFSHealthCheckerConstants.INSTANCE.getMAX_CHILDREN_TO_LOG() + " of " + childrenOfParent.size() + ": " : "";
                    int n = $this$checkRecordIsOrphan.getInconsistentParentChildRelationships();
                    $this$checkRecordIsOrphan.setInconsistentParentChildRelationships(n + 1);
                    this.alsoLogThrottled(n, "file[#" + fileId + "]{" + fileName + "}: record is orphan, .parent[#" + parentId + "].children(" + childrenPrefix + CollectionsKt.joinToString$default((Iterable)childrenOfParent, null, null, null, (int)VFSHealthCheckerConstants.INSTANCE.getMAX_CHILDREN_TO_LOG(), null, null, (int)55, null) + ") doesn't contain it, " + (hasChildWithSameName ? "but there is non-orphan child with same name." : "and there are NO non-orphan children with the same name."));
                }
                catch (Throwable e) {
                    int n = $this$checkRecordIsOrphan.getGeneralErrors();
                    $this$checkRecordIsOrphan.setGeneralErrors(n + 1);
                    this.alsoLogThrottled(n, "file[#" + fileId + "]{" + fileName + "}.parent[#" + parentId + "]: error accessing children", e);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object verifyRoots(Continuation<? super VFSHealthCheckReport.RootsReport> $completion) {
        if (!($completion instanceof verifyRoots.1)) ** GOTO lbl-1000
        var9_2 = $completion;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ VFSHealthChecker this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return VFSHealthChecker.access$verifyRoots(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$verifyRoots_u24lambda_u240 = var3_7 = (report = new VFSHealthCheckReport.RootsReport(0, 0, 0, 0, 8, null));
                $i$a$-apply-VFSHealthChecker$verifyRoots$2 = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)report);
                $continuation.L$1 = var3_7;
                $continuation.L$2 = $this$verifyRoots_u24lambda_u240;
                $continuation.I$0 = $i$a$-apply-VFSHealthChecker$verifyRoots$2;
                $continuation.label = 1;
                v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, verifyRoots$lambda$0$0(com.intellij.openapi.vfs.newvfs.persistent.VFSHealthChecker com.intellij.openapi.vfs.newvfs.persistent.VFSHealthChecker$VFSHealthCheckReport$RootsReport ), ()Lkotlin/Unit;)((VFSHealthChecker)this, (VFSHealthCheckReport.RootsReport)$this$verifyRoots_u24lambda_u240), (Continuation)$continuation);
                ** if (v0 != var10_4) goto lbl24
lbl23:
                // 1 sources

                return var10_4;
lbl24:
                // 1 sources

                ** GOTO lbl40
            }
            case 1: {
                $i$a$-apply-VFSHealthChecker$verifyRoots$2 = $continuation.I$0;
                $this$verifyRoots_u24lambda_u240 = (VFSHealthCheckReport.RootsReport)$continuation.L$2;
                var3_7 = (VFSHealthCheckReport.RootsReport)$continuation.L$1;
                report = (VFSHealthCheckReport.RootsReport)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (Throwable t) {
                    var7_12 = $this$verifyRoots_u24lambda_u240.getGeneralErrors();
                    $this$verifyRoots_u24lambda_u240.setGeneralErrors(var7_12 + 1);
                    this.alsoLogThrottled(var7_12, "verifyRoots: can't do something", t);
                }
lbl40:
                // 3 sources

                return var3_7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final VFSHealthCheckReport.NamesEnumeratorReport verifyNamesEnumerator() {
        ScannableDataEnumeratorEx<String> scannableDataEnumeratorEx = this.impl.connection().names();
        Intrinsics.checkNotNullExpressionValue(scannableDataEnumeratorEx, (String)"names(...)");
        ScannableDataEnumeratorEx<String> namesEnumerator = scannableDataEnumeratorEx;
        VFSHealthCheckReport.NamesEnumeratorReport report = new VFSHealthCheckReport.NamesEnumeratorReport(0, 0, 0, 0, 0, 31, null);
        try {
            namesEnumerator.forEach((arg_0, arg_1) -> VFSHealthChecker.verifyNamesEnumerator$lambda$1((arg_0, arg_1) -> VFSHealthChecker.verifyNamesEnumerator$lambda$0(report, namesEnumerator, this, arg_0, arg_1), arg_0, arg_1));
        }
        catch (Throwable e) {
            int n = report.getGeneralErrors();
            report.setGeneralErrors(n + 1);
            this.alsoLogThrottled(n, "Error to verify namesEnumerator", e);
        }
        return report;
    }

    private final VFSHealthCheckReport.ContentEnumeratorReport verifyContentEnumerator() {
        VFSHealthCheckReport.ContentEnumeratorReport report = new VFSHealthCheckReport.ContentEnumeratorReport(0, 0);
        PersistentFSConnection connection = this.impl.connection();
        VFSContentStorage vFSContentStorage = connection.contents();
        Intrinsics.checkNotNullExpressionValue((Object)vFSContentStorage, (String)"contents(...)");
        VFSContentStorage contentsStorage = vFSContentStorage;
        RecordIdIterator contentRecordsIterator = contentsStorage.createRecordIdIterator();
        while (contentRecordsIterator.hasNextId()) {
            int n = report.getContentRecordsChecked();
            report.setContentRecordsChecked(n + 1);
            int contentId = contentRecordsIterator.nextId();
            try {
                contentsStorage.checkRecord(contentId, false);
            }
            catch (Throwable e) {
                int n2 = report.getGeneralErrors();
                report.setGeneralErrors(n2 + 1);
                this.alsoLogThrottled(n2, "contentId[#" + contentId + "]: content record fails to read or inconsistent: " + e.getMessage());
            }
        }
        return report;
    }

    private final void alsoLogThrottled(int $this$alsoLogThrottled, String message) {
        int errorsCount = $this$alsoLogThrottled;
        if (errorsCount < VFSHealthCheckerConstants.INSTANCE.getMAX_SINGLE_ERROR_LOGS_BEFORE_THROTTLE()) {
            this.log.info(message);
        } else if (errorsCount == VFSHealthCheckerConstants.INSTANCE.getMAX_SINGLE_ERROR_LOGS_BEFORE_THROTTLE()) {
            this.log.info(message + "\n..." + VFSHealthCheckerConstants.INSTANCE.getMAX_SINGLE_ERROR_LOGS_BEFORE_THROTTLE() + " similar errors -> continue counting, but don't log same errors anymore to not trash the log file");
        }
    }

    private final void alsoLogThrottled(int $this$alsoLogThrottled, String message, Throwable error2) {
        int errorsCount = $this$alsoLogThrottled;
        if (errorsCount < VFSHealthCheckerConstants.INSTANCE.getMAX_SINGLE_ERROR_LOGS_BEFORE_THROTTLE()) {
            this.log.info(message, error2);
        } else if (errorsCount == VFSHealthCheckerConstants.INSTANCE.getMAX_SINGLE_ERROR_LOGS_BEFORE_THROTTLE()) {
            this.log.info(message + "\n..." + VFSHealthCheckerConstants.INSTANCE.getMAX_SINGLE_ERROR_LOGS_BEFORE_THROTTLE() + " similar errors -> continue counting, but don't log same errors anymore to not trash the log file", error2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit verifyFileRecords$lambda$0$0(List $fileIdsChunk, PersistentFSRecordsStorage $fileRecords, VFSHealthCheckReport.FileRecordsReport $this_apply, int $invalidFlagsMask, VFSHealthChecker this$0, ScannableDataEnumeratorEx $namesEnumerator, VFSAttributesStorage $attributes, VFSContentStorage $contentsStorage, IntOpenHashSet $allRoots, boolean $checkForOrphanRecords) {
        Iterator iterator2 = $fileIdsChunk.iterator();
        while (iterator2.hasNext()) {
            int fileId = ((Number)iterator2.next()).intValue();
            try {
                Object $this$map$iv;
                int n;
                String fileName;
                int n2;
                int nameId = $fileRecords.getNameId(fileId);
                int parentId = $fileRecords.getParent(fileId);
                int flags = $fileRecords.getFlags(fileId);
                int attributeRecordId = $fileRecords.getAttributeRecordId(fileId);
                int contentId = $fileRecords.getContentRecordId(fileId);
                long length = $fileRecords.getLength(fileId);
                long timestamp = $fileRecords.getTimestamp(fileId);
                $this_apply.setFileRecordsChecked(fileId);
                if ((flags & $invalidFlagsMask) != 0) {
                    n2 = $this_apply.getGeneralErrors();
                    $this_apply.setGeneralErrors(n2 + 1);
                    this$0.alsoLogThrottled(n2, "file[#" + fileId + "]: invalid flags: " + Integer.toBinaryString(flags));
                }
                if (PersistentFSRecordAccessor.hasDeletedFlag(flags)) {
                    n2 = $this_apply.getFileRecordsDeleted();
                    $this_apply.setFileRecordsDeleted(n2 + 1);
                    return Unit.INSTANCE;
                }
                if (nameId == 0) {
                    n2 = $this_apply.getNullNameIds();
                    $this_apply.setNullNameIds(n2 + 1);
                    this$0.alsoLogThrottled(n2, "file[#" + fileId + "]: nameId is not set (NULL_ID) -> file record is incorrect (broken?)");
                }
                if ((fileName = (String)$namesEnumerator.valueOf(nameId)) == null) {
                    int n3 = $this_apply.getUnresolvableNameIds();
                    $this_apply.setUnresolvableNameIds(n3 + 1);
                    this$0.alsoLogThrottled(n3, "file[#" + fileId + "]: name[#" + nameId + "] does not exist (null)! -> names enumerator is inconsistent (broken?)");
                }
                boolean attributesAreResolvable = false;
                try {
                    $attributes.checkAttributeRecordSanity(fileId, attributeRecordId);
                    attributesAreResolvable = true;
                }
                catch (Throwable t) {
                    n = $this_apply.getUnresolvableAttributesIds();
                    $this_apply.setUnresolvableAttributesIds(n + 1);
                    this$0.alsoLogThrottled(n, "file[#" + fileId + "]{" + fileName + "}: attribute[#" + attributeRecordId + "] can't be read", t);
                    attributesAreResolvable = false;
                }
                if (contentId != 0) {
                    int t = $this_apply.getNotNullContentIds();
                    $this_apply.setNotNullContentIds(t + 1);
                    try {
                        $contentsStorage.checkRecord(contentId, false);
                    }
                    catch (Throwable e) {
                        n = $this_apply.getUnresolvableContentIds();
                        $this_apply.setUnresolvableContentIds(n + 1);
                        this$0.alsoLogThrottled(n, "file[#" + fileId + "]{" + fileName + "}: content[#" + contentId + "] can't be read, or inconsistent", e);
                    }
                }
                if (parentId == 0) {
                    if (!$allRoots.contains(fileId)) {
                        int e = $this_apply.getNullParents();
                        $this_apply.setNullParents(e + 1);
                        this$0.alsoLogThrottled(e, "file[#" + fileId + "]{" + fileName + "}: not in ROOTS, but parentId is not set (NULL_ID) -> non-ROOTS must have parents");
                    }
                } else {
                    int parentFlags = $fileRecords.getFlags(parentId);
                    boolean parentIsDirectory = BitUtil.isSet((int)parentFlags, (int)2);
                    if (!parentIsDirectory) {
                        int n4 = $this_apply.getInconsistentParentChildRelationships();
                        $this_apply.setInconsistentParentChildRelationships(n4 + 1);
                        this$0.alsoLogThrottled(n4, "file[#" + fileId + "]{" + fileName + "}: parent[#" + parentId + "] is !directory (flags: " + Integer.toBinaryString(parentFlags) + ")");
                    }
                    if (attributesAreResolvable && $checkForOrphanRecords) {
                        this$0.checkRecordIsOrphan($this_apply, $fileRecords, fileId, parentId, parentFlags, fileName);
                    }
                }
                if (!attributesAreResolvable) continue;
                boolean isDirectory = BitUtil.isSet((int)flags, (int)2);
                try {
                    void $this$mapTo$iv$iv;
                    List<? extends ChildInfo> list2 = this$0.impl.list((int)fileId).children;
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"children");
                    $this$map$iv = list2;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ChildInfo childInfo = (ChildInfo)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getId());
                    }
                    $this$map$iv = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
                }
                catch (Throwable e) {
                    int $this$mapTo$iv$iv = $this_apply.getGeneralErrors();
                    $this_apply.setGeneralErrors($this$mapTo$iv$iv + 1);
                    this$0.alsoLogThrottled($this$mapTo$iv$iv, "file[#" + fileId + "]{" + fileName + "}: error accessing children", e);
                    $this$map$iv = new int[0];
                }
                Object children2 = $this$map$iv;
                if (isDirectory) {
                    int n5 = ((Object)children2).length;
                    for (int i2 = 0; i2 < n5; ++i2) {
                        int $this$mapTo$iv$iv = $this_apply.getChildrenChecked();
                        $this_apply.setChildrenChecked($this$mapTo$iv$iv + 1);
                        Object childId = children2[i2];
                        int childParentId = $fileRecords.getParent((int)childId);
                        if (fileId == childParentId) continue;
                        int n6 = $this_apply.getInconsistentParentChildRelationships();
                        $this_apply.setInconsistentParentChildRelationships(n6 + 1);
                        this$0.alsoLogThrottled(n6, "file[#" + fileId + "]{" + fileName + "}: children[" + i2 + "][#" + (int)childId + "].parent[=#" + childParentId + "] != this -> parent-child relationship is inconsistent (records are broken?)");
                    }
                    continue;
                }
                if (!(!(((Object)children2).length == 0))) continue;
                int n7 = $this_apply.getInconsistentParentChildRelationships();
                $this_apply.setInconsistentParentChildRelationships(n7 + 1);
                this$0.alsoLogThrottled(n7, "file[#" + fileId + "]{" + fileName + "}: !directory (flags: " + Integer.toBinaryString(flags) + ") but has children(" + ((Object)children2).length + ")");
            }
            catch (Throwable t) {
                int n = $this_apply.getGeneralErrors();
                $this_apply.setGeneralErrors(n + 1);
                this$0.alsoLogThrottled(n, "file[#" + fileId + "]: unhandled exception while checking", t);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit verifyRoots$lambda$0$0(VFSHealthChecker this$0, VFSHealthCheckReport.RootsReport $this_apply) {
        int[] nArray = this$0.impl.listRoots();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"listRoots(...)");
        int[] rootIds = nArray;
        PersistentFSRecordsStorage persistentFSRecordsStorage = this$0.impl.connection().records();
        Intrinsics.checkNotNullExpressionValue((Object)persistentFSRecordsStorage, (String)"records(...)");
        PersistentFSRecordsStorage records = persistentFSRecordsStorage;
        int maxAllocatedID = records.maxAllocatedID();
        $this_apply.setRootsCount(rootIds.length);
        for (int rootId : rootIds) {
            int flags;
            if (rootId < 2 || rootId > maxAllocatedID) {
                int n = $this_apply.getGeneralErrors();
                $this_apply.setGeneralErrors(n + 1);
                this$0.alsoLogThrottled(n, "root[#" + rootId + "]: is outside of allocated IDs range [2.." + maxAllocatedID + "]");
                continue;
            }
            int rootParentId = records.getParent(rootId);
            if (rootParentId != 0) {
                int n = $this_apply.getRootsWithParents();
                $this_apply.setRootsWithParents(n + 1);
                this$0.alsoLogThrottled(n, "root[#" + rootId + "]: parentId[#" + rootParentId + "] != 0 -> inconsistency");
            }
            if (!PersistentFSRecordAccessor.hasDeletedFlag(flags = records.getFlags(rootId))) continue;
            int n = $this_apply.getRootsDeletedButNotRemoved();
            $this_apply.setRootsDeletedButNotRemoved(n + 1);
            this$0.alsoLogThrottled(n, "root[#" + rootId + "]: record is deleted (flags: " + Integer.toBinaryString(flags) + ") but not removed from the roots");
        }
        return Unit.INSTANCE;
    }

    private static final boolean verifyNamesEnumerator$lambda$0(VFSHealthCheckReport.NamesEnumeratorReport $report, ScannableDataEnumeratorEx $namesEnumerator, VFSHealthChecker this$0, int id2, String name2) {
        try {
            int n = $report.getNamesChecked();
            $report.setNamesChecked(n + 1);
            int nameId = $namesEnumerator.tryEnumerate((Object)name2);
            if (nameId == 0) {
                int n2 = $report.getNamesResolvedToNull();
                $report.setNamesResolvedToNull(n2 + 1);
                this$0.alsoLogThrottled(n2, "name[" + name2 + "] enumerated to NULL -> namesEnumerator is corrupted");
                return true;
            }
            String nameResolved = (String)$namesEnumerator.valueOf(nameId);
            if (nameResolved == null) {
                int n3 = $report.getIdsResolvedToNull();
                $report.setIdsResolvedToNull(n3 + 1);
                this$0.alsoLogThrottled(n3, "name[" + name2 + "]: enumerated to nameId(=" + nameId + "), resolved back to null -> namesEnumerator is corrupted");
                return true;
            }
            if (!Intrinsics.areEqual((Object)name2, (Object)nameResolved)) {
                int n4 = $report.getInconsistentNames();
                $report.setInconsistentNames(n4 + 1);
                this$0.alsoLogThrottled(n4, "name[" + name2 + "]: enumerated to nameId(=" + nameId + "), resolved back to different name [" + nameResolved + "] -> namesEnumerator is corrupted");
            }
        }
        catch (Throwable e) {
            int n = $report.getGeneralErrors();
            $report.setGeneralErrors(n + 1);
            this$0.alsoLogThrottled(n, "name[" + name2 + "]: exception while checking -> namesEnumerator is corrupted: " + e.getMessage());
        }
        return true;
    }

    private static final boolean verifyNamesEnumerator$lambda$1(Function2 $tmp0, int p0, Object p1) {
        return (Boolean)$tmp0.invoke((Object)p0, p1);
    }

    public static final /* synthetic */ Object access$verifyFileRecords(VFSHealthChecker $this, boolean checkForOrphanRecords, Continuation $completion) {
        return $this.verifyFileRecords(checkForOrphanRecords, (Continuation<? super VFSHealthCheckReport.FileRecordsReport>)$completion);
    }

    public static final /* synthetic */ Object access$verifyRoots(VFSHealthChecker $this, Continuation $completion) {
        return $this.verifyRoots((Continuation<? super VFSHealthCheckReport.RootsReport>)$completion);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001:\u0004-./0B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0000J\n\u0010\u001c\u001a\u00020\u001dH\u0096\u0080\u0004J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\t\u0010$\u001a\u00020\tH\u00c6\u0003J\u0010\u0010%\u001a\u00020\u000bH\u00c6\u0003\u00a2\u0006\u0004\b&\u0010\u0017JB\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001\u00a2\u0006\u0004\b(\u0010)J\u0014\u0010*\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010+\u001a\u00020,H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\n\u001a\u00020\u000b\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u001e\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u00061"}, d2={"Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport;", "", "recordsReport", "Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$FileRecordsReport;", "rootsReport", "Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$RootsReport;", "namesEnumeratorReport", "Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$NamesEnumeratorReport;", "contentEnumeratorReport", "Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$ContentEnumeratorReport;", "timeTaken", "Lkotlin/time/Duration;", "<init>", "(Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$FileRecordsReport;Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$RootsReport;Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$NamesEnumeratorReport;Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$ContentEnumeratorReport;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getRecordsReport", "()Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$FileRecordsReport;", "getRootsReport", "()Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$RootsReport;", "getNamesEnumeratorReport", "()Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$NamesEnumeratorReport;", "getContentEnumeratorReport", "()Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$ContentEnumeratorReport;", "getTimeTaken-UwyO8pc", "()J", "J", "hasSameErrors", "", "other", "toString", "", "healthy", "getHealthy", "()Z", "component1", "component2", "component3", "component4", "component5", "component5-UwyO8pc", "copy", "copy-9VgGkz4", "(Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$FileRecordsReport;Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$RootsReport;Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$NamesEnumeratorReport;Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$ContentEnumeratorReport;J)Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport;", "equals", "hashCode", "", "FileRecordsReport", "NamesEnumeratorReport", "RootsReport", "ContentEnumeratorReport", "intellij.platform.ide.impl"})
    public static final class VFSHealthCheckReport {
        @NotNull
        private final FileRecordsReport recordsReport;
        @NotNull
        private final RootsReport rootsReport;
        @NotNull
        private final NamesEnumeratorReport namesEnumeratorReport;
        @NotNull
        private final ContentEnumeratorReport contentEnumeratorReport;
        private final long timeTaken;

        private VFSHealthCheckReport(FileRecordsReport recordsReport, RootsReport rootsReport, NamesEnumeratorReport namesEnumeratorReport, ContentEnumeratorReport contentEnumeratorReport, long timeTaken) {
            Intrinsics.checkNotNullParameter((Object)recordsReport, (String)"recordsReport");
            Intrinsics.checkNotNullParameter((Object)rootsReport, (String)"rootsReport");
            Intrinsics.checkNotNullParameter((Object)namesEnumeratorReport, (String)"namesEnumeratorReport");
            Intrinsics.checkNotNullParameter((Object)contentEnumeratorReport, (String)"contentEnumeratorReport");
            this.recordsReport = recordsReport;
            this.rootsReport = rootsReport;
            this.namesEnumeratorReport = namesEnumeratorReport;
            this.contentEnumeratorReport = contentEnumeratorReport;
            this.timeTaken = timeTaken;
        }

        @NotNull
        public final FileRecordsReport getRecordsReport() {
            return this.recordsReport;
        }

        @NotNull
        public final RootsReport getRootsReport() {
            return this.rootsReport;
        }

        @NotNull
        public final NamesEnumeratorReport getNamesEnumeratorReport() {
            return this.namesEnumeratorReport;
        }

        @NotNull
        public final ContentEnumeratorReport getContentEnumeratorReport() {
            return this.contentEnumeratorReport;
        }

        public final long getTimeTaken-UwyO8pc() {
            return this.timeTaken;
        }

        public final boolean hasSameErrors(@NotNull VFSHealthCheckReport other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.recordsReport.hasSameErrors(other.recordsReport) && this.rootsReport.hasSameErrors(other.rootsReport) && this.namesEnumeratorReport.hasSameErrors(other.namesEnumeratorReport) && this.contentEnumeratorReport.hasSameErrors(other.contentEnumeratorReport);
        }

        @NotNull
        public String toString() {
            return "VFSHealthCheckReport[healthy: " + this.getHealthy() + "](" + this.recordsReport + ", " + this.rootsReport + ", " + this.namesEnumeratorReport + ", " + this.contentEnumeratorReport + "){timeTaken=" + Duration.toString-impl((long)this.timeTaken) + "}";
        }

        public final boolean getHealthy() {
            return this.recordsReport.getHealthy() && this.rootsReport.getHealthy() && this.namesEnumeratorReport.getHealthy() && this.contentEnumeratorReport.getHealthy();
        }

        @NotNull
        public final FileRecordsReport component1() {
            return this.recordsReport;
        }

        @NotNull
        public final RootsReport component2() {
            return this.rootsReport;
        }

        @NotNull
        public final NamesEnumeratorReport component3() {
            return this.namesEnumeratorReport;
        }

        @NotNull
        public final ContentEnumeratorReport component4() {
            return this.contentEnumeratorReport;
        }

        public final long component5-UwyO8pc() {
            return this.timeTaken;
        }

        @NotNull
        public final VFSHealthCheckReport copy-9VgGkz4(@NotNull FileRecordsReport recordsReport, @NotNull RootsReport rootsReport, @NotNull NamesEnumeratorReport namesEnumeratorReport, @NotNull ContentEnumeratorReport contentEnumeratorReport, long timeTaken) {
            Intrinsics.checkNotNullParameter((Object)recordsReport, (String)"recordsReport");
            Intrinsics.checkNotNullParameter((Object)rootsReport, (String)"rootsReport");
            Intrinsics.checkNotNullParameter((Object)namesEnumeratorReport, (String)"namesEnumeratorReport");
            Intrinsics.checkNotNullParameter((Object)contentEnumeratorReport, (String)"contentEnumeratorReport");
            return new VFSHealthCheckReport(recordsReport, rootsReport, namesEnumeratorReport, contentEnumeratorReport, timeTaken, null);
        }

        public static /* synthetic */ VFSHealthCheckReport copy-9VgGkz4$default(VFSHealthCheckReport vFSHealthCheckReport, FileRecordsReport fileRecordsReport, RootsReport rootsReport, NamesEnumeratorReport namesEnumeratorReport, ContentEnumeratorReport contentEnumeratorReport, long l, int n, Object object) {
            if ((n & 1) != 0) {
                fileRecordsReport = vFSHealthCheckReport.recordsReport;
            }
            if ((n & 2) != 0) {
                rootsReport = vFSHealthCheckReport.rootsReport;
            }
            if ((n & 4) != 0) {
                namesEnumeratorReport = vFSHealthCheckReport.namesEnumeratorReport;
            }
            if ((n & 8) != 0) {
                contentEnumeratorReport = vFSHealthCheckReport.contentEnumeratorReport;
            }
            if ((n & 0x10) != 0) {
                l = vFSHealthCheckReport.timeTaken;
            }
            return vFSHealthCheckReport.copy-9VgGkz4(fileRecordsReport, rootsReport, namesEnumeratorReport, contentEnumeratorReport, l);
        }

        public int hashCode() {
            int result2 = this.recordsReport.hashCode();
            result2 = result2 * 31 + this.rootsReport.hashCode();
            result2 = result2 * 31 + this.namesEnumeratorReport.hashCode();
            result2 = result2 * 31 + this.contentEnumeratorReport.hashCode();
            result2 = result2 * 31 + Duration.hashCode-impl((long)this.timeTaken);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VFSHealthCheckReport)) {
                return false;
            }
            VFSHealthCheckReport vFSHealthCheckReport = (VFSHealthCheckReport)other;
            if (!Intrinsics.areEqual((Object)this.recordsReport, (Object)vFSHealthCheckReport.recordsReport)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.rootsReport, (Object)vFSHealthCheckReport.rootsReport)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.namesEnumeratorReport, (Object)vFSHealthCheckReport.namesEnumeratorReport)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.contentEnumeratorReport, (Object)vFSHealthCheckReport.contentEnumeratorReport)) {
                return false;
            }
            return Duration.equals-impl0((long)this.timeTaken, (long)vFSHealthCheckReport.timeTaken);
        }

        public /* synthetic */ VFSHealthCheckReport(FileRecordsReport recordsReport, RootsReport rootsReport, NamesEnumeratorReport namesEnumeratorReport, ContentEnumeratorReport contentEnumeratorReport, long timeTaken, DefaultConstructorMarker $constructor_marker) {
            this(recordsReport, rootsReport, namesEnumeratorReport, contentEnumeratorReport, timeTaken);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0000J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u0018\u001a\u00020\u0019H\u00d6\u0081\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$ContentEnumeratorReport;", "", "contentRecordsChecked", "", "generalErrors", "<init>", "(II)V", "getContentRecordsChecked", "()I", "setContentRecordsChecked", "(I)V", "getGeneralErrors", "setGeneralErrors", "healthy", "", "getHealthy", "()Z", "hasSameErrors", "other", "component1", "component2", "copy", "equals", "hashCode", "toString", "", "intellij.platform.ide.impl"})
        public static final class ContentEnumeratorReport {
            private int contentRecordsChecked;
            private int generalErrors;

            public ContentEnumeratorReport(int contentRecordsChecked, int generalErrors) {
                this.contentRecordsChecked = contentRecordsChecked;
                this.generalErrors = generalErrors;
            }

            public /* synthetic */ ContentEnumeratorReport(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 1) != 0) {
                    n = 0;
                }
                if ((n3 & 2) != 0) {
                    n2 = 0;
                }
                this(n, n2);
            }

            public final int getContentRecordsChecked() {
                return this.contentRecordsChecked;
            }

            public final void setContentRecordsChecked(int n) {
                this.contentRecordsChecked = n;
            }

            public final int getGeneralErrors() {
                return this.generalErrors;
            }

            public final void setGeneralErrors(int n) {
                this.generalErrors = n;
            }

            public final boolean getHealthy() {
                return this.generalErrors == 0;
            }

            public final boolean hasSameErrors(@NotNull ContentEnumeratorReport other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                return this.generalErrors == other.generalErrors;
            }

            public final int component1() {
                return this.contentRecordsChecked;
            }

            public final int component2() {
                return this.generalErrors;
            }

            @NotNull
            public final ContentEnumeratorReport copy(int contentRecordsChecked, int generalErrors) {
                return new ContentEnumeratorReport(contentRecordsChecked, generalErrors);
            }

            public static /* synthetic */ ContentEnumeratorReport copy$default(ContentEnumeratorReport contentEnumeratorReport, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = contentEnumeratorReport.contentRecordsChecked;
                }
                if ((n3 & 2) != 0) {
                    n2 = contentEnumeratorReport.generalErrors;
                }
                return contentEnumeratorReport.copy(n, n2);
            }

            @NotNull
            public String toString() {
                return "ContentEnumeratorReport(contentRecordsChecked=" + this.contentRecordsChecked + ", generalErrors=" + this.generalErrors + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.contentRecordsChecked);
                result2 = result2 * 31 + Integer.hashCode(this.generalErrors);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ContentEnumeratorReport)) {
                    return false;
                }
                ContentEnumeratorReport contentEnumeratorReport = (ContentEnumeratorReport)other;
                if (this.contentRecordsChecked != contentEnumeratorReport.contentRecordsChecked) {
                    return false;
                }
                return this.generalErrors == contentEnumeratorReport.generalErrors;
            }

            public ContentEnumeratorReport() {
                this(0, 0, 3, null);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b%\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u0086\b\u0018\u00002\u00020\u0001Bu\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u0012\b\b\u0002\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020\u0000J\n\u0010.\u001a\u00020/H\u0096\u0080\u0004J\t\u00100\u001a\u00020\u0003H\u00c6\u0003J\t\u00101\u001a\u00020\u0003H\u00c6\u0003J\t\u00102\u001a\u00020\u0003H\u00c6\u0003J\t\u00103\u001a\u00020\u0003H\u00c6\u0003J\t\u00104\u001a\u00020\u0003H\u00c6\u0003J\t\u00105\u001a\u00020\u0003H\u00c6\u0003J\t\u00106\u001a\u00020\u0003H\u00c6\u0003J\t\u00107\u001a\u00020\u0003H\u00c6\u0003J\t\u00108\u001a\u00020\u0003H\u00c6\u0003J\t\u00109\u001a\u00020\u0003H\u00c6\u0003J\t\u0010:\u001a\u00020\u0003H\u00c6\u0003Jw\u0010;\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010<\u001a\u00020)2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010=\u001a\u00020\u0003H\u00d6\u0081\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0013R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0011\"\u0004\b\u001d\u0010\u0013R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0011\"\u0004\b\u001f\u0010\u0013R\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0011\"\u0004\b!\u0010\u0013R\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0011\"\u0004\b#\u0010\u0013R\u001a\u0010\f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0011\"\u0004\b%\u0010\u0013R\u001a\u0010\r\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0011\"\u0004\b'\u0010\u0013R\u0011\u0010(\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006>"}, d2={"Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$FileRecordsReport;", "", "fileRecordsChecked", "", "fileRecordsDeleted", "nullNameIds", "unresolvableNameIds", "notNullContentIds", "unresolvableContentIds", "unresolvableAttributesIds", "nullParents", "childrenChecked", "inconsistentParentChildRelationships", "generalErrors", "<init>", "(IIIIIIIIIII)V", "getFileRecordsChecked", "()I", "setFileRecordsChecked", "(I)V", "getFileRecordsDeleted", "setFileRecordsDeleted", "getNullNameIds", "setNullNameIds", "getUnresolvableNameIds", "setUnresolvableNameIds", "getNotNullContentIds", "setNotNullContentIds", "getUnresolvableContentIds", "setUnresolvableContentIds", "getUnresolvableAttributesIds", "setUnresolvableAttributesIds", "getNullParents", "setNullParents", "getChildrenChecked", "setChildrenChecked", "getInconsistentParentChildRelationships", "setInconsistentParentChildRelationships", "getGeneralErrors", "setGeneralErrors", "healthy", "", "getHealthy", "()Z", "hasSameErrors", "other", "toString", "", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "copy", "equals", "hashCode", "intellij.platform.ide.impl"})
        public static final class FileRecordsReport {
            private int fileRecordsChecked;
            private int fileRecordsDeleted;
            private int nullNameIds;
            private int unresolvableNameIds;
            private int notNullContentIds;
            private int unresolvableContentIds;
            private int unresolvableAttributesIds;
            private int nullParents;
            private int childrenChecked;
            private int inconsistentParentChildRelationships;
            private int generalErrors;

            public FileRecordsReport(int fileRecordsChecked, int fileRecordsDeleted, int nullNameIds, int unresolvableNameIds, int notNullContentIds, int unresolvableContentIds, int unresolvableAttributesIds, int nullParents, int childrenChecked, int inconsistentParentChildRelationships, int generalErrors) {
                this.fileRecordsChecked = fileRecordsChecked;
                this.fileRecordsDeleted = fileRecordsDeleted;
                this.nullNameIds = nullNameIds;
                this.unresolvableNameIds = unresolvableNameIds;
                this.notNullContentIds = notNullContentIds;
                this.unresolvableContentIds = unresolvableContentIds;
                this.unresolvableAttributesIds = unresolvableAttributesIds;
                this.nullParents = nullParents;
                this.childrenChecked = childrenChecked;
                this.inconsistentParentChildRelationships = inconsistentParentChildRelationships;
                this.generalErrors = generalErrors;
            }

            public /* synthetic */ FileRecordsReport(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n12 & 1) != 0) {
                    n = 0;
                }
                if ((n12 & 2) != 0) {
                    n2 = 0;
                }
                if ((n12 & 4) != 0) {
                    n3 = 0;
                }
                if ((n12 & 8) != 0) {
                    n4 = 0;
                }
                if ((n12 & 0x10) != 0) {
                    n5 = 0;
                }
                if ((n12 & 0x20) != 0) {
                    n6 = 0;
                }
                if ((n12 & 0x40) != 0) {
                    n7 = 0;
                }
                if ((n12 & 0x80) != 0) {
                    n8 = 0;
                }
                if ((n12 & 0x100) != 0) {
                    n9 = 0;
                }
                if ((n12 & 0x200) != 0) {
                    n10 = 0;
                }
                if ((n12 & 0x400) != 0) {
                    n11 = 0;
                }
                this(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11);
            }

            public final int getFileRecordsChecked() {
                return this.fileRecordsChecked;
            }

            public final void setFileRecordsChecked(int n) {
                this.fileRecordsChecked = n;
            }

            public final int getFileRecordsDeleted() {
                return this.fileRecordsDeleted;
            }

            public final void setFileRecordsDeleted(int n) {
                this.fileRecordsDeleted = n;
            }

            public final int getNullNameIds() {
                return this.nullNameIds;
            }

            public final void setNullNameIds(int n) {
                this.nullNameIds = n;
            }

            public final int getUnresolvableNameIds() {
                return this.unresolvableNameIds;
            }

            public final void setUnresolvableNameIds(int n) {
                this.unresolvableNameIds = n;
            }

            public final int getNotNullContentIds() {
                return this.notNullContentIds;
            }

            public final void setNotNullContentIds(int n) {
                this.notNullContentIds = n;
            }

            public final int getUnresolvableContentIds() {
                return this.unresolvableContentIds;
            }

            public final void setUnresolvableContentIds(int n) {
                this.unresolvableContentIds = n;
            }

            public final int getUnresolvableAttributesIds() {
                return this.unresolvableAttributesIds;
            }

            public final void setUnresolvableAttributesIds(int n) {
                this.unresolvableAttributesIds = n;
            }

            public final int getNullParents() {
                return this.nullParents;
            }

            public final void setNullParents(int n) {
                this.nullParents = n;
            }

            public final int getChildrenChecked() {
                return this.childrenChecked;
            }

            public final void setChildrenChecked(int n) {
                this.childrenChecked = n;
            }

            public final int getInconsistentParentChildRelationships() {
                return this.inconsistentParentChildRelationships;
            }

            public final void setInconsistentParentChildRelationships(int n) {
                this.inconsistentParentChildRelationships = n;
            }

            public final int getGeneralErrors() {
                return this.generalErrors;
            }

            public final void setGeneralErrors(int n) {
                this.generalErrors = n;
            }

            public final boolean getHealthy() {
                return this.nullNameIds == 0 && this.unresolvableNameIds == 0 && this.unresolvableAttributesIds == 0 && this.unresolvableContentIds == 0 && this.nullParents == 0 && this.inconsistentParentChildRelationships == 0 && this.generalErrors == 0;
            }

            public final boolean hasSameErrors(@NotNull FileRecordsReport other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                return this.nullNameIds == other.nullNameIds && this.unresolvableNameIds == other.unresolvableNameIds && this.unresolvableAttributesIds == other.unresolvableAttributesIds && this.unresolvableContentIds == other.unresolvableContentIds && this.nullParents == other.nullParents && this.inconsistentParentChildRelationships == other.inconsistentParentChildRelationships && this.generalErrors == other.generalErrors;
            }

            @NotNull
            public String toString() {
                return "FileRecordsReport[recordsChecked=" + this.fileRecordsChecked + ", recordsDeleted=" + this.fileRecordsDeleted + ", childrenChecked=" + this.childrenChecked + "]{nullNameIds=" + this.nullNameIds + ", unresolvableNameIds=" + this.unresolvableNameIds + ", notNullContentIds=" + this.notNullContentIds + ", unresolvableContentIds=" + this.unresolvableContentIds + ", unresolvableAttributesIds=" + this.unresolvableAttributesIds + ", nullParents=" + this.nullParents + ", inconsistentParentChildRelationships=" + this.inconsistentParentChildRelationships + ", generalErrors=" + this.generalErrors + ")";
            }

            public final int component1() {
                return this.fileRecordsChecked;
            }

            public final int component2() {
                return this.fileRecordsDeleted;
            }

            public final int component3() {
                return this.nullNameIds;
            }

            public final int component4() {
                return this.unresolvableNameIds;
            }

            public final int component5() {
                return this.notNullContentIds;
            }

            public final int component6() {
                return this.unresolvableContentIds;
            }

            public final int component7() {
                return this.unresolvableAttributesIds;
            }

            public final int component8() {
                return this.nullParents;
            }

            public final int component9() {
                return this.childrenChecked;
            }

            public final int component10() {
                return this.inconsistentParentChildRelationships;
            }

            public final int component11() {
                return this.generalErrors;
            }

            @NotNull
            public final FileRecordsReport copy(int fileRecordsChecked, int fileRecordsDeleted, int nullNameIds, int unresolvableNameIds, int notNullContentIds, int unresolvableContentIds, int unresolvableAttributesIds, int nullParents, int childrenChecked, int inconsistentParentChildRelationships, int generalErrors) {
                return new FileRecordsReport(fileRecordsChecked, fileRecordsDeleted, nullNameIds, unresolvableNameIds, notNullContentIds, unresolvableContentIds, unresolvableAttributesIds, nullParents, childrenChecked, inconsistentParentChildRelationships, generalErrors);
            }

            public static /* synthetic */ FileRecordsReport copy$default(FileRecordsReport fileRecordsReport, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, Object object) {
                if ((n12 & 1) != 0) {
                    n = fileRecordsReport.fileRecordsChecked;
                }
                if ((n12 & 2) != 0) {
                    n2 = fileRecordsReport.fileRecordsDeleted;
                }
                if ((n12 & 4) != 0) {
                    n3 = fileRecordsReport.nullNameIds;
                }
                if ((n12 & 8) != 0) {
                    n4 = fileRecordsReport.unresolvableNameIds;
                }
                if ((n12 & 0x10) != 0) {
                    n5 = fileRecordsReport.notNullContentIds;
                }
                if ((n12 & 0x20) != 0) {
                    n6 = fileRecordsReport.unresolvableContentIds;
                }
                if ((n12 & 0x40) != 0) {
                    n7 = fileRecordsReport.unresolvableAttributesIds;
                }
                if ((n12 & 0x80) != 0) {
                    n8 = fileRecordsReport.nullParents;
                }
                if ((n12 & 0x100) != 0) {
                    n9 = fileRecordsReport.childrenChecked;
                }
                if ((n12 & 0x200) != 0) {
                    n10 = fileRecordsReport.inconsistentParentChildRelationships;
                }
                if ((n12 & 0x400) != 0) {
                    n11 = fileRecordsReport.generalErrors;
                }
                return fileRecordsReport.copy(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11);
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.fileRecordsChecked);
                result2 = result2 * 31 + Integer.hashCode(this.fileRecordsDeleted);
                result2 = result2 * 31 + Integer.hashCode(this.nullNameIds);
                result2 = result2 * 31 + Integer.hashCode(this.unresolvableNameIds);
                result2 = result2 * 31 + Integer.hashCode(this.notNullContentIds);
                result2 = result2 * 31 + Integer.hashCode(this.unresolvableContentIds);
                result2 = result2 * 31 + Integer.hashCode(this.unresolvableAttributesIds);
                result2 = result2 * 31 + Integer.hashCode(this.nullParents);
                result2 = result2 * 31 + Integer.hashCode(this.childrenChecked);
                result2 = result2 * 31 + Integer.hashCode(this.inconsistentParentChildRelationships);
                result2 = result2 * 31 + Integer.hashCode(this.generalErrors);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FileRecordsReport)) {
                    return false;
                }
                FileRecordsReport fileRecordsReport = (FileRecordsReport)other;
                if (this.fileRecordsChecked != fileRecordsReport.fileRecordsChecked) {
                    return false;
                }
                if (this.fileRecordsDeleted != fileRecordsReport.fileRecordsDeleted) {
                    return false;
                }
                if (this.nullNameIds != fileRecordsReport.nullNameIds) {
                    return false;
                }
                if (this.unresolvableNameIds != fileRecordsReport.unresolvableNameIds) {
                    return false;
                }
                if (this.notNullContentIds != fileRecordsReport.notNullContentIds) {
                    return false;
                }
                if (this.unresolvableContentIds != fileRecordsReport.unresolvableContentIds) {
                    return false;
                }
                if (this.unresolvableAttributesIds != fileRecordsReport.unresolvableAttributesIds) {
                    return false;
                }
                if (this.nullParents != fileRecordsReport.nullParents) {
                    return false;
                }
                if (this.childrenChecked != fileRecordsReport.childrenChecked) {
                    return false;
                }
                if (this.inconsistentParentChildRelationships != fileRecordsReport.inconsistentParentChildRelationships) {
                    return false;
                }
                return this.generalErrors == fileRecordsReport.generalErrors;
            }

            public FileRecordsReport() {
                this(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2047, null);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0000J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J;\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\"\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010#\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010$\u001a\u00020%H\u00d6\u0081\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000b\"\u0004\b\u0015\u0010\rR\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006&"}, d2={"Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$NamesEnumeratorReport;", "", "namesChecked", "", "namesResolvedToNull", "idsResolvedToNull", "inconsistentNames", "generalErrors", "<init>", "(IIIII)V", "getNamesChecked", "()I", "setNamesChecked", "(I)V", "getNamesResolvedToNull", "setNamesResolvedToNull", "getIdsResolvedToNull", "setIdsResolvedToNull", "getInconsistentNames", "setInconsistentNames", "getGeneralErrors", "setGeneralErrors", "healthy", "", "getHealthy", "()Z", "hasSameErrors", "other", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "hashCode", "toString", "", "intellij.platform.ide.impl"})
        public static final class NamesEnumeratorReport {
            private int namesChecked;
            private int namesResolvedToNull;
            private int idsResolvedToNull;
            private int inconsistentNames;
            private int generalErrors;

            public NamesEnumeratorReport(int namesChecked, int namesResolvedToNull, int idsResolvedToNull, int inconsistentNames, int generalErrors) {
                this.namesChecked = namesChecked;
                this.namesResolvedToNull = namesResolvedToNull;
                this.idsResolvedToNull = idsResolvedToNull;
                this.inconsistentNames = inconsistentNames;
                this.generalErrors = generalErrors;
            }

            public /* synthetic */ NamesEnumeratorReport(int n, int n2, int n3, int n4, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n6 & 1) != 0) {
                    n = 0;
                }
                if ((n6 & 2) != 0) {
                    n2 = 0;
                }
                if ((n6 & 4) != 0) {
                    n3 = 0;
                }
                if ((n6 & 8) != 0) {
                    n4 = 0;
                }
                if ((n6 & 0x10) != 0) {
                    n5 = 0;
                }
                this(n, n2, n3, n4, n5);
            }

            public final int getNamesChecked() {
                return this.namesChecked;
            }

            public final void setNamesChecked(int n) {
                this.namesChecked = n;
            }

            public final int getNamesResolvedToNull() {
                return this.namesResolvedToNull;
            }

            public final void setNamesResolvedToNull(int n) {
                this.namesResolvedToNull = n;
            }

            public final int getIdsResolvedToNull() {
                return this.idsResolvedToNull;
            }

            public final void setIdsResolvedToNull(int n) {
                this.idsResolvedToNull = n;
            }

            public final int getInconsistentNames() {
                return this.inconsistentNames;
            }

            public final void setInconsistentNames(int n) {
                this.inconsistentNames = n;
            }

            public final int getGeneralErrors() {
                return this.generalErrors;
            }

            public final void setGeneralErrors(int n) {
                this.generalErrors = n;
            }

            public final boolean getHealthy() {
                return this.namesResolvedToNull == 0 && this.idsResolvedToNull == 0 && this.inconsistentNames == 0 && this.generalErrors == 0;
            }

            public final boolean hasSameErrors(@NotNull NamesEnumeratorReport other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                return this.namesResolvedToNull == other.namesResolvedToNull && this.idsResolvedToNull == other.idsResolvedToNull && this.inconsistentNames == other.inconsistentNames && this.generalErrors == other.generalErrors;
            }

            public final int component1() {
                return this.namesChecked;
            }

            public final int component2() {
                return this.namesResolvedToNull;
            }

            public final int component3() {
                return this.idsResolvedToNull;
            }

            public final int component4() {
                return this.inconsistentNames;
            }

            public final int component5() {
                return this.generalErrors;
            }

            @NotNull
            public final NamesEnumeratorReport copy(int namesChecked, int namesResolvedToNull, int idsResolvedToNull, int inconsistentNames, int generalErrors) {
                return new NamesEnumeratorReport(namesChecked, namesResolvedToNull, idsResolvedToNull, inconsistentNames, generalErrors);
            }

            public static /* synthetic */ NamesEnumeratorReport copy$default(NamesEnumeratorReport namesEnumeratorReport, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
                if ((n6 & 1) != 0) {
                    n = namesEnumeratorReport.namesChecked;
                }
                if ((n6 & 2) != 0) {
                    n2 = namesEnumeratorReport.namesResolvedToNull;
                }
                if ((n6 & 4) != 0) {
                    n3 = namesEnumeratorReport.idsResolvedToNull;
                }
                if ((n6 & 8) != 0) {
                    n4 = namesEnumeratorReport.inconsistentNames;
                }
                if ((n6 & 0x10) != 0) {
                    n5 = namesEnumeratorReport.generalErrors;
                }
                return namesEnumeratorReport.copy(n, n2, n3, n4, n5);
            }

            @NotNull
            public String toString() {
                return "NamesEnumeratorReport(namesChecked=" + this.namesChecked + ", namesResolvedToNull=" + this.namesResolvedToNull + ", idsResolvedToNull=" + this.idsResolvedToNull + ", inconsistentNames=" + this.inconsistentNames + ", generalErrors=" + this.generalErrors + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.namesChecked);
                result2 = result2 * 31 + Integer.hashCode(this.namesResolvedToNull);
                result2 = result2 * 31 + Integer.hashCode(this.idsResolvedToNull);
                result2 = result2 * 31 + Integer.hashCode(this.inconsistentNames);
                result2 = result2 * 31 + Integer.hashCode(this.generalErrors);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NamesEnumeratorReport)) {
                    return false;
                }
                NamesEnumeratorReport namesEnumeratorReport = (NamesEnumeratorReport)other;
                if (this.namesChecked != namesEnumeratorReport.namesChecked) {
                    return false;
                }
                if (this.namesResolvedToNull != namesEnumeratorReport.namesResolvedToNull) {
                    return false;
                }
                if (this.idsResolvedToNull != namesEnumeratorReport.idsResolvedToNull) {
                    return false;
                }
                if (this.inconsistentNames != namesEnumeratorReport.inconsistentNames) {
                    return false;
                }
                return this.generalErrors == namesEnumeratorReport.generalErrors;
            }

            public NamesEnumeratorReport() {
                this(0, 0, 0, 0, 0, 31, null);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0000J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u001e\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001f\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010 \u001a\u00020!H\u00d6\u0081\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/vfs/newvfs/persistent/VFSHealthChecker$VFSHealthCheckReport$RootsReport;", "", "rootsCount", "", "rootsWithParents", "rootsDeletedButNotRemoved", "generalErrors", "<init>", "(IIII)V", "getRootsCount", "()I", "setRootsCount", "(I)V", "getRootsWithParents", "setRootsWithParents", "getRootsDeletedButNotRemoved", "setRootsDeletedButNotRemoved", "getGeneralErrors", "setGeneralErrors", "healthy", "", "getHealthy", "()Z", "hasSameErrors", "other", "component1", "component2", "component3", "component4", "copy", "equals", "hashCode", "toString", "", "intellij.platform.ide.impl"})
        public static final class RootsReport {
            private int rootsCount;
            private int rootsWithParents;
            private int rootsDeletedButNotRemoved;
            private int generalErrors;

            public RootsReport(int rootsCount, int rootsWithParents, int rootsDeletedButNotRemoved, int generalErrors) {
                this.rootsCount = rootsCount;
                this.rootsWithParents = rootsWithParents;
                this.rootsDeletedButNotRemoved = rootsDeletedButNotRemoved;
                this.generalErrors = generalErrors;
            }

            public /* synthetic */ RootsReport(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n5 & 1) != 0) {
                    n = 0;
                }
                if ((n5 & 2) != 0) {
                    n2 = 0;
                }
                if ((n5 & 4) != 0) {
                    n3 = 0;
                }
                if ((n5 & 8) != 0) {
                    n4 = 0;
                }
                this(n, n2, n3, n4);
            }

            public final int getRootsCount() {
                return this.rootsCount;
            }

            public final void setRootsCount(int n) {
                this.rootsCount = n;
            }

            public final int getRootsWithParents() {
                return this.rootsWithParents;
            }

            public final void setRootsWithParents(int n) {
                this.rootsWithParents = n;
            }

            public final int getRootsDeletedButNotRemoved() {
                return this.rootsDeletedButNotRemoved;
            }

            public final void setRootsDeletedButNotRemoved(int n) {
                this.rootsDeletedButNotRemoved = n;
            }

            public final int getGeneralErrors() {
                return this.generalErrors;
            }

            public final void setGeneralErrors(int n) {
                this.generalErrors = n;
            }

            public final boolean getHealthy() {
                return this.rootsWithParents == 0 && this.rootsDeletedButNotRemoved == 0 && this.generalErrors == 0;
            }

            public final boolean hasSameErrors(@NotNull RootsReport other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                return this.rootsWithParents == other.rootsWithParents && this.rootsDeletedButNotRemoved == other.rootsDeletedButNotRemoved && this.generalErrors == other.generalErrors;
            }

            public final int component1() {
                return this.rootsCount;
            }

            public final int component2() {
                return this.rootsWithParents;
            }

            public final int component3() {
                return this.rootsDeletedButNotRemoved;
            }

            public final int component4() {
                return this.generalErrors;
            }

            @NotNull
            public final RootsReport copy(int rootsCount, int rootsWithParents, int rootsDeletedButNotRemoved, int generalErrors) {
                return new RootsReport(rootsCount, rootsWithParents, rootsDeletedButNotRemoved, generalErrors);
            }

            public static /* synthetic */ RootsReport copy$default(RootsReport rootsReport, int n, int n2, int n3, int n4, int n5, Object object) {
                if ((n5 & 1) != 0) {
                    n = rootsReport.rootsCount;
                }
                if ((n5 & 2) != 0) {
                    n2 = rootsReport.rootsWithParents;
                }
                if ((n5 & 4) != 0) {
                    n3 = rootsReport.rootsDeletedButNotRemoved;
                }
                if ((n5 & 8) != 0) {
                    n4 = rootsReport.generalErrors;
                }
                return rootsReport.copy(n, n2, n3, n4);
            }

            @NotNull
            public String toString() {
                return "RootsReport(rootsCount=" + this.rootsCount + ", rootsWithParents=" + this.rootsWithParents + ", rootsDeletedButNotRemoved=" + this.rootsDeletedButNotRemoved + ", generalErrors=" + this.generalErrors + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.rootsCount);
                result2 = result2 * 31 + Integer.hashCode(this.rootsWithParents);
                result2 = result2 * 31 + Integer.hashCode(this.rootsDeletedButNotRemoved);
                result2 = result2 * 31 + Integer.hashCode(this.generalErrors);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RootsReport)) {
                    return false;
                }
                RootsReport rootsReport = (RootsReport)other;
                if (this.rootsCount != rootsReport.rootsCount) {
                    return false;
                }
                if (this.rootsWithParents != rootsReport.rootsWithParents) {
                    return false;
                }
                if (this.rootsDeletedButNotRemoved != rootsReport.rootsDeletedButNotRemoved) {
                    return false;
                }
                return this.generalErrors == rootsReport.generalErrors;
            }

            public RootsReport() {
                this(0, 0, 0, 0, 15, null);
            }
        }
    }
}

