/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent.mapped.content;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.ContentTooBigException;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSContentAccessor;
import com.intellij.openapi.vfs.newvfs.persistent.mapped.content.CompressingAlgo;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.util.io.storages.appendonlylog.AppendOnlyLog;
import com.intellij.platform.util.io.storages.appendonlylog.AppendOnlyLogFactory;
import com.intellij.platform.util.io.storages.appendonlylog.AppendOnlyLogOverMMappedFile;
import com.intellij.platform.util.io.storages.intmultimaps.extendiblehashmap.ExtendibleHashMap;
import com.intellij.platform.util.io.storages.intmultimaps.extendiblehashmap.ExtendibleMapFactory;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.io.CorruptedException;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.Unmappable;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.storage.RecordIdIterator;
import com.intellij.util.io.storage.VFSContentStorage;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class VFSContentStorageOverMMappedFile
implements VFSContentStorage,
Unmappable {
    private static final Logger LOG = Logger.getInstance(VFSContentStorageOverMMappedFile.class);
    private static final byte STORAGE_FORMAT_VERSION_BASE = 1;
    private static final int EXTERNAL_VERSION_FIELD_NO = 0;
    private static final int CONTENT_HASH_LENGTH = 20;
    private final Path storagePath;
    private final ExtendibleHashMap hashToContentRecordIdMap;
    private final AppendOnlyLogOverMMappedFile contentStorage;
    private final CompressingAlgo compressingAlgo;
    private final AtomicInteger recordsStored;
    private final AtomicInteger recordsStoredCompressed;
    private final AtomicInteger recordsDeduplicated;
    private final AtomicLong recordsUncompressedSize;
    private final AtomicLong recordsStoredSize;
    private final AtomicLong recordsRead;
    private final AtomicLong recordsReadUncompressedSize;
    private final AtomicLong recordsReadDecompressed;
    private final AtomicLong recordsReadDecompressionTimeNs;
    private final BatchCallback otelCallback;

    public VFSContentStorageOverMMappedFile(@NotNull Path storagePath, int pageSize, @NotNull CompressingAlgo compressingAlgo) throws IOException {
        if (storagePath == null) {
            VFSContentStorageOverMMappedFile.$$$reportNull$$$0(0);
        }
        if (compressingAlgo == null) {
            VFSContentStorageOverMMappedFile.$$$reportNull$$$0(1);
        }
        this.recordsStored = new AtomicInteger();
        this.recordsStoredCompressed = new AtomicInteger();
        this.recordsDeduplicated = new AtomicInteger();
        this.recordsUncompressedSize = new AtomicLong();
        this.recordsStoredSize = new AtomicLong();
        this.recordsRead = new AtomicLong();
        this.recordsReadUncompressedSize = new AtomicLong();
        this.recordsReadDecompressed = new AtomicLong();
        this.recordsReadDecompressionTimeNs = new AtomicLong();
        this.storagePath = storagePath;
        this.compressingAlgo = compressingAlgo;
        int storageFormatVersion = 0x1000000 + compressingAlgo.algoID();
        AppendOnlyLogOverMMappedFile contentStorage = null;
        ExtendibleHashMap hashToContentRecordIdMap = null;
        try {
            contentStorage = AppendOnlyLogFactory.withDefaults().pageSize(pageSize).failIfFileIncompatible().failIfDataFormatVersionNotMatch(storageFormatVersion).open(storagePath);
            Path mapPath = storagePath.resolveSibling(storagePath.getFileName().toString() + ".hashToId");
            if (contentStorage.isEmpty() || !contentStorage.wasClosedProperly() || contentStorage.wasRecoveryNeeded()) {
                NioFiles.deleteRecursively((Path)mapPath);
            }
            if ((hashToContentRecordIdMap = ExtendibleMapFactory.mediumSize().ifNotClosedProperly(ExtendibleMapFactory.NotClosedProperlyAction.DROP_AND_CREATE_EMPTY_MAP).cleanIfFileIncompatible().open(mapPath)).isEmpty() && !contentStorage.isEmpty()) {
                LOG.warn("Content map[" + String.valueOf(mapPath) + "] is empty (or dropped) while content storage is not: re-building map from the storage");
                VFSContentStorageOverMMappedFile.rebuildMap((AppendOnlyLog)contentStorage, hashToContentRecordIdMap);
            }
            this.contentStorage = contentStorage;
            this.hashToContentRecordIdMap = hashToContentRecordIdMap;
            this.otelCallback = VFSContentStorageOverMMappedFile.setupOTelMonitoring(this, TelemetryManager.getInstance().getMeter(PlatformScopesKt.VFS));
        }
        catch (Throwable th) {
            if (contentStorage != null) {
                try {
                    contentStorage.close();
                }
                catch (Throwable closeEx) {
                    th.addSuppressed(closeEx);
                }
            }
            if (hashToContentRecordIdMap != null) {
                try {
                    hashToContentRecordIdMap.close();
                }
                catch (Throwable closeEx) {
                    th.addSuppressed(closeEx);
                }
            }
            throw th;
        }
    }

    public int getVersion() throws IOException {
        return this.contentStorage.getUserDefinedHeaderField(0);
    }

    public void setVersion(int expectedVersion) throws IOException {
        this.contentStorage.setUserDefinedHeaderField(0, expectedVersion);
    }

    public int storeRecord(@NotNull ByteArraySequence bytes) throws IOException, ContentTooBigException {
        if (bytes == null) {
            VFSContentStorageOverMMappedFile.$$$reportNull$$$0(2);
        }
        byte[] cryptoHash = PersistentFSContentAccessor.calculateHash(bytes);
        int hash = VFSContentStorageOverMMappedFile.hashCodeOf(cryptoHash);
        ByteBuffer cryptoHashWrapped = ByteBuffer.wrap(cryptoHash);
        try {
            return this.hashToContentRecordIdMap.lookupOrInsert(hash, recordId -> {
                long storageId = VFSContentStorageOverMMappedFile.contentIdToStorageId(recordId);
                Boolean recordHasSameCryptoHash = (Boolean)this.contentStorage.read(storageId, buffer2 -> {
                    ByteBuffer cryptoHashSlice = buffer2.slice(0, 20);
                    return cryptoHashSlice.equals(cryptoHashWrapped);
                });
                if (recordHasSameCryptoHash.booleanValue()) {
                    this.recordsDeduplicated.incrementAndGet();
                }
                return recordHasSameCryptoHash;
            }, _hash -> {
                int uncompressedSize;
                ByteArraySequence bytesToStore;
                if (this.compressingAlgo.shouldCompress(bytes)) {
                    bytesToStore = this.compressingAlgo.compress(bytes, true);
                    uncompressedSize = -bytes.length();
                    this.recordsStoredCompressed.incrementAndGet();
                } else {
                    bytesToStore = bytes;
                    uncompressedSize = bytes.length();
                }
                this.recordsStored.incrementAndGet();
                this.recordsUncompressedSize.addAndGet(bytes.length());
                this.recordsStoredSize.addAndGet(bytesToStore.length());
                int totalSize = cryptoHash.length + 4 + bytesToStore.length();
                long storageId = this.contentStorage.append(buffer2 -> buffer2.put(cryptoHash).putInt(uncompressedSize).put(bytesToStore.getInternalBuffer(), bytesToStore.getOffset(), bytesToStore.length()), totalSize);
                return VFSContentStorageOverMMappedFile.storageIdToContentId(storageId);
            });
        }
        catch (IOException | IllegalArgumentException e) {
            e.addSuppressed(new IOException("content[" + bytes.length() + "b], cryptoHash[" + IOUtil.toHexString((byte[])cryptoHash) + "], hash(=" + hash + ")"));
            throw e;
        }
    }

    public void checkRecord(int recordId, boolean fastCheck) throws IOException {
        long storageId = VFSContentStorageOverMMappedFile.contentIdToStorageId(recordId);
        this.contentStorage.read(storageId, buffer2 -> {
            int recordHeaderSize;
            int recordSize = buffer2.limit();
            if (recordSize < (recordHeaderSize = 24)) {
                throw new CorruptedException("record[" + recordId + "].length(" + recordSize + "b) < headerSize(" + recordHeaderSize + "b) => record is corrupted");
            }
            int uncompressedSize = buffer2.getInt(20);
            if (!fastCheck) {
                byte[] contentBytes;
                byte[] cryptoHashStored = new byte[20];
                buffer2.get(0, cryptoHashStored);
                buffer2.position(24);
                if (uncompressedSize >= 0) {
                    int contentSize = recordSize - recordHeaderSize;
                    contentBytes = new byte[contentSize];
                    buffer2.get(contentBytes);
                } else {
                    int actualUncompressedSize = -uncompressedSize;
                    contentBytes = new byte[actualUncompressedSize];
                    this.compressingAlgo.decompress(buffer2, contentBytes);
                }
                byte[] cryptoHashCalculated = PersistentFSContentAccessor.calculateHash(contentBytes, 0, contentBytes.length);
                if (!Arrays.equals(cryptoHashStored, cryptoHashCalculated)) {
                    throw new CorruptedException("record[" + recordId + "].cryptoHash does not match => record is corrupted\n\t    stored hash: " + IOUtil.toHexString((byte[])cryptoHashStored) + "\n\tcalculated hash: " + IOUtil.toHexString((byte[])cryptoHashCalculated) + "\n");
                }
            }
            return null;
        });
    }

    public byte[] contentHash(int recordId) throws IOException {
        long storageId = VFSContentStorageOverMMappedFile.contentIdToStorageId(recordId);
        return (byte[])this.contentStorage.read(storageId, buffer2 -> {
            byte[] cryptoHash = new byte[20];
            buffer2.get(cryptoHash);
            return cryptoHash;
        });
    }

    public InputStream readStream(int recordId) throws IOException {
        long storageId = VFSContentStorageOverMMappedFile.contentIdToStorageId(recordId);
        byte[] bytes = (byte[])this.contentStorage.read(storageId, buffer2 -> {
            buffer2.position(20);
            int uncompressedSize = buffer2.getInt();
            if (uncompressedSize >= 0) {
                int contentSize = buffer2.remaining();
                byte[] contentBytes = new byte[contentSize];
                buffer2.get(contentBytes);
                return contentBytes;
            }
            int actualUncompressedSize = -uncompressedSize;
            byte[] bufferForDecompression = new byte[actualUncompressedSize];
            long startedAtNs = System.nanoTime();
            this.compressingAlgo.decompress(buffer2, bufferForDecompression);
            long decompressionTimeNs = System.nanoTime() - startedAtNs;
            this.recordsReadDecompressionTimeNs.addAndGet(decompressionTimeNs);
            this.recordsReadDecompressed.incrementAndGet();
            return bufferForDecompression;
        });
        this.recordsRead.incrementAndGet();
        this.recordsReadUncompressedSize.addAndGet(bytes.length);
        return new UnsyncByteArrayInputStream(bytes);
    }

    public RecordIdIterator createRecordIdIterator() throws IOException {
        IntArrayList externalIds = new IntArrayList();
        this.contentStorage.forEachRecord((arg_0, arg_1) -> VFSContentStorageOverMMappedFile.lambda$createRecordIdIterator$7((IntList)externalIds, arg_0, arg_1));
        final IntListIterator iterator2 = externalIds.iterator();
        return new RecordIdIterator(){

            public boolean hasNextId() {
                return iterator2.hasNext();
            }

            public int nextId() {
                return iterator2.nextInt();
            }

            public boolean validId() {
                return true;
            }
        };
    }

    public int getRecordsCount() throws IOException {
        return this.hashToContentRecordIdMap.size();
    }

    public boolean isEmpty() throws IOException {
        return this.contentStorage.isEmpty();
    }

    public boolean isDirty() {
        return this.hashToContentRecordIdMap.isDirty();
    }

    public void force() throws IOException {
        this.contentStorage.flush();
        this.hashToContentRecordIdMap.flush();
    }

    public void close() throws IOException {
        ThrowableRunnable[] throwableRunnableArray = new ThrowableRunnable[3];
        throwableRunnableArray[0] = () -> ((ExtendibleHashMap)this.hashToContentRecordIdMap).close();
        throwableRunnableArray[1] = () -> ((AppendOnlyLogOverMMappedFile)this.contentStorage).close();
        throwableRunnableArray[2] = () -> ((BatchCallback)this.otelCallback).close();
        ExceptionUtil.runAllAndRethrowAllExceptions(IOException.class, () -> new IOException("Close [" + String.valueOf(this.storagePath) + "] fails"), (ThrowableRunnable[])throwableRunnableArray);
    }

    public void closeAndUnsafelyUnmap() throws IOException {
        ThrowableRunnable[] throwableRunnableArray = new ThrowableRunnable[3];
        throwableRunnableArray[0] = () -> ((AppendOnlyLogOverMMappedFile)this.contentStorage).closeAndUnsafelyUnmap();
        throwableRunnableArray[1] = () -> ((ExtendibleHashMap)this.hashToContentRecordIdMap).closeAndUnsafelyUnmap();
        throwableRunnableArray[2] = () -> ((BatchCallback)this.otelCallback).close();
        ExceptionUtil.runAllAndRethrowAllExceptions(IOException.class, () -> new IOException("Can't .closeAndUnsafelyUnmap() " + String.valueOf(this.contentStorage) + "/" + String.valueOf(this.hashToContentRecordIdMap)), (ThrowableRunnable[])throwableRunnableArray);
    }

    public void closeAndClean() throws IOException {
        ThrowableRunnable[] throwableRunnableArray = new ThrowableRunnable[3];
        throwableRunnableArray[0] = () -> ((ExtendibleHashMap)this.hashToContentRecordIdMap).closeAndClean();
        throwableRunnableArray[1] = () -> ((AppendOnlyLogOverMMappedFile)this.contentStorage).closeAndClean();
        throwableRunnableArray[2] = () -> ((BatchCallback)this.otelCallback).close();
        ExceptionUtil.runAllAndRethrowAllExceptions(IOException.class, () -> new IOException("closeAndClean [" + String.valueOf(this.storagePath) + "] fails"), (ThrowableRunnable[])throwableRunnableArray);
    }

    private static int storageIdToContentId(long storageId) throws IOException {
        int intStorageId = (int)storageId;
        if ((long)intStorageId != storageId) {
            throw new IOException("Overflow: storageId(=" + storageId + ") > MAX_INT(2147483647)");
        }
        return intStorageId;
    }

    private static long contentIdToStorageId(int recordId) {
        return recordId;
    }

    private static int hashCodeOf(byte[] contentHash) {
        int hashCode = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            hashCode = (hashCode << 8) + (contentHash[i2] & 0xFF);
        }
        return hashCode;
    }

    private static void rebuildMap(@NotNull AppendOnlyLog contentStorage, @NotNull ExtendibleHashMap hashToRecordIdMap) throws IOException {
        if (contentStorage == null) {
            VFSContentStorageOverMMappedFile.$$$reportNull$$$0(3);
        }
        if (hashToRecordIdMap == null) {
            VFSContentStorageOverMMappedFile.$$$reportNull$$$0(4);
        }
        contentStorage.forEachRecord((storageId, buffer2) -> {
            byte[] cryptoHashStored = new byte[20];
            buffer2.get(cryptoHashStored);
            int hash = VFSContentStorageOverMMappedFile.hashCodeOf(cryptoHashStored);
            int contentId = VFSContentStorageOverMMappedFile.storageIdToContentId(storageId);
            hashToRecordIdMap.put(hash, contentId);
            return true;
        });
    }

    public static BatchCallback setupOTelMonitoring(@NotNull VFSContentStorageOverMMappedFile storage, @NotNull Meter meter) {
        if (storage == null) {
            VFSContentStorageOverMMappedFile.$$$reportNull$$$0(5);
        }
        if (meter == null) {
            VFSContentStorageOverMMappedFile.$$$reportNull$$$0(6);
        }
        ObservableLongMeasurement recordsStoredCounter = meter.counterBuilder("VFS.contentStorage.recordsStored").buildObserver();
        ObservableLongMeasurement recordsStoredCompressedCounter = meter.counterBuilder("VFS.contentStorage.recordsStoredCompressed").buildObserver();
        ObservableLongMeasurement recordsDeduplicatedCounter = meter.counterBuilder("VFS.contentStorage.recordsDeduplicated").buildObserver();
        ObservableLongMeasurement recordsUncompressedSizeCounter = meter.counterBuilder("VFS.contentStorage.recordsUncompressedSize").buildObserver();
        ObservableLongMeasurement recordsStoredSizeCounter = meter.counterBuilder("VFS.contentStorage.recordsStoredSize").buildObserver();
        ObservableLongMeasurement recordsReadCounter = meter.counterBuilder("VFS.contentStorage.recordsRead").buildObserver();
        ObservableLongMeasurement recordsReadSizeCounter = meter.counterBuilder("VFS.contentStorage.recordsReadSize").buildObserver();
        ObservableLongMeasurement recordsReadDecompressedCounter = meter.counterBuilder("VFS.contentStorage.recordsReadDecompressed").buildObserver();
        ObservableLongMeasurement recordsDecompressionTimeUsCounter = meter.counterBuilder("VFS.contentStorage.recordsDecompressionTimeUs").buildObserver();
        return meter.batchCallback(() -> {
            recordsStoredCounter.record((long)storage.recordsStored.get());
            recordsStoredCompressedCounter.record((long)storage.recordsStoredCompressed.get());
            recordsDeduplicatedCounter.record((long)storage.recordsDeduplicated.get());
            recordsUncompressedSizeCounter.record(storage.recordsUncompressedSize.get());
            recordsStoredSizeCounter.record(storage.recordsStoredSize.get());
            recordsReadCounter.record(storage.recordsRead.get());
            recordsReadSizeCounter.record(storage.recordsReadUncompressedSize.get());
            recordsReadDecompressedCounter.record(storage.recordsReadDecompressed.get());
            recordsDecompressionTimeUsCounter.record(TimeUnit.NANOSECONDS.toMicros(storage.recordsReadDecompressionTimeNs.get()));
        }, (ObservableMeasurement)recordsStoredCounter, new ObservableMeasurement[]{recordsStoredCompressedCounter, recordsDeduplicatedCounter, recordsUncompressedSizeCounter, recordsStoredSizeCounter, recordsReadCounter, recordsReadSizeCounter, recordsReadDecompressedCounter, recordsDecompressionTimeUsCounter});
    }

    private static /* synthetic */ boolean lambda$createRecordIdIterator$7(IntList externalIds, long storageId, ByteBuffer buffer2) throws IOException {
        externalIds.add(VFSContentStorageOverMMappedFile.storageIdToContentId(storageId));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storagePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compressingAlgo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentStorage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashToRecordIdMap";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/mapped/content/VFSContentStorageOverMMappedFile";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "storeRecord";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "rebuildMap";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setupOTelMonitoring";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

