/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.ProjectFrameHelperKt;
import com.intellij.platform.ide.CoreUiCoroutineScopeHolder;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/wm/impl/WindowCloseListener;", "Ljava/awt/event/WindowAdapter;", "<init>", "()V", "windowClosing", "", "e", "Ljava/awt/event/WindowEvent;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nProjectFrameHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectFrameHelper.kt\ncom/intellij/openapi/wm/impl/WindowCloseListener\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,663:1\n42#2,3:664\n*S KotlinDebug\n*F\n+ 1 ProjectFrameHelper.kt\ncom/intellij/openapi/wm/impl/WindowCloseListener\n*L\n648#1:664,3\n*E\n"})
final class WindowCloseListener
extends WindowAdapter {
    @NotNull
    public static final WindowCloseListener INSTANCE = new WindowCloseListener();

    private WindowCloseListener() {
    }

    @Override
    public void windowClosing(@NotNull WindowEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Window window = e.getWindow();
        IdeFrameImpl ideFrameImpl = window instanceof IdeFrameImpl ? (IdeFrameImpl)window : null;
        if (ideFrameImpl == null) {
            return;
        }
        IdeFrameImpl frame = ideFrameImpl;
        IdeFrameImpl.FrameHelper frameHelper = frame.getFrameHelper();
        IdeFrame ideFrame = frameHelper != null ? frameHelper.getHelper() : null;
        ProjectFrameHelper projectFrameHelper = ideFrame instanceof ProjectFrameHelper ? (ProjectFrameHelper)ideFrame : null;
        if (projectFrameHelper == null) {
            return;
        }
        ProjectFrameHelper frameHelper2 = projectFrameHelper;
        Project project2 = frameHelper2.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        if (ProjectFrameHelperKt.access$isTemporaryDisposed(frame) || LaterInvocator.isInModalContext((JFrame)frame, (Project)project3)) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        if (app != null && !app.isDisposed()) {
            boolean $i$f$service = false;
            Class<CoreUiCoroutineScopeHolder> serviceClass$iv = CoreUiCoroutineScopeHolder.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ThreadContext.installThreadContext$default((CoroutineContext)((CoreUiCoroutineScopeHolder)object).coroutineScope.getCoroutineContext(), (boolean)false, () -> WindowCloseListener.windowClosing$lambda$0(frameHelper2, project3), (int)2, null);
        }
    }

    private static final Unit windowClosing$lambda$0(ProjectFrameHelper $frameHelper, Project $project) {
        $frameHelper.windowClosing($project);
        return Unit.INSTANCE;
    }
}

