/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.tabInEditor;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.impl.tabInEditor.Placeholder;
import com.intellij.openapi.wm.impl.tabInEditor.ToolWindowTabFile;
import com.intellij.ui.content.Content;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a \u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0000\"\u0016\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"ORIGINAL_PREFERRED_FOCUSABLE_KEY", "Lcom/intellij/openapi/util/Key;", "Ljavax/swing/JComponent;", "moveContentToEditor", "", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "content", "Lcom/intellij/ui/content/Content;", "project", "Lcom/intellij/openapi/project/Project;", "moveContentBackToTab", "file", "Lcom/intellij/openapi/wm/impl/tabInEditor/ToolWindowTabFile;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nToolWindowTabInEditorDefaultHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolWindowTabInEditorDefaultHelper.kt\ncom/intellij/openapi/wm/impl/tabInEditor/ToolWindowTabInEditorDefaultHelperKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1#2:152\n*E\n"})
public final class ToolWindowTabInEditorDefaultHelperKt {
    @NotNull
    private static final Key<JComponent> ORIGINAL_PREFERRED_FOCUSABLE_KEY;

    public static final void moveContentToEditor(@NotNull ToolWindow toolWindow2, @NotNull Content content2, @NotNull Project project2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Content prevSelection = toolWindow2.getContentManager().getSelectedContent();
        String string2 = content2.getTabName();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            String string3 = StringUtil.stripHtml((String)it, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"stripHtml(...)");
            string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        } else {
            string = null;
        }
        String tabName = string;
        toolWindow2.getContentManager().setSelectedContentCB(content2).doWhenProcessed(() -> ToolWindowTabInEditorDefaultHelperKt.moveContentToEditor$lambda$1(tabName, toolWindow2, content2, project2, prevSelection));
    }

    public static final void moveContentBackToTab(@NotNull Project project2, @NotNull Content content2, @NotNull ToolWindowTabFile file2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            FileEditorManager.getInstance((Project)project2).closeFile((VirtualFile)file2);
            ApplicationKt.getApplication().runWriteAction(() -> ToolWindowTabInEditorDefaultHelperKt.moveContentBackToTab$lambda$0(file2));
            content2.setComponent(file2.getComponent());
            content2.setPreferredFocusableComponent((JComponent)content2.getUserData(ORIGINAL_PREFERRED_FOCUSABLE_KEY));
            content2.putUserData(ORIGINAL_PREFERRED_FOCUSABLE_KEY, null);
            Object object = content2.getComponent().getFocusCycleRootAncestor();
            if (object == null || (object = ((Container)object).getFocusTraversalPolicy()) == null || (object = ((FocusTraversalPolicy)object).getDefaultComponent(content2.getComponent())) == null) break block0;
            ((Component)object).requestFocus();
        }
    }

    private static final void moveContentToEditor$lambda$1$0(Content $prevSelection, Project $project, ToolWindowTabFile $vFile, ToolWindow $toolWindow) {
        Content content2 = $prevSelection;
        if (content2 != null) {
            Content it = content2;
            boolean bl = false;
            $toolWindow.getContentManager().setSelectedContent(it);
        }
        FileEditorManager.getInstance((Project)$project).openFile((VirtualFile)$vFile, true);
    }

    private static final void moveContentToEditor$lambda$1(String $tabName, ToolWindow $toolWindow, Content $content, Project $project, Content $prevSelection) {
        CharSequence charSequence = $tabName;
        String string = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || Intrinsics.areEqual((Object)$tabName, (Object)$toolWindow.getStripeTitle()) ? $toolWindow.getStripeTitle() : $tabName + " (" + $toolWindow.getStripeTitle() + ")";
        Intrinsics.checkNotNull((Object)string);
        String fileName = string;
        Icon icon2 = $content.getIcon();
        if (icon2 == null) {
            icon2 = $toolWindow.getIcon();
        }
        String string2 = $toolWindow.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
        JComponent jComponent = $content.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        ToolWindowTabFile vFile = new ToolWindowTabFile(fileName, icon2, string2, jComponent);
        $content.setComponent((JComponent)((Object)new Placeholder($project, $content, vFile)));
        JComponent explicitlyRequested = $content.getPreferredFocusableComponent();
        if (explicitlyRequested != null && explicitlyRequested != $content.getComponent()) {
            $content.putUserData(ORIGINAL_PREFERRED_FOCUSABLE_KEY, (Object)explicitlyRequested);
        }
        $content.setPreferredFocusableComponent($content.getComponent());
        $toolWindow.hide(() -> ToolWindowTabInEditorDefaultHelperKt.moveContentToEditor$lambda$1$0($prevSelection, $project, vFile, $toolWindow));
    }

    private static final void moveContentBackToTab$lambda$0(ToolWindowTabFile $file) {
        MessageBus messageBus = ApplicationKt.getApplication().getMessageBus();
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        BulkFileListener publisher = (BulkFileListener)messageBus.syncPublisher(topic);
        List<VFileDeleteEvent> it = Collections.singletonList(new VFileDeleteEvent((Object)$file, (VirtualFile)$file));
        boolean bl = false;
        publisher.before(it);
        $file.setValid(false);
        publisher.after(it);
    }

    static {
        Key key = Key.create((String)"component.preferredFocusableComponent");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        ORIGINAL_PREFERRED_FOCUSABLE_KEY = key;
    }
}

