/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Expandable;
import com.intellij.ui.ExtendableEditorSupport;
import com.intellij.ui.components.fields.ExpandableSupport;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class ExpandableEditorSupport
extends ExpandableSupport<EditorTextField> {
    private static final Pattern TAG_PATTERN = Pattern.compile("([cse])(\\d{1,3})");

    public ExpandableEditorSupport(@NotNull EditorTextField field) {
        if (field == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(0);
        }
        super((JComponent)((Object)field), null, null);
        field.addSettingsProvider(editor2 -> {
            this.initFieldEditor(editor2, field.getBackground());
            this.updateFieldFolding(editor2);
        });
    }

    public ExpandableEditorSupport(@NotNull EditorTextField field, @NotNull Function<? super String, ? extends List<String>> parser, @NotNull Function<? super List<String>, String> joiner) {
        if (field == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(1);
        }
        if (parser == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(2);
        }
        if (joiner == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(3);
        }
        super((JComponent)((Object)field), text2 -> StringUtil.join((Collection)((Collection)parser.fun(text2)), (String)"\n"), text2 -> (String)joiner.fun(Arrays.asList(StringUtil.splitByLines((String)text2))));
        field.addSettingsProvider(editor2 -> {
            this.initFieldEditor(editor2, field.getBackground());
            this.updateFieldFolding(editor2);
        });
    }

    protected void initPopupEditor(@NotNull EditorEx editor2, Color background) {
        if (editor2 == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(4);
        }
        JLabel label2 = ExpandableSupport.createLabel((ExtendableTextComponent.Extension)this.createCollapseExtension());
        label2.setBorder((Border)JBUI.Borders.empty((int)5, (int)3, (int)5, (int)7));
        editor2.getContentComponent().putClientProperty(Expandable.class, (Object)this);
        editor2.getScrollPane().setHorizontalScrollBarPolicy(30);
        editor2.getScrollPane().setVerticalScrollBarPolicy(22);
        editor2.getScrollPane().getVerticalScrollBar().setBackground(background);
        editor2.getScrollPane().getVerticalScrollBar().add("JB_SCROLL_BAR_LEADING_COMPONENT", label2);
        editor2.getScrollPane().setViewportBorder((Border)JBUI.Borders.empty((int)4, (int)6));
        label2.setOpaque(true);
    }

    protected void initFieldEditor(@NotNull EditorEx editor2, Color background) {
        if (editor2 == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(5);
        }
        editor2.getContentComponent().putClientProperty(Expandable.class, (Object)this);
        ExtendableTextComponent.Extension extension = this.createExpandExtension();
        ExtendableEditorSupport.setupExtension(editor2, background, extension);
    }

    protected void updateFieldFolding(@NotNull EditorEx editor2) {
        if (editor2 == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(6);
        }
        FoldingModelEx model2 = editor2.getFoldingModel();
        CharSequence text2 = editor2.getDocument().getCharsSequence();
        model2.runBatchFoldingOperation(() -> {
            model2.clearFoldRegions();
            for (int i2 = 0; i2 < text2.length(); ++i2) {
                if (text2.charAt(i2) != '\n') continue;
                model2.createFoldRegion(i2, i2 + 1, " \u23ce ", null, true);
            }
        });
    }

    @NotNull
    protected ExpandableSupport.Content prepare(final @NotNull EditorTextField field, @NotNull Function<? super String, String> onShow) {
        if (field == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(7);
        }
        if (onShow == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(8);
        }
        final EditorTextField popup2 = this.createPopupEditor(field, (String)onShow.fun((Object)field.getText()));
        Color background = field.getBackground();
        popup2.setBackground(background);
        popup2.setOneLineMode(false);
        popup2.setPreferredSize(new Dimension(field.getWidth(), 5 * field.getHeight()));
        popup2.addSettingsProvider(editor2 -> {
            this.initPopupEditor(editor2, background);
            ExpandableEditorSupport.copyCaretPosition(editor2, field.getEditor(), onShow);
        });
        return new ExpandableSupport.Content(){

            @NotNull
            public JComponent getContentComponent() {
                EditorTextField editorTextField = popup2;
                if (editorTextField == null) {
                    1.$$$reportNull$$$0(0);
                }
                return editorTextField;
            }

            public JComponent getFocusableComponent() {
                return popup2;
            }

            public void cancel(@NotNull Function<? super String, String> onHide) {
                if (onHide == null) {
                    1.$$$reportNull$$$0(1);
                }
                field.setText((String)onHide.fun((Object)popup2.getText()));
                Editor editor2 = field.getEditor();
                if (editor2 != null) {
                    ExpandableEditorSupport.copyCaretPosition(editor2, popup2.getEditor(), onHide);
                }
                if (editor2 instanceof EditorEx) {
                    ExpandableEditorSupport.this.updateFieldFolding((EditorEx)editor2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/ExpandableEditorSupport$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "onHide";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getContentComponent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/ExpandableEditorSupport$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "cancel";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    @NotNull
    protected EditorTextField createPopupEditor(@NotNull EditorTextField field, @NotNull String text2) {
        if (field == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(9);
        }
        if (text2 == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(10);
        }
        if (Objects.equals(text2, field.getText())) {
            return new EditorTextField(field.getDocument(), field.getProject(), field.getFileType());
        }
        return new EditorTextField(text2, field.getProject(), field.getFileType());
    }

    private static void copyCaretPosition(@NotNull Editor destination, Editor source, Function<? super String, String> mapper) {
        if (destination == null) {
            ExpandableEditorSupport.$$$reportNull$$$0(11);
        }
        if (source == null) {
            return;
        }
        try {
            List<CaretState> states = source.getCaretModel().getCaretsAndSelections();
            if (!mapper.equals((Object)Functions.identity())) {
                states = ExpandableEditorSupport.extractStates((String)mapper.fun((Object)ExpandableEditorSupport.injectStates(source.getDocument().getText(), (List<? extends CaretState>)states)));
            }
            destination.getCaretModel().setCaretsAndSelections((List)states);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static @Unmodifiable List<CaretState> extractStates(String text2) {
        int x = 0;
        int y = 0;
        ArrayList<LogicalPosition[]> list2 = new ArrayList<LogicalPosition[]>();
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            char c = text2.charAt(i2);
            if (c == '\u0000') {
                int next = text2.indexOf(0, i2 + 1);
                if (next == -1) continue;
                String tag = text2.substring(i2 + 1, next);
                Matcher matcher = TAG_PATTERN.matcher(tag);
                if (matcher.matches()) {
                    String what;
                    int idx = switch (what = matcher.group(1)) {
                        case "c" -> 0;
                        case "s" -> 1;
                        case "e" -> 2;
                        default -> throw new AssertionError((Object)("Unexpected value: " + what));
                    };
                    int offset = Integer.parseInt(matcher.group(2));
                    while (list2.size() <= offset) {
                        list2.add(new LogicalPosition[3]);
                    }
                    ((LogicalPosition[])list2.get((int)offset))[idx] = new LogicalPosition(y, x);
                }
                i2 = next;
                continue;
            }
            if (c == '\n') {
                ++y;
                x = 0;
                continue;
            }
            ++x;
        }
        return ContainerUtil.map(list2, arr -> new CaretState(arr[0], arr[1], arr[2]));
    }

    private static String injectStates(String text2, List<? extends CaretState> states) {
        if (states.isEmpty()) {
            return text2;
        }
        record Point(int x, int y) {
            static Point from(LogicalPosition pos) {
                return new Point(pos.column, pos.line);
            }
        }
        HashMap<Point, String> tags = new HashMap<Point, String>();
        for (int i2 = 0; i2 < states.size(); ++i2) {
            LogicalPosition selectionEnd;
            LogicalPosition selectionStart;
            CaretState state2 = states.get(i2);
            LogicalPosition caretPosition = state2.getCaretPosition();
            if (caretPosition != null) {
                tags.merge(Point.from(caretPosition), "\u0000c" + i2 + "\u0000", String::concat);
            }
            if ((selectionStart = state2.getSelectionStart()) != null) {
                tags.merge(Point.from(selectionStart), "\u0000s" + i2 + "\u0000", String::concat);
            }
            if ((selectionEnd = state2.getSelectionEnd()) == null) continue;
            tags.merge(Point.from(selectionEnd), "\u0000e" + i2 + "\u0000", String::concat);
        }
        StringBuilder builder = new StringBuilder(text2.length() + tags.values().stream().mapToInt(String::length).sum());
        int x = 0;
        int y = 0;
        for (int i3 = 0; i3 < text2.length(); ++i3) {
            builder.append(tags.getOrDefault(new Point(x, y), ""));
            char c = text2.charAt(i3);
            if (c == '\n') {
                ++y;
                x = 0;
            } else {
                ++x;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "joiner";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onShow";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/ExpandableEditorSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "initPopupEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "initFieldEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFieldFolding";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "prepare";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createPopupEditor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "copyCaretPosition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

