/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.screenmenu;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.ui.mac.screenmenu.Menu;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.MultiResolutionImageProvider;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class MenuItem
implements Disposable,
PropertyChangeListener {
    long nativePeer;
    Runnable actionDelegate;
    boolean isInHierarchy = false;
    Presentation presentation;
    String myTitle;

    public MenuItem() {
    }

    MenuItem(long nsMenuItem) {
        if (nsMenuItem != 0L) {
            this.nativePeer = this.nativeAttach(nsMenuItem);
            this.isInHierarchy = true;
        }
    }

    public void setActionDelegate(Runnable actionDelegate) {
        this.actionDelegate = actionDelegate;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
    }

    public void listenPresentationChanges(@NotNull Presentation newPresentation) {
        if (newPresentation == null) {
            MenuItem.$$$reportNull$$$0(0);
        }
        if (this.presentation != null) {
            this.presentation.removePropertyChangeListener((PropertyChangeListener)this);
        }
        newPresentation.addPropertyChangeListener((PropertyChangeListener)this);
        this.setEnabled(newPresentation.isEnabled());
        this.presentation = newPresentation;
    }

    public void setSubmenu(@NotNull Menu subMenu, boolean onAppKit) {
        if (subMenu == null) {
            MenuItem.$$$reportNull$$$0(1);
        }
        this.ensureNativePeer();
        subMenu.ensureNativePeer();
        this.nativeSetSubmenu(this.nativePeer, subMenu.nativePeer, this.isInHierarchy || subMenu.isInHierarchy);
    }

    public void setState(boolean isToggled) {
        this.ensureNativePeer();
        this.nativeSetState(this.nativePeer, isToggled, this.isInHierarchy);
    }

    public void setEnabled(boolean isEnabled) {
        this.ensureNativePeer();
        this.nativeSetEnabled(this.nativePeer, isEnabled, this.isInHierarchy);
    }

    public void setLabel(String label2, KeyStroke ks) {
        int modifiers;
        this.ensureNativePeer();
        char keyChar = ks == null ? (char)'\u0000' : ks.getKeyChar();
        int keyCode = ks == null ? 0 : ks.getKeyCode();
        int n = modifiers = ks == null ? 0 : ks.getModifiers();
        if (label2 == null) {
            label2 = "";
        }
        if (keyChar == '\uffff') {
            keyChar = '\u0000';
        }
        this.myTitle = label2;
        this.nativeSetTitleAndAccelerator(this.nativePeer, label2, keyChar, keyCode, modifiers, this.isInHierarchy);
    }

    public void setLabel(String label2) {
        this.ensureNativePeer();
        if (label2 == null) {
            label2 = "";
        }
        this.myTitle = label2;
        this.nativeSetTitle(this.nativePeer, label2, this.isInHierarchy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIcon(Icon icon2) {
        if (icon2 == null) {
            return;
        }
        ScaleContext ctx = ScaleContext.create();
        icon2 = MultiResolutionImageProvider.convertFromMRIcon((Icon)icon2, (ScaleContext)ctx);
        int w = icon2.getIconWidth();
        int h = icon2.getIconHeight();
        if (w <= 0 || h <= 0) {
            return;
        }
        BufferedImage image2 = IconUtil.toBufferedImage((Icon)icon2, (ScaleContext)ctx, (boolean)false);
        if (image2.getType() != 3) {
            BufferedImage newImage = new BufferedImage(image2.getWidth(), image2.getHeight(), 3);
            Graphics2D g = newImage.createGraphics();
            try {
                g.setComposite(AlphaComposite.Src);
                UIUtil.drawImage((Graphics)g, (Image)image2, (int)0, (int)0, null);
            }
            finally {
                g.dispose();
            }
            image2 = newImage;
        }
        int[] bytes = ((DataBufferInt)image2.getRaster().getDataBuffer()).getData();
        this.ensureNativePeer();
        this.nativeSetImage(this.nativePeer, bytes, w, h, image2.getWidth(), image2.getHeight(), this.isInHierarchy);
    }

    public void setAcceleratorText(String acceleratorText) {
        this.ensureNativePeer();
        this.nativeSetAcceleratorText(this.nativePeer, acceleratorText, this.isInHierarchy);
    }

    synchronized void ensureNativePeer() {
        if (this.nativePeer == 0L) {
            this.nativePeer = this.nativeCreate(false);
        }
    }

    void handleAction(int modifiers) {
        if (this.actionDelegate != null) {
            this.actionDelegate.run();
        }
    }

    public synchronized void dispose() {
        if (this.presentation != null) {
            this.presentation.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.presentation = null;
        if (this.nativePeer != 0L) {
            this.nativeDispose(this.nativePeer);
            this.nativePeer = 0L;
        }
    }

    private native long nativeCreate(boolean var1);

    private native long nativeAttach(long var1);

    native void nativeDispose(long var1);

    private native void nativeSetTitleAndAccelerator(long var1, String var3, char var4, int var5, int var6, boolean var7);

    private native void nativeSetTitle(long var1, String var3, boolean var4);

    private native void nativeSetImage(long var1, int[] var3, int var4, int var5, int var6, int var7, boolean var8);

    private native void nativeSetEnabled(long var1, boolean var3, boolean var4);

    private native void nativeSetAcceleratorText(long var1, String var3, boolean var4);

    private native void nativeSetState(long var1, boolean var3, boolean var4);

    private native void nativeSetSubmenu(long var1, long var3, boolean var5);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPresentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subMenu";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/mac/screenmenu/MenuItem";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "listenPresentationChanges";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setSubmenu";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

