/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.lang.Language;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xml.util.XmlStringUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="debuggerHistoryManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
public final class XDebuggerHistoryManager
implements PersistentStateComponent<Element> {
    private static final String STATE_TAG = "root";
    private static final String ID_ATTRIBUTE = "id";
    private static final String EXPRESSIONS_TAG = "expressions";
    private static final String EXPRESSION_TAG = "expression";
    private final Map<String, LinkedList<XExpression>> myRecentExpressions = new HashMap<String, LinkedList<XExpression>>();

    public static XDebuggerHistoryManager getInstance(@NotNull Project project) {
        if (project == null) {
            XDebuggerHistoryManager.$$$reportNull$$$0(0);
        }
        return (XDebuggerHistoryManager)project.getService(XDebuggerHistoryManager.class);
    }

    public boolean addRecentExpression(@NotNull @NonNls String id, @Nullable XExpression expression) {
        if (id == null) {
            XDebuggerHistoryManager.$$$reportNull$$$0(1);
        }
        if (XDebuggerUtilImpl.isEmptyExpression(expression) || expression.getExpression().length() > 100000) {
            return false;
        }
        LinkedList list = this.myRecentExpressions.computeIfAbsent(id, k -> new LinkedList());
        int max = AdvancedSettings.getInt((String)"debugger.max.recent.expressions");
        while (list.size() >= max) {
            list.removeLast();
        }
        XExpressionImpl trimmedExpression = new XExpressionImpl(expression.getExpression().trim(), expression.getLanguage(), expression.getCustomInfo(), expression.getMode());
        list.remove(trimmedExpression);
        list.addFirst(trimmedExpression);
        return true;
    }

    public List<XExpression> getRecentExpressions(@NonNls String id) {
        return ContainerUtil.notNullize((List)this.myRecentExpressions.get(id));
    }

    @NotNull
    public Element getState() {
        Element state = new Element(STATE_TAG);
        for (String id : this.myRecentExpressions.keySet()) {
            LinkedList<XExpression> expressions = this.myRecentExpressions.get(id);
            List states = ContainerUtil.map(expressions, ExpressionState::new);
            Element entryElement = new Element(EXPRESSIONS_TAG);
            entryElement.setAttribute(ID_ATTRIBUTE, id);
            for (ExpressionState expressionState : states) {
                entryElement.addContent(XmlSerializer.serialize((Object)expressionState));
            }
            state.addContent(entryElement);
        }
        Element element = state;
        if (element == null) {
            XDebuggerHistoryManager.$$$reportNull$$$0(2);
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            XDebuggerHistoryManager.$$$reportNull$$$0(3);
        }
        this.myRecentExpressions.clear();
        for (Element expression : state.getChildren(EXPRESSIONS_TAG)) {
            String id = expression.getAttributeValue(ID_ATTRIBUTE);
            LinkedList<XExpression> expressions = new LinkedList<XExpression>();
            for (Element expressionElement : expression.getChildren(EXPRESSION_TAG)) {
                expressions.add(((ExpressionState)XmlSerializer.deserialize((Element)expressionElement, ExpressionState.class)).toXExpression());
            }
            this.myRecentExpressions.put(id, expressions);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = ID_ATTRIBUTE;
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/XDebuggerHistoryManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerHistoryManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addRecentExpression";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    @Tag(value="expression")
    private static class ExpressionState {
        @Tag(value="expression-string")
        String myExpression;
        @Tag(value="language-id")
        String myLanguageId;
        @Tag(value="custom-info")
        String myCustomInfo;
        @Tag(value="evaluation-mode")
        EvaluationMode myEvaluationMode;

        ExpressionState() {
        }

        ExpressionState(@NotNull XExpression expression) {
            if (expression == null) {
                ExpressionState.$$$reportNull$$$0(0);
            }
            this.myExpression = XmlStringUtil.escapeIllegalXmlChars((String)expression.getExpression());
            Language language = expression.getLanguage();
            this.myLanguageId = language == null ? null : language.getID();
            this.myCustomInfo = expression.getCustomInfo();
            this.myEvaluationMode = expression.getMode();
        }

        @NotNull
        XExpression toXExpression() {
            if (this.myEvaluationMode == null) {
                this.myEvaluationMode = EvaluationMode.EXPRESSION;
            }
            return new XExpressionImpl(XmlStringUtil.unescapeIllegalXmlChars((String)this.myExpression), Language.findLanguageByID((String)this.myLanguageId), this.myCustomInfo, this.myEvaluationMode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", XDebuggerHistoryManager.EXPRESSION_TAG, "com/intellij/xdebugger/impl/XDebuggerHistoryManager$ExpressionState", "<init>"));
        }
    }

    public static final class XDebuggerHistoryPathMacroFilter
    extends PathMacroFilter {
        public boolean skipPathMacros(@NotNull Element element) {
            Element grandParent;
            Element parent;
            Parent parent2;
            if (element == null) {
                XDebuggerHistoryPathMacroFilter.$$$reportNull$$$0(0);
            }
            return "expression-string".equals(element.getName()) && (parent2 = element.getParent()) instanceof Element && XDebuggerHistoryManager.EXPRESSION_TAG.equals((parent = (Element)parent2).getName()) && (parent2 = parent.getParent()) instanceof Element && XDebuggerHistoryManager.EXPRESSIONS_TAG.equals((grandParent = (Element)parent2).getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xdebugger/impl/XDebuggerHistoryManager$XDebuggerHistoryPathMacroFilter", "skipPathMacros"));
        }
    }
}

