/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.inline;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EDT;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerManagerProxyListener;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.inline.InlineDebugRenderer;
import com.intellij.xdebugger.impl.inline.InlineWatchNodeImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeListener;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@ApiStatus.Internal
public final class XDebuggerInlayUtil {
    public static final String INLINE_HINTS_DELIMETER = ":";
    @NotNull
    private final Project myProject;

    public static XDebuggerInlayUtil getInstance(Project project) {
        return (XDebuggerInlayUtil)project.getService(XDebuggerInlayUtil.class);
    }

    XDebuggerInlayUtil(final Project project) {
        this.myProject = project;
        project.getMessageBus().connect().subscribe(XDebuggerManagerProxyListener.TOPIC, (Object)new XDebuggerManagerProxyListener(){

            @Override
            public void sessionStopped(@NotNull XDebugSessionProxy session) {
                if (session == null) {
                    1.$$$reportNull$$$0(0);
                }
                XVariablesView.InlineVariablesInfo.set(session, null);
            }

            @Override
            public void activeSessionChanged(@Nullable XDebugSessionProxy previousSession, @Nullable XDebugSessionProxy currentSession) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    XVariablesView.InlineVariablesInfo info;
                    if (previousSession != null && !previousSession.isStopped() && (info = XVariablesView.InlineVariablesInfo.get(previousSession)) != null) {
                        info.setInlays(XDebuggerInlayUtil.clearInlaysInt(project));
                    }
                    if (currentSession != null && (info = XVariablesView.InlineVariablesInfo.get(currentSession)) != null) {
                        info.getInlays().forEach(renderer -> XDebuggerInlayUtil.createInlayInt(currentSession, renderer));
                    }
                    DebuggerUIUtil.repaintCurrentEditor(project);
                }, ModalityState.nonModal(), project.getDisposed());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/inline/XDebuggerInlayUtil$1", "sessionStopped"));
            }
        });
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(this){

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                XDebuggerInlayUtil.clearInlaysInEditor(event.getEditor());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/inline/XDebuggerInlayUtil$2", "editorReleased"));
            }
        }, (Disposable)project);
    }

    public void createLineEndInlay(@NotNull XValueNodeImpl valueNode2, @NotNull XDebugSessionProxy session, @NotNull VirtualFile file2, int line) {
        if (valueNode2 == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(0);
        }
        if (session == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(2);
        }
        if (valueNode2.getValuePresentation() != null) {
            ApplicationManager.getApplication().invokeLater(() -> XDebuggerInlayUtil.createInlayInt(session, new InlineDebugRenderer(valueNode2, file2, line, session)), ModalityState.nonModal(), session.getProject().getDisposed());
        }
    }

    private static void createInlayInt(@NotNull XDebugSessionProxy session, final InlineDebugRenderer renderer) {
        if (session == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(3);
        }
        EDT.assertIsEdt();
        XSourcePosition position = renderer.getPosition();
        FileEditor editor = XDebuggerUtil.getInstance().getSelectedEditor(session.getProject(), position.getFile());
        if (editor instanceof TextEditor) {
            TextEditor te = (TextEditor)editor;
            Editor e = te.getEditor();
            int line = position.getLine();
            if (!DocumentUtil.isValidLine((int)line, (Document)e.getDocument())) {
                return;
            }
            int lineStart = e.getDocument().getLineStartOffset(line);
            int lineEnd = e.getDocument().getLineEndOffset(line);
            List existingInlays = e.getInlayModel().getAfterLineEndElementsInRange(lineStart, lineEnd, InlineDebugRenderer.class);
            if (ContainerUtil.exists((Iterable)existingInlays, i -> ((InlineDebugRenderer)i.getRenderer()).getValueNode().equals(renderer.getValueNode()))) {
                return;
            }
            final Inlay inlay = e.getInlayModel().addAfterLineEndElement(lineEnd, new InlayProperties().disableSoftWrapping(true).priority(renderer.isCustomNode() ? 0 : -1), (EditorCustomElementRenderer)renderer);
            if (inlay == null) {
                return;
            }
            final XValueNodeImpl valueNode2 = renderer.getValueNode();
            valueNode2.getTree().addTreeListener(new XDebuggerTreeListener(){

                @Override
                public void nodeLoaded(@NotNull RestorableStateNode node, @NotNull String name) {
                    if (node == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (name == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    if (node == valueNode2) {
                        renderer.updatePresentation();
                        inlay.update();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "node";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "name";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/xdebugger/impl/inline/XDebuggerInlayUtil$3";
                    objectArray[2] = "nodeLoaded";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (Disposable)inlay);
            if (renderer.isCustomNode()) {
                ((InlineWatchNodeImpl)valueNode2).inlayCreated((Inlay<InlineDebugRenderer>)inlay);
            }
        }
    }

    public void clearInlays() {
        ApplicationManager.getApplication().invokeLater(() -> XDebuggerInlayUtil.clearInlaysInt(this.myProject), ModalityState.nonModal(), this.myProject.getDisposed());
    }

    private static List<Inlay> clearInlaysInEditor(@NotNull Editor editor) {
        if (editor == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(4);
        }
        EDT.assertIsEdt();
        List inlays = editor.getInlayModel().getAfterLineEndElementsInRange(0, editor.getDocument().getTextLength(), InlineDebugRenderer.class);
        inlays.forEach(Disposer::dispose);
        return inlays;
    }

    private static List<InlineDebugRenderer> clearInlaysInt(@NotNull Project project) {
        if (project == null) {
            XDebuggerInlayUtil.$$$reportNull$$$0(5);
        }
        return StreamEx.of((Object[])FileEditorManager.getInstance((Project)project).getAllEditors()).select(TextEditor.class).flatCollection(textEditor -> XDebuggerInlayUtil.clearInlaysInEditor(textEditor.getEditor())).map(Inlay::getRenderer).select(InlineDebugRenderer.class).toList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueNode";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/inline/XDebuggerInlayUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createLineEndInlay";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createInlayInt";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "clearInlaysInEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "clearInlaysInt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

