/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.connectivity.dataSource.AbstractDataSourceManager;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.database.SqlDataSourceAutoSyncManager;
import com.intellij.sql.database.SqlDataSourceConfigurable;
import com.intellij.sql.database.SqlDataSourceImpl;
import com.intellij.sql.database.SqlDataSourceStorage;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import icons.DatabaseIcons;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.Promise;

public final class SqlDataSourceManager
extends AbstractDataSourceManager<SqlDataSourceImpl> {
    private final SqlDataSourceStorage myStorage;
    private final MergingUpdateQueue myQueue;

    @NotNull
    public static SqlDataSourceManager getInstance(@NotNull Project project) {
        if (project == null) {
            SqlDataSourceManager.$$$reportNull$$$0(0);
        }
        SqlDataSourceManager sqlDataSourceManager = (SqlDataSourceManager)((Object)EP_NAME.findExtensionOrFail(SqlDataSourceManager.class, (AreaInstance)project));
        if (sqlDataSourceManager == null) {
            SqlDataSourceManager.$$$reportNull$$$0(1);
        }
        return sqlDataSourceManager;
    }

    public SqlDataSourceManager(final @NotNull Project project) {
        if (project == null) {
            SqlDataSourceManager.$$$reportNull$$$0(2);
        }
        super(project, SqlDataSourceStorage.getInstance(project).getDataSources());
        this.myStorage = SqlDataSourceStorage.getInstance(project);
        this.myQueue = new MergingUpdateQueue(((Object)((Object)this)).getClass().getSimpleName(), 200, true, null, (Disposable)this.myStorage);
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){
            final FileDocumentManager docManager = FileDocumentManager.getInstance();
            final FileTypeManager ftManager = FileTypeManager.getInstance();

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project.isDisposed()) {
                    return;
                }
                VirtualFile file = this.docManager.getFile(event.getDocument());
                if (file != null && !(file.getFileSystem() instanceof NonPhysicalFileSystem) && this.ftManager.isFileOfType(file, (FileType)SqlFileType.INSTANCE)) {
                    SqlDataSourceManager.this.onDataSourceFilesAffected(Collections.singleton(file));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/sql/database/SqlDataSourceManager$1", "documentChanged"));
            }
        }, (Disposable)this.myStorage);
        VirtualFileManager.getInstance().addAsyncFileListener(events -> {
            final ArrayList<VFileEvent> aboutSql = new ArrayList<VFileEvent>();
            for (VFileEvent event : events) {
                String name;
                ProgressManager.checkCanceled();
                CharSequence charSequence = name = event instanceof VFileCreateEvent ? ((VFileCreateEvent)event).getChildName() : Objects.requireNonNull(event.getFile()).getNameSequence();
                if (FileTypeRegistry.getInstance().getFileTypeByFileName((CharSequence)name) != SqlFileType.INSTANCE) continue;
                aboutSql.add(event);
            }
            return aboutSql.isEmpty() ? null : new AsyncFileListener.ChangeApplier(){

                public void afterVfsChange() {
                    SqlDataSourceManager.this.onDataSourceFilesAffected(ContainerUtil.mapNotNull((Collection)aboutSql, VFileEvent::getFile));
                }
            };
        }, (Disposable)this.myStorage);
        MessageBusConnection projectConnection = project.getMessageBus().connect();
        projectConnection.subscribe(DataSourceStorage.TOPIC, (Object)new DataSourceStorage.Listener(){

            public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    3.$$$reportNull$$$0(0);
                }
                this.process((AbstractDataSource)dataSource);
            }

            public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
                if (dataSource == null) {
                    3.$$$reportNull$$$0(1);
                }
                this.process((AbstractDataSource)dataSource);
            }

            public void dataSourceChanged(LocalDataSource dataSource) {
                this.process((AbstractDataSource)dataSource);
            }

            void process(AbstractDataSource dataSource) {
                if (dataSource == null) {
                    for (SqlDataSourceImpl ds : SqlDataSourceManager.this.getDataSources()) {
                        SqlDataSourceManager.autoSync(ds);
                    }
                } else {
                    SqlDataSourceManager.this.autoSync((DasDataSource)dataSource);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "dataSource";
                objectArray2[1] = "com/intellij/sql/database/SqlDataSourceManager$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dataSourceRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public DataSourceManager.ActionPreferedPosition getActionPreferedPosition() {
        return DataSourceManager.ActionPreferedPosition.TAIL;
    }

    private void onDataSourceFilesAffected(Collection<VirtualFile> files) {
        JBIterable dataSources = this.getAffectedDataSources(files).collect();
        for (SqlDataSourceImpl ds : dataSources) {
            ds.onFilesModified();
        }
        class U
        extends Update {
            final Set<String> dataSourceIds;
            final /* synthetic */ SqlDataSourceManager this$0;

            U(@NotNull SqlDataSourceManager this$0, Iterable<? extends SqlDataSource> dataSources) {
                if (dataSources == null) {
                    U.$$$reportNull$$$0(0);
                }
                this(this$0, (Set)JBIterable.from(dataSources).map(DasDataSource::getUniqueId).addAllTo(new HashSet()));
            }

            U(@NotNull SqlDataSourceManager this$0, Set<String> dataSourceIds) {
                if (dataSourceIds == null) {
                    U.$$$reportNull$$$0(1);
                }
                this.this$0 = this$0;
                super(dataSourceIds);
                this.dataSourceIds = dataSourceIds;
            }

            public void run() {
                if (this.dataSourceIds.isEmpty()) {
                    return;
                }
                SqlDataSourceManager.autoSync(this.this$0.getDataSources(), this.dataSourceIds);
            }

            public boolean canEat(@NotNull Update update) {
                if (update == null) {
                    U.$$$reportNull$$$0(2);
                }
                if (update instanceof U) {
                    this.dataSourceIds.addAll(((U)update).dataSourceIds);
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSources";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceIds";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "update";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/sql/database/SqlDataSourceManager$1U";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "canEat";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        this.myQueue.queue((Update)new U(this, (Iterable<? extends SqlDataSource>)dataSources));
    }

    @NotNull
    private JBIterable<SqlDataSourceImpl> getAffectedDataSources(Iterable<VirtualFile> files) {
        JBIterable jBIterable = JBIterable.from(this.myStorage.getDataSources()).filter(ds -> SqlDataSourceManager.containsAny(ds, files));
        if (jBIterable == null) {
            SqlDataSourceManager.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    private static boolean containsAny(SqlDataSource ds, Iterable<VirtualFile> files) {
        return ContainerUtil.exists(files, f -> ds.containsFile(f));
    }

    public boolean isLoading(@NotNull SqlDataSourceImpl element) {
        if (element == null) {
            SqlDataSourceManager.$$$reportNull$$$0(4);
        }
        return this.myStorage.isLoading(element);
    }

    public void autoSync(DasDataSource info) {
        SqlDataSourceManager.autoSync(this.getDataSources(), ContainerUtil.newHashSet((Object[])new String[]{info.getUniqueId()}));
    }

    public static void autoSync(SqlDataSource ds) {
        ((SqlDataSourceAutoSyncManager)ds.getProject().getService(SqlDataSourceAutoSyncManager.class)).check(ds);
    }

    private static void autoSync(List<SqlDataSourceImpl> dataSourceElements, Set<String> uniqueIdsToClean) {
        for (int i = 0; i < dataSourceElements.size(); ++i) {
            boolean changed = false;
            for (SqlDataSourceImpl sourceElement : dataSourceElements) {
                String parentID;
                if (uniqueIdsToClean.contains(sourceElement.getUniqueId()) || !StringUtil.isNotEmpty((String)(parentID = sourceElement.getParentUniqueId())) || !uniqueIdsToClean.contains(parentID)) continue;
                uniqueIdsToClean.add(sourceElement.getUniqueId());
                changed = true;
            }
            if (!changed) break;
        }
        for (SqlDataSourceImpl element : dataSourceElements) {
            if (!uniqueIdsToClean.contains(element.getUniqueId())) continue;
            SqlDataSourceManager.autoSync(element);
        }
    }

    public void addDataSource(@NotNull SqlDataSourceImpl dataSource) {
        if (dataSource == null) {
            SqlDataSourceManager.$$$reportNull$$$0(5);
        }
        this.myStorage.addDataSource(dataSource);
        this.attachDataSource((RawDataSource)dataSource);
        SqlDataSourceManager.autoSync(dataSource);
    }

    public void removeDataSource(@NotNull SqlDataSourceImpl element) {
        if (element == null) {
            SqlDataSourceManager.$$$reportNull$$$0(6);
        }
        this.myStorage.removeDataSource(element);
        this.detachDataSource((RawDataSource)element);
    }

    public void renameDataSource(@NotNull SqlDataSourceImpl element, @NotNull String name) {
        if (element == null) {
            SqlDataSourceManager.$$$reportNull$$$0(7);
        }
        if (name == null) {
            SqlDataSourceManager.$$$reportNull$$$0(8);
        }
        element.setName(name);
        this.updateDataSource((RawDataSource)element);
    }

    protected void saveDataSource(@NotNull SqlDataSourceImpl dataSource) {
        if (dataSource == null) {
            SqlDataSourceManager.$$$reportNull$$$0(9);
        }
        this.updateDataSource((RawDataSource)dataSource);
    }

    @NotNull
    public Configurable createDataSourceEditor(@NotNull SqlDataSourceImpl element) {
        if (element == null) {
            SqlDataSourceManager.$$$reportNull$$$0(10);
        }
        return new SqlDataSourceConfigurable(this, element);
    }

    @NotNull
    public AnAction getCreateDataSourceAction(final @NotNull Consumer<? super SqlDataSourceImpl> consumer) {
        if (consumer == null) {
            SqlDataSourceManager.$$$reportNull$$$0(11);
        }
        return new DumbAwareAction(this, SqlBundle.message((String)"action.text.create.sql.datasource", (Object[])new Object[0]), null, DatabaseIcons.DdlDbms){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    4.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabledAndVisible(e.getProject() != null && DatabaseViewActions.isDataSourceActionsEnabled((AnActionEvent)e));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(2);
                }
                Project project = Objects.requireNonNull(e.getProject());
                SqlDataSourceImpl result = new SqlDataSourceImpl(DasUtil.NO_NAME, project, null);
                result.setName("DDL data source");
                consumer.consume((Object)result);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/database/SqlDataSourceManager$4";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/database/SqlDataSourceManager$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    @NotNull
    public SqlDataSourceImpl createEmpty() {
        return new SqlDataSourceImpl("", this.myProject, null);
    }

    @NotNull
    public SqlDataSourceImpl copyDataSource(@NotNull String newName, @NotNull SqlDataSourceImpl copyFrom) {
        if (newName == null) {
            SqlDataSourceManager.$$$reportNull$$$0(12);
        }
        if (copyFrom == null) {
            SqlDataSourceManager.$$$reportNull$$$0(13);
        }
        SqlDataSourceImpl result = copyFrom.copy(false);
        result.setName(StringUtil.notNullize((String)newName, (String)"DDL data source"));
        SqlDataSourceImpl sqlDataSourceImpl = result;
        if (sqlDataSourceImpl == null) {
            SqlDataSourceManager.$$$reportNull$$$0(14);
        }
        return sqlDataSourceImpl;
    }

    public boolean canCreateDataSourceByFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            SqlDataSourceManager.$$$reportNull$$$0(15);
        }
        for (VirtualFile file : files) {
            if (!FileTypeRegistry.getInstance().isFileOfType(file, (FileType)SqlFileType.INSTANCE)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<SqlDataSourceImpl> createDataSourceByFiles(@NotNull DatabaseCredentials credentials, @NotNull List<VirtualFile> files) {
        if (credentials == null) {
            SqlDataSourceManager.$$$reportNull$$$0(16);
        }
        if (files == null) {
            SqlDataSourceManager.$$$reportNull$$$0(17);
        }
        ArrayList<VirtualFile> sqlFiles = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : files) {
            if (!FileTypeRegistry.getInstance().isFileOfType(virtualFile, (FileType)SqlFileType.INSTANCE)) continue;
            sqlFiles.add(virtualFile);
        }
        if (sqlFiles.isEmpty()) {
            List<SqlDataSourceImpl> list = Collections.emptyList();
            if (list == null) {
                SqlDataSourceManager.$$$reportNull$$$0(18);
            }
            return list;
        }
        String defaultName = DbUtil.generateUniqueDataSourceName((Project)this.myProject, (String)((VirtualFile)sqlFiles.get(0)).getNameWithoutExtension());
        SqlDataSourceImpl dataSource = new SqlDataSourceImpl(defaultName, this.myProject, null);
        dataSource.setFiles(sqlFiles.toArray(VirtualFile.EMPTY_ARRAY));
        List<SqlDataSourceImpl> list = Collections.singletonList(dataSource);
        if (list == null) {
            SqlDataSourceManager.$$$reportNull$$$0(19);
        }
        return list;
    }

    public boolean isMyDataSource(@NotNull Class<? extends DasDataSource> clazz) {
        if (clazz == null) {
            SqlDataSourceManager.$$$reportNull$$$0(20);
        }
        return SqlDataSource.class.isAssignableFrom(clazz);
    }

    private static List<String> getFileUrls(DnDEvent aEvent) {
        try {
            PsiElement[] elements = AbstractProjectViewPane.getTransferedPsiElements((Transferable)aEvent);
            if (elements != null) {
                ArrayList<String> result = new ArrayList<String>();
                for (PsiElement element : elements) {
                    VirtualFile file;
                    if (!(element instanceof PsiFile) || (file = ((PsiFile)element).getVirtualFile()) == null || !FileTypeRegistry.getInstance().isFileOfType(file, (FileType)SqlFileType.INSTANCE)) continue;
                    result.add(file.getUrl());
                }
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    @NotNull
    public DatabaseDialectEx getDatabaseDialect(@NotNull SqlDataSourceImpl element) {
        if (element == null) {
            SqlDataSourceManager.$$$reportNull$$$0(21);
        }
        DatabaseDialectEx databaseDialectEx = element.getDatabaseDialect();
        if (databaseDialectEx == null) {
            SqlDataSourceManager.$$$reportNull$$$0(22);
        }
        return databaseDialectEx;
    }

    @NotNull
    public Language getQueryLanguage(@NotNull SqlDataSourceImpl element) {
        if (element == null) {
            SqlDataSourceManager.$$$reportNull$$$0(23);
        }
        SqlLanguageDialect sqlLanguageDialect = element.getSqlDialect();
        if (sqlLanguageDialect == null) {
            SqlDataSourceManager.$$$reportNull$$$0(24);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public Language getPushedQueryLanguage(@NotNull SqlDataSourceImpl element) {
        if (element == null) {
            SqlDataSourceManager.$$$reportNull$$$0(25);
        }
        SqlLanguageDialect sqlLanguageDialect = element.getSqlDialect();
        if (sqlLanguageDialect == null) {
            SqlDataSourceManager.$$$reportNull$$$0(26);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public Promise<?> getLoadingPromise(@NotNull SqlDataSourceImpl source) {
        if (source == null) {
            SqlDataSourceManager.$$$reportNull$$$0(27);
        }
        Promise<?> promise = this.myStorage.getLoadingPromise(source);
        if (promise == null) {
            SqlDataSourceManager.$$$reportNull$$$0(28);
        }
        return promise;
    }

    @NotNull
    public DnDTarget createDnDTarget(@NotNull SqlDataSourceImpl element) {
        if (element == null) {
            SqlDataSourceManager.$$$reportNull$$$0(29);
        }
        return new MyDnDTarget(element);
    }

    @TestOnly
    public void clear() {
        this.getDataSources().forEach(this::removeDataSource);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 14, 18, 19, 22, 24, 26, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlDataSourceManager";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 21: 
            case 23: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFrom";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlDataSourceManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedDataSources";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "copyDataSource";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceByFiles";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueryLanguage";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getPushedQueryLanguage";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingPromise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isLoading";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addDataSource";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeDataSource";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "renameDataSource";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "saveDataSource";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceEditor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCreateDataSourceAction";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copyDataSource";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "canCreateDataSourceByFiles";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceByFiles";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isMyDataSource";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getQueryLanguage";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPushedQueryLanguage";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getLoadingPromise";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createDnDTarget";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 14, 18, 19, 22, 24, 26, 28 -> new IllegalStateException(string);
        };
    }

    private class MyDnDTarget
    implements DnDTarget {
        final SqlDataSourceImpl element;

        MyDnDTarget(SqlDataSourceImpl element) {
            this.element = element;
        }

        public boolean update(DnDEvent aEvent) {
            List<String> files = SqlDataSourceManager.getFileUrls(aEvent);
            return !files.isEmpty();
        }

        public void drop(DnDEvent aEvent) {
            List<String> files = SqlDataSourceManager.getFileUrls(aEvent);
            SqlDataSourceImpl sqlDataSource = this.element;
            ArrayList<String> newList = new ArrayList<String>(sqlDataSource.getUrls());
            newList.removeAll(files);
            newList.addAll(files);
            if (!SqlDataSourceConfigurable.checkGenericDialectUsage(SqlDataSourceManager.this.myProject, newList)) {
                return;
            }
            sqlDataSource.setUrls(newList);
            SqlDataSourceManager.autoSync(sqlDataSource);
        }
    }
}

